/*
 ******************************************************************************
 *  Copyright 1996 DeltaLink bv. All Rights Reserved.
 ******************************************************************************
 *
 * DeltaLink FactoryLink synchronization utilities.
 *
 * File: nt_sync.c
 *
 * This file contains utility routines for the synchronization of the Real-Time 
 * Database of FactoryLink in case of multi-threaded processes. These routines
 * are platform specific and in this case for Windows-NT.
 *
 */
#ifdef WIN32

#define NOMSG             // typedef MSG and associated routines
#define _OLE2_H_          // no ole

#include  <windows.h>
#include  <stdio.h>
#include  <stdlib.h>

#undef ERROR

#endif

#include  <flib.h>
#include  <fl_utils.h>                     /* FactoryLink definitions */

/*
 * Define the critical section object
 */
CRITICAL_SECTION  Critical_RTDB;
CRITICAL_SECTION  Critical_SIGNAL;

#ifdef ECHANGING
CRITICAL_SECTION  Critical_ECHANGE;
CRITICAL_SECTION  Critical_ESIGNAL;
#endif

/*
 * handle indicating which thread owns the critical section
 */
DWORD      Critical_owner;
int        Critical_nested;


/*
 * Function     : InitializeCSection
 *
 * Description  : Initializes the critical section functionality.
 *
 */
int InitializeCSection( CRITICAL_SECTION *CriticalSection, int n ) 
{
  if( n != 1 )
    return ERROR;

  InitializeCriticalSection( CriticalSection );

  return GOOD;
}

/*
 * Function     : DeleteCSection
 *
 * Description  : Deinitializes the critical section functionality.
 *
 */
int DeleteCSection( CRITICAL_SECTION *CriticalSection)
{
  DeleteCriticalSection( CriticalSection);

  return GOOD;
}

/*
 * Function     : EnterCSection
 *
 * Description  : Try to enter the critical section
 *
 */
int EnterCSection( CRITICAL_SECTION *CriticalSection, int mode )
{
  if( mode == 1 )
    return ERROR;

  EnterCriticalSection( CriticalSection );

  return GOOD;
}

/*
 * Function     : LeaveCSection
 *
 * Description  : Leave the critical section .
 *
 */
int LeaveCSection( CRITICAL_SECTION *CriticalSection) {

  LeaveCriticalSection( CriticalSection);

  return GOOD;
}

/*
 * Function     : SetCSectionOwner
 *
 * Description  : Check if this thread is the owner of the critical section
 *
 */
int SetCSectionOwner( ) 
{
  Critical_owner   = GetCurrentThreadId();
  Critical_nested  = 0;

  return GOOD;
}

/*
 * Function     : ResetCSectionOwner
 *
 * Description  : Set the critical section state owned by nobody
 *
 */
int ResetCSectionOwner( )
{

	/* check first if we hold the critical section */

	if ( GetCurrentThreadId() != Critical_owner )
		return ERROR;

  /* check first if this critical section has been nested */

  if( Critical_nested )
  {
    Critical_nested--;
    return ERROR;
  }
  else 
  {
    Critical_owner = 0;

    return GOOD;
  }
}

/*
 * Function     : IsCSectionOwner
 *
 * Description  : Check if this thread is the owner of the critical section
 *
 */
int IsCSectionOwner( )
{
  if ( GetCurrentThreadId() == Critical_owner )
  {
    /* increment the nesting counter */

    Critical_nested++;

    return GOOD;
  }
  else
    return ERROR;
}