/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.gde;

import com.schneiderautomation.gde.ClipObject;
import com.schneiderautomation.gde.GdeApplet;
import com.schneiderautomation.gde.GdeEditor;
import com.schneiderautomation.gde.GdeMsgArea;
import com.schneiderautomation.gde.GdeStrings;
import com.schneiderautomation.gde.ObjectDescriptor;
import com.schneiderautomation.gde.PaletteDescriptor;
import com.schneiderautomation.gde.Wrapper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.peer.LightweightPeer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;

public class BeanBox
extends Panel
implements MouseListener,
MouseMotionListener,
Serializable {
    static final long serialVersionUID = 8111788376744146349L;
    private static transient GdeApplet applet;
    private transient GdeEditor editor;
    private transient GdeMsgArea statusOut;
    private transient Image gridImage;
    private transient Image bkgdImage;
    private transient Cursor dragMode;
    private transient Point dragStart;
    private transient Wrapper[] dragChildren;
    private transient Rectangle[] dragBoxes;
    private transient Rectangle[] rubberBoxes;
    private transient Dimension minDragSize;
    private transient Dimension maxDragSize;
    private transient Rectangle dragBounds;
    private transient Rectangle bbBounds;
    private transient Point selectStart;
    private transient Rectangle selectBox;
    private transient Rectangle rubberBox;
    transient Wrapper reference;
    private int idBean = 0;
    private String bkgdName = "";
    private int iNbclik = 0;

    BeanBox(GdeApplet gdeApplet, GdeEditor gdeEditor, GdeMsgArea gdeMsgArea) {
        this.setLayout(null);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.connect(gdeApplet, gdeEditor, gdeMsgArea);
    }

    synchronized void connect(GdeApplet gdeApplet, GdeEditor gdeEditor, GdeMsgArea gdeMsgArea) {
        applet = gdeApplet;
        this.editor = gdeEditor;
        this.statusOut = gdeMsgArea;
        this.addComponentListener(gdeEditor);
        this.addComponentListener(gdeApplet);
        this.addContainerListener(gdeApplet);
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            ((Wrapper)componentArray[i]).connect(gdeApplet);
        }
    }

    synchronized void disconnect() {
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            ((Wrapper)componentArray[i]).disconnect();
        }
        this.removeContainerListener(applet);
        this.removeComponentListener(applet);
        this.removeComponentListener(this.editor);
    }

    synchronized void setUserInputEnabled(boolean bl) {
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            ((Wrapper)componentArray[i]).setUserInputEnabled(bl);
        }
    }

    synchronized void repaintAll() {
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            Wrapper wrapper = (Wrapper)componentArray[i];
            wrapper.getBean().repaint();
            wrapper.repaint();
        }
        this.repaint();
    }

    public void setWidth(int n) {
        int n2 = 128;
        int n3 = 1600;
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            Rectangle rectangle = componentArray[i].getBounds();
            int n4 = rectangle.x + rectangle.width - Wrapper.BORDER_WIDTH;
            if (n2 >= n4) continue;
            n2 = n4;
        }
        n = Math.max(Math.min(n3, n), n2);
        this.setSize(n, this.getSize().height);
    }

    public int getWidth() {
        return this.getSize().width;
    }

    public void setHeight(int n) {
        int n2 = 96;
        int n3 = 1200;
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            Rectangle rectangle = componentArray[i].getBounds();
            int n4 = rectangle.y + rectangle.height - Wrapper.BORDER_WIDTH;
            if (n2 >= n4) continue;
            n2 = n4;
        }
        n = Math.max(Math.min(n3, n), n2);
        this.setSize(this.getSize().width, n);
    }

    public int getHeight() {
        return this.getSize().height;
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.editor.backgroundChanged();
        this.resetGrid();
        this.repaintAll();
    }

    public void setImageName(String string) {
        this.bkgdName = string;
        if (this.bkgdImage != null) {
            this.bkgdImage.flush();
            this.bkgdImage = null;
        }
        this.resetGrid();
        this.repaint();
    }

    public String getImageName() {
        return this.bkgdName != null ? this.bkgdName : "";
    }

    void resetGrid() {
        if (this.gridImage != null) {
            this.gridImage.flush();
            this.gridImage = null;
        }
        System.gc();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public static Image getBeanImage(String string, String string2) {
        Image image = null;
        try {
            String string3 = "../";
            image = applet.getImage(new URL(applet.getCodeBase(), string3 + string2 + "/" + string));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return image;
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (this.bkgdImage == null && this.getImageName().length() > 0) {
            boolean bl;
            Object object;
            try {
                this.bkgdImage = applet.getImage(new URL(applet.getDocumentBase(), this.getImageName()));
                object = new MediaTracker(this);
                ((MediaTracker)object).addImage(this.bkgdImage, 0);
                ((MediaTracker)object).waitForAll();
                bl = (((MediaTracker)object).statusAll(false) & 4) != 0;
            }
            catch (MalformedURLException malformedURLException) {
                bl = true;
            }
            catch (InterruptedException interruptedException) {
                bl = true;
            }
            if (bl) {
                this.bkgdImage = this.createImage(128, 48);
                object = this.bkgdImage.getGraphics();
                ((Graphics)object).setColor(Color.magenta);
                ((Graphics)object).fillRect(0, 0, dimension.width, dimension.height);
                ((Graphics)object).setColor(Color.black);
                ((Graphics)object).drawString(this.getImageName(), 8, 24);
                ((Graphics)object).dispose();
            }
        }
        if (BeanBox.applet.fEditMode && this.editor.fGrid) {
            if (this.gridImage == null) {
                this.gridImage = this.createImage(dimension.width, dimension.height);
                Graphics graphics2 = this.gridImage.getGraphics();
                graphics2.setColor(this.getBackground());
                graphics2.fillRect(0, 0, dimension.width, dimension.height);
                if (this.bkgdImage != null) {
                    graphics2.drawImage(this.bkgdImage, 0, 0, null);
                }
                graphics2.setColor(Color.black);
                graphics2.setXORMode(Color.white);
                for (int i = 0; i < dimension.width; i += this.editor.cxGrid) {
                    for (int j = 0; j < dimension.height; j += this.editor.cyGrid) {
                        graphics2.fillRect(i, j, 2, 2);
                    }
                }
                graphics2.dispose();
            }
            graphics.drawImage(this.gridImage, 0, 0, null);
        } else {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, dimension.width, dimension.height);
            if (this.bkgdImage != null) {
                graphics.drawImage(this.bkgdImage, 0, 0, null);
            }
        }
    }

    private synchronized void insertBean(int n, int n2) {
        block12: {
            applet.setWaitCursor();
            PaletteDescriptor paletteDescriptor = (PaletteDescriptor)BeanBox.applet.palettes.elementAt(BeanBox.applet.idPaletteInsert);
            ObjectDescriptor objectDescriptor = (ObjectDescriptor)paletteDescriptor.objects.elementAt(BeanBox.applet.idBeanInsert);
            try {
                Dimension dimension;
                Wrapper wrapper = new Wrapper(objectDescriptor, ++this.idBean);
                this.addBean(wrapper);
                wrapper.connect(applet);
                Component component = wrapper.getBean();
                int n3 = component.getSize().width;
                int n4 = component.getSize().height;
                int n5 = Wrapper.BORDER_WIDTH;
                Dimension dimension2 = component.getMinimumSize();
                if (dimension2.width < n5) {
                    dimension2.width = n5;
                }
                if (dimension2.height < n5) {
                    dimension2.height = n5;
                }
                if (n3 < dimension2.width) {
                    n3 = dimension2.width;
                }
                if (n4 < dimension2.height) {
                    n4 = dimension2.height;
                }
                Dimension dimension3 = component.getPreferredSize();
                if (n3 < dimension3.width) {
                    n3 = dimension3.width;
                }
                if (n4 < dimension3.height) {
                    n4 = dimension3.height;
                }
                if (this.editor.fSnap) {
                    n3 = (n3 + this.editor.cxGrid - 1) / this.editor.cxGrid * this.editor.cxGrid;
                    n4 = (n4 + this.editor.cyGrid - 1) / this.editor.cyGrid * this.editor.cyGrid;
                    dimension = component.getMaximumSize();
                    if (n3 > dimension.width) {
                        n3 = dimension.width;
                    }
                    if (n4 > dimension.height) {
                        n4 = dimension.height;
                    }
                }
                this.bbBounds = new Rectangle(this.getSize());
                this.dragBounds = new Rectangle(n -= n3 / 2, n2 -= n4 / 2, n3, n4);
                dimension = new Dimension();
                this.limitMove(dimension);
                n += dimension.width;
                n2 += dimension.height;
                if (this.editor.fSnap) {
                    n = (n + this.editor.cxGrid / 2) / this.editor.cxGrid * this.editor.cxGrid;
                    n2 = (n2 + this.editor.cyGrid / 2) / this.editor.cyGrid * this.editor.cyGrid;
                    this.dragBounds = new Rectangle(n, n2, n3, n4);
                    dimension = new Dimension();
                    this.limitMoveSnap(dimension);
                    n += dimension.width;
                    n2 += dimension.height;
                }
                wrapper.setBounds(n -= Wrapper.BORDER_WIDTH, n2 -= Wrapper.BORDER_WIDTH, n3 += Wrapper.BORDER_WIDTH_X2, n4 += Wrapper.BORDER_WIDTH_X2);
                this.setCurrentComponent(wrapper, true);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (this.statusOut == null) break block12;
                String string = exception.getMessage() != null ? exception.getMessage() : exception.toString();
                Object[] objectArray = new Object[]{objectDescriptor.name, string};
                this.statusOut.printErr(GdeStrings.getFormattedString("INSERT_ERROR", objectArray));
            }
        }
        applet.clearInsertBean();
    }

    synchronized void setCurrentComponent(Wrapper wrapper, boolean bl) {
        Wrapper wrapper2 = this.reference;
        this.reference = wrapper;
        if (this.reference != null) {
            this.reference.setSelected(true);
        }
        if (bl) {
            Component[] componentArray = this.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                if (componentArray[i] == this.reference) continue;
                ((Wrapper)componentArray[i]).setSelected(false);
            }
        } else if (wrapper2 != null) {
            wrapper2.repaint();
        }
        if (this.reference == null || this.reference != wrapper2) {
            if (BeanBox.applet.ps != null) {
                applet.showPropertySheet();
            }
            if (BeanBox.applet.cs != null) {
                BeanBox.applet.cs.dispose();
            }
        }
        applet.selectionChanged(this.getSelectedCount());
    }

    synchronized void unsetCurrentComponent(Wrapper wrapper) {
        wrapper.setSelected(false);
        if (wrapper == this.reference) {
            this.reference = null;
            Component[] componentArray = this.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                Wrapper wrapper2 = (Wrapper)componentArray[i];
                if (!wrapper2.isSelected()) continue;
                this.setCurrentComponent(wrapper2, false);
                return;
            }
            if (BeanBox.applet.ps != null) {
                applet.showPropertySheet();
            }
            if (BeanBox.applet.cs != null) {
                BeanBox.applet.cs.dispose();
            }
        }
        applet.selectionChanged(this.getSelectedCount());
    }

    void startDrag(Wrapper wrapper, Cursor cursor, MouseEvent mouseEvent) {
        int n;
        this.dragMode = cursor;
        this.dragStart = this.translatePoint(mouseEvent);
        this.bbBounds = new Rectangle(this.getSize());
        this.bbBounds.grow(Wrapper.BORDER_WIDTH, Wrapper.BORDER_WIDTH);
        if (this.dragMode == GdeEditor.MOVE_CURSOR) {
            this.dragChildren = this.getSelected();
            this.dragBounds = new Rectangle(this.dragChildren[0].getBounds());
            for (n = 1; n < this.dragChildren.length; ++n) {
                this.dragBounds.add(this.dragChildren[n].getBounds());
            }
        } else {
            this.dragChildren = new Wrapper[1];
            this.dragChildren[0] = wrapper;
            n = 800 - Wrapper.BORDER_WIDTH_X2;
            this.maxDragSize = new Dimension(n, n);
            Dimension dimension = wrapper.getBean().getMaximumSize();
            if (this.maxDragSize.width > dimension.width) {
                this.maxDragSize.width = dimension.width;
            }
            if (this.maxDragSize.height > dimension.height) {
                this.maxDragSize.height = dimension.height;
            }
            this.maxDragSize.width += Wrapper.BORDER_WIDTH_X2;
            this.maxDragSize.height += Wrapper.BORDER_WIDTH_X2;
            this.minDragSize = new Dimension(Wrapper.BORDER_WIDTH, Wrapper.BORDER_WIDTH);
            Dimension dimension2 = wrapper.getBean().getMinimumSize();
            if (this.minDragSize.width < dimension2.width) {
                this.minDragSize.width = dimension2.width;
            }
            if (this.minDragSize.height < dimension2.height) {
                this.minDragSize.height = dimension2.height;
            }
            this.minDragSize.width += Wrapper.BORDER_WIDTH_X2;
            this.minDragSize.height += Wrapper.BORDER_WIDTH_X2;
        }
        this.dragBoxes = new Rectangle[this.dragChildren.length];
        for (n = 0; n < this.dragBoxes.length; ++n) {
            this.dragBoxes[n] = this.dragChildren[n].getBounds();
        }
        this.drawRubberBoxes();
    }

    void doDrag(MouseEvent mouseEvent) {
        if (this.dragMode != null) {
            ((Component)mouseEvent.getSource()).setCursor(this.dragMode);
            Point point = this.translatePoint(mouseEvent);
            Dimension dimension = new Dimension(point.x - this.dragStart.x, point.y - this.dragStart.y);
            if (this.dragMode == GdeEditor.MOVE_CURSOR) {
                this.limitMove(dimension);
                if (this.editor.fSnap) {
                    Point point2 = this.reference.getLocation();
                    point2.translate(Wrapper.BORDER_WIDTH, Wrapper.BORDER_WIDTH);
                    this.snapMove(dimension, point2.x, point2.y);
                    this.limitMoveSnap(dimension);
                }
                for (int i = 0; i < this.dragChildren.length; ++i) {
                    Point point3 = this.dragChildren[i].getLocation();
                    point3.translate(dimension.width, dimension.height);
                    this.dragBoxes[i].setLocation(point3);
                }
                this.drawRubberBoxes();
                return;
            }
            Rectangle rectangle = this.dragChildren[0].getBounds();
            Rectangle rectangle2 = this.dragBoxes[0];
            if (this.dragMode == GdeEditor.SE_RESIZE_CURSOR) {
                rectangle2.width = rectangle.width + dimension.width;
                rectangle2.height = rectangle.height + dimension.height;
                if (this.editor.fSnap) {
                    this.limitResize(rectangle2);
                    dimension.width = rectangle2.width - rectangle.width;
                    dimension.height = rectangle2.height - rectangle.height;
                    int n = rectangle.x + rectangle.width - Wrapper.BORDER_WIDTH;
                    int n2 = rectangle.y + rectangle.height - Wrapper.BORDER_WIDTH;
                    this.snapMove(dimension, n, n2);
                    rectangle2.width = rectangle.width + dimension.width;
                    rectangle2.height = rectangle.height + dimension.height;
                    this.limitResizeSnap(rectangle2);
                }
                this.limitResize(rectangle2);
            } else if (this.dragMode == GdeEditor.NE_RESIZE_CURSOR) {
                rectangle2.width = rectangle.width + dimension.width;
                rectangle2.height = rectangle.height - dimension.height;
                rectangle2.y = rectangle.y + dimension.height;
                if (this.editor.fSnap) {
                    this.limitResize(rectangle2);
                    dimension.width = rectangle2.width - rectangle.width;
                    dimension.height = rectangle.height - rectangle2.height;
                    int n = rectangle.x + rectangle.width - Wrapper.BORDER_WIDTH;
                    int n3 = rectangle.y + Wrapper.BORDER_WIDTH;
                    this.snapMove(dimension, n, n3);
                    rectangle2.width = rectangle.width + dimension.width;
                    rectangle2.height = rectangle.height - dimension.height;
                    rectangle2.y = rectangle.y + dimension.height;
                    this.limitResizeSnap(rectangle2);
                    rectangle2.y = rectangle.y + rectangle.height - rectangle2.height;
                }
                this.limitResize(rectangle2);
                rectangle2.y = rectangle.y + rectangle.height - rectangle2.height;
            } else if (this.dragMode == GdeEditor.SW_RESIZE_CURSOR) {
                rectangle2.width = rectangle.width - dimension.width;
                rectangle2.height = rectangle.height + dimension.height;
                rectangle2.x = rectangle.x + dimension.width;
                if (this.editor.fSnap) {
                    this.limitResize(rectangle2);
                    dimension.width = rectangle.width - rectangle2.width;
                    dimension.height = rectangle2.height - rectangle.height;
                    int n = rectangle.x + Wrapper.BORDER_WIDTH;
                    int n4 = rectangle.y + rectangle.height - Wrapper.BORDER_WIDTH;
                    this.snapMove(dimension, n, n4);
                    rectangle2.width = rectangle.width - dimension.width;
                    rectangle2.height = rectangle.height + dimension.height;
                    rectangle2.x = rectangle.x + dimension.width;
                    this.limitResizeSnap(rectangle2);
                    rectangle2.x = rectangle.x + rectangle.width - rectangle2.width;
                }
                this.limitResize(rectangle2);
                rectangle2.x = rectangle.x + rectangle.width - rectangle2.width;
            } else if (this.dragMode == GdeEditor.NW_RESIZE_CURSOR) {
                rectangle2.width = rectangle.width - dimension.width;
                rectangle2.height = rectangle.height - dimension.height;
                rectangle2.x = rectangle.x + dimension.width;
                rectangle2.y = rectangle.y + dimension.height;
                if (this.editor.fSnap) {
                    this.limitResize(rectangle2);
                    dimension.width = rectangle.width - rectangle2.width;
                    dimension.height = rectangle.height - rectangle2.height;
                    int n = rectangle.x + Wrapper.BORDER_WIDTH;
                    int n5 = rectangle.y + Wrapper.BORDER_WIDTH;
                    this.snapMove(dimension, n, n5);
                    rectangle2.width = rectangle.width - dimension.width;
                    rectangle2.height = rectangle.height - dimension.height;
                    rectangle2.x = rectangle.x + dimension.width;
                    rectangle2.y = rectangle.y + dimension.height;
                    this.limitResizeSnap(rectangle2);
                    rectangle2.x = rectangle.x + rectangle.width - rectangle2.width;
                    rectangle2.y = rectangle.y + rectangle.height - rectangle2.height;
                }
                this.limitResize(rectangle2);
                rectangle2.x = rectangle.x + rectangle.width - rectangle2.width;
                rectangle2.y = rectangle.y + rectangle.height - rectangle2.height;
            } else if (this.dragMode == GdeEditor.E_RESIZE_CURSOR) {
                rectangle2.width = rectangle.width + dimension.width;
                if (this.editor.fSnap) {
                    this.limitResize(rectangle2);
                    dimension.width = rectangle2.width - rectangle.width;
                    int n = rectangle.x + rectangle.width - Wrapper.BORDER_WIDTH;
                    dimension.width = this.snapDelta(dimension.width, n, this.editor.cxGrid);
                    rectangle2.width = rectangle.width + dimension.width;
                    this.limitResizeSnap(rectangle2);
                }
                this.limitResize(rectangle2);
            } else if (this.dragMode == GdeEditor.S_RESIZE_CURSOR) {
                rectangle2.height = rectangle.height + dimension.height;
                if (this.editor.fSnap) {
                    this.limitResize(rectangle2);
                    dimension.height = rectangle2.height - rectangle.height;
                    int n = rectangle.y + rectangle.height - Wrapper.BORDER_WIDTH;
                    dimension.height = this.snapDelta(dimension.height, n, this.editor.cyGrid);
                    rectangle2.height = rectangle.height + dimension.height;
                    this.limitResizeSnap(rectangle2);
                }
                this.limitResize(rectangle2);
            } else if (this.dragMode == GdeEditor.W_RESIZE_CURSOR) {
                rectangle2.width = rectangle.width - dimension.width;
                rectangle2.x = rectangle.x + dimension.width;
                if (this.editor.fSnap) {
                    this.limitResize(rectangle2);
                    dimension.width = rectangle.width - rectangle2.width;
                    int n = rectangle.x + Wrapper.BORDER_WIDTH;
                    dimension.width = this.snapDelta(dimension.width, n, this.editor.cxGrid);
                    rectangle2.width = rectangle.width - dimension.width;
                    rectangle2.x = rectangle.x + dimension.width;
                    this.limitResizeSnap(rectangle2);
                    rectangle2.x = rectangle.x + rectangle.width - rectangle2.width;
                }
                this.limitResize(rectangle2);
                rectangle2.x = rectangle.x + rectangle.width - rectangle2.width;
            } else if (this.dragMode == GdeEditor.N_RESIZE_CURSOR) {
                rectangle2.height = rectangle.height - dimension.height;
                rectangle2.y = rectangle.y + dimension.height;
                if (this.editor.fSnap) {
                    this.limitResize(rectangle2);
                    dimension.height = rectangle.height - rectangle2.height;
                    int n = rectangle.y + Wrapper.BORDER_WIDTH;
                    dimension.height = this.snapDelta(dimension.height, n, this.editor.cyGrid);
                    rectangle2.height = rectangle.height - dimension.height;
                    rectangle2.y = rectangle.y + dimension.height;
                    this.limitResizeSnap(rectangle2);
                    rectangle2.y = rectangle.y + rectangle.height - rectangle2.height;
                }
                this.limitResize(rectangle2);
                rectangle2.y = rectangle.y + rectangle.height - rectangle2.height;
            } else {
                return;
            }
            this.drawRubberBoxes();
        }
    }

    void endDrag() {
        if (this.dragMode != null) {
            this.deleteRubberBoxes();
            if (this.dragMode == GdeEditor.MOVE_CURSOR) {
                for (int i = 0; i < this.dragChildren.length; ++i) {
                    this.dragChildren[i].setLocation(this.dragBoxes[i].getLocation());
                }
            } else {
                this.dragChildren[0].setBounds(this.dragBoxes[0]);
                if (BeanBox.applet.ps != null) {
                    BeanBox.applet.ps.refresh();
                }
            }
            this.dragMode = null;
        }
    }

    void cancelDrag() {
        this.deleteRubberBoxes();
        this.dragMode = null;
        this.repaint();
    }

    synchronized void alignLeft() {
        int n = this.reference.getLocation().x;
        Wrapper[] wrapperArray = this.getSelected();
        for (int i = 0; i < wrapperArray.length; ++i) {
            if (wrapperArray[i] == this.reference) continue;
            Point point = wrapperArray[i].getLocation();
            wrapperArray[i].setLocation(n, point.y);
        }
    }

    synchronized void alignCenter() {
        Rectangle rectangle = this.reference.getBounds();
        int n = rectangle.x + rectangle.width / 2;
        Wrapper[] wrapperArray = this.getSelected();
        for (int i = 0; i < wrapperArray.length; ++i) {
            if (wrapperArray[i] == this.reference) continue;
            rectangle = wrapperArray[i].getBounds();
            wrapperArray[i].setLocation(n - rectangle.width / 2, rectangle.y);
        }
    }

    synchronized void alignRight() {
        Rectangle rectangle = this.reference.getBounds();
        int n = rectangle.x + rectangle.width;
        Wrapper[] wrapperArray = this.getSelected();
        for (int i = 0; i < wrapperArray.length; ++i) {
            if (wrapperArray[i] == this.reference) continue;
            rectangle = wrapperArray[i].getBounds();
            wrapperArray[i].setLocation(n - rectangle.width, rectangle.y);
        }
    }

    synchronized void alignTop() {
        int n = this.reference.getLocation().y;
        Wrapper[] wrapperArray = this.getSelected();
        for (int i = 0; i < wrapperArray.length; ++i) {
            if (wrapperArray[i] == this.reference) continue;
            Point point = wrapperArray[i].getLocation();
            wrapperArray[i].setLocation(point.x, n);
        }
    }

    synchronized void alignMiddle() {
        Rectangle rectangle = this.reference.getBounds();
        int n = rectangle.y + rectangle.height / 2;
        Wrapper[] wrapperArray = this.getSelected();
        for (int i = 0; i < wrapperArray.length; ++i) {
            if (wrapperArray[i] == this.reference) continue;
            rectangle = wrapperArray[i].getBounds();
            wrapperArray[i].setLocation(rectangle.x, n - rectangle.height / 2);
        }
    }

    synchronized void alignBottom() {
        Rectangle rectangle = this.reference.getBounds();
        int n = rectangle.y + rectangle.height;
        Wrapper[] wrapperArray = this.getSelected();
        for (int i = 0; i < wrapperArray.length; ++i) {
            if (wrapperArray[i] == this.reference) continue;
            rectangle = wrapperArray[i].getBounds();
            wrapperArray[i].setLocation(rectangle.x, n - rectangle.height);
        }
    }

    synchronized void spaceHorz() {
        Cloneable cloneable;
        int n;
        Wrapper[] wrapperArray = this.getSelected();
        Rectangle rectangle = wrapperArray[0].getBounds();
        int n2 = rectangle.width;
        for (n = 1; n < wrapperArray.length; ++n) {
            cloneable = wrapperArray[n].getBounds();
            rectangle.add((Rectangle)cloneable);
            n2 += ((Rectangle)cloneable).width;
        }
        n = (rectangle.width - n2) / (wrapperArray.length - 1);
        if (n > 0) {
            Wrapper wrapper;
            int n3;
            int n4;
            cloneable = new Vector(wrapperArray.length);
            ((Vector)cloneable).addElement(wrapperArray[0]);
            for (int i = 1; i < wrapperArray.length; ++i) {
                n4 = wrapperArray[i].getLocation().x;
                for (n3 = 0; n3 < ((Vector)cloneable).size(); ++n3) {
                    wrapper = (Wrapper)((Vector)cloneable).elementAt(n3);
                    if (n4 < wrapper.getLocation().x) break;
                }
                ((Vector)cloneable).insertElementAt(wrapperArray[i], n3);
            }
            Rectangle rectangle2 = ((Wrapper)((Vector)cloneable).elementAt(0)).getBounds();
            n3 = rectangle2.x + rectangle2.width + n;
            for (n4 = 1; n4 < ((Vector)cloneable).size() - 1; ++n4) {
                wrapper = (Wrapper)((Vector)cloneable).elementAt(n4);
                rectangle2 = wrapper.getBounds();
                wrapper.setLocation(n3, rectangle2.y);
                n3 += rectangle2.width + n;
            }
        }
    }

    synchronized void spaceVert() {
        Cloneable cloneable;
        int n;
        Wrapper[] wrapperArray = this.getSelected();
        Rectangle rectangle = wrapperArray[0].getBounds();
        int n2 = rectangle.height;
        for (n = 1; n < wrapperArray.length; ++n) {
            cloneable = wrapperArray[n].getBounds();
            rectangle.add((Rectangle)cloneable);
            n2 += ((Rectangle)cloneable).height;
        }
        n = (rectangle.height - n2) / (wrapperArray.length - 1);
        if (n > 0) {
            Wrapper wrapper;
            int n3;
            int n4;
            cloneable = new Vector(wrapperArray.length);
            ((Vector)cloneable).addElement(wrapperArray[0]);
            for (int i = 1; i < wrapperArray.length; ++i) {
                n4 = wrapperArray[i].getLocation().y;
                for (n3 = 0; n3 < ((Vector)cloneable).size(); ++n3) {
                    wrapper = (Wrapper)((Vector)cloneable).elementAt(n3);
                    if (n4 < wrapper.getLocation().y) break;
                }
                ((Vector)cloneable).insertElementAt(wrapperArray[i], n3);
            }
            Rectangle rectangle2 = ((Wrapper)((Vector)cloneable).elementAt(0)).getBounds();
            n3 = rectangle2.y + rectangle2.height + n;
            for (n4 = 1; n4 < ((Vector)cloneable).size() - 1; ++n4) {
                wrapper = (Wrapper)((Vector)cloneable).elementAt(n4);
                rectangle2 = wrapper.getBounds();
                wrapper.setLocation(rectangle2.x, n3);
                n3 += rectangle2.height + n;
            }
        }
    }

    synchronized void matchWidth() {
        int n = this.reference.getSize().width;
        Wrapper[] wrapperArray = this.getSelected();
        for (int i = 0; i < wrapperArray.length; ++i) {
            if (wrapperArray[i] == this.reference) continue;
            wrapperArray[i].setSize(n, wrapperArray[i].getSize().height);
        }
    }

    synchronized void matchHeight() {
        int n = this.reference.getSize().height;
        Wrapper[] wrapperArray = this.getSelected();
        for (int i = 0; i < wrapperArray.length; ++i) {
            if (wrapperArray[i] == this.reference) continue;
            wrapperArray[i].setSize(wrapperArray[i].getSize().width, n);
        }
    }

    synchronized void cutSelected() {
        this.copyToClipboard(true);
        this.reference = null;
        this.setCurrentComponent(null, false);
        applet.setPasteEnabled(this.editor.clipboard.size() > 0);
        this.repaint();
    }

    synchronized void copySelected() {
        this.copyToClipboard(false);
        applet.setPasteEnabled(this.editor.clipboard.size() > 0);
    }

    synchronized void paste() {
        Object object;
        Vector vector = this.editor.clipboard;
        this.setCurrentComponent(null, true);
        Rectangle rectangle = null;
        for (int i = 0; i < vector.size(); ++i) {
            object = (ClipObject)vector.elementAt(i);
            if (rectangle == null) {
                rectangle = new Rectangle(((ClipObject)object).bounds);
                continue;
            }
            rectangle.add(((ClipObject)object).bounds);
        }
        Dimension dimension = this.getSize();
        this.setSize(0, 0);
        object = null;
        for (int i = vector.size() - 1; i >= 0; --i) {
            ClipObject clipObject = (ClipObject)vector.elementAt(i);
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(clipObject.copy);
                ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                Wrapper wrapper = (Wrapper)objectInputStream.readObject();
                wrapper.setLocation(clipObject.bounds.x - rectangle.x, clipObject.bounds.y - rectangle.y);
                this.addBean(wrapper);
                wrapper.connect(applet);
                wrapper.getBean().repaint();
                wrapper.setSelected(true);
                object = wrapper;
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.setSize(dimension);
        this.setCurrentComponent((Wrapper)object, false);
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyToClipboard(boolean bl) {
        this.editor.clipboard.removeAllElements();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Wrapper[] wrapperArray = this.getSelected();
        for (int i = 0; i < wrapperArray.length; ++i) {
            Object var9_9;
            byteArrayOutputStream.reset();
            wrapperArray[i].disconnect();
            try {
                try {
                    ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                    objectOutputStream.writeObject(wrapperArray[i]);
                    objectOutputStream.close();
                    Rectangle rectangle = new Rectangle(wrapperArray[i].getBounds());
                    ClipObject clipObject = new ClipObject(rectangle, byteArrayOutputStream.toByteArray());
                    this.editor.clipboard.addElement(clipObject);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    var9_9 = null;
                    if (bl) {
                        this.remove(wrapperArray[i]);
                        continue;
                    }
                    wrapperArray[i].connect(applet);
                    continue;
                }
                var9_9 = null;
                if (bl) {
                    this.remove(wrapperArray[i]);
                    continue;
                }
                wrapperArray[i].connect(applet);
                continue;
            }
            catch (Throwable throwable) {
                var9_9 = null;
                if (bl) {
                    this.remove(wrapperArray[i]);
                } else {
                    wrapperArray[i].connect(applet);
                }
                throw throwable;
            }
        }
    }

    private void addBean(Wrapper wrapper) {
        wrapper.setUserInputEnabled(true);
        this.add((Component)wrapper, 0);
        wrapper.setUserInputEnabled(false);
    }

    private final void snapMove(Dimension dimension, int n, int n2) {
        dimension.width = this.snapDelta(dimension.width, n, this.editor.cxGrid);
        dimension.height = this.snapDelta(dimension.height, n2, this.editor.cyGrid);
    }

    private final int snapDelta(int n, int n2, int n3) {
        int n4 = (n2 + n + n3 / 2) / n3 * n3;
        return n4 - n2;
    }

    private final void limitMove(Dimension dimension) {
        if (this.dragBounds.x + dimension.width < this.bbBounds.x) {
            dimension.width = this.bbBounds.x - this.dragBounds.x;
        } else if (this.dragBounds.x + this.dragBounds.width + dimension.width > this.bbBounds.x + this.bbBounds.width) {
            dimension.width = this.bbBounds.x + this.bbBounds.width - this.dragBounds.width - this.dragBounds.x;
        }
        if (this.dragBounds.y + dimension.height < this.bbBounds.y) {
            dimension.height = this.bbBounds.y - this.dragBounds.y;
        } else if (this.dragBounds.y + this.dragBounds.height + dimension.height > this.bbBounds.y + this.bbBounds.height) {
            dimension.height = this.bbBounds.y + this.bbBounds.height - this.dragBounds.height - this.dragBounds.y;
        }
    }

    private final void limitMoveSnap(Dimension dimension) {
        if (this.dragBounds.x + dimension.width < this.bbBounds.x) {
            dimension.width += this.editor.cxGrid;
        } else if (this.dragBounds.x + this.dragBounds.width + dimension.width > this.bbBounds.x + this.bbBounds.width) {
            dimension.width -= this.editor.cxGrid;
        }
        if (this.dragBounds.y + dimension.height < this.bbBounds.y) {
            dimension.height += this.editor.cyGrid;
        } else if (this.dragBounds.y + this.dragBounds.height + dimension.height > this.bbBounds.y + this.bbBounds.height) {
            dimension.height -= this.editor.cyGrid;
        }
    }

    private final void limitResize(Rectangle rectangle) {
        if (rectangle.x < this.bbBounds.x) {
            rectangle.width -= this.bbBounds.x - rectangle.x;
        } else if (rectangle.x + rectangle.width > this.bbBounds.x + this.bbBounds.width) {
            rectangle.width = this.bbBounds.x + this.bbBounds.width - rectangle.x;
        }
        if (rectangle.y < this.bbBounds.y) {
            rectangle.height -= this.bbBounds.y - rectangle.y;
        } else if (rectangle.y + rectangle.height > this.bbBounds.y + this.bbBounds.height) {
            rectangle.height = this.bbBounds.y + this.bbBounds.height - rectangle.y;
        }
        if (rectangle.width < this.minDragSize.width) {
            rectangle.width = this.minDragSize.width;
        }
        if (rectangle.width > this.maxDragSize.width) {
            rectangle.width = this.maxDragSize.width;
        }
        if (rectangle.height < this.minDragSize.height) {
            rectangle.height = this.minDragSize.height;
        }
        if (rectangle.height > this.maxDragSize.height) {
            rectangle.height = this.maxDragSize.height;
        }
    }

    private final void limitResizeSnap(Rectangle rectangle) {
        if (rectangle.x < this.bbBounds.x) {
            rectangle.width -= this.editor.cxGrid;
        } else if (rectangle.x + rectangle.width > this.bbBounds.x + this.bbBounds.width) {
            rectangle.width -= this.editor.cxGrid;
        }
        if (rectangle.y < this.bbBounds.y) {
            rectangle.height -= this.editor.cyGrid;
        } else if (rectangle.y + rectangle.height > this.bbBounds.y + this.bbBounds.height) {
            rectangle.height -= this.editor.cyGrid;
        }
        if (rectangle.width < this.minDragSize.width) {
            rectangle.width += this.editor.cxGrid;
        }
        if (rectangle.width > this.maxDragSize.width) {
            rectangle.width -= this.editor.cxGrid;
        }
        if (rectangle.height < this.minDragSize.height) {
            rectangle.height += this.editor.cyGrid;
        }
        if (rectangle.height > this.maxDragSize.height) {
            rectangle.height -= this.editor.cyGrid;
        }
    }

    private final void drawRubberBoxes() {
        this.deleteRubberBoxes();
        this.rubberBoxes = new Rectangle[this.dragBoxes.length];
        for (int i = 0; i < this.dragBoxes.length; ++i) {
            this.rubberBoxes[i] = new Rectangle(this.dragBoxes[i]);
            this.rubberBoxes[i].grow(-Wrapper.BORDER_WIDTH, -Wrapper.BORDER_WIDTH);
        }
        this.drawXORBoxes(this, this.rubberBoxes);
    }

    private final void deleteRubberBoxes() {
        if (this.rubberBoxes != null) {
            this.drawXORBoxes(this, this.rubberBoxes);
            this.rubberBoxes = null;
        }
    }

    private final Point translatePoint(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        for (Component component = (Component)mouseEvent.getSource(); component != this; component = component.getParent()) {
            Point point2 = component.getLocation();
            point.x += point2.x;
            point.y += point2.y;
        }
        return point;
    }

    private final Wrapper[] getSelected() {
        Component[] componentArray = this.getComponents();
        Wrapper[] wrapperArray = new Wrapper[componentArray.length];
        int n = 0;
        for (int i = 0; i < componentArray.length; ++i) {
            Wrapper wrapper = (Wrapper)componentArray[i];
            if (!wrapper.isSelected()) continue;
            wrapperArray[n++] = wrapper;
        }
        Wrapper[] wrapperArray2 = new Wrapper[n];
        System.arraycopy(wrapperArray, 0, wrapperArray2, 0, n);
        return wrapperArray2;
    }

    private final int getSelectedCount() {
        Component[] componentArray = this.getComponents();
        int n = 0;
        for (int i = 0; i < componentArray.length; ++i) {
            if (!((Wrapper)componentArray[i]).isSelected()) continue;
            ++n;
        }
        return n;
    }

    private void startSelect(MouseEvent mouseEvent) {
        this.selectStart = mouseEvent.getPoint();
        this.selectBox = new Rectangle(this.selectStart);
        this.drawRubberBox();
    }

    private void dragSelect(MouseEvent mouseEvent) {
        if (this.selectBox != null) {
            int n = mouseEvent.getX() - this.selectStart.x;
            int n2 = mouseEvent.getY() - this.selectStart.y;
            this.selectBox.x = n > 0 ? this.selectStart.x : mouseEvent.getX();
            this.selectBox.y = n2 > 0 ? this.selectStart.y : mouseEvent.getY();
            this.selectBox.width = n > 0 ? n : -n;
            this.selectBox.height = n2 > 0 ? n2 : -n2;
            this.drawRubberBox();
        }
    }

    private void endSelect() {
        this.deleteRubberBox();
        if (this.selectBox != null) {
            this.reference = null;
            Wrapper wrapper = null;
            Component[] componentArray = this.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                Wrapper wrapper2 = (Wrapper)componentArray[i];
                wrapper2.setSelected(wrapper2.getBounds().intersects(this.selectBox));
                if (wrapper != null || !wrapper2.isSelected()) continue;
                wrapper = wrapper2;
            }
            this.selectBox = null;
            this.setCurrentComponent(wrapper, false);
        }
    }

    private void cancelSelect() {
        this.selectBox = null;
        this.deleteRubberBox();
    }

    private final void drawRubberBox() {
        this.deleteRubberBox();
        this.rubberBox = new Rectangle(this.selectBox);
        this.drawXORBox(this, this.rubberBox);
    }

    private final void deleteRubberBox() {
        if (this.rubberBox != null) {
            this.drawXORBox(this, this.rubberBox);
            this.rubberBox = null;
        }
    }

    private final void drawXORBox(Container container, Rectangle rectangle) {
        Rectangle[] rectangleArray = new Rectangle[]{rectangle};
        this.drawXORBoxes(container, rectangleArray);
    }

    private final void drawXORBoxes(Container container, Rectangle[] rectangleArray) {
        Rectangle rectangle = new Rectangle(container.getSize());
        boolean bl = false;
        Graphics graphics = container.getGraphics();
        for (int i = 0; i < rectangleArray.length; ++i) {
            if (!this.drawXORBox(graphics, rectangle, rectangleArray[i])) continue;
            bl = true;
        }
        graphics.dispose();
        if (bl) {
            Component[] componentArray = container.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                Point point = componentArray[i].getLocation();
                if (componentArray[i] instanceof Container) {
                    Rectangle[] rectangleArray2 = new Rectangle[rectangleArray.length];
                    for (int j = 0; j < rectangleArray.length; ++j) {
                        rectangleArray2[j] = new Rectangle(rectangleArray[j]);
                        rectangleArray2[j].translate(-point.x, -point.y);
                    }
                    this.drawXORBoxes((Container)componentArray[i], rectangleArray2);
                    continue;
                }
                if (componentArray[i].getPeer() instanceof LightweightPeer) continue;
                rectangle = new Rectangle(componentArray[i].getSize());
                graphics = componentArray[i].getGraphics();
                for (int j = 0; j < rectangleArray.length; ++j) {
                    Rectangle rectangle2 = new Rectangle(rectangleArray[j]);
                    rectangle2.translate(-point.x, -point.y);
                    this.drawXORBox(graphics, rectangle, rectangle2);
                }
                graphics.dispose();
            }
        }
    }

    private final boolean drawXORBox(Graphics graphics, Rectangle rectangle, Rectangle rectangle2) {
        if (rectangle2.intersects(rectangle)) {
            graphics.setColor(Color.black);
            graphics.setXORMode(Color.white);
            graphics.drawRect(rectangle2.x, rectangle2.y, rectangle2.width - 1, rectangle2.height - 1);
            return true;
        }
        return false;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (applet != null) {
            if (this.dragMode != null) {
                this.cancelDrag();
            }
            if (this.selectBox != null) {
                this.cancelSelect();
            }
            if (BeanBox.applet.idBeanInsert < 0) {
                this.setCursor(GdeEditor.SELECT_CURSOR);
            } else {
                this.setCursor(GdeEditor.INSERT_CURSOR);
            }
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (applet != null && BeanBox.applet.idBeanInsert < 0 && BeanBox.applet.fEditMode) {
            this.startSelect(mouseEvent);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (applet != null && BeanBox.applet.idBeanInsert < 0) {
            if (this.selectBox != null) {
                this.dragSelect(mouseEvent);
            } else {
                this.doDrag(mouseEvent);
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (applet != null && BeanBox.applet.idBeanInsert < 0) {
            if (this.selectBox != null) {
                this.endSelect();
            } else {
                this.endDrag();
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (!BeanBox.applet.fEditMode) {
            this.iNbclik += mouseEvent.getClickCount();
            if (this.iNbclik >= 2) {
                BeanBox.applet.topPanel.setVisible(!BeanBox.applet.topPanel.isVisible());
                int n = BeanBox.applet.getSize().width;
                int n2 = BeanBox.applet.getSize().height;
                applet.resize(n + 1, n2 + 1);
                applet.resize(n, n2);
                this.iNbclik = 0;
            }
        }
        if (applet != null && BeanBox.applet.fEditMode) {
            if (mouseEvent.getClickCount() == 1) {
                if (BeanBox.applet.idBeanInsert >= 0) {
                    this.insertBean(mouseEvent.getX(), mouseEvent.getY());
                }
            } else if (mouseEvent.getClickCount() == 2) {
                applet.showPropertySheet();
            }
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }
}

