/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.gde;

import com.schneiderautomation.gde.GdeTopPanel;
import com.schneiderautomation.gde.ObjectDescriptor;
import com.schneiderautomation.gde.PaletteDescriptor;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.io.DataInputStream;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class BeanLoader
extends Thread {
    private GdeTopPanel topPanel;
    private Vector palettes;
    private String paletteParam;
    private InputStream is;
    private DataInputStream dis;
    private String ligne;
    private String tablo = "";
    private int nbMaxConcat = 0;
    private int indexnbmax = 0;
    private static Hashtable beaninfo = new Hashtable();

    BeanLoader(GdeTopPanel gdeTopPanel, Vector vector, String string) {
        this.topPanel = gdeTopPanel;
        this.palettes = vector;
        this.paletteParam = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.buildPalette();
            this.loadBeans();
        }
        finally {
            this.topPanel.beanInitDone();
        }
    }

    private void buildPalette() {
        PaletteDescriptor paletteDescriptor = null;
        try {
            this.is = this.getClass().getResourceAsStream("/Toolbar.txt");
            this.dis = new DataInputStream(this.is);
            this.ligne = this.dis.readLine();
            int n = 0;
            while (this.ligne != null) {
                this.tablo = this.tablo + this.ligne;
                this.ligne = this.dis.readLine();
                ++n;
            }
        }
        catch (Exception exception) {
            System.out.println("Error reading File");
        }
        this.paletteParam = this.tablo;
        StringTokenizer stringTokenizer = new StringTokenizer(this.paletteParam, "[");
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            try {
                int n = string.indexOf("]");
                String string2 = string.substring(0, n).trim();
                String string3 = string.substring(n + 1).trim();
                if (!string2.equals("widgetLoadermax")) {
                    paletteDescriptor = new PaletteDescriptor(string2);
                    StringTokenizer stringTokenizer2 = new StringTokenizer(string3, ";");
                    for (int i = 0; stringTokenizer2.hasMoreTokens() && i < this.nbMaxConcat; ++i) {
                        String string4 = stringTokenizer2.nextToken().trim();
                        if (string4.length() <= 0) continue;
                        paletteDescriptor.objects.addElement(new ObjectDescriptor(string4));
                    }
                    this.palettes.addElement(paletteDescriptor);
                    continue;
                }
                this.indexnbmax = string.indexOf("=");
                this.nbMaxConcat = Integer.parseInt(string.substring(this.indexnbmax + 1).trim());
            }
            catch (Exception exception) {
                System.err.println("Syntax error parsing 'PALETTE' parameter: " + string);
            }
        }
    }

    private void loadBeans() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        for (int i = 0; i < this.palettes.size(); ++i) {
            PaletteDescriptor paletteDescriptor = (PaletteDescriptor)this.palettes.elementAt(i);
            for (int j = 0; j < paletteDescriptor.objects.size(); ++j) {
                ObjectDescriptor objectDescriptor = (ObjectDescriptor)paletteDescriptor.objects.elementAt(j);
                BeanInfo beanInfo = BeanLoader.getBeanInfo(classLoader, objectDescriptor.name);
                if (beanInfo != null) {
                    objectDescriptor.icon = beanInfo.getIcon(2);
                    BeanDescriptor beanDescriptor = beanInfo.getBeanDescriptor();
                    if (beanDescriptor != null) {
                        objectDescriptor.label = beanDescriptor.getDisplayName();
                        objectDescriptor.desc = beanDescriptor.getShortDescription();
                    }
                    if (objectDescriptor.label != null) continue;
                    objectDescriptor.label = objectDescriptor.name.substring(objectDescriptor.name.lastIndexOf(46) + 1);
                    continue;
                }
                paletteDescriptor.objects.removeElementAt(j--);
            }
        }
    }

    static Class getCustomizerClass(Class clazz) {
        BeanDescriptor beanDescriptor;
        BeanInfo beanInfo = BeanLoader.getBeanInfo(clazz);
        if (beanInfo != null && (beanDescriptor = beanInfo.getBeanDescriptor()) != null) {
            return beanDescriptor.getCustomizerClass();
        }
        return null;
    }

    public static BeanInfo getBeanInfo(Class clazz) {
        return BeanLoader.getBeanInfo(clazz.getClassLoader(), clazz.getName());
    }

    public static synchronized BeanInfo getBeanInfo(ClassLoader classLoader, String string) {
        String string2 = string + "BeanInfo";
        BeanInfo beanInfo = (BeanInfo)beaninfo.get(string2);
        if (beanInfo == null) {
            try {
                Class<?> clazz = classLoader != null ? classLoader.loadClass(string2) : Class.forName(string2);
                beanInfo = (BeanInfo)clazz.newInstance();
                beaninfo.put(string2, beanInfo);
            }
            catch (ClassNotFoundException classNotFoundException) {
                try {
                    Class<?> clazz = classLoader != null ? classLoader.loadClass(string) : Class.forName(string);
                    beanInfo = Introspector.getBeanInfo(clazz);
                    beaninfo.put(string2, beanInfo);
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    System.err.println("Unable to find class " + string);
                }
                catch (IntrospectionException introspectionException) {
                    System.err.println("Unable to introspect " + string + ": " + introspectionException.getMessage());
                }
                catch (SecurityException securityException) {
                    System.err.println("Security Exception loading " + string);
                }
                catch (Exception exception) {
                    System.err.println("Exception loading " + string);
                    exception.printStackTrace();
                }
            }
            catch (Exception exception) {
                System.err.println("Exception loading " + string2);
                exception.printStackTrace();
            }
            catch (Error error) {
                System.err.println("Error loading " + string2 + ": " + error);
            }
        }
        return beanInfo;
    }
}

