/*
 * Decompiled with CFR 0.152.
 */
package GXGrid;

import GXGrid.GXCell;
import GXGrid.GXControl;
import GXGrid.GXCover;
import GXGrid.GXData;
import GXGrid.GXDebug;
import GXGrid.GXGridParam;
import GXGrid.GXGridView;
import GXGrid.GXLabel;
import GXGrid.GXProperties;
import GXGrid.GXPtrArray;
import GXGrid.GXRange;
import GXGrid.GXStyle;
import GXGrid.GXStylesMap;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.SystemColor;
import java.util.Vector;

public class GXCore
extends af {
    public GXGridParam m_gxParam = new GXGridParam();
    public int m_nGridWidth;
    public int m_nGridHeight;
    public int A;
    public int B;
    public int m_nYLastRow;
    public int m_nXLastCol;
    public boolean C = false;
    public static final int LABEL = 1;
    public static final int IMAGE = 2;
    public static final int MOVE = 0;
    public static final int DELETE = 1;
    public static final int INSERT = 2;
    public GXPtrArray m_rgList;
    public transient Vector D;

    public GXCore() {
        this(2, 2);
    }

    public GXCore(int n2, int n3) {
        GXStylesMap gXStylesMap = new GXStylesMap();
        gXStylesMap.setDefaultStyles();
        this.m_gxParam.setStylesMap(gXStylesMap).setData(new GXData()).setProperties(new GXProperties());
        this.registerControls();
        this.m_gxParam.getData().storeRowCount(n2);
        this.m_gxParam.getData().storeColCount(n3);
        this.m_rgList = new GXPtrArray();
        this.D = new Vector();
    }

    public GXGridParam getParam() {
        return this.m_gxParam;
    }

    public void setParam(GXGridParam gXGridParam) {
        this.m_gxParam = gXGridParam;
    }

    public void registerControls() {
        this.registerControl(new GXLabel(this), 1);
    }

    public void addNotify() {
        super.addNotify();
        this.gridInitialUpdate();
        this.updateScrollbar();
    }

    public void gridInitialUpdate() {
        GXStyle gXStyle = new GXStyle();
        gXStyle.changeStyle(this.standardStyle(), 2);
        gXStyle.setFont(new Font("Dialog", 0, 12));
        this.setTableStyle(gXStyle);
    }

    public void registerControl(GXControl gXControl, int n2) {
        this.getParam().registerControl(gXControl, n2);
    }

    public boolean unregisterControl(int n2) {
        return this.getParam().unregisterControl(n2);
    }

    public synchronized GXStyle getStyleObject() {
        if (this.D == null || this.D.size() < 1) {
            return new GXStyle();
        }
        int n2 = this.D.size() - 1;
        GXStyle gXStyle = (GXStyle)this.D.elementAt(n2);
        this.D.removeElementAt(n2);
        return gXStyle;
    }

    public void recycleStyleObject(GXStyle gXStyle) {
        if (this.D == null) {
            this.D = new Vector();
        }
        if (gXStyle != null && this.D.size() < 50) {
            this.D.addElement(gXStyle);
        }
    }

    public boolean isTransparentBackground() {
        return this.getParam().isTransparentBackground();
    }

    public void setTransparentBackground(boolean bl) {
        this.getParam().setTransparentBackground(bl);
    }

    public void setMarkCurRow(boolean bl) {
        this.m_gxParam.getProperties().setMarkCurRow(bl);
    }

    public boolean getMarkCurRow() {
        return this.m_gxParam.getProperties().getMarkCurRow();
    }

    public void setMarkCurCol(boolean bl) {
        this.m_gxParam.getProperties().setMarkCurCol(bl);
    }

    public boolean getMarkCurCol() {
        return this.m_gxParam.getProperties().getMarkCurCol();
    }

    public boolean isLockUpdate() {
        return this.m_gxParam.v;
    }

    public boolean setLockUpdate(boolean bl) {
        boolean bl2 = this.m_gxParam.v;
        this.m_gxParam.v = bl;
        return bl2;
    }

    public synchronized void setBorder(boolean bl) {
        if (this.C != bl) {
            this.C = bl;
            this.repaint();
        }
    }

    public boolean isBorder() {
        return this.C;
    }

    public void set3DButtonColor(Color color) {
        this.m_gxParam.getProperties().setColor(2, color);
        this.colHeaderStyle().setBackground(color);
        this.rowHeaderStyle().setBackground(color);
    }

    public Color get3DButtonColor() {
        return this.m_gxParam.getProperties().getColor(2);
    }

    public void set3DButtonTextColor(Color color) {
        this.m_gxParam.getProperties().setColor(3, color);
        this.colHeaderStyle().setForeground(color);
        this.rowHeaderStyle().setForeground(color);
    }

    public Color get3DButtonTextColor() {
        return this.m_gxParam.getProperties().getColor(3);
    }

    public void setGridLineColor(Color color) {
        this.m_gxParam.getProperties().setColor(0, color);
    }

    public Color getGridLineColor() {
        return this.m_gxParam.getProperties().getColor(0);
    }

    public void setSizeLineColor(Color color) {
        this.m_gxParam.getProperties().setColor(1, color);
    }

    public Color getSizeLineColor() {
        return this.m_gxParam.getProperties().getColor(1);
    }

    public void setSelectionRectColor(Color color) {
        this.m_gxParam.getProperties().setColor(4, color);
    }

    public Color getSelectionRectColor() {
        return this.m_gxParam.getProperties().getColor(4);
    }

    public void setControlColor(Color color) {
        this.m_gxParam.getProperties().setColor(5, color);
    }

    public Color getControlColor() {
        return this.m_gxParam.getProperties().getColor(5);
    }

    public void setControlTextColor(Color color) {
        this.m_gxParam.getProperties().setColor(6, color);
    }

    public Color getControlTextColor() {
        return this.m_gxParam.getProperties().getColor(6);
    }

    public void setControlHighlightColor(Color color) {
        this.m_gxParam.getProperties().setColor(7, color);
    }

    public Color getControlHighlightColor() {
        return this.m_gxParam.getProperties().getColor(7);
    }

    public void setControlLtHighlightColor(Color color) {
        this.m_gxParam.getProperties().setColor(8, color);
    }

    public Color getControlLtHighlightColor() {
        return this.m_gxParam.getProperties().getColor(8);
    }

    public void setControlShadowColor(Color color) {
        this.m_gxParam.getProperties().setColor(9, color);
    }

    public Color getControlShadowColor() {
        return this.m_gxParam.getProperties().getColor(9);
    }

    public void setControlDKShadowColor(Color color) {
        this.m_gxParam.getProperties().setColor(10, color);
    }

    public Color getControlDKShadowColor() {
        return this.m_gxParam.getProperties().getColor(10);
    }

    public void setDrawHLine(boolean bl) {
        this.m_gxParam.getProperties().setDisplayHorzLines(bl);
    }

    public boolean getDrawHLine() {
        return this.m_gxParam.getProperties().getDisplayHorzLines();
    }

    public void setDrawVLine(boolean bl) {
        this.m_gxParam.getProperties().setDisplayVertLines(bl);
    }

    public boolean getDrawVLine() {
        return this.m_gxParam.getProperties().getDisplayVertLines();
    }

    public boolean get3DButtons() {
        return this.m_gxParam.getProperties().getDraw3DHead();
    }

    public void set3DButtons(boolean bl) {
        this.m_gxParam.getProperties().setDraw3DHead(bl);
        if (bl) {
            this.colHeaderStyle().setDraw3dFrame(2);
            this.rowHeaderStyle().setDraw3dFrame(2);
            return;
        }
        this.colHeaderStyle().setDraw3dFrame(0);
        this.rowHeaderStyle().setDraw3dFrame(0);
    }

    public boolean isThickFrame() {
        return this.m_gxParam.getProperties().isThickFrame();
    }

    public void setThickFrame(boolean bl) {
        boolean bl2 = this.isThickFrame();
        if (bl2 && !bl || !bl2 && bl) {
            this.m_gxParam.getProperties().setThickFrame(bl);
            if (this.isShowing()) {
                this.update();
            }
        }
    }

    public void setDrawingTechnique(boolean bl) {
        this.m_bDoubleBuffering = !bl;
    }

    public int getHeaderRows() {
        return this.m_gxParam.getHeaderRows();
    }

    public void setHeaderRows(int n2) {
        this.m_gxParam.setHeaderRows(n2);
    }

    public int getHeaderCols() {
        return this.m_gxParam.getHeaderCols();
    }

    public void setHeaderCols(int n2) {
        this.m_gxParam.setHeaderCols(n2);
    }

    public boolean isBaseStyleUsed() {
        return this.getParam().isBaseStyleUsed();
    }

    public void setBaseStyleUsed(boolean bl) {
        this.getParam().setBaseStyleUsed(bl);
    }

    public boolean setValueRange(GXRange gXRange, String string) {
        int n2 = gXRange.top;
        while (n2 <= gXRange.bottom) {
            int n3 = gXRange.left;
            while (n3 <= gXRange.right) {
                this.setCellValue(new GXCell(n2, n3), string);
                ++n3;
            }
            ++n2;
        }
        return true;
    }

    public void setCellValue(int n2, int n3, String string) {
        GXStyle gXStyle = this.getStyleObject();
        this.getStyleRowCol(n2, n3, gXStyle, 2);
        if (gXStyle == null) {
            gXStyle = this.getStyleObject();
        }
        gXStyle.setValue(string);
        this.storeStyleRowCol(n2, n3, gXStyle, 2);
    }

    public void setCellValue(GXCell gXCell, String string) {
        GXStyle gXStyle = this.getStyleObject();
        this.getStyleRowCol(gXCell.row, gXCell.col, gXStyle, 2);
        if (gXStyle == null) {
            gXStyle = this.getStyleObject();
        }
        gXStyle.setValue(string);
        this.storeStyleRowCol(gXCell.row, gXCell.col, gXStyle, 2);
    }

    public String getCellValue(int n2, int n3) {
        GXStyle gXStyle = this.getStyleObject();
        this.getStyleRowCol(n2, n3, gXStyle, 2);
        if (gXStyle == null) {
            return null;
        }
        return gXStyle.getValue();
    }

    public void setCellChoice(int n2, int n3, String string) {
        GXStyle gXStyle = this.getStyleObject();
        this.getStyleRowCol(n2, n3, gXStyle, 2);
        if (gXStyle == null) {
            gXStyle = this.getStyleObject();
        }
        gXStyle.setChoice(string);
        this.storeStyleRowCol(n2, n3, gXStyle, 2);
    }

    public void setCellChoice(GXCell gXCell, String string) {
        GXStyle gXStyle = this.getStyleObject();
        this.getStyleRowCol(gXCell.row, gXCell.col, gXStyle, 2);
        if (gXStyle == null) {
            gXStyle = this.getStyleObject();
        }
        gXStyle.setChoice(string);
        this.storeStyleRowCol(gXCell.row, gXCell.col, gXStyle, 2);
    }

    public String getCellChoice(int n2, int n3) {
        GXStyle gXStyle = this.getStyleObject();
        this.getStyleRowCol(n2, n3, gXStyle, 2);
        if (gXStyle == null) {
            return null;
        }
        return gXStyle.getChoice();
    }

    public void clearCells(GXRange gXRange, boolean bl) {
        if (bl) {
            int n2 = gXRange.top;
            while (n2 <= gXRange.bottom) {
                int n3 = gXRange.left;
                while (n3 <= gXRange.right) {
                    GXStyle gXStyle = this.getStyleObject();
                    this.getStyleRowCol(n2, n3, gXStyle, 2);
                    gXStyle.setIncludeValue(false);
                    gXStyle.setIncludeChoice(false);
                    this.storeStyleRowCol(n2, n3, gXStyle, 2, 0);
                    ++n3;
                }
                ++n2;
            }
            return;
        }
        int n4 = gXRange.top;
        while (n4 <= gXRange.bottom) {
            int n5 = gXRange.left;
            while (n5 <= gXRange.right) {
                this.storeStyleRowCol(n4, n5, null, 4, 0);
                ++n5;
            }
            ++n4;
        }
    }

    public GXStyle standardStyle() {
        return this.m_gxParam.getStylesMap().getStandardStyle();
    }

    public GXStyle rowHeaderStyle() {
        return this.m_gxParam.getStylesMap().getRowHeaderStyle();
    }

    public GXStyle colHeaderStyle() {
        return this.m_gxParam.getStylesMap().getColHeaderStyle();
    }

    public boolean setTableStyle(GXStyle gXStyle) {
        return this.m_gxParam.getData().storeStyleRowCol(0, 0, gXStyle, 2, -3);
    }

    public boolean getTableStyle(GXStyle gXStyle) {
        return this.getStyleRowCol(0, 0, gXStyle, 2, -3);
    }

    public boolean setRowStyle(int n2, GXStyle gXStyle) {
        if (gXStyle == null) {
            return this.m_gxParam.getData().storeStyleRowCol(n2, 0, null, 4, -2);
        }
        return this.m_gxParam.getData().storeStyleRowCol(n2, 0, gXStyle, 2, -2);
    }

    public boolean getRowStyle(int n2, GXStyle gXStyle) {
        return this.getStyleRowCol(n2, 0, gXStyle, 2, -2);
    }

    public boolean setColStyle(int n2, GXStyle gXStyle) {
        if (gXStyle == null) {
            return this.m_gxParam.getData().storeStyleRowCol(0, n2, null, 4, -1);
        }
        return this.m_gxParam.getData().storeStyleRowCol(0, n2, gXStyle, 2, -1);
    }

    public boolean getColStyle(int n2, GXStyle gXStyle) {
        return this.getStyleRowCol(0, n2, gXStyle, 2, -1);
    }

    public boolean storeStyleRowCol(int n2, int n3, GXStyle gXStyle) {
        return this.m_gxParam.getData().storeStyleRowCol(n2, n3, gXStyle, 0, 0);
    }

    public boolean storeStyleRowCol(int n2, int n3, GXStyle gXStyle, int n4) {
        return this.m_gxParam.getData().storeStyleRowCol(n2, n3, gXStyle, n4, 0);
    }

    public boolean storeStyleRowCol(int n2, int n3, GXStyle gXStyle, int n4, int n5) {
        return this.m_gxParam.getData().storeStyleRowCol(n2, n3, gXStyle, n4, n5);
    }

    public boolean composeStyleRowCol(int n2, int n3, GXStyle gXStyle) {
        int n4 = this.getHeaderCols();
        int n5 = this.getHeaderRows();
        if (!this.getStyleRowCol(n2, n3, gXStyle, 2, 0)) {
            return false;
        }
        if (n3 > n4) {
            this.getStyleRowCol(n2, 0, gXStyle, 0, -1);
        }
        if (n2 > n5) {
            this.getStyleRowCol(0, n3, gXStyle, 0, -1);
        }
        if (n2 > n5 && n3 > n4) {
            this.getStyleRowCol(0, 0, gXStyle, 0, -1);
        }
        if (this.isBaseStyleUsed()) {
            gXStyle.loadBaseStyle();
        }
        if (n2 <= n5) {
            gXStyle.changeStyle(this.rowHeaderStyle(), 0);
        }
        if (n3 <= n4) {
            gXStyle.changeStyle(this.colHeaderStyle(), 0);
        }
        gXStyle.changeStyle(this.standardStyle(), 0);
        return true;
    }

    public boolean getStyleRowCol(int n2, int n3, GXStyle gXStyle) {
        if (n2 < this.getHeaderRows() || n3 < this.getHeaderCols()) {
            if (n3 < this.getHeaderCols()) {
                gXStyle.changeStyle(this.rowHeaderStyle(), 0);
                gXStyle.setControl(new GXLabel(this));
            } else if (n2 < this.getHeaderRows()) {
                gXStyle.changeStyle(this.colHeaderStyle(), 0);
                gXStyle.setControl(new GXLabel(this));
            }
            GXStyle gXStyle2 = this.getStyleObject();
            if (this.getStyleRowCol(n2, n3, gXStyle2, 2, 0)) {
                gXStyle.changeStyle(gXStyle2, 1);
            }
            return true;
        }
        return this.getStyleRowCol(n2, n3, gXStyle, 0, 0);
    }

    public boolean getStyleRowCol(int n2, int n3, GXStyle gXStyle, int n4) {
        return this.getStyleRowCol(n2, n3, gXStyle, n4, 0);
    }

    public boolean getStyleRowCol(int n2, int n3, GXStyle gXStyle, int n4, int n5) {
        if (n2 < 0 || n3 < 0) {
            return false;
        }
        return this.m_gxParam.getData().getStyleRowCol(n2, n3, gXStyle, n4, n5);
    }

    public int getRowCount() {
        return this.m_gxParam.getData().getRowCount();
    }

    public int getColCount() {
        return this.m_gxParam.getData().getColCount();
    }

    public boolean storeRowCount(int n2) {
        return this.m_gxParam.getData().storeRowCount(n2);
    }

    public void setRowCount(int n2) {
        this.m_gxParam.getData().storeRowCount(n2);
        this.updateScrollbar();
    }

    public boolean storeColCount(int n2) {
        return this.m_gxParam.getData().storeColCount(n2);
    }

    public void setColCount(int n2) {
        this.m_gxParam.getData().storeColCount(n2);
        this.updateScrollbar();
    }

    public boolean storeInsertRows(int n2, int n3) {
        return this.storeInsertRows(n2, n3, null, 0, -1, true);
    }

    public boolean storeInsertRows(int n2, int n3, int[] nArray, int n4, int n5, boolean bl) {
        this.deactiveCurrentCell();
        boolean bl2 = true;
        if (bl) {
            bl2 = this.m_gxParam.getData().storeInsertRows(n2, n3);
        }
        if (bl2) {
            int n6 = this.getRowCount();
            int[] nArray2 = new int[n6 - n2];
            int n7 = n2;
            while (n7 < n6) {
                nArray2[n7 - n2] = this.getRowHeight(n7);
                ++n7;
            }
            n7 = n2;
            while (n7 < n2 + n3) {
                this.storeRowHeight(n7, this.getDefaultRowHeight());
                ++n7;
            }
            n7 = n2;
            while (n7 < n6) {
                this.storeRowHeight(n7 + n3, nArray2[n7 - n2]);
                ++n7;
            }
            this.updateCovers(n2, n3, 0, 2, true);
            this.updateScrollbar();
        }
        return bl2;
    }

    public boolean storeInsertCols(int n2, int n3) {
        return this.storeInsertCols(n2, n3, null, 0, -1, true);
    }

    public boolean storeInsertCols(int n2, int n3, int[] nArray, int n4, int n5, boolean bl) {
        this.deactiveCurrentCell();
        boolean bl2 = true;
        if (bl) {
            bl2 = this.m_gxParam.getData().storeInsertCols(n2, n3);
        }
        int n6 = this.getColCount();
        if (bl2 && n2 < n6 - n3) {
            int[] nArray2 = new int[n6 - n2];
            int n7 = n2;
            while (n7 < n6) {
                nArray2[n7 - n2] = this.getColWidth(n7);
                ++n7;
            }
            n7 = n2;
            while (n7 < n2 + n3) {
                this.storeColWidth(n7, this.getDefaultColWidth());
                ++n7;
            }
            n7 = n2;
            while (n7 < n6) {
                this.storeColWidth(n7 + n3, nArray2[n7 - n2]);
                ++n7;
            }
            this.updateCovers(n2, n3, 0, 2, false);
        }
        if (bl2) {
            this.updateScrollbar();
        }
        return bl2;
    }

    public boolean storeRemoveRows(int n2, int n3) {
        return this.storeRemoveRows(n2, n3, true);
    }

    public boolean storeRemoveRows(int n2, int n3, boolean bl) {
        this.deactiveCurrentCell();
        boolean bl2 = true;
        if (bl) {
            bl2 = this.m_gxParam.getData().a(n2, n3);
        }
        if (bl2) {
            int n4 = this.getRowCount();
            int n5 = n3 + 1;
            while (n5 < n4) {
                this.storeRowHeight(n5 + n2 - n3 - 1, this.getRowHeight(n5));
                ++n5;
            }
            int n6 = n4 - n3 + n2 - 1;
            while (n6 < n4) {
                if (bl) {
                    this.storeRowHeight(n6, -1);
                } else {
                    this.storeRowHeight(n6, 0);
                }
                ++n6;
            }
            this.shiftSelectionRange(n2, n3, 0, 1, true);
            this.updateCovers(n2, n3, 0, 1, true);
            this.updateScrollbar();
        }
        return bl2;
    }

    public boolean storeRemoveCols(int n2, int n3) {
        return this.storeRemoveCols(n2, n3, true);
    }

    public boolean storeRemoveCols(int n2, int n3, boolean bl) {
        this.deactiveCurrentCell();
        boolean bl2 = true;
        if (bl) {
            bl2 = this.m_gxParam.getData().b(n2, n3);
        }
        if (bl2) {
            int n4 = this.getColCount();
            int n5 = n3 + 1;
            while (n5 < n4) {
                this.storeColWidth(n5 + n2 - n3 - 1, this.getColWidth(n5));
                ++n5;
            }
            int n6 = n4 - n3 + n2 - 1;
            while (n6 < n4) {
                if (bl) {
                    this.storeColWidth(n6, -1);
                } else {
                    this.storeColWidth(n6, 0);
                }
                ++n6;
            }
            this.shiftSelectionRange(n2, n3, 0, 1, false);
            this.updateCovers(n2, n3, 0, 1, false);
            this.updateScrollbar();
        }
        return bl2;
    }

    public boolean storeMoveCols(int n2, int n3, int n4) {
        return this.storeMoveCols(n2, n3, n4, 0, -1, true);
    }

    public boolean storeMoveCols(int n2, int n3, int n4, boolean bl) {
        return this.storeMoveCols(n2, n3, n4, 0, -1, bl);
    }

    public boolean storeMoveCols(int n2, int n3, int n4, int n5, int n6, boolean bl) {
        this.deactiveCurrentCell();
        boolean bl2 = true;
        if (bl) {
            bl2 = this.m_gxParam.getData().b(n2, n3, n4);
        }
        if (bl2) {
            if (n2 == n4) {
                return false;
            }
            int n7 = Math.min(n2, n4);
            int n8 = Math.max(n3, n4);
            int n9 = n7 == n4 ? n2 : n3;
            int[] nArray = new int[Math.abs(n8 - n7 + 1)];
            int n10 = n7;
            while (n10 <= n8) {
                nArray[n10 - n7] = this.getColWidth(n10);
                ++n10;
            }
            if (n2 < n4) {
                n10 = n7;
                while (n10 < n7 + n8 - n9) {
                    this.storeColWidth(n10, nArray[n10 + n9 - 2 * n7 + 1]);
                    ++n10;
                }
                n10 = n7 + n8 - n9;
                while (n10 <= n8) {
                    this.storeColWidth(n10, nArray[n10 - n7 - n8 + n9]);
                    ++n10;
                }
            } else {
                n10 = n7 + 1;
                while (n10 <= n7 + n8 - n9 + 1) {
                    this.storeColWidth(n10, nArray[n10 + n9 - 2 * n7 - 1]);
                    ++n10;
                }
                n10 = n7 + n8 - n9 + 2;
                while (n10 <= n8) {
                    this.storeColWidth(n10, nArray[n10 - n7 - n8 + n9 - 1]);
                    ++n10;
                }
            }
            this.shiftSelectionRange(n2, n3, n4, 0, false);
            this.updateCovers(n2, n3, n4, 0, false);
        }
        return bl2;
    }

    public boolean storeMoveRows(int n2, int n3, int n4) {
        return this.storeMoveRows(n2, n3, n4, 0, -1, true);
    }

    public boolean storeMoveRows(int n2, int n3, int n4, boolean bl) {
        return this.storeMoveRows(n2, n3, n4, 0, -1, bl);
    }

    public boolean storeMoveRows(int n2, int n3, int n4, int n5, int n6, boolean bl) {
        this.deactiveCurrentCell();
        boolean bl2 = true;
        if (bl) {
            bl2 = this.m_gxParam.getData().a(n2, n3, n4);
        }
        if (bl2) {
            if (n2 == n4) {
                return false;
            }
            int n7 = Math.min(n2, n4);
            int n8 = Math.max(n3, n4);
            int n9 = n7 == n4 ? n2 : n3;
            int[] nArray = new int[Math.abs(n8 - n7 + 1)];
            int n10 = n7;
            while (n10 <= n8) {
                nArray[n10 - n7] = this.getRowHeight(n10);
                ++n10;
            }
            if (n2 < n4) {
                n10 = n7;
                while (n10 < n7 + n8 - n9) {
                    this.storeRowHeight(n10, nArray[n10 + n9 - 2 * n7 + 1]);
                    ++n10;
                }
                n10 = n7 + n8 - n9;
                while (n10 <= n8) {
                    this.storeRowHeight(n10, nArray[n10 - n7 - n8 + n9]);
                    ++n10;
                }
            } else {
                n10 = n7 + 1;
                while (n10 <= n7 + n8 - n9 + 1) {
                    this.storeRowHeight(n10, nArray[n10 + n9 - 2 * n7 - 1]);
                    ++n10;
                }
                n10 = n7 + n8 - n9 + 2;
                while (n10 <= n8) {
                    this.storeRowHeight(n10, nArray[n10 - n7 - n8 + n9 - 1]);
                    ++n10;
                }
            }
            this.shiftSelectionRange(n2, n3, n4, 0, true);
            this.updateCovers(n2, n3, n4, 0, true);
        }
        return bl2;
    }

    public synchronized boolean deactiveCurrentCell() {
        return true;
    }

    public int height_DPtoLP(int n2) {
        return n2;
    }

    public int width_DPtoLP(int n2) {
        return n2;
    }

    public int height_LPtoDP(int n2) {
        return n2;
    }

    public int width_LPtoDP(int n2) {
        return n2;
    }

    public boolean storeDefaultRowHeight(int n2) {
        this.m_gxParam.g = this.height_DPtoLP(n2);
        return true;
    }

    public boolean storeDefaultColWidth(int n2) {
        this.m_gxParam.h = this.width_DPtoLP(n2);
        return true;
    }

    public int getDefaultRowHeight() {
        return this.height_LPtoDP(this.m_gxParam.g);
    }

    public boolean setDefaultRowHeight(int n2, int n3, int n4) {
        this.m_gxParam.g = this.height_DPtoLP(n2);
        return true;
    }

    public int getDefaultColWidth() {
        return this.width_LPtoDP(this.m_gxParam.h);
    }

    public boolean setDefaultColWidth(int n2, int n3, int n4) {
        this.m_gxParam.h = this.width_DPtoLP(n2);
        return true;
    }

    public int getRowHeight(int n2) {
        Integer n3 = (Integer)this.m_gxParam.e.get(new Integer(n2));
        if (n3 != null) {
            return this.height_LPtoDP(n3);
        }
        return this.getDefaultRowHeight();
    }

    public int getColWidth(int n2) {
        Integer n3 = (Integer)this.m_gxParam.f.get(new Integer(n2));
        if (n3 != null) {
            return this.width_LPtoDP(n3);
        }
        return this.getDefaultColWidth();
    }

    public boolean storeRowHeight(int n2) {
        return this.storeRowHeight(n2, 0);
    }

    public boolean storeRowHeight(int n2, int n3) {
        if (n3 >= 0) {
            this.m_gxParam.e.put(new Integer(n2), new Integer(this.height_DPtoLP(n3)));
        } else {
            this.m_gxParam.e.remove(new Integer(n2));
        }
        return true;
    }

    public boolean setRowHeight(int n2, int n3, int n4, int[] nArray, int n5, int n6) {
        if (n3 == 0) {
            n3 = n2;
        }
        if (n3 < n2) {
            return false;
        }
        int n7 = n2;
        while (n7 <= n3) {
            if (nArray != null) {
                this.storeRowHeight(n7, nArray[n7 - n2]);
            } else {
                this.storeRowHeight(n7, n4);
            }
            ++n7;
        }
        this.repaint();
        return true;
    }

    public boolean storeColWidth(int n2) {
        return this.storeColWidth(n2, 0);
    }

    public boolean storeColWidth(int n2, int n3) {
        if (n3 >= 0) {
            this.m_gxParam.f.put(new Integer(n2), new Integer(this.width_DPtoLP(n3)));
        } else {
            this.m_gxParam.f.remove(new Integer(n2));
        }
        return true;
    }

    public boolean setColWidth(int n2, int n3, int n4, int[] nArray, int n5, int n6) {
        if (n3 == 0) {
            n3 = n2;
        }
        if (n3 < n2) {
            return false;
        }
        int n7 = n2;
        while (n7 <= n3) {
            if (nArray != null) {
                this.storeColWidth(n7, nArray[n7 - n2]);
            } else {
                this.storeColWidth(n7, n4);
            }
            ++n7;
        }
        return true;
    }

    public boolean isRowHidden(int n2) {
        int n3 = this.getFrozenRows();
        int n4 = this.getTopRow();
        return n3 <= n2 && n2 < n4;
    }

    public boolean isColHidden(int n2) {
        int n3 = this.getFrozenCols();
        int n4 = this.getLeftCol();
        return n3 <= n2 && n2 < n4;
    }

    public int getTopRow() {
        return this.A;
    }

    public int getLeftCol() {
        return this.B;
    }

    public int getMaxLeftCol() {
        int n2 = this.getColCount();
        int n3 = n2 - 1;
        int n4 = this.getInsets().left;
        int n5 = this.getFrozenCols();
        int n6 = 0;
        int n7 = 0;
        while (n7 < n5) {
            n6 += this.getColWidth(n7);
            ++n7;
        }
        while (n4 < this.m_nGridWidth - n6 && n3 > 0) {
            n4 += this.getColWidth(n3);
            --n3;
        }
        if (n4 < this.m_nGridWidth - n6) {
            return 0;
        }
        return n3 - n5 + 3;
    }

    public int getMaxTopRow() {
        int n2 = this.getRowCount();
        int n3 = n2 - 1;
        int n4 = this.getInsets().top;
        int n5 = this.getFrozenRows();
        int n6 = 0;
        int n7 = 0;
        while (n7 < n5) {
            n6 += this.getRowHeight(n7);
            ++n7;
        }
        while (n4 < this.m_nGridHeight - n6 && n3 > 0) {
            n4 += this.getRowHeight(n3);
            --n3;
        }
        if (n4 < this.m_nGridHeight - n6) {
            return 0;
        }
        return n3 - n5 + 3;
    }

    public int getLastVisibleRow() {
        int n2 = 0;
        int n3 = this.getRowCount();
        int n4 = this.getInsets().top;
        n2 = 0;
        while (n2 < n3) {
            if (n4 > this.m_nGridHeight) break;
            if (this.isRowHidden(n2)) {
                n2 = this.A - 1;
            } else {
                n4 += this.getRowHeight(n2);
            }
            ++n2;
        }
        if (n4 > this.m_nGridHeight) {
            return n2 - 1;
        }
        return n2;
    }

    public int getLastVisibleCol() {
        int n2 = 0;
        int n3 = this.getColCount();
        int n4 = this.getInsets().left;
        n2 = 0;
        while (n2 < n3) {
            if (n4 > this.m_nGridWidth) break;
            if (this.isColHidden(n2)) {
                n2 = this.B - 1;
            } else {
                n4 += this.getColWidth(n2);
            }
            ++n2;
        }
        if (n4 > this.m_nGridWidth) {
            return n2 - 1;
        }
        return n2;
    }

    public int getHLineExtend() {
        int n2 = this.getColCount();
        int n3 = this.getInsets().left;
        int n4 = 0;
        while (n4 < n2) {
            if (n3 > this.m_nGridWidth) break;
            if (this.isColHidden(n4)) {
                n4 = this.B - 1;
            } else {
                n3 += this.getColWidth(n4);
            }
            ++n4;
        }
        return n3 - 1;
    }

    public int getVLineExtend() {
        int n2 = this.getRowCount();
        int n3 = this.getInsets().top;
        int n4 = 0;
        while (n4 < n2) {
            if (n3 > this.m_nGridHeight) break;
            if (this.isRowHidden(n4)) {
                n4 = this.A - 1;
            } else {
                n3 += this.getRowHeight(n4);
            }
            ++n4;
        }
        return n3 - 1;
    }

    public GXCell isCellBeCovered(int n2, int n3) {
        return null;
    }

    public boolean isVisibleCell(GXCell gXCell) {
        return true;
    }

    public void updateCovers(int n2, int n3, int n4, int n5, boolean bl) {
    }

    public void paintCovers(Graphics graphics) {
    }

    public boolean setUncoverCellsRowCol(int n2, int n3, int n4, int n5) {
        return false;
    }

    public boolean setCoverCellsRowCol(int n2, int n3, int n4, int n5, int n6, int n7) {
        return false;
    }

    public int getCoverCount() {
        return 0;
    }

    public GXCover getCoverAt(int n2) {
        return null;
    }

    public void shiftSelectionRange(int n2, int n3, int n4, int n5, boolean bl) {
    }

    public int getFrozenRows() {
        return this.m_gxParam.getFrozenRows();
    }

    public void setFrozenRows(int n2) {
        this.m_gxParam.setFrozenRows(n2);
    }

    public int getFrozenCols() {
        return this.m_gxParam.getFrozenCols();
    }

    public void setFrozenCols(int n2) {
        this.m_gxParam.setFrozenCols(n2);
    }

    public void frozenCols() {
    }

    public void frozenRows() {
    }

    public void unfrozenCols() {
    }

    public void unfrozenRows() {
    }

    public Rectangle calcRectFromRowCol(int n2, int n3) {
        return this.calcRectFromRowCol(n2, n3, n2, n3);
    }

    public Rectangle calcRectFromRange(GXRange gXRange) {
        if (gXRange == null || !gXRange.isValid()) {
            return null;
        }
        if (gXRange.isCells()) {
            return this.calcRectFromRowCol(gXRange.top, gXRange.left, gXRange.bottom, gXRange.right);
        }
        if (gXRange.isRows()) {
            return this.calcRectFromRowCol(gXRange.top, 0, gXRange.bottom, this.getLastVisibleCol());
        }
        if (gXRange.isCols()) {
            return this.calcRectFromRowCol(0, gXRange.left, this.getLastVisibleRow(), gXRange.right);
        }
        if (gXRange.isTable()) {
            return this.calcRectFromRowCol(0, 0, this.getLastVisibleRow(), this.getLastVisibleCol());
        }
        GXDebug.assert(0L);
        return null;
    }

    public Rectangle calcRectFromRowCol(int n2, int n3, int n4, int n5) {
        Insets insets = this.getInsets();
        int n6 = insets.left;
        int n7 = insets.top;
        int n8 = 0;
        int n9 = 0;
        n4 = Math.min(n4, this.getRowCount() - 1);
        n5 = Math.min(n5, this.getColCount() - 1);
        int n10 = 0;
        while (n10 < n3) {
            if (!this.isColHidden(n10)) {
                n6 += this.getColWidth(n10);
            } else {
                n10 = this.B - 1;
            }
            ++n10;
        }
        n10 = 0;
        while (n10 < n2) {
            if (!this.isRowHidden(n10)) {
                n7 += this.getRowHeight(n10);
            } else {
                n10 = this.A - 1;
            }
            ++n10;
        }
        n10 = n3;
        while (n10 <= n5) {
            if (!this.isColHidden(n10)) {
                n8 += this.getColWidth(n10);
            }
            ++n10;
        }
        n10 = n2;
        while (n10 <= n4) {
            if (!this.isRowHidden(n10)) {
                n9 += this.getRowHeight(n10);
            }
            ++n10;
        }
        Rectangle rectangle = new Rectangle(this.getInsets().left, this.getInsets().top, this.m_nGridWidth, this.m_nGridHeight);
        return rectangle.intersection(new Rectangle(n6, n7, n8 - 1, n9 - 1));
    }

    public synchronized void scroll(int n2, int n3) {
        block22: {
            Rectangle rectangle;
            block23: {
                block25: {
                    Rectangle rectangle2;
                    block24: {
                        int n4;
                        boolean bl;
                        block17: {
                            block21: {
                                Rectangle rectangle3;
                                block18: {
                                    block20: {
                                        Rectangle rectangle4;
                                        block19: {
                                            int n5;
                                            bl = false;
                                            String string = System.getProperty("java.version");
                                            int n6 = string.lastIndexOf(46);
                                            if (n6 > 0) {
                                                boolean bl2 = bl = string.compareTo("1.1.2") >= 0;
                                            }
                                            if (n2 != 1) break block17;
                                            int n7 = this.getFrozenRows();
                                            int n8 = n7 + n3;
                                            if (!this.onTopRowChange(n8)) {
                                                return;
                                            }
                                            int n9 = this.A;
                                            rectangle4 = null;
                                            if (n8 > this.A) {
                                                n5 = this.getLastVisibleRow() - 1;
                                                if (n5 > n8) {
                                                    rectangle4 = this.calcRectFromRowCol(n8, 0, n5, 0);
                                                }
                                            } else {
                                                this.A = n8;
                                                rectangle4 = this.calcRectFromRowCol(n9, 0, n9, 0);
                                            }
                                            this.A = n8;
                                            n5 = this.getFrozenRows();
                                            rectangle3 = this.calcRectFromRowCol(n5, 0);
                                            if (!bl || rectangle4 == null || this.isTransparentBackground()) break block18;
                                            if (n8 <= n9) break block19;
                                            Graphics graphics = this.getGraphics();
                                            if (graphics != null) {
                                                graphics.copyArea(this.getInsets().left, rectangle4.y, this.m_nGridWidth, rectangle4.height, 0, rectangle3.y - rectangle4.y);
                                                this.update(graphics, this.getInsets().left, rectangle3.y + rectangle4.height, this.m_nGridWidth, this.getInsets().top + this.m_nGridHeight - rectangle3.y - rectangle4.height);
                                                graphics.dispose();
                                                return;
                                            }
                                            break block20;
                                        }
                                        Graphics graphics = this.getGraphics();
                                        if (graphics == null) break block21;
                                        graphics.copyArea(this.getInsets().left, rectangle3.y, this.m_nGridWidth, this.getInsets().top + this.m_nGridHeight - rectangle4.y, 0, rectangle4.y - rectangle3.y);
                                        this.update(graphics, this.getInsets().left, rectangle3.y, this.m_nGridWidth, rectangle4.y - rectangle3.y + 1);
                                        graphics.dispose();
                                    }
                                    return;
                                }
                                this.repaint(this.getInsets().left, rectangle3.y, this.m_nGridWidth, this.getInsets().top + this.m_nGridHeight - rectangle3.y);
                            }
                            return;
                        }
                        if (n2 != 0) break block22;
                        int n10 = this.getFrozenCols();
                        int n11 = n10 + n3;
                        if (!this.onLeftColChange(n11)) {
                            return;
                        }
                        int n12 = this.B;
                        rectangle2 = null;
                        if (n11 > this.B) {
                            n4 = this.getLastVisibleCol() - 1;
                            if (n4 > n11) {
                                rectangle2 = this.calcRectFromRowCol(0, n11, 0, n4);
                            }
                        } else {
                            this.B = n11;
                            rectangle2 = this.calcRectFromRowCol(0, n12, 0, n12);
                        }
                        this.B = n11;
                        n4 = this.getFrozenCols();
                        rectangle = this.calcRectFromRowCol(0, n4);
                        if (!bl || rectangle2 == null || this.isTransparentBackground()) break block23;
                        if (n11 <= n12) break block24;
                        Graphics graphics = this.getGraphics();
                        if (graphics != null) {
                            graphics.copyArea(rectangle2.x, this.getInsets().top, rectangle2.width, this.m_nGridHeight, rectangle.x - rectangle2.x, 0);
                            this.update(graphics, rectangle.x + rectangle2.width, this.getInsets().top, this.getInsets().left + this.m_nGridWidth - rectangle.x - rectangle2.width, this.m_nGridHeight);
                            graphics.dispose();
                            return;
                        }
                        break block25;
                    }
                    Graphics graphics = this.getGraphics();
                    if (graphics == null) break block22;
                    graphics.copyArea(rectangle.x, this.getInsets().top, this.getInsets().left + this.m_nGridWidth - rectangle2.x, this.m_nGridHeight, rectangle2.x - rectangle.x, 0);
                    this.update(graphics, rectangle.x, this.getInsets().top, rectangle2.x - rectangle.x + 1, this.m_nGridHeight);
                    graphics.dispose();
                }
                return;
            }
            this.repaint(rectangle.x, this.getInsets().top, this.getInsets().left + this.m_nGridWidth - rectangle.x, this.m_nGridHeight);
        }
    }

    public boolean onLeftColChange(int n2) {
        return true;
    }

    public void onLeftColChanged(int n2) {
        this.scroll(0, n2);
        this.onMoveCurControl();
    }

    public boolean onTopRowChange(int n2) {
        return true;
    }

    public void onTopRowChanged(int n2) {
        this.scroll(1, n2);
        this.onMoveCurControl();
    }

    public synchronized void draw(Graphics graphics) {
        if (this.isLockUpdate()) {
            return;
        }
        this.getSize();
        this.drawCorner(graphics);
        if (this.C) {
            this.drawBorder(graphics);
        }
        graphics.clipRect(this.getInsets().left, this.getInsets().top, this.m_nGridWidth, this.m_nGridHeight);
        int n2 = this.m_gxParam.getData().getRowCount();
        int n3 = this.getInsets().top;
        int n4 = 0;
        Rectangle rectangle = graphics.getClipBounds();
        int n5 = 0;
        while (n5 < n2) {
            if (this.isRowHidden(n5)) {
                n5 = this.A - 1;
            } else {
                n4 = this.getRowHeight(n5);
                if ((n3 += n4) > rectangle.y + rectangle.height) break;
                if (n3 + n4 >= rectangle.y) {
                    this.drawRow(graphics, n5, n3, n4);
                }
            }
            ++n5;
        }
        int n6 = this.getInsets().top;
        int n7 = this.getInsets().left;
        int n8 = this.getHLineExtend();
        int n9 = this.getVLineExtend();
        graphics.drawLine(n8, n6, n8, n9);
        graphics.drawLine(n7, n9, n8, n9);
        this.updateHeaders(graphics, true);
        this.paintCovers(graphics);
        this.paintSelectionRange(graphics);
        this.paintFocusRect(graphics);
        if (this.m_nGridWidth - n8 > 0) {
            graphics.clearRect(n8 + 1, n6, this.m_nGridWidth - n8 + n7, this.m_nGridHeight);
        }
        if (this.m_nGridHeight - n9 > 0) {
            graphics.clearRect(n7, n9 + 1, this.m_nGridWidth, this.m_nGridHeight - n9 + n6);
        }
    }

    public void drawRow(Graphics graphics, int n2, int n3, int n4) {
        int n5 = this.getColCount();
        int n6 = this.getInsets().left;
        int n7 = 0;
        Rectangle rectangle = graphics.getClipBounds();
        GXStyle gXStyle = this.getStyleObject();
        int n8 = 0;
        while (n8 < n5) {
            if (this.isColHidden(n8)) {
                n8 = this.B - 1;
            } else {
                n7 = this.getColWidth(n8);
                if ((n6 += n7) > rectangle.x + rectangle.width) break;
                if (n6 + n7 >= rectangle.x && this.isCellBeCovered(n2, n8) == null) {
                    GXRange gXRange = this.getSpanCellsRowCol(n2, n8);
                    if (gXRange != null) {
                        this.m_rgList.add(gXRange);
                    } else {
                        this.getStyleRowCol(n2, n8, gXStyle);
                        if (this.isBaseStyleUsed()) {
                            gXStyle.loadBaseStyle();
                        }
                        this.drawCell(graphics, n2, n8, n6, n3, n7, n4, gXStyle);
                        this.drawGridLines(graphics, n6, n3, n7, n4);
                        gXStyle.clearAllIncludes();
                    }
                }
            }
            ++n8;
        }
        this.recycleStyleObject(gXStyle);
    }

    public GXRange getSpanCellsRowCol(int n2, int n3) {
        return null;
    }

    public void drawCell(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7, GXStyle gXStyle) {
        if (gXStyle.getControl() != null) {
            gXStyle.doPaint(graphics, new Rectangle(n4, n5, n6 - 1, n7 - 1), n2, n3);
        }
    }

    public void drawGridLines(Graphics graphics, int n2, int n3, int n4, int n5) {
        graphics.setColor(this.getGridLineColor());
        if (this.getDrawHLine()) {
            graphics.drawLine(n2 - 1, n3 - 1, n2 + n4 - 1, n3 - 1);
        }
        if (this.getDrawVLine()) {
            graphics.drawLine(n2 - 1, n3 - 1, n2 - 1, n3 + n5 - 1);
        }
    }

    public void onMoveCurControl() {
    }

    public void drawCorner(Graphics graphics) {
        Dimension dimension = this.getSize();
        graphics.setColor(SystemColor.control);
        graphics.fillRect(this.m_nGridWidth + this.getInsets().left, this.m_nGridHeight + this.getInsets().top, dimension.width - this.m_nGridWidth, dimension.height - this.m_nGridHeight);
    }

    public void drawBorder(Graphics graphics) {
        Dimension dimension = this.getSize();
        graphics.setColor(this.getControlColor());
        graphics.draw3DRect(0, 0, dimension.width - 1, dimension.height - 1, false);
        graphics.drawRect(1, 1, dimension.width - 3, dimension.height - 3);
        graphics.setColor(this.getControlDKShadowColor());
        graphics.drawLine(1, 1, dimension.width - 2, 1);
        graphics.drawLine(1, 1, 1, dimension.height - 3);
    }

    public void paintFocusRect(Graphics graphics) {
    }

    public void paintSelectionRange(Graphics graphics) {
    }

    public void updateHeaders(Graphics graphics, boolean bl) {
    }

    public void invalidateTable() {
        this.invalidate();
        this.repaint();
    }

    public void invalidateRows(int n2, int n3) {
        int n4 = Math.min(n2, n3);
        int n5 = Math.max(n2, n3);
        if (n4 < 0 || n5 >= this.getRowCount()) {
            return;
        }
        GXRange gXRange = new GXRange();
        gXRange.setRows(n4, n5);
        Rectangle rectangle = this.calcRectFromRange(gXRange);
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            this.update(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.dispose();
        }
    }

    public void invalidateCols(int n2, int n3) {
        int n4 = Math.min(n2, n3);
        int n5 = Math.max(n2, n3);
        if (n4 < 0 || n5 >= this.getColCount()) {
            return;
        }
        GXRange gXRange = new GXRange();
        gXRange.setCols(n4, n5);
        Rectangle rectangle = this.calcRectFromRange(gXRange);
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            this.update(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.dispose();
        }
    }

    public synchronized Dimension getPreferredSize() {
        Dimension dimension = this.getSize();
        if (dimension.width > 0 && dimension.height > 0) {
            return dimension;
        }
        return this.getMinimumSize();
    }

    public synchronized Dimension getMinimumSize() {
        return new Dimension(100, 50);
    }

    public void reshape(int n2, int n3, int n4, int n5) {
        super.reshape(n2, n3, n4, n5);
        Insets insets = this.getInsets();
        Container container = this.getParent();
        while (container != null && container.getParent() != null && !(container instanceof GXGridView)) {
            container = container.getParent();
        }
        boolean bl = container != null && container instanceof GXGridView;
        int n6 = !this.m_bHideVScrollbar || bl ? this.getVScrollbar().bounds().width : 0;
        int n7 = !this.m_bHideHScrollbar || bl ? this.getHScrollbar().bounds().height : 0;
        this.m_nGridWidth = n4 - n6 - insets.left;
        this.m_nGridHeight = n5 - n7 - insets.top;
        this.updateScrollbar();
        this.doLayout();
    }

    public void setBounds(int n2, int n3, int n4, int n5) {
        super.setBounds(n2, n3, n4, n5);
        Insets insets = this.getInsets();
        Container container = this.getParent();
        while (container != null && container.getParent() != null && !(container instanceof GXGridView)) {
            container = container.getParent();
        }
        boolean bl = container != null && container instanceof GXGridView;
        int n6 = !this.m_bHideVScrollbar || bl ? this.getVScrollbar().getBounds().width : 0;
        int n7 = !this.m_bHideHScrollbar || bl ? this.getHScrollbar().getBounds().height : 0;
        this.m_nGridWidth = n4 - n6 - insets.left - insets.right;
        this.m_nGridHeight = n5 - n7 - insets.top - insets.bottom;
        this.updateScrollbar();
        this.doLayout();
    }

    public synchronized void doLayout() {
        if (!this.m_bHideVScrollbar) {
            this.getVScrollbar().setBounds(this.getInsets().left + this.m_nGridWidth, this.getInsets().top, this.m_nVScrollbarWidth, this.m_nGridHeight);
        }
        if (!this.m_bHideHScrollbar) {
            this.getHScrollbar().setBounds(this.getInsets().left, this.getInsets().top + this.m_nGridHeight, this.m_nGridWidth, this.m_nHScrollbarHeight);
        }
    }

    public Insets getInsets() {
        if (this.C) {
            return new Insets(2, 2, 2, 2);
        }
        return new Insets(0, 0, 0, 0);
    }

    public Scrollbar getHScrollbar() {
        Container container = this.getParent();
        while (container != null && container.getParent() != null && !(container instanceof GXGridView)) {
            container = container.getParent();
        }
        if (container != null && container instanceof GXGridView) {
            return ((GXGridView)container).getHScrollbar();
        }
        return super.getHScrollbar();
    }

    public Scrollbar getVScrollbar() {
        Container container = this.getParent();
        while (container != null && container.getParent() != null && !(container instanceof GXGridView)) {
            container = container.getParent();
        }
        if (container != null && container instanceof GXGridView) {
            return ((GXGridView)container).getVScrollbar();
        }
        return super.getVScrollbar();
    }

    public synchronized void updateScrollbar() {
        int n2 = this.getFrozenRows();
        int n3 = this.getFrozenCols();
        Scrollbar scrollbar = this.getHScrollbar();
        Scrollbar scrollbar2 = this.getVScrollbar();
        int n4 = scrollbar2.getValue();
        int n5 = scrollbar.getValue();
        if (n4 >= this.getMaxTopRow()) {
            this.A = this.getMaxTopRow() + n2;
            n4 = this.getMaxTopRow();
        }
        if (n5 >= this.getMaxLeftCol()) {
            this.B = this.getMaxLeftCol() + n3;
            n5 = this.getMaxLeftCol();
        }
        scrollbar2.setValues(n4, 1, 0, this.getMaxTopRow());
        scrollbar.setValues(n5, 1, 0, this.getMaxLeftCol());
        if (this.isShowing()) {
            this.update();
        }
    }
}

