/*
 * Decompiled with CFR 0.152.
 */
package GXGrid;

import GXGrid.GXCell;
import GXGrid.GXControl;
import GXGrid.GXCore;
import GXGrid.GXCover;
import GXGrid.GXDebug;
import GXGrid.GXExControl;
import GXGrid.GXGridEvent;
import GXGrid.GXGridListener;
import GXGrid.GXRange;
import GXGrid.GXStyle;
import GXGrid.GXTextField;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Vector;

public class GXCore1
extends GXCore {
    public GXCell m_gxCurrentCell;
    public GXCell m_gxPreviousCell;
    public GXCell m_gxFirstSelectedCell;
    public GXStyle m_gxStCurrentCell;
    public static final int coNoDragging = 0;
    public static final int coSelectedCurCell = 1;
    public static final int coSelectedTable = 2;
    public static final int coDraggingVerticalSelection = 3;
    public static final int coDraggingHorizontalSelection = 4;
    public static final int coDraggingSelection = 5;
    public static final int coDraggingVerticalResizing = 6;
    public static final int coDraggingHorizontalResizing = 7;
    public static final int coDraggingDiagonalResizing = 8;
    public static final int coDraggingRows = 9;
    public static final int coDraggingCols = 10;
    public static final int coDraggingCells = 11;
    public static final int coNOP = -1;
    public GXControl m_awtComponent;
    public GXRange m_gxSelectionRange;
    public Vector m_gxRangeList = new Vector(10);
    public Rectangle m_rectSelection;
    public Rectangle m_rectDraggingX;
    public Rectangle m_rectDraggingY;
    public int m_nCursorType = 0;
    public int m_nDraggingState = 0;
    public int m_nRowTracking;
    public int m_nColTracking;
    public int m_nTrackingCellX;
    public int m_nTrackingCellY;
    public int m_nTrackingRowHeight;
    public int m_nTrackingColWidth;
    public int m_nXMouse;
    public int m_nYMouse;
    public boolean m_bModifiedFlag = false;
    public boolean m_bCaptured = false;
    public boolean m_bDragnDrop = false;
    public transient boolean m_bDragCell = false;
    public boolean m_bInitialized = false;
    public boolean m_bTracking = false;
    public boolean m_bTrackMove = false;
    public boolean m_bDoubleClicked = false;
    public boolean m_bMakeCellActive = false;
    public boolean m_bUpdateRange = true;
    public static final int TEXT = 3;
    public String m_strWarningText = "";
    public boolean m_bProcessFocusEvent = true;
    public boolean u = false;
    public boolean v = false;
    public transient boolean w = false;
    public String x = System.getProperty("os.name");
    public int oldX = -1;
    public int oldY = -1;
    public static int nNorm = 1;
    public static int nEXLLike = 2;
    public int y = nNorm;
    public Vector z = new Vector(10);

    public GXCore1() {
        this(2, 2);
    }

    public GXCore1(int n2, int n3) {
        super(n2, n3);
        this.m_gxCurrentCell = new GXCell(1, 1);
        this.m_gxPreviousCell = new GXCell(1, 1);
        this.m_gxSelectionRange = new GXRange();
    }

    public void gridInitialUpdate() {
        super.gridInitialUpdate();
        GXStyle gXStyle = new GXStyle();
        this.getTableStyle(gXStyle);
        gXStyle.setControl(new GXTextField(this));
        this.setTableStyle(gXStyle);
    }

    public void registerControls() {
        super.registerControls();
        this.registerControl(new GXTextField(this), 3);
    }

    public GXRange getSelectRange() {
        return this.m_gxSelectionRange;
    }

    public void setSelectRange(GXRange gXRange) {
        this.m_gxSelectionRange = gXRange;
    }

    public boolean isReadOnly() {
        boolean bl = this.getParam().isLockReadOnly();
        return bl;
    }

    public void setReadOnly(boolean bl) {
        if (bl) {
            this.m_gxCurrentCell = new GXCell();
            this.deactiveCurrentCell();
        }
        this.getParam().setLockReadOnly(bl);
    }

    public boolean isSelectionEnabled() {
        return this.getParam().getProperties().getSelectionMode() != 0;
    }

    public void setSelectionEnabled(boolean bl) {
        int n2 = 0;
        if (bl) {
            n2 = 3;
        }
        this.getParam().getProperties().setSelectionMode(n2);
    }

    public int getSelectionMode() {
        return this.getParam().getProperties().getSelectionMode();
    }

    public void setSelectionMode(int n2) {
        this.getParam().getProperties().setSelectionMode(n2);
    }

    public Component getAwtComponent() {
        if (this.m_awtComponent instanceof Component) {
            return (Component)((Object)this.m_awtComponent);
        }
        return null;
    }

    public GXControl getCurrentCellControl() {
        GXCell gXCell = this.getCurrentCell();
        if (gXCell == null || !gXCell.isValid()) {
            return null;
        }
        return this.getGXControl(gXCell.row, gXCell.col);
    }

    public GXControl getGXControl(int n2) {
        return this.getParam().getGXControl(n2);
    }

    public GXControl getGXControl(int n2, int n3) {
        GXStyle gXStyle = this.getStyleObject();
        if (this.getStyleRowCol(n2, n3, gXStyle)) {
            return gXStyle.getControl();
        }
        return null;
    }

    public GXCell getCurrentCell() {
        return this.m_gxCurrentCell;
    }

    public boolean isCurrentCell(int n2, int n3) {
        GXCell gXCell = this.getCurrentCell();
        return gXCell.row == n2 && gXCell.col == n3;
    }

    public String getValueRowCol(int n2, int n3) {
        GXStyle gXStyle = this.getStyleObject();
        this.getStyleRowCol(n2, n3, gXStyle, 2);
        return gXStyle.getValue();
    }

    public boolean setCurrentCell(int n2, int n3) {
        Object object;
        int n4 = -1;
        int n5 = -1;
        GXCell gXCell = this.getCurrentCell();
        if (gXCell != null) {
            n4 = gXCell.row;
            n5 = gXCell.col;
            gXCell = this.isCellBeCovered(n2, n3);
            if (gXCell != null && gXCell.isValid()) {
                n2 = gXCell.row;
                n3 = gXCell.col;
            }
            if (n4 == n2 && n5 == n3) {
                return true;
            }
        }
        boolean bl = false;
        if (this.canSelectCurrentCell(false, n2, n3, n4, n5)) {
            if (this.m_gxStCurrentCell != null && !this.deactiveCurrentCell()) {
                this.setWarningText("Can not deactivate current cell.");
                this.displayWarningText();
                this.storeCurrentCell(n4, n5);
                bl = true;
            }
        } else {
            this.setWarningText("Can not select the cell as current cell.");
            this.displayWarningText();
            bl = true;
        }
        if (!bl && n2 < this.getRowCount() && n3 < this.getColCount()) {
            object = this.getStyleObject();
            this.getStyleRowCol(n2, n3, (GXStyle)object);
            if (this.isBaseStyleUsed()) {
                ((GXStyle)object).loadBaseStyle();
            }
            if (((GXStyle)object).getControl() == null) {
                ((GXStyle)object).setControl(new GXTextField(this));
            }
            if (this.m_gxCurrentCell != null) {
                this.m_gxPreviousCell.row = this.m_gxCurrentCell.row;
                this.m_gxPreviousCell.col = this.m_gxCurrentCell.col;
                this.m_gxCurrentCell.row = n2;
                this.m_gxCurrentCell.col = n3;
            } else {
                this.m_gxCurrentCell = new GXCell(n2, n3);
            }
            this.m_gxStCurrentCell = object;
            this.activateCurrentCell(false);
        }
        if (!bl && (object = this.getGraphics()) != null) {
            this.updateHeaders((Graphics)object);
            ((Graphics)object).dispose();
        }
        return !bl;
    }

    public void storeCurrentCell(int n2, int n3) {
    }

    public boolean canSelectCurrentCell(boolean bl, int n2, int n3, int n4, int n5) {
        Object object;
        boolean bl2 = true;
        if (n2 > this.getRowCount() || n3 > this.getColCount()) {
            return false;
        }
        this.setWarningText(null);
        GXCell gXCell = this.getCurrentCell();
        GXStyle gXStyle = this.getCurrentCellStyle();
        if (gXCell != null && gXCell.equals(new GXCell(n4, n5)) && gXStyle != null && (object = gXStyle.getControl()) != null && object instanceof Component && ((Component)object).isShowing()) {
            bl2 = object.onValidate();
        }
        if (bl && n2 >= this.getHeaderRows() && n3 >= this.getHeaderCols()) {
            object = this.getStyleObject();
            this.getStyleRowCol(n2, n3, (GXStyle)object);
            bl2 = bl2 && (!((GXStyle)object).getIncludeEnabled() || ((GXStyle)object).getEnabled());
            ((GXStyle)object).clearAllIncludes();
            this.recycleStyleObject((GXStyle)object);
        }
        return bl2;
    }

    public GXStyle getCurrentCellStyle() {
        return this.m_gxStCurrentCell;
    }

    public void setCurrentCellStyle(GXStyle gXStyle) {
        if (gXStyle != null) {
            this.m_gxStCurrentCell = this.getStyleObject();
            this.m_gxStCurrentCell.b(gXStyle);
            return;
        }
        this.m_gxStCurrentCell = null;
    }

    public void setWarningText(String string) {
        this.m_strWarningText = string;
    }

    public String getWarningText() {
        return this.m_strWarningText;
    }

    public void displayWarningText() {
        if (this.m_strWarningText != null) {
            GXDebug.msg(this.m_strWarningText);
        }
    }

    public void applyStyleToCurrentRange(GXStyle gXStyle) {
        this.onDeactiveCurrentCell();
        GXRange gXRange = this.getSelectRange();
        if (gXRange != null && gXRange.isValid()) {
            this.setStyleRange(gXRange, gXStyle, 2, 0);
        } else {
            GXCell gXCell = this.getCurrentCell();
            if (gXCell.isValid()) {
                gXRange = new GXRange(gXCell.row, gXCell.col, gXCell.row, gXCell.col);
                this.setStyleRange(gXRange, gXStyle, 2, 0);
            }
        }
        this.repaint();
    }

    public boolean setStyleRange(GXRange gXRange, GXStyle gXStyle) {
        return this.setStyleRange(gXRange, gXStyle, 2, 0);
    }

    public boolean setStyleRange(GXRange gXRange, GXStyle gXStyle, int n2, int n3, boolean bl) {
        return this.setStyleRange(gXRange, gXStyle, n2, n3, null, 0, 0, bl);
    }

    public boolean setStyleRange(GXRange gXRange, GXStyle gXStyle, int n2, int n3) {
        return this.setStyleRange(gXRange, gXStyle, n2, n3, null, 0, 0, true);
    }

    public boolean setStyleRange(GXRange gXRange, GXStyle gXStyle, int n2, int n3, GXStyle[] gXStyleArray, int n4, int n5) {
        return this.setStyleRange(gXRange, gXStyle, n2, n3, gXStyleArray, n4, n5, true);
    }

    public boolean setStyleRange(GXRange gXRange, GXStyle gXStyle, int n2, int n3, GXStyle[] gXStyleArray, int n4, int n5, boolean bl) {
        if (gXRange == null) {
            return false;
        }
        if (gXStyle != null) {
            if (gXRange.isRows()) {
                int n6 = gXRange.top;
                while (n6 <= gXRange.bottom) {
                    this.setRowStyle(n6, gXStyle);
                    ++n6;
                }
            } else if (gXRange.isCols()) {
                int n7 = gXRange.left;
                while (n7 <= gXRange.right) {
                    this.setColStyle(n7, gXStyle);
                    ++n7;
                }
            } else if (gXRange.isTable()) {
                this.setTableStyle(gXStyle);
            } else {
                int n8 = gXRange.top;
                while (n8 <= gXRange.bottom) {
                    int n9 = gXRange.left;
                    while (n9 <= gXRange.right) {
                        this.storeStyleRowCol(n8, n9, gXStyle, 1);
                        ++n9;
                    }
                    ++n8;
                }
            }
        } else if (gXRange.isRows()) {
            int n10 = gXRange.top;
            while (n10 <= gXRange.bottom) {
                this.setRowStyle(n10, gXStyleArray[n10 - gXRange.top]);
                ++n10;
            }
        } else if (gXRange.isCols()) {
            int n11 = gXRange.left;
            while (n11 <= gXRange.right) {
                this.setColStyle(n11, gXStyleArray[n11 - gXRange.left]);
                ++n11;
            }
        } else {
            boolean bl2 = false;
            int n12 = 0;
            int n13 = gXRange.top;
            while (n13 <= gXRange.bottom) {
                int n14 = gXRange.left;
                while (n14 <= gXRange.right) {
                    n12 = (n13 - gXRange.top) * gXRange.getWidth() + (n14 - gXRange.left);
                    if (gXStyleArray[n12] == null) {
                        this.storeStyleRowCol(n13, n14, gXStyleArray[n12], 4, n3);
                    } else {
                        this.storeStyleRowCol(n13, n14, gXStyleArray[n12], 1, n3);
                    }
                    ++n14;
                }
                ++n13;
            }
        }
        if (bl) {
            this.repaintRange(gXRange);
        }
        return true;
    }

    public void repaintRange(GXRange gXRange) {
        Rectangle rectangle = this.calcRectFromRange(gXRange);
        if (rectangle == null) {
            return;
        }
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            try {
                this.update(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            catch (Exception exception) {}
            graphics.dispose();
        }
    }

    public boolean getModifiedFlag() {
        return this.m_bModifiedFlag;
    }

    public void setModifiedFlag() {
        this.m_bModifiedFlag = true;
    }

    public void setModifiedFlag(boolean bl) {
        this.m_bModifiedFlag = bl;
    }

    public boolean getStyleRowCol(int n2, int n3, GXStyle gXStyle, int n4, int n5) {
        if (!super.getStyleRowCol(n2, n3, gXStyle, n4, n5)) {
            return false;
        }
        try {
            if (this.m_gxCurrentCell.equals(new GXCell(n2, n3)) && this.getAwtComponent().isShowing()) {
                this.m_gxStCurrentCell.getControl().onSetGXStyle(this.m_gxStCurrentCell, false);
                gXStyle.setValue(this.m_gxStCurrentCell.getValue(), false);
                gXStyle.setChoice(this.m_gxStCurrentCell.getChoice(), false);
                return true;
            }
        }
        catch (NullPointerException nullPointerException) {}
        return true;
    }

    public synchronized boolean isVisibleCell(GXCell gXCell) {
        boolean bl = gXCell.row > this.getLastVisibleRow() || gXCell.col > this.getLastVisibleCol();
        return !bl && !this.isColHidden(gXCell.col) && !this.isRowHidden(gXCell.row) && (this.isCellBeCovered(gXCell.row, gXCell.col) == null || this.isCellBeCovered(gXCell.row, gXCell.col).equals(gXCell));
    }

    public boolean hideRows(int n2, int n3) {
        int n4 = n2;
        while (n4 < n3) {
            this.storeRowHeight(n4);
            ++n4;
        }
        this.updateScrollbar();
        return true;
    }

    public boolean hideCols(int n2, int n3) {
        int n4 = n2;
        while (n4 < n3) {
            this.storeColWidth(n4);
            ++n4;
        }
        this.updateScrollbar();
        return true;
    }

    public void resizeColWidthsToFit(GXRange gXRange, boolean bl) {
        if (!gXRange.isValid()) {
            return;
        }
        int n2 = gXRange.isRows() ? 0 : gXRange.left;
        int n3 = gXRange.isRows() ? this.getColCount() - 1 : gXRange.right;
        int n4 = gXRange.isCols() ? 0 : gXRange.top;
        int n5 = gXRange.isCols() ? this.getRowCount() - 1 : gXRange.bottom;
        int n6 = n2;
        while (n6 <= n3) {
            if (this.getColWidth(n6) != 0) {
                int n7 = 0;
                int n8 = n4;
                while (n8 <= n5) {
                    GXStyle gXStyle = new GXStyle();
                    if (this.getStyleRowCol(n8, n6, gXStyle)) {
                        Dimension dimension = this.getCellSize(gXStyle, 0, false);
                        if (dimension.width > n7) {
                            n7 = dimension.width;
                        }
                    }
                    ++n8;
                }
                if (n7 > 3 * this.m_nGridWidth / 4) {
                    n7 = 3 * this.m_nGridWidth / 4;
                }
                if (n7 == 0) {
                    n7 = this.getDefaultColWidth();
                }
                this.storeColWidth(n6, n7);
            }
            ++n6;
        }
        if (bl) {
            Rectangle rectangle = this.calcRectFromRange(gXRange);
            Graphics graphics = this.getGraphics();
            if (graphics != null) {
                this.update(graphics, rectangle.x, rectangle.y, this.m_nGridWidth - rectangle.x, this.m_nGridHeight - rectangle.y);
                graphics.dispose();
            }
        }
    }

    public Dimension getCellSize(GXStyle gXStyle, int n2, boolean bl) {
        if (gXStyle.getValue() != null) {
            Font font = null;
            font = gXStyle.getIncludeFont() && gXStyle.getFont() != null ? gXStyle.getFont() : this.getFont();
            FontMetrics fontMetrics = this.getFontMetrics(font);
            Vector vector = bl ? L.wrapText(gXStyle.getValue(), n2, true, fontMetrics) : L.wrapText(gXStyle.getValue(), 0, false, fontMetrics);
            int n3 = 0;
            int n4 = 0;
            while (n3 < vector.size()) {
                String string = (String)vector.elementAt(n3);
                if (fontMetrics.stringWidth(string) + 25 > n4) {
                    n4 = fontMetrics.stringWidth(string) + 25;
                }
                ++n3;
            }
            int n5 = fontMetrics.getHeight() * n3 + 4;
            return new Dimension(n4, n5);
        }
        return new Dimension(0, 0);
    }

    public void resizeRowHeightsToFit(GXRange gXRange, boolean bl) {
        if (!gXRange.isValid()) {
            return;
        }
        int n2 = gXRange.isRows() ? 0 : gXRange.left;
        int n3 = gXRange.isRows() ? this.getColCount() - 1 : gXRange.right;
        int n4 = gXRange.isCols() ? 0 : gXRange.top;
        int n5 = gXRange.isCols() ? this.getRowCount() - 1 : gXRange.bottom;
        int n6 = n4;
        while (n6 <= n5) {
            if (this.getRowHeight(n6) != 0) {
                int n7 = 0;
                int n8 = n2;
                while (n8 <= n3) {
                    GXStyle gXStyle = new GXStyle();
                    if (this.getStyleRowCol(n6, n8, gXStyle)) {
                        Dimension dimension = this.getCellSize(gXStyle, this.getColWidth(n8), true);
                        if (dimension.height > n7) {
                            n7 = dimension.height;
                        }
                    }
                    ++n8;
                }
                if (n7 > 3 * this.m_nGridHeight / 4) {
                    n7 = 3 * this.m_nGridHeight / 4;
                }
                if (n7 == 0) {
                    n7 = this.getDefaultRowHeight();
                }
                this.storeRowHeight(n6, n7);
            }
            ++n6;
        }
        if (bl) {
            Rectangle rectangle = this.calcRectFromRange(gXRange);
            Graphics graphics = this.getGraphics();
            if (graphics != null) {
                this.update(graphics, rectangle.x, rectangle.y, this.m_nGridWidth - rectangle.x, this.m_nGridHeight - rectangle.y);
                graphics.dispose();
            }
        }
    }

    public GXCell calcValidClientRowColFromPt(int n2, int n3) {
        int n4 = this.getRowCount();
        int n5 = this.getColCount();
        int n6 = 0;
        int n7 = 0;
        Insets insets = this.getInsets();
        int n8 = insets.top;
        int n9 = insets.left;
        while (n9 <= n2 && n7 < n5) {
            if (!this.isColHidden(n7)) {
                n9 += this.getColWidth(n7);
            }
            ++n7;
        }
        while (n8 <= n3 && n6 < n4) {
            if (!this.isRowHidden(n6)) {
                n8 += this.getRowHeight(n6);
            }
            ++n6;
        }
        int n10 = 0;
        while (n10 < this.getCoverCount()) {
            GXCover gXCover = this.getCoverAt(n10);
            if (gXCover.getRange().isCellInRange(n6 - 1, n7 - 1)) {
                return gXCover.getCell();
            }
            ++n10;
        }
        return new GXCell(n6 - 1, n7 - 1);
    }

    public synchronized void processMouseEvent(MouseEvent mouseEvent) {
        this.getSize();
        Point point = mouseEvent.getPoint();
        switch (mouseEvent.getID()) {
            case 501: {
                this.mouseDown(mouseEvent, point.x, point.y);
                break;
            }
            case 502: {
                this.mouseUp(mouseEvent, point.x, point.y);
                break;
            }
            case 505: {
                this.mouseExit(mouseEvent, point.x, point.y);
                break;
            }
            case 504: {
                this.mouseEnter(mouseEvent, point.x, point.y);
            }
        }
        super.processMouseEvent(mouseEvent);
    }

    public void processMouseMotionEvent(MouseEvent mouseEvent) {
        this.getSize();
        Point point = mouseEvent.getPoint();
        switch (mouseEvent.getID()) {
            case 506: {
                this.mouseDrag(mouseEvent, point.x, point.y);
                break;
            }
            case 503: {
                this.mouseMove(mouseEvent, point.x, point.y);
            }
        }
        super.processMouseMotionEvent(mouseEvent);
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        int n2 = keyEvent.getKeyCode();
        if (keyEvent.getID() == 401) {
            if (this.m_bDragnDrop) {
                if (n2 == 17) {
                    this.printDragImg(this.oldX, this.oldY, true, true, true);
                }
            } else {
                this.keyDown(keyEvent, n2);
            }
        } else if (keyEvent.getID() == 402 && n2 == 17) {
            this.printDragImg(this.oldX, this.oldY, true, true, false);
        }
        if (keyEvent.getKeyChar() == '\t' && !this.u) {
            keyEvent.consume();
        }
        super.processKeyEvent(keyEvent);
    }

    public void setProcessFocusEvent(boolean bl) {
        this.m_bProcessFocusEvent = bl;
    }

    public void processFocusEvent(FocusEvent focusEvent) {
        if (!this.m_bProcessFocusEvent) {
            return;
        }
        switch (focusEvent.getID()) {
            case 1004: {
                this.gotFocus();
                break;
            }
            case 1005: {
                this.lostFocus();
            }
        }
        super.processFocusEvent(focusEvent);
    }

    public boolean isFocusTraversable() {
        return this.u;
    }

    public void setFocusTraversable(boolean bl) {
        this.u = bl;
    }

    public void gotFocus() {
        this.v = true;
        this.getAwtComponent();
        this.update();
    }

    public void lostFocus() {
        this.v = false;
        this.update();
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        try {
            Component component = (Component)focusEvent.getSource();
            if (component.isShowing()) {
                this.deactiveCurrentCell();
                return;
            }
        }
        catch (Exception exception) {}
    }

    public boolean mouseEnter(MouseEvent mouseEvent, int n2, int n3) {
        return false;
    }

    public boolean isValidCell(GXCell gXCell) {
        return gXCell != null && gXCell.isValid() && gXCell.row < this.getRowCount() && gXCell.col < this.getColCount();
    }

    public boolean mouseDown(MouseEvent mouseEvent, int n2, int n3) {
        this.w = true;
        this.requestFocus();
        if (n2 < 0 || n2 > this.m_nGridWidth || n3 < 0 || n3 > this.m_nGridHeight) {
            return true;
        }
        GXCell gXCell = this.calcValidClientRowColFromPt(n2, n3);
        if (gXCell.col >= this.m_gxParam.getData().getColCount() || gXCell.row > this.m_gxParam.getData().getRowCount()) {
            return true;
        }
        if (!this.isReadOnly()) {
            if (mouseEvent.isShiftDown() && this.isSelectionEnabled()) {
                this.onShiftSelection(gXCell);
                return true;
            }
            if (mouseEvent.isControlDown() && this.isSelectionEnabled()) {
                if (!this.m_bDragnDrop) {
                    this.onCtrlSelection(gXCell);
                }
                return true;
            }
        }
        if (mouseEvent.getClickCount() == 2) {
            GXGridEvent gXGridEvent = new GXGridEvent(this, 18, gXCell);
            this.processGXGridEvent(gXGridEvent);
            return this.onDoubleClicked(gXCell.row, gXCell.col);
        }
        if (!this.isReadOnly()) {
            Serializable serializable;
            this.m_rectSelection = this.calcRectFromRange(this.m_gxSelectionRange);
            if (this.m_rectSelection != null && this.m_rectSelection.contains(n2, n3) && !this.m_gxSelectionRange.isTable()) {
                if (gXCell.col == 0 && !this.isMoveRows() || gXCell.row == 0 && !this.isMoveCols()) {
                    return true;
                }
                serializable = new Rectangle(this.m_rectSelection.x + 3, this.m_rectSelection.y + 3, this.m_rectSelection.width - 6, this.m_rectSelection.height - 6);
                if (gXCell.row < this.getHeaderRows() || gXCell.col < this.getHeaderCols() || !((Rectangle)serializable).contains(n2, n3)) {
                    if (!this.m_bCaptured || this.m_nCursorType != 13) {
                        this.setCursor(13);
                        this.m_nCursorType = 13;
                        this.m_bCaptured = true;
                    }
                    this.m_bDragnDrop = true;
                    this.onSelDragStart(gXCell.row, gXCell.col, n2, n3);
                    return true;
                }
            }
            if (this.m_bCaptured && this.m_bDragCell) {
                this.m_bDragnDrop = true;
                this.onSelDragStart(gXCell.row, gXCell.col, n2, n3);
                this.m_nDraggingState = 11;
                return true;
            }
            this.m_bMakeCellActive = false;
            if (gXCell.equals(this.m_gxCurrentCell)) {
                this.m_bMakeCellActive = true;
                this.activateCurrentCell(true);
                serializable = this.getAwtComponent();
                if (serializable != null && ((Component)serializable).isShowing()) {
                    ((Component)serializable).dispatchEvent(mouseEvent);
                }
                return true;
            }
        }
        if (this.m_gxCurrentCell != null && !this.onLeftCurrentCell(this.m_gxCurrentCell.row, this.m_gxCurrentCell.col)) {
            return true;
        }
        int n4 = -1;
        int n5 = -1;
        if (this.m_gxCurrentCell != null) {
            n4 = this.m_gxCurrentCell.row;
            n5 = this.m_gxCurrentCell.col;
        }
        if (!this.canSelectCurrentCell(true, gXCell.row, gXCell.col, n4, n5)) {
            this.m_nDraggingState = 0;
            return true;
        }
        if (this.m_gxSelectionRange.isValid() || this.m_gxRangeList.size() > 0) {
            this.clearSelection();
        }
        this.deactiveCurrentCell();
        this.m_gxFirstSelectedCell = this.m_gxCurrentCell = gXCell;
        this.a(gXCell, n2, n3);
        if (this.m_nDraggingState == 7 || this.m_nDraggingState == 6 || this.m_nDraggingState == 8) {
            return true;
        }
        Rectangle rectangle = this.calcRectFromRowCol(this.m_gxCurrentCell.row, this.m_gxCurrentCell.col);
        int n6 = n2 - rectangle.x;
        int n7 = n3 - rectangle.y;
        this.activateCurrentCell(mouseEvent, n6, n7);
        this.onCurrentCellChanged(this.m_gxCurrentCell.row, this.m_gxCurrentCell.col);
        return true;
    }

    private void a(GXCell gXCell, int n2, int n3) {
        Graphics graphics = this.getGraphics();
        if (graphics == null) {
            return;
        }
        graphics.clipRect(this.getInsets().left, this.getInsets().right, this.m_nGridWidth, this.m_nGridHeight);
        graphics.setColor(this.getSizeLineColor());
        int n4 = this.getRowHeight(0);
        int n5 = this.getColWidth(0);
        if (this.m_nDraggingState == 8) {
            if (this.onStartTracking(this.m_nRowTracking, this.m_nColTracking, 8)) {
                this.m_rectDraggingY = new Rectangle(this.getInsets().left + n5, n3, this.m_nGridWidth - n5, 1);
                graphics.fillRect(this.m_rectDraggingY.x, this.m_rectDraggingY.y, this.m_rectDraggingY.width, this.m_rectDraggingY.height);
                this.m_rectDraggingX = new Rectangle(n2, this.getInsets().top + n4, 1, this.m_nGridHeight - n4);
                graphics.fillRect(this.m_rectDraggingX.x, this.m_rectDraggingX.y, this.m_rectDraggingX.width, this.m_rectDraggingX.height);
            }
            graphics.dispose();
            return;
        }
        if (this.m_nDraggingState == 6) {
            if (this.onStartTracking(this.m_nRowTracking, this.m_nColTracking, 6)) {
                this.m_rectDraggingY = new Rectangle(this.getInsets().left + n5, n3, this.m_nGridWidth - n5, 1);
                graphics.fillRect(this.m_rectDraggingY.x, this.m_rectDraggingY.y, this.m_rectDraggingY.width, this.m_rectDraggingY.height);
            }
            graphics.dispose();
            return;
        }
        if (this.m_nDraggingState == 7) {
            if (this.onStartTracking(this.m_nRowTracking, this.m_nColTracking, 7)) {
                this.m_rectDraggingX = new Rectangle(n2, this.getInsets().top + n4, 1, this.m_nGridHeight - n4);
                graphics.fillRect(this.m_rectDraggingX.x, this.m_rectDraggingX.y, this.m_rectDraggingX.width, this.m_rectDraggingX.height);
            }
            graphics.dispose();
            return;
        }
        if (gXCell.col < 1 && gXCell.row < 1) {
            if (this.isSelectionEnabled() && this.getSelectionMode() != 2 && !this.isReadOnly()) {
                this.m_gxSelectionRange.setTable();
                this.update();
            }
        } else if (gXCell.col < 1) {
            if (this.isSelectionEnabled() && this.getSelectionMode() != 2 && !this.isReadOnly()) {
                this.m_gxSelectionRange.setRows(gXCell.row, gXCell.row);
                this.m_nDraggingState = 3;
                Rectangle rectangle = this.calcRectFromRange(this.m_gxSelectionRange);
                graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                this.update(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        } else if (gXCell.row < 1) {
            if (this.isSelectionEnabled() && this.getSelectionMode() != 2 && !this.isReadOnly()) {
                this.m_gxSelectionRange.setCols(gXCell.col, gXCell.col);
                this.m_nDraggingState = 4;
                Rectangle rectangle = this.calcRectFromRange(this.m_gxSelectionRange);
                graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                this.update(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        } else if (this.isSelectionEnabled() && this.getSelectionMode() != 1 && !this.isReadOnly()) {
            this.m_nDraggingState = 5;
            this.m_gxSelectionRange = new GXRange();
        }
        graphics.dispose();
    }

    public boolean mouseDrag(MouseEvent mouseEvent, int n2, int n3) {
        if (this.m_bDragnDrop) {
            new GXCell();
            GXCell gXCell = null;
            gXCell = this.m_nDraggingState == 9 ? this.calcValidClientRowColFromPt(0, n3) : (this.m_nDraggingState == 10 ? this.calcValidClientRowColFromPt(n2, 0) : this.calcValidClientRowColFromPt(n2, n3));
            this.printDragImg(n2, n3, true, true, mouseEvent.isControlDown());
            this.onSelDragMove(gXCell.row + this.m_gxSelectionRange.getHeight(), gXCell.col + this.m_gxSelectionRange.getWidth());
            this.m_bTrackMove = true;
            return true;
        }
        switch (this.m_nDraggingState) {
            case 3: {
                GXCell gXCell = this.calcValidClientRowColFromPt(n2, n3);
                boolean bl = this.getParam().getProperties().isAutoScroll();
                if (bl) {
                    this.scrollToView(gXCell.row, gXCell.col);
                }
                GXRange gXRange = new GXRange();
                gXRange.setRows(this.m_gxFirstSelectedCell.row, gXCell.row);
                if (this.m_gxSelectionRange.equals(gXRange)) break;
                GXRange gXRange2 = this.m_gxSelectionRange;
                this.m_gxSelectionRange = gXRange;
                this.printMark(gXRange2, gXRange);
                break;
            }
            case 4: {
                GXCell gXCell = this.calcValidClientRowColFromPt(n2, n3);
                boolean bl = this.getParam().getProperties().isAutoScroll();
                if (bl) {
                    this.scrollToView(gXCell.row, gXCell.col);
                }
                GXRange gXRange = new GXRange();
                gXRange.setCols(this.m_gxFirstSelectedCell.col, gXCell.col);
                if (this.m_gxSelectionRange.equals(gXRange)) break;
                GXRange gXRange3 = this.m_gxSelectionRange;
                this.m_gxSelectionRange = gXRange;
                this.printMark(gXRange3, gXRange);
                break;
            }
            case 5: {
                GXRange gXRange;
                GXCell gXCell = this.calcValidClientRowColFromPt(n2, n3);
                boolean bl = this.getParam().getProperties().isAutoScroll();
                if (bl) {
                    this.scrollToView(gXCell.row, gXCell.col);
                }
                if (this.m_gxSelectionRange.equals(gXRange = new GXRange(this.m_gxFirstSelectedCell.row, this.m_gxFirstSelectedCell.col, gXCell.row, gXCell.col))) break;
                GXRange gXRange4 = this.m_gxSelectionRange;
                this.m_gxSelectionRange = gXRange;
                this.printMark(gXRange4, gXRange);
                break;
            }
            case 8: {
                int n4;
                if (n2 - this.m_nTrackingCellX < -3 || n3 - this.m_nTrackingCellY < -3 || (n4 = this.getParam().getProperties().getTrackColWidthMode()) == 0) break;
                this.onMoveTracking(this.m_nRowTracking, this.m_nColTracking, new Dimension(n2, n3));
                break;
            }
            case 7: {
                int n5;
                if (n2 - this.m_nTrackingCellX < -3 || (n5 = this.getParam().getProperties().getTrackColWidthMode()) == 0) break;
                this.onMoveTracking(this.m_gxCurrentCell.row, this.m_nColTracking, new Dimension(n2, this.m_nYLastRow));
                break;
            }
            case 6: {
                int n6;
                if (n3 - this.m_nTrackingCellY < -3 || (n6 = this.getParam().getProperties().getTrackRowHeightMode()) == 0) break;
                this.onMoveTracking(this.m_nRowTracking, this.m_gxCurrentCell.col, new Dimension(this.m_nXLastCol, n3));
            }
        }
        return true;
    }

    public boolean mouseUp(MouseEvent mouseEvent, int n2, int n3) {
        if (!this.w) {
            return true;
        }
        this.w = false;
        if (this.m_bDoubleClicked) {
            this.m_bDoubleClicked = false;
            this.m_nDraggingState = 0;
            return true;
        }
        if (this.m_bDragnDrop) {
            this.m_bDragnDrop = false;
            this.m_bDragCell = false;
            this.onSelDragDrop(n2, n3, mouseEvent.isControlDown());
            return true;
        }
        if (this.m_bMakeCellActive) {
            this.m_bMakeCellActive = false;
            return true;
        }
        if (this.m_bTracking) {
            if (this.m_nDraggingState == 8) {
                this.onEndTracking(this.m_nRowTracking, this.m_nColTracking, new Dimension(Math.max(n2 - this.m_nTrackingCellX, 0), Math.max(n3 - this.m_nTrackingCellY, 0)));
                return true;
            }
            if (this.m_nDraggingState == 7) {
                this.onEndTracking(0, this.m_nColTracking, new Dimension(Math.max(n2 - this.m_nTrackingCellX, 0), 0));
                return true;
            }
            if (this.m_nDraggingState == 6) {
                this.onEndTracking(this.m_nRowTracking, 0, new Dimension(0, Math.max(n3 - this.m_nTrackingCellY, 0)));
                return true;
            }
        }
        if (this.m_nDraggingState == 3 || this.m_nDraggingState == 4 || this.m_nDraggingState == 5) {
            this.m_nDraggingState = 0;
            this.update();
        }
        if (this.m_gxCurrentCell.isValid()) {
            Rectangle rectangle = this.calcRectFromRowCol(this.m_gxCurrentCell.row, this.m_gxCurrentCell.col);
            Component component = this.getAwtComponent();
            if (component != null && component instanceof L && !this.m_gxSelectionRange.isValid() && this.m_gxRangeList.size() == 0 && this.m_gxStCurrentCell.getValue() != null && this.m_gxStCurrentCell.getValue().length() > 0) {
                this.activateCurrentCell(true);
                mouseEvent.translatePoint(-rectangle.x, -rectangle.y);
                component.dispatchEvent(mouseEvent);
            }
        }
        return true;
    }

    public boolean mouseMove(MouseEvent mouseEvent, int n2, int n3) {
        int n4;
        Rectangle rectangle;
        if (this.m_gxSelectionRange != null && this.m_gxSelectionRange.isTable()) {
            return true;
        }
        if (n2 < this.getInsets().left + 4 || n3 < this.getInsets().top + 4) {
            return true;
        }
        GXCell gXCell = this.calcValidClientRowColFromPt(n2, n3);
        Rectangle rectangle2 = this.calcRectFromRowCol(gXCell.row, gXCell.col);
        if (this.m_gxSelectionRange == null || !this.m_gxSelectionRange.isValid()) {
            if (this.isMoveCells() && gXCell.equals(this.m_gxCurrentCell) && rectangle2.contains(n2, n3) && this.getAwtComponent() != null && !this.getAwtComponent().isShowing()) {
                rectangle = new Rectangle(rectangle2.x + 3, rectangle2.y + 3, rectangle2.width - 6, rectangle2.height - 6);
                if (gXCell.row >= this.getHeaderRows() && gXCell.col >= this.getHeaderCols() && !rectangle.contains(n2, n3)) {
                    if (!this.m_bCaptured || this.m_nCursorType != 13) {
                        this.setCursor(13);
                        this.m_nCursorType = 13;
                        this.m_bCaptured = true;
                        this.m_bDragCell = true;
                    }
                    return true;
                }
            } else {
                this.m_bDragCell = false;
            }
        }
        this.m_rectSelection = this.calcRectFromRange(this.m_gxSelectionRange);
        if (!(this.m_rectSelection == null || !this.m_rectSelection.contains(n2, n3) || this.m_gxSelectionRange.isTable() || gXCell.col == 0 && !this.isMoveRows() || gXCell.row == 0 && !this.isMoveCols() || gXCell.row >= this.getHeaderRows() && gXCell.col >= this.getHeaderCols() && !this.isMoveCells())) {
            rectangle = new Rectangle(this.m_rectSelection.x + 3, this.m_rectSelection.y + 3, this.m_rectSelection.width - 6, this.m_rectSelection.height - 6);
            if (gXCell.row == 0 || gXCell.col == 0 || gXCell.row >= this.getHeaderRows() && gXCell.col >= this.getHeaderCols() && !rectangle.contains(n2, n3)) {
                if (!this.m_bCaptured || this.m_nCursorType != 13) {
                    this.setCursor(13);
                    this.m_nCursorType = 13;
                    this.m_bCaptured = true;
                }
                return true;
            }
        }
        boolean bl = false;
        boolean bl2 = false;
        if (Math.abs(n2 - rectangle2.x) < 3) {
            n4 = gXCell.col - 1;
            while (n4 >= 0 && this.getColWidth(n4) == 0) {
                --n4;
            }
            this.m_nColTracking = n4;
            this.m_nTrackingCellX = rectangle2.x - this.getColWidth(this.m_nColTracking);
            bl = true;
        } else if (Math.abs(rectangle2.x + rectangle2.width - n2) < 3) {
            this.m_nColTracking = gXCell.col;
            this.m_nTrackingCellX = rectangle2.x;
            bl = true;
        }
        if (Math.abs(n3 - rectangle2.y) < 3) {
            n4 = gXCell.row - 1;
            while (n4 >= 0 && this.getRowHeight(n4) == 0) {
                --n4;
            }
            this.m_nRowTracking = n4;
            this.m_nTrackingCellY = rectangle2.y - this.getRowHeight(this.m_nRowTracking);
            bl2 = true;
        } else if (Math.abs(rectangle2.y + rectangle2.height - n3) < 3) {
            this.m_nRowTracking = gXCell.row;
            this.m_nTrackingCellY = rectangle2.y;
            bl2 = true;
        }
        if (bl && bl2 && this.m_nColTracking != 0 && this.m_nRowTracking != 0 && this.onStartTracking(this.m_nRowTracking, this.m_nColTracking, 8)) {
            this.m_nDraggingState = 8;
            if (!this.m_bCaptured || this.m_nCursorType != 7) {
                this.setCursor(7);
            }
            this.m_bCaptured = true;
        } else if (bl && this.onStartTracking(gXCell.row, this.m_nColTracking, 7)) {
            this.m_nDraggingState = 7;
            if (!this.m_bCaptured || this.m_nCursorType != 10) {
                this.setCursor(10);
            }
            this.m_bCaptured = true;
        } else if (bl2 && this.onStartTracking(this.m_nRowTracking, gXCell.col, 6)) {
            this.m_nDraggingState = 6;
            if (!this.m_bCaptured || this.m_nCursorType != 8) {
                this.setCursor(8);
            }
            this.m_bCaptured = true;
        } else {
            this.m_nDraggingState = 0;
            if (this.m_bCaptured) {
                this.setCursor(0);
            }
            this.m_bCaptured = false;
        }
        return true;
    }

    public boolean mouseExit(MouseEvent mouseEvent, int n2, int n3) {
        if (this.m_bCaptured && !this.m_bTrackMove) {
            this.m_nDraggingState = 0;
            this.setCursor(0);
            this.m_bCaptured = false;
        }
        return true;
    }

    public void setCursor(int n2) {
        this.m_nCursorType = n2;
        try {
            if (!this.x.equals("Windows NT") && !this.x.equals("Windows 95") && n2 != 0) {
                this.m_nCursorType = 13;
            }
        }
        catch (Exception exception) {}
        this.setCursor(Cursor.getPredefinedCursor(n2));
    }

    public void clearSelection() {
        this.m_gxSelectionRange = new GXRange();
        if (this.m_gxRangeList == null) {
            this.m_gxRangeList = new Vector(10);
        }
        this.m_gxRangeList.removeAllElements();
        this.update();
    }

    public void onShiftSelection(GXCell gXCell) {
        GXRange gXRange = this.m_gxSelectionRange;
        this.m_gxSelectionRange = new GXRange(this.m_gxFirstSelectedCell.row, this.m_gxFirstSelectedCell.col, gXCell.row, gXCell.col);
        this.printMark(gXRange, this.m_gxSelectionRange);
    }

    public void onCtrlSelection(GXCell gXCell) {
        Object object;
        if (this.m_bDragnDrop) {
            return;
        }
        if (this.m_gxSelectionRange.isValid()) {
            this.m_gxRangeList.addElement(this.m_gxSelectionRange);
        } else {
            object = new GXRange(this.m_gxCurrentCell.row, this.m_gxCurrentCell.col, this.m_gxCurrentCell.row, this.m_gxCurrentCell.col);
            this.m_gxRangeList.addElement(object);
            Rectangle rectangle = this.calcRectFromRange((GXRange)object);
            Graphics graphics = this.getGraphics();
            if (graphics != null) {
                this.update(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                graphics.dispose();
            }
        }
        if (gXCell.col == 0) {
            if (gXCell.row == 0) {
                this.m_gxSelectionRange.setTable();
            } else {
                this.m_gxSelectionRange.setRows(gXCell.row, gXCell.row);
                this.m_nDraggingState = 3;
            }
        } else if (gXCell.row == 0) {
            this.m_gxSelectionRange.setCols(gXCell.col, gXCell.col);
            this.m_nDraggingState = 4;
        } else {
            this.m_nDraggingState = 5;
            this.m_gxSelectionRange = new GXRange();
        }
        this.m_rectSelection = this.calcRectFromRange(this.m_gxSelectionRange);
        this.m_gxFirstSelectedCell = gXCell;
        this.deactiveCurrentCell();
        this.m_gxCurrentCell = gXCell;
        this.getStyleRowCol(gXCell.row, gXCell.col, this.m_gxStCurrentCell);
        this.activateCurrentCell(false);
        object = this.getGraphics();
        if (object != null) {
            this.updateHeaders((Graphics)object);
            ((Graphics)object).dispose();
        }
    }

    public void shiftSelectionRange(int n2, int n3, int n4, int n5, boolean bl) {
        if (n5 == 1 && bl) {
            if (Math.min(n2, n3) < 1) {
                return;
            }
            if (this.m_gxSelectionRange != null && this.m_gxSelectionRange.top > Math.max(n2, n3)) {
                this.m_gxSelectionRange.setRows(this.m_gxSelectionRange.top - Math.abs(n2 - n3) - 1, this.m_gxSelectionRange.bottom - Math.abs(n2 - n3) - 1);
                return;
            }
            if (this.m_gxSelectionRange == null || this.m_gxSelectionRange.bottom >= Math.min(n2, n3)) {
                this.m_gxSelectionRange = new GXRange();
            }
            return;
        }
        if (n5 == 1 && !bl) {
            if (Math.min(n2, n3) < 1) {
                return;
            }
            if (this.m_gxSelectionRange != null && this.m_gxSelectionRange.left > Math.max(n2, n3)) {
                this.m_gxSelectionRange.setCols(this.m_gxSelectionRange.left - Math.abs(n2 - n3) - 1, this.m_gxSelectionRange.right - Math.abs(n2 - n3) - 1);
                return;
            }
            if (this.m_gxSelectionRange == null || this.m_gxSelectionRange.right >= Math.min(n2, n3)) {
                this.m_gxSelectionRange = new GXRange();
            }
            return;
        }
        if (n5 == 0 && !bl) {
            if (n4 > n2) {
                this.m_gxSelectionRange.setCols(n4, n4 - Math.abs(n2 - n3));
                return;
            }
            this.m_gxSelectionRange.setCols(n4 + 1, n4 + Math.abs(n2 - n3) + 1);
            return;
        }
        if (n5 == 0 && bl) {
            if (n4 > n2) {
                this.m_gxSelectionRange.setRows(n4, n4 - Math.abs(n2 - n3));
                return;
            }
            this.m_gxSelectionRange.setRows(n4 + 1, n4 + Math.abs(n2 - n3) + 1);
        }
    }

    public void dragSelect(int n2, int n3, boolean bl, boolean bl2) {
        GXCell gXCell = this.calcValidClientRowColFromPt(n2, n3);
        boolean bl3 = this.getParam().getProperties().isAutoScroll();
        if (bl3) {
            this.scrollToView(gXCell.row, gXCell.col);
        }
        GXRange gXRange = new GXRange();
        if (bl) {
            gXRange = new GXRange(this.m_gxFirstSelectedCell.row, this.m_gxFirstSelectedCell.col, gXCell.row, gXCell.col);
        } else if (bl2) {
            gXRange.setRows(this.m_gxFirstSelectedCell.row, gXCell.row);
        } else {
            gXRange.setCols(this.m_gxFirstSelectedCell.col, gXCell.col);
        }
        if (!this.m_gxSelectionRange.equals(gXRange)) {
            GXRange gXRange2 = this.m_gxSelectionRange;
            this.m_gxSelectionRange = gXRange;
            this.printMark(gXRange2, gXRange);
        }
    }

    public void printDragImg(int n2, int n3, boolean bl, boolean bl2, boolean bl3) {
    }

    public boolean isMoveRows() {
        return false;
    }

    public boolean isMoveCols() {
        return false;
    }

    public boolean isMoveCells() {
        return false;
    }

    public boolean onSelDragStart(int n2, int n3, int n4, int n5) {
        return true;
    }

    public boolean onSelDragMove(int n2, int n3) {
        return true;
    }

    public boolean onSelDragDrop(int n2, int n3, boolean bl) {
        return true;
    }

    public boolean isSizingOnlyHeaders() {
        return this.getParam().getProperties().isSizingOnlyHeaders();
    }

    public void setSizingOnlyHeaders(boolean bl) {
        this.getParam().getProperties().setSizingOnlyHeaders(bl);
    }

    public void onChangedRowHeightPerDragging(int n2, int n3) {
        this.m_gxStCurrentCell = null;
        int n4 = this.getParam().getProperties().getTrackRowHeightMode();
        if (n4 == 2) {
            int n5 = this.getParam().getMinRowHeight();
            int n6 = n3 > n5 ? n3 : n5;
            int n7 = this.getHeaderRows();
            while (n7 < this.getRowCount()) {
                this.storeRowHeight(n7, n6);
                ++n7;
            }
            return;
        }
        if (n4 == 1) {
            if (n3 < 3) {
                this.storeRowHeight(n2);
                return;
            }
            this.storeRowHeight(n2, n3);
        }
    }

    public void onChangedColWidthPerDragging(int n2, int n3) {
        this.m_gxStCurrentCell = null;
        int n4 = this.getParam().getProperties().getTrackColWidthMode();
        if (n4 == 2) {
            int n5 = this.getParam().getMinColWidth();
            int n6 = n3 > n5 ? n3 : n5;
            int n7 = this.getHeaderCols();
            while (n7 < this.getColCount()) {
                this.storeColWidth(n7, n6);
                ++n7;
            }
            return;
        }
        if (n4 == 1) {
            if (n3 < 3) {
                this.storeColWidth(n2);
                return;
            }
            this.storeColWidth(n2, n3);
        }
    }

    public boolean onStartTracking(int n2, int n3, int n4) {
        int n5;
        this.m_bTrackMove = false;
        if (n2 > 0 && n3 > 0 && this.isSizingOnlyHeaders()) {
            return false;
        }
        if (!((n4 != 7 || this.onTrackColWidth(n3) && this.onTrackColWidthStart(n3)) && (n4 != 6 || this.onTrackRowHeight(n2) && this.onTrackRowHeightStart(n2)))) {
            return false;
        }
        if ((n4 == 7 || n4 == 8) && (n5 = this.getParam().getProperties().getTrackColWidthMode()) == 0) {
            return false;
        }
        if ((n4 == 6 || n4 == 8) && (n5 = this.getParam().getProperties().getTrackRowHeightMode()) == 0) {
            return false;
        }
        this.m_nDraggingState = n4;
        this.m_bTracking = true;
        return true;
    }

    public boolean onMoveTracking(int n2, int n3, Dimension dimension) {
        Rectangle rectangle;
        int n4;
        if (!this.m_bTracking) {
            return true;
        }
        this.m_bTrackMove = true;
        boolean bl = false;
        if (this.m_nDraggingState == 8) {
            bl = true;
        } else if (this.m_nDraggingState == 7) {
            bl = this.onTrackColWidthMove(n3, dimension.width);
        } else if (this.m_nDraggingState == 6) {
            bl = this.onTrackRowHeightMove(n2, dimension.height);
        }
        if (!bl) {
            return true;
        }
        if (this.m_bDoubleClicked) {
            return true;
        }
        int n5 = this.getRowHeight(0);
        int n6 = this.getColWidth(0);
        Graphics graphics = this.getGraphics();
        if (graphics == null) {
            return true;
        }
        graphics.setColor(this.getBackground());
        graphics.setXORMode(this.getSizeLineColor());
        if ((this.m_nDraggingState == 7 || this.m_nDraggingState == 8) && this.m_rectDraggingX != null) {
            graphics.fillRect(this.m_rectDraggingX.x, this.m_rectDraggingX.y, this.m_rectDraggingX.width, this.m_rectDraggingX.height);
        }
        if ((this.m_nDraggingState == 6 || this.m_nDraggingState == 8) && this.m_rectDraggingY != null) {
            graphics.fillRect(this.m_rectDraggingY.x, this.m_rectDraggingY.y, this.m_rectDraggingY.width, this.m_rectDraggingY.height);
        }
        if (this.m_nDraggingState == 7 || this.m_nDraggingState == 8) {
            this.m_rectDraggingX = new Rectangle(dimension.width, this.getInsets().top + n5, 1, this.m_nGridHeight - n5);
            graphics.fillRect(this.m_rectDraggingX.x, this.m_rectDraggingX.y, this.m_rectDraggingX.width, this.m_rectDraggingX.height);
        }
        if (this.m_nDraggingState == 6 || this.m_nDraggingState == 8) {
            this.m_rectDraggingY = new Rectangle(this.getInsets().left + n6, dimension.height, this.m_nGridWidth - n6, 1);
            graphics.fillRect(this.m_rectDraggingY.x, this.m_rectDraggingY.y, this.m_rectDraggingY.width, this.m_rectDraggingY.height);
        }
        if (this.m_nDraggingState == 7 || this.m_nDraggingState == 8) {
            this.onChangedColWidthPerDragging(this.m_nColTracking, dimension.width - this.m_nTrackingCellX);
            n4 = this.getParam().getProperties().getTrackColWidthMode();
            if (n4 == 2) {
                rectangle = null;
            } else {
                rectangle = new Rectangle(this.m_nTrackingCellX, this.getInsets().top, this.getInsets().left + this.m_nGridWidth - this.m_nTrackingCellX, n5);
                graphics = this.getGraphics();
                if (graphics != null) {
                    this.update(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
            }
        }
        if (this.m_nDraggingState == 6 || this.m_nDraggingState == 8) {
            this.onChangedRowHeightPerDragging(this.m_nRowTracking, dimension.height - this.m_nTrackingCellY);
            n4 = this.getParam().getProperties().getTrackRowHeightMode();
            if (n4 != 2) {
                rectangle = new Rectangle(this.getInsets().left, this.m_nTrackingCellY, n6, this.getInsets().top + this.m_nGridHeight - this.m_nTrackingCellY);
                graphics = this.getGraphics();
                if (graphics != null) {
                    this.update(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
            }
        }
        if (graphics != null) {
            graphics.dispose();
        }
        return true;
    }

    public void clearCells(GXRange gXRange, boolean bl) {
        int n2;
        int n3;
        if (bl) {
            n3 = gXRange.top;
            while (n3 <= gXRange.bottom) {
                n2 = gXRange.left;
                while (n2 <= gXRange.right) {
                    GXStyle gXStyle = this.getStyleObject();
                    this.getStyleRowCol(n3, n2, gXStyle, 2);
                    gXStyle.setIncludeValue(false);
                    gXStyle.setIncludeChoice(false);
                    this.storeStyleRowCol(n3, n2, gXStyle, 2, 0);
                    ++n2;
                }
                ++n3;
            }
        } else {
            n3 = gXRange.top;
            while (n3 <= gXRange.bottom) {
                n2 = gXRange.left;
                while (n2 <= gXRange.right) {
                    this.storeStyleRowCol(n3, n2, null, 4, 0);
                    ++n2;
                }
                ++n3;
            }
        }
        GXCell gXCell = this.getCurrentCell();
        if (gXCell != null && gXCell.isValid() && gXRange.isCellInRange(gXCell.row, gXCell.col)) {
            GXStyle gXStyle = this.getCurrentCellStyle();
            gXStyle.setValue("");
        }
        Rectangle rectangle = this.calcRectFromRange(gXRange);
        this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void onEndTracking(int n2, int n3, Dimension dimension) {
        if (this.getAwtComponent() != null && this.getAwtComponent().isShowing()) {
            return;
        }
        this.m_gxCurrentCell = new GXCell();
        if ((this.m_nDraggingState == 7 || this.m_nDraggingState == 8) && this.onTrackColWidthEnd(n3, dimension.width) && this.m_bTrackMove) {
            this.storeColWidth(this.m_nColTracking, this.m_nTrackingColWidth);
            this.setColWidth(this.m_nColTracking, this.m_nColTracking, dimension.width, null, 0, 0);
            this.m_nTrackingColWidth = 0;
            this.onChangedColWidthPerDragging(this.m_nColTracking, dimension.width);
        }
        if ((this.m_nDraggingState == 6 || this.m_nDraggingState == 8) && this.onTrackRowHeightEnd(n2, dimension.height) && this.m_bTrackMove) {
            this.storeRowHeight(this.m_nRowTracking, this.m_nTrackingRowHeight);
            this.setRowHeight(this.m_nRowTracking, this.m_nRowTracking, dimension.height, null, 0, 0);
            this.m_nTrackingRowHeight = 0;
            this.onChangedRowHeightPerDragging(this.m_nRowTracking, dimension.height);
        }
        if (this.m_bTrackMove) {
            this.updateScrollbar();
            this.update();
        } else {
            this.update();
        }
        this.m_rectDraggingY = null;
        this.m_rectDraggingX = null;
        this.m_bTrackMove = false;
        this.m_bTracking = false;
        this.m_gxSelectionRange = new GXRange();
        this.m_rectSelection = null;
    }

    public boolean onTrackColWidth(int n2) {
        return true;
    }

    public boolean onTrackColWidthStart(int n2) {
        this.m_nTrackingColWidth = this.getColWidth(n2);
        GXGridEvent gXGridEvent = new GXGridEvent(this, 7, new Integer(n2));
        this.processGXGridEvent(gXGridEvent);
        return true;
    }

    public boolean onTrackColWidthMove(int n2, int n3) {
        GXGridEvent gXGridEvent = new GXGridEvent(this, 9, new Integer(n2));
        this.processGXGridEvent(gXGridEvent);
        return true;
    }

    public boolean onTrackColWidthEnd(int n2, int n3) {
        GXGridEvent gXGridEvent = new GXGridEvent(this, 11, new Integer(n2));
        this.processGXGridEvent(gXGridEvent);
        return true;
    }

    public boolean onTrackRowHeight(int n2) {
        return true;
    }

    public boolean onTrackRowHeightStart(int n2) {
        this.m_nTrackingRowHeight = this.getRowHeight(n2);
        GXGridEvent gXGridEvent = new GXGridEvent(this, 8, new Integer(n2));
        this.processGXGridEvent(gXGridEvent);
        return true;
    }

    public boolean onTrackRowHeightMove(int n2, int n3) {
        GXGridEvent gXGridEvent = new GXGridEvent(this, 10, new Integer(n2));
        this.processGXGridEvent(gXGridEvent);
        return true;
    }

    public boolean onTrackRowHeightEnd(int n2, int n3) {
        GXGridEvent gXGridEvent = new GXGridEvent(this, 12, new Integer(n2));
        this.processGXGridEvent(gXGridEvent);
        return true;
    }

    public void setTrackColWidthMode(int n2) {
        this.getParam().getProperties().setTrackColWidthMode(n2);
    }

    public int getTrackColWidthMode() {
        return this.getParam().getProperties().getTrackColWidthMode();
    }

    public void setTrackRowHeightMode(int n2) {
        this.getParam().getProperties().setTrackRowHeightMode(n2);
    }

    public int getTrackRowHeightMode() {
        return this.getParam().getProperties().getTrackRowHeightMode();
    }

    public int getTrackColID() {
        return this.m_nColTracking;
    }

    public int getTrackRowID() {
        return this.m_nRowTracking;
    }

    public void activateCurrentCell(MouseEvent mouseEvent, int n2, int n3) {
        Graphics graphics;
        if (!this.m_gxCurrentCell.isValid()) {
            return;
        }
        GXStyle gXStyle = this.getStyleObject();
        this.getStyleRowCol(this.m_gxCurrentCell.row, this.m_gxCurrentCell.col, gXStyle);
        if (gXStyle.getControl() == null) {
            gXStyle.setControl(new GXTextField(this));
        }
        if (this.m_gxStCurrentCell != null) {
            this.m_gxStCurrentCell.clearAllIncludes();
            this.recycleStyleObject(this.m_gxStCurrentCell);
        }
        this.m_gxStCurrentCell = gXStyle;
        this.m_awtComponent = this.m_gxStCurrentCell.getControl();
        boolean bl = !(this.m_awtComponent instanceof L);
        this.activateCurrentCell(bl);
        try {
            if (this.m_awtComponent instanceof Component && ((Component)((Object)this.m_awtComponent)).isShowing()) {
                ((Component)((Object)this.m_awtComponent)).dispatchEvent(mouseEvent);
            }
        }
        catch (Exception exception) {}
        if (!((graphics = this.getGraphics()) == null || this.m_gxSelectionRange != null && this.m_gxSelectionRange.isTable())) {
            this.updateHeaders(graphics);
        }
        if (graphics != null) {
            graphics.dispose();
        }
    }

    public synchronized boolean activateCurrentCell(boolean bl) {
        Object object;
        GXControl gXControl;
        boolean bl2;
        GXCell gXCell = this.getCurrentCell();
        GXStyle gXStyle = this.getCurrentCellStyle();
        boolean bl3 = bl2 = this.isReadOnly() || gXStyle != null && gXStyle.getReadOnly();
        if (gXStyle == null) {
            gXStyle = this.getStyleObject();
            this.getStyleRowCol(gXCell.row, gXCell.col, gXStyle);
            if (gXStyle == null) {
                return false;
            }
            if (this.m_gxStCurrentCell != null) {
                this.m_gxStCurrentCell.clearAllIncludes();
                this.recycleStyleObject(this.m_gxStCurrentCell);
            }
            this.m_gxStCurrentCell = gXStyle;
        }
        if ((gXControl = gXStyle.getControl()) == null) {
            return false;
        }
        if (this.isBaseStyleUsed()) {
            gXStyle.loadBaseStyle();
        }
        gXControl.onSetGXStyle(gXStyle, true);
        Rectangle rectangle = this.calcRectFromRowCol(gXCell.row, gXCell.col);
        try {
            if (((Component)((Object)gXControl)).getParent() != this && !bl2) {
                this.add((Component)((Object)gXControl));
            }
            ((Component)((Object)gXControl)).setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            if (gXControl instanceof GXExControl) {
                ((GXExControl)gXControl).doGetFocus(bl);
            } else if (bl && !bl2) {
                ((Component)((Object)gXControl)).setVisible(true);
                ((Component)((Object)gXControl)).enable();
            } else {
                ((Component)((Object)gXControl)).setVisible(false);
                ((Component)((Object)gXControl)).disable();
            }
        }
        catch (Exception exception) {}
        if (!bl && (object = this.getGraphics()) != null) {
            ((Graphics)object).clipRect(rectangle.x - 2, rectangle.y - 2, rectangle.width + 5, rectangle.height + 5);
            this.update((Graphics)object, rectangle.x - 2, rectangle.y - 2, rectangle.width + 5, rectangle.height + 5);
            ((Graphics)object).dispose();
        }
        object = this.m_gxPreviousCell;
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            rectangle = this.calcRectFromRowCol(((GXCell)object).row, ((GXCell)object).col);
            graphics.clipRect(rectangle.x - 2, rectangle.y - 2, rectangle.width + 5, rectangle.height + 5);
            this.update(graphics, rectangle.x - 2, rectangle.y - 2, rectangle.width + 5, rectangle.height + 5);
            graphics.dispose();
        }
        this.setProcessFocusEvent(false);
        if (!bl2 && bl && gXControl instanceof Component) {
            ((Component)((Object)gXControl)).requestFocus();
        } else {
            this.requestFocus();
            this.setProcessFocusEvent(true);
        }
        this.m_awtComponent = this.m_gxStCurrentCell.getControl();
        if (this.isAutoScroll()) {
            int n2 = this.A;
            int n3 = this.B;
            this.scrollToView(gXCell.row, gXCell.col);
            if (n2 != this.A || n3 != this.B) {
                object = this.m_gxPreviousCell;
                graphics = this.getGraphics();
                if (graphics != null) {
                    rectangle = this.calcRectFromRowCol(((GXCell)object).row, ((GXCell)object).col);
                    graphics.clipRect(rectangle.x - 2, rectangle.y - 2, rectangle.width + 5, rectangle.height + 5);
                    this.update(graphics, rectangle.x - 2, rectangle.y - 2, rectangle.width + 5, rectangle.height + 5);
                    graphics.dispose();
                }
            }
        }
        return true;
    }

    public GXRange getStartRange() {
        if (this.m_gxSelectionRange.isValid() && !this.m_bUpdateRange) {
            return this.m_gxSelectionRange;
        }
        return new GXRange(this.m_gxCurrentCell.row, this.m_gxCurrentCell.col, this.m_gxCurrentCell.row, this.m_gxCurrentCell.col);
    }

    public boolean keyDown(KeyEvent keyEvent, int n2) {
        boolean bl;
        if (this.m_gxCurrentCell == null || !this.m_gxCurrentCell.isValid()) {
            return true;
        }
        GXRange gXRange = this.getStartRange();
        boolean bl2 = bl = keyEvent.getModifiers() == 1;
        if (this.m_bUpdateRange && this.m_gxSelectionRange.isValid() && n2 != 16) {
            this.m_gxRangeList.addElement(this.m_gxSelectionRange);
        }
        switch (n2) {
            case 40: {
                this.onMoveCurrentCell(40, bl, gXRange);
                break;
            }
            case 39: {
                this.onMoveCurrentCell(39, bl, gXRange);
                break;
            }
            case 38: {
                this.onMoveCurrentCell(38, bl, gXRange);
                break;
            }
            case 37: {
                this.onMoveCurrentCell(37, bl, gXRange);
                break;
            }
            case 9: {
                if (this.u) break;
                this.m_bUpdateRange = true;
                if (!bl) {
                    this.moveToNextCell(39);
                    this.update();
                } else {
                    this.moveToNextCell(37);
                    this.update();
                }
                keyEvent.consume();
                break;
            }
            case 10: {
                this.m_bUpdateRange = true;
                if (this.m_gxStCurrentCell == null || this.m_gxStCurrentCell.getAllowEnter()) break;
                this.moveToNextCell(39);
                break;
            }
            case 27: {
                GXControl gXControl;
                if (this.m_gxStCurrentCell == null || (gXControl = this.m_gxStCurrentCell.getControl()) == null) break;
                gXControl.onCancelEdit();
                break;
            }
            case 34: {
                if (!this.moveToNextCell(34)) break;
                if (!bl) {
                    this.m_bUpdateRange = true;
                    break;
                }
                if (this.m_bUpdateRange) {
                    this.m_bUpdateRange = false;
                }
                this.m_gxSelectionRange = this.m_gxCurrentCell.row > gXRange.bottom ? new GXRange(gXRange.top, gXRange.left, this.m_gxCurrentCell.row, gXRange.right) : new GXRange(this.m_gxCurrentCell.row, gXRange.left, gXRange.bottom, gXRange.right);
                this.printMark(gXRange, this.m_gxSelectionRange);
                break;
            }
            case 33: {
                if (!this.moveToNextCell(33)) break;
                int n3 = this.getFrozenRows();
                Scrollbar scrollbar = this.getVScrollbar();
                if (this.getCurrentCell().row < n3 && scrollbar.getValue() != scrollbar.getMinimum()) {
                    int n4 = scrollbar.getMinimum();
                    scrollbar.setValue(n4);
                    this.scroll(1, n4);
                }
                if (!bl) {
                    this.m_bUpdateRange = true;
                    break;
                }
                if (this.m_bUpdateRange) {
                    this.m_bUpdateRange = false;
                }
                this.m_gxSelectionRange = this.m_gxCurrentCell.row < gXRange.top ? new GXRange(this.m_gxCurrentCell.row, gXRange.left, gXRange.bottom, gXRange.right) : new GXRange(gXRange.top, gXRange.left, this.m_gxCurrentCell.row, gXRange.right);
                this.printMark(gXRange, this.m_gxSelectionRange);
                break;
            }
            default: {
                if (keyEvent.getModifiers() == 2 || keyEvent.getModifiers() == 8) break;
                this.activateCurrentCell(true);
                Component component = this.getAwtComponent();
                if (component == null) break;
                component.dispatchEvent(keyEvent);
            }
        }
        if (this.getFocusRectType() == nEXLLike && this.m_gxSelectionRange != null && this.m_gxSelectionRange.isValid() && !this.m_gxSelectionRange.isCellInRange(this.m_gxCurrentCell.row, this.m_gxCurrentCell.col)) {
            this.clearSelection();
        }
        return true;
    }

    public void onMoveCurrentCell(int n2, boolean bl, GXRange gXRange) {
        if (this.moveToNextCell(n2)) {
            if (!bl) {
                this.m_bUpdateRange = true;
                return;
            }
            this.updateRange(gXRange, n2);
            this.printMark(gXRange, this.m_gxSelectionRange);
        }
    }

    public boolean moveToNextCell(int n2) {
        int n3 = this.m_gxCurrentCell.row;
        int n4 = this.m_gxCurrentCell.col;
        GXCell gXCell = this.nextCell(new GXCell(n3, n4), n2);
        boolean bl = !gXCell.equals(this.m_gxCurrentCell);
        if (bl) {
            this.moveTo(gXCell.row, gXCell.col);
        } else {
            bl = false;
        }
        return bl;
    }

    public void updateRange(GXRange gXRange, int n2) {
        if (!this.isSelectionEnabled()) {
            return;
        }
        if (this.m_bUpdateRange) {
            this.m_bUpdateRange = false;
        }
        GXRange gXRange2 = new GXRange();
        GXRange gXRange3 = new GXRange(this.m_gxCurrentCell.row, this.m_gxCurrentCell.col, this.m_gxCurrentCell.row, this.m_gxCurrentCell.col);
        if (n2 == 40 && this.m_gxCurrentCell.row > gXRange.bottom || n2 == 39 && this.m_gxCurrentCell.col > gXRange.right || n2 == 38 && this.m_gxCurrentCell.row < gXRange.top || n2 == 37 && this.m_gxCurrentCell.col < gXRange.left) {
            if (gXRange2.unionRange(gXRange, gXRange3)) {
                this.m_gxSelectionRange = gXRange2;
                return;
            }
        } else {
            switch (n2) {
                case 40: {
                    this.m_gxSelectionRange = new GXRange(this.m_gxCurrentCell.row, gXRange.left, gXRange.bottom, gXRange.right);
                    return;
                }
                case 39: {
                    this.m_gxSelectionRange = new GXRange(gXRange.top, this.m_gxCurrentCell.col, gXRange.bottom, gXRange.right);
                    return;
                }
                case 38: {
                    this.m_gxSelectionRange = new GXRange(gXRange.top, gXRange.left, this.m_gxCurrentCell.row, gXRange.right);
                    return;
                }
                case 37: {
                    this.m_gxSelectionRange = new GXRange(gXRange.top, gXRange.left, gXRange.bottom, this.m_gxCurrentCell.col);
                    return;
                }
            }
        }
    }

    public void printMark(GXRange gXRange, GXRange gXRange2) {
        Object object;
        if (!this.isSelectionEnabled()) {
            return;
        }
        Rectangle rectangle = this.calcRectFromRange(gXRange2);
        if (gXRange.isValid()) {
            object = this.calcRectFromRange(gXRange);
            rectangle = rectangle.union((Rectangle)object);
        }
        if ((object = this.getGraphics()) != null) {
            this.update((Graphics)object, rectangle.x - 2, rectangle.y - 2, rectangle.width + 5, rectangle.height + 5);
            ((Graphics)object).dispose();
        }
    }

    public GXCell nextCell(GXCell gXCell, int n2) {
        GXCell gXCell2 = new GXCell();
        switch (n2) {
            case 38: {
                int n3 = gXCell.row - 1;
                while (n3 >= this.getHeaderRows()) {
                    gXCell2 = this.isCellBeCovered(n3, gXCell.col);
                    if (gXCell2 != null && gXCell2.row < gXCell.row && this.canSelectCurrentCell(true, gXCell2.row, gXCell2.col, this.m_gxCurrentCell.row, this.m_gxCurrentCell.col)) {
                        return gXCell2;
                    }
                    if (gXCell2 == null && this.getRowHeight(n3) > 0 && this.canSelectCurrentCell(true, n3, gXCell.col, this.m_gxCurrentCell.row, this.m_gxCurrentCell.col)) {
                        return new GXCell(n3, gXCell.col);
                    }
                    --n3;
                }
                return gXCell;
            }
            case 40: {
                int n4 = gXCell.row + 1;
                while (n4 < this.getRowCount()) {
                    gXCell2 = this.isCellBeCovered(n4, gXCell.col);
                    if (gXCell2 != null && gXCell2.row > gXCell.row && this.canSelectCurrentCell(true, gXCell2.row, gXCell2.col, this.m_gxCurrentCell.row, this.m_gxCurrentCell.col)) {
                        return gXCell2;
                    }
                    if (gXCell2 == null && this.getRowHeight(n4) > 0 && !this.isRowHidden(n4) && this.canSelectCurrentCell(true, n4, gXCell.col, this.m_gxCurrentCell.row, this.m_gxCurrentCell.col)) {
                        return new GXCell(n4, gXCell.col);
                    }
                    ++n4;
                }
                return gXCell;
            }
            case 37: {
                int n5 = gXCell.col - 1;
                while (n5 >= this.getHeaderCols()) {
                    gXCell2 = this.isCellBeCovered(gXCell.row, n5);
                    if (gXCell2 != null && gXCell2.col < gXCell.col && this.canSelectCurrentCell(true, gXCell2.row, gXCell2.col, this.m_gxCurrentCell.row, this.m_gxCurrentCell.col)) {
                        return gXCell2;
                    }
                    if (gXCell2 == null && this.getColWidth(n5) > 0 && this.canSelectCurrentCell(true, gXCell.row, n5, this.m_gxCurrentCell.row, this.m_gxCurrentCell.col)) {
                        return new GXCell(gXCell.row, n5);
                    }
                    --n5;
                }
                return gXCell;
            }
            case 39: {
                int n6 = gXCell.col + 1;
                while (n6 < this.getColCount()) {
                    gXCell2 = this.isCellBeCovered(gXCell.row, n6);
                    if (gXCell2 != null && gXCell2.col > gXCell.col && this.canSelectCurrentCell(true, gXCell2.row, gXCell2.col, this.m_gxCurrentCell.row, this.m_gxCurrentCell.col)) {
                        return gXCell2;
                    }
                    if (gXCell2 == null && this.getColWidth(n6) > 0 && !this.isColHidden(n6) && this.canSelectCurrentCell(true, gXCell.row, n6, this.m_gxCurrentCell.row, this.m_gxCurrentCell.col)) {
                        return new GXCell(gXCell.row, n6);
                    }
                    ++n6;
                }
                return gXCell;
            }
            case 34: {
                int n7 = 0;
                int n8 = this.getFrozenRows();
                int n9 = 0;
                while (n9 < n8) {
                    n7 += this.getRowHeight(n9);
                    ++n9;
                }
                int n10 = this.getLastVisibleRow();
                n9 = 0;
                while (n10 < this.getRowCount() && n9 < this.m_nGridHeight - this.getHScrollbar().bounds().height - n7) {
                    n9 += this.getRowHeight(n10);
                    ++n10;
                }
                --n10;
                while (n10 < this.getRowCount()) {
                    gXCell2 = this.isCellBeCovered(n10, gXCell.col);
                    if (gXCell2 != null && gXCell2.row > gXCell.row && this.canSelectCurrentCell(true, gXCell2.row, gXCell2.col, this.m_gxCurrentCell.row, this.m_gxCurrentCell.col)) {
                        return gXCell2;
                    }
                    if (gXCell2 == null && this.getRowHeight(n10) > 0 && !this.isRowHidden(n10) && this.canSelectCurrentCell(true, n10, gXCell.col, this.m_gxCurrentCell.row, this.m_gxCurrentCell.col)) {
                        return new GXCell(n10, gXCell.col);
                    }
                    ++n10;
                }
            }
            case 33: {
                int n7 = 0;
                int n8 = this.getFrozenRows();
                int n11 = 0;
                while (n11 < n8) {
                    n7 += this.getRowHeight(n11);
                    ++n11;
                }
                int n10 = this.getTopRow();
                int n9 = 0;
                while (n10 > 0 && n9 < this.m_nGridHeight - this.getHScrollbar().bounds().height - n7) {
                    n9 += this.getRowHeight(n10);
                    --n10;
                }
                ++n10;
                while (n10 >= this.getHeaderRows()) {
                    gXCell2 = this.isCellBeCovered(n10, gXCell.col);
                    if (gXCell2 != null && gXCell2.row < gXCell.row && this.canSelectCurrentCell(true, gXCell2.row, gXCell2.col, this.m_gxCurrentCell.row, this.m_gxCurrentCell.col)) {
                        return gXCell2;
                    }
                    if (gXCell2 == null && this.getRowHeight(n10) > 0 && this.canSelectCurrentCell(true, n10, gXCell.col, this.m_gxCurrentCell.row, this.m_gxCurrentCell.col)) {
                        return new GXCell(n10, gXCell.col);
                    }
                    --n10;
                }
                break;
            }
        }
        return gXCell2;
    }

    public boolean moveTo(int n2, int n3) {
        if (n2 < this.getHeaderRows() || n2 >= this.getRowCount()) {
            return false;
        }
        if (n3 < this.getHeaderCols() || n3 >= this.getColCount()) {
            return false;
        }
        GXCell gXCell = this.getCurrentCell();
        if (!this.onLeftCurrentCell(gXCell.row, gXCell.col)) {
            return false;
        }
        if (!this.deactiveCurrentCell()) {
            return false;
        }
        if (this.m_gxStCurrentCell == null) {
            this.m_gxStCurrentCell = this.getStyleObject();
        } else {
            this.m_gxStCurrentCell.clearAllIncludes();
        }
        this.getStyleRowCol(n2, n3, this.m_gxStCurrentCell);
        if (this.m_gxCurrentCell == null) {
            this.m_gxCurrentCell = new GXCell(n2, n3);
        } else {
            this.m_gxCurrentCell.row = n2;
            this.m_gxCurrentCell.col = n3;
        }
        try {
            Graphics graphics = this.getGraphics();
            if (graphics != null) {
                this.updateHeaders(graphics);
                graphics.dispose();
            }
        }
        catch (Exception exception) {}
        try {
            this.activateCurrentCell(false);
        }
        catch (Exception exception) {}
        this.m_awtComponent = this.m_gxStCurrentCell.getControl();
        this.onCurrentCellChanged(n2, n3);
        this.m_gxFirstSelectedCell = this.m_gxCurrentCell;
        return true;
    }

    public boolean moveTo(int n2) {
        return this.moveTo(n2, this.m_gxCurrentCell.col);
    }

    public synchronized boolean deactiveCurrentCell() {
        GXCell gXCell = this.getCurrentCell();
        boolean bl = false;
        if (gXCell.isValid()) {
            try {
                bl = this.onDeactiveCurrentCell();
            }
            catch (Exception exception) {
                GXDebug.msg("deactive " + exception.toString());
            }
            if (bl) {
                this.m_gxPreviousCell.row = gXCell.row;
                this.m_gxPreviousCell.col = gXCell.col;
            }
        }
        return bl;
    }

    public synchronized boolean onDeactiveCurrentCell() {
        GXStyle gXStyle = this.getCurrentCellStyle();
        GXCell gXCell = this.getCurrentCell();
        Component component = this.getAwtComponent();
        if (component == null || !component.isShowing()) {
            return true;
        }
        if (this.isReadOnly() || gXStyle != null && gXStyle.getReadOnly()) {
            return true;
        }
        if (gXStyle != null && gXStyle.getIncludeControl()) {
            GXControl gXControl = gXStyle.getControl();
            if (!gXControl.onValidate()) {
                return false;
            }
            if (gXControl.getModify()) {
                gXControl.onSetGXStyle(gXStyle, false);
                GXStyle gXStyle2 = this.getStyleObject();
                if (!this.getStyleRowCol(gXCell.row, gXCell.col, gXStyle2, 2)) {
                    gXStyle2 = this.getStyleObject();
                }
                if (gXStyle.getIncludeValue()) {
                    gXStyle2.setValue(gXStyle.getValue(), false);
                }
                if (gXStyle.getIncludeChoice()) {
                    gXStyle2.setChoice(gXStyle.getChoice(), false);
                }
                if (gXStyle.getIncludeUserAttrs()) {
                    gXStyle2.setUserAttrs(gXStyle.getUserAttrs());
                }
                if (gXStyle.getIncludeData()) {
                    gXStyle2.setData(gXStyle.getData());
                }
                GXRange gXRange = new GXRange(gXCell.row, gXCell.col, gXCell.row, gXCell.col);
                this.setStyleRange(gXRange, gXStyle2, 2, 0);
                gXStyle2.clearAllIncludes();
                this.recycleStyleObject(gXStyle2);
                this.mergeCell(gXCell.row, gXCell.col);
                GXGridEvent gXGridEvent = new GXGridEvent(this, 6, gXCell);
                this.processGXGridEvent(gXGridEvent);
            }
            if (gXControl instanceof GXExControl) {
                ((GXExControl)gXControl).doLoseFocus();
            } else if (gXControl instanceof Component) {
                ((Component)((Object)gXControl)).setVisible(false);
            }
            return true;
        }
        return false;
    }

    public synchronized void mergeCell(int n2, int n3) {
    }

    public void onSaveStyle(int n2, int n3, GXStyle gXStyle, int n4) {
        GXRange gXRange = new GXRange(n2, n3, n2, n3);
        this.setStyleRange(gXRange, gXStyle, 2, 0, false);
    }

    public void updateHeaders(Graphics graphics) {
        this.updateHeaders(graphics, false);
        this.updateHeaders(graphics, true);
    }

    public void updateHeaders(Graphics graphics, boolean bl) {
        block5: {
            GXCell gXCell = bl ? this.m_gxCurrentCell : this.m_gxPreviousCell;
            try {
                if (gXCell == null || gXCell.row <= 0 || gXCell.col <= 0) break block5;
                if (this.getMarkCurRow() && (bl || this.m_gxCurrentCell.row != this.m_gxPreviousCell.row) && this.getHeaderCols() > 0) {
                    this.updateHeader(graphics, gXCell.row, 0, bl);
                }
                if (!this.getMarkCurCol()) break block5;
                if (bl || this.m_gxCurrentCell.col != this.m_gxPreviousCell.col) {
                    if (this.getHeaderRows() <= 0) break block5;
                    this.updateHeader(graphics, 0, gXCell.col, bl);
                }
                return;
            }
            catch (Exception exception) {}
        }
    }

    public void updateHeader(Graphics graphics, int n2, int n3, boolean bl) {
        GXCell gXCell = this.isCellBeCovered(n2, n3);
        GXStyle gXStyle = this.getStyleObject();
        if (gXCell == null) {
            this.getStyleRowCol(n2, n3, gXStyle);
        } else {
            this.getStyleRowCol(gXCell.row, gXCell.col, gXStyle);
        }
        if (this.get3DButtons() && !bl) {
            gXStyle.setDraw3dFrame(2);
        } else {
            gXStyle.setDraw3dFrame(0);
        }
        if (gXCell == null) {
            Rectangle rectangle = this.calcRectFromRowCol(n2, n3);
            if (this.isBaseStyleUsed()) {
                gXStyle.loadBaseStyle();
            }
            gXStyle.doPaint(graphics, rectangle, n2, n3);
            if (this.isCellBeSelected(n2, n3) && bl) {
                graphics.setColor(this.getBackground());
                graphics.setXORMode(this.getSelectionRectColor());
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                graphics.setPaintMode();
            }
        } else {
            Rectangle rectangle = this.calcRectFromRowCol(gXCell.row, gXCell.col);
            if (!this.getDrawVLine()) {
                --rectangle.width;
            }
            if (!this.getDrawHLine()) {
                --rectangle.height;
            }
            if (this.isBaseStyleUsed()) {
                gXStyle.loadBaseStyle();
            }
            gXStyle.doPaint(graphics, rectangle, gXCell.row, gXCell.col);
            if (this.isCellBeSelected(gXCell.row, gXCell.col) && bl) {
                graphics.setColor(this.getBackground());
                graphics.setXORMode(this.getSelectionRectColor());
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                graphics.setPaintMode();
            }
        }
        gXStyle.clearAllIncludes();
        this.recycleStyleObject(gXStyle);
    }

    public boolean onLeftCurrentCell(int n2, int n3) {
        GXGridEvent gXGridEvent = new GXGridEvent(this, 3, new GXCell(n2, n3));
        this.processGXGridEvent(gXGridEvent);
        return true;
    }

    public void onCurrentCellChanged(int n2, int n3) {
        GXGridEvent gXGridEvent = new GXGridEvent(this, 5, new GXCell(n2, n3));
        this.processGXGridEvent(gXGridEvent);
    }

    public void setAutoScroll(boolean bl) {
        this.getParam().getProperties().setAutoScroll(bl);
    }

    public boolean isAutoScroll() {
        return this.getParam().getProperties().isAutoScroll();
    }

    public void scrollToView(int n2, int n3) {
        int n4;
        int n5 = this.getLastVisibleRow();
        int n6 = this.getLastVisibleCol();
        Scrollbar scrollbar = this.getHScrollbar();
        Scrollbar scrollbar2 = this.getVScrollbar();
        if (this.isRowHidden(n2)) {
            n4 = scrollbar2.getValue() - this.getTopRow() + n2;
            if (n4 <= scrollbar2.getMinimum()) {
                n4 = scrollbar2.getMinimum();
            }
            scrollbar2.setValue(n4);
            this.scroll(1, n4);
            this.onTopRowChanged(n4);
        }
        if (n2 > n5 - 1) {
            n4 = scrollbar2.getValue() + n2 - n5 + 1;
            if (n4 > scrollbar2.getMaximum() || n2 == this.getRowCount()) {
                n4 = scrollbar2.getMaximum();
            }
            scrollbar2.setValue(n4);
            this.scroll(1, n4);
            this.onTopRowChanged(n4);
        }
        if (this.isColHidden(n3)) {
            n4 = scrollbar.getValue() - this.getLeftCol() + n3;
            if (n4 <= scrollbar.getMinimum()) {
                n4 = scrollbar.getMinimum();
            }
            scrollbar.setValue(n4);
            this.scroll(0, n4);
            this.onLeftColChanged(n4);
        }
        if (n3 > n6 - 1) {
            n4 = scrollbar.getValue() + n3 - n6 + 1;
            if (n4 > scrollbar.getMaximum()) {
                n4 = scrollbar.getMaximum();
            }
            scrollbar.setValue(n4);
            this.scroll(0, n4);
            this.onLeftColChanged(n4);
        }
    }

    public void onLeftColChanged(int n2) {
        super.onLeftColChanged(n2);
        GXGridEvent gXGridEvent = new GXGridEvent(this, 2, new Integer(n2));
        this.processGXGridEvent(gXGridEvent);
    }

    public void onTopRowChanged(int n2) {
        super.onTopRowChanged(n2);
        GXGridEvent gXGridEvent = new GXGridEvent(this, 1, new Integer(n2));
        this.processGXGridEvent(gXGridEvent);
    }

    public void setFocusRectType(int n2) {
        this.y = n2;
    }

    public int getFocusRectType() {
        return this.y;
    }

    public void setFocusRectColor(Color color) {
        this.m_gxParam.getProperties().setColor(11, color);
    }

    public Color getFocusRectColor() {
        return this.m_gxParam.getProperties().getColor(11);
    }

    public void paintFocusRect(Graphics graphics) {
        if (!(this.v || this.getAwtComponent() != null && this.getAwtComponent().isShowing())) {
            return;
        }
        boolean bl = this.m_gxCurrentCell.isValid() && this.isVisibleCell(this.m_gxCurrentCell) && this.m_gxCurrentCell.row >= this.getHeaderRows() && this.m_gxCurrentCell.col >= this.getHeaderCols() || this.getFocusRectType() == nEXLLike && this.m_gxSelectionRange != null && this.m_gxSelectionRange.bottom >= Math.max(this.getHeaderRows(), this.A) && this.m_gxSelectionRange.right >= Math.max(this.getHeaderCols(), this.B);
        if (bl) {
            Rectangle rectangle = this.getFocusRectType() == nEXLLike && this.m_gxSelectionRange != null && this.m_gxSelectionRange.isValid() && this.m_gxSelectionRange.isCellInRange(this.m_gxCurrentCell.row, this.m_gxCurrentCell.col) ? this.calcRectFromRange(this.m_gxSelectionRange) : this.calcRectFromRowCol(this.m_gxCurrentCell.row, this.m_gxCurrentCell.col);
            graphics.setColor(this.getFocusRectColor());
            graphics.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
            if (this.getFocusRectType() == nEXLLike) {
                graphics.drawRect(rectangle.x - 2, rectangle.y - 2, rectangle.width + 3, rectangle.height + 3);
                graphics.fillRect(rectangle.x + rectangle.width - 2, rectangle.y + rectangle.height - 2, 5, 5);
                graphics.setColor(this.getBackground());
                graphics.drawRect(rectangle.x + rectangle.width - 3, rectangle.y + rectangle.height - 3, 7, 7);
            }
        }
    }

    public void paintSelectionRange(Graphics graphics) {
        if (this.m_gxSelectionRange != null && this.m_gxSelectionRange.isValid() || this.m_gxRangeList.size() > 0) {
            Rectangle rectangle = graphics.getClipBounds();
            Dimension dimension = this.getSize();
            int n2 = this.m_gxParam.getData().getRowCount();
            int n3 = this.m_gxParam.getData().getColCount();
            graphics.setColor(this.getBackground());
            graphics.setXORMode(this.getSelectionRectColor());
            this.getInsets();
            int n4 = 0;
            int n5 = this.getInsets().top;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            while (n8 < n2 && n5 < dimension.height) {
                n4 = this.getInsets().left;
                n6 = 0;
                if (this.isRowHidden(n8)) {
                    n8 = this.A - 1;
                } else {
                    n7 = this.getRowHeight(n8);
                    if ((n5 += n7) > rectangle.y + rectangle.height) break;
                    if (n5 + n7 >= rectangle.y && n5 <= rectangle.y + rectangle.height) {
                        int n9 = 0;
                        while (n9 < n3 && n4 < dimension.width) {
                            if (this.isColHidden(n9)) {
                                n9 = this.B - 1;
                            } else {
                                n6 = this.getColWidth(n9);
                                if ((n4 += n6) > rectangle.x + rectangle.width) break;
                                if (n4 + n6 >= rectangle.x && n4 <= rectangle.x + rectangle.width && this.isCellBeSelected(n8, n9) && !new GXCell(n8, n9).equals(this.m_gxCurrentCell)) {
                                    graphics.fillRect(n4, n5, n6 - 1, n7 - 1);
                                }
                            }
                            ++n9;
                        }
                    }
                }
                ++n8;
            }
            graphics.setPaintMode();
        }
    }

    public synchronized void onMoveCurControl() {
        Component component = this.getAwtComponent();
        if (component != null) {
            if (this.isVisibleCell(this.getCurrentCell())) {
                Rectangle rectangle = this.calcRectFromRowCol(this.m_gxCurrentCell.row, this.m_gxCurrentCell.col);
                component.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                return;
            }
            component.setLocation(this.getSize().width, this.getSize().height);
            this.setProcessFocusEvent(false);
            this.requestFocus();
            this.setProcessFocusEvent(true);
        }
    }

    public boolean isCellBeSelected(int n2, int n3) {
        return this.m_gxSelectionRange.isValid() && this.m_gxSelectionRange.isCellInRange(n2, n3);
    }

    public boolean onClickedButton(int n2, int n3) {
        return true;
    }

    public boolean onClickedListBox(int n2, int n3) {
        return true;
    }

    public boolean onClickedComboBox(int n2, int n3) {
        return true;
    }

    public boolean onClickedSpinner(int n2, int n3) {
        return true;
    }

    public boolean onMaskEditModified(int n2, int n3) {
        return true;
    }

    public boolean onTextModified(int n2, int n3) {
        return true;
    }

    public boolean onClickedDateField(int n2, int n3) {
        return true;
    }

    public boolean onClickedTimeField(int n2, int n3) {
        return true;
    }

    public boolean onClickedCurrencyField(int n2, int n3) {
        return true;
    }

    public boolean onClickedCheckbox(int n2, int n3) {
        return true;
    }

    public boolean onDoubleClicked(int n2, int n3) {
        this.m_bDoubleClicked = true;
        if (this.m_nCursorType == 10) {
            if (this.getColWidth(n3 - 1) == 0) {
                this.storeColWidth(n3 - 1, this.getDefaultColWidth());
                this.repaint();
            }
        } else if (this.m_nCursorType == 8 && this.getRowHeight(n2 - 1) == 0) {
            this.storeRowHeight(n2 - 1, this.getDefaultRowHeight());
            this.repaint();
        }
        return true;
    }

    public void addGXGridListener(GXGridListener gXGridListener) {
        this.z.addElement(gXGridListener);
    }

    public void removeGXGridListener(GXGridListener gXGridListener) {
        this.z.removeElement(gXGridListener);
    }

    public void processGXGridEvent(GXGridEvent gXGridEvent) {
        GXGridListener[] gXGridListenerArray = new GXGridListener[this.z.size()];
        Vector vector = this.z;
        synchronized (vector) {
            int n2 = 0;
            while (n2 < this.z.size()) {
                gXGridListenerArray[n2] = (GXGridListener)this.z.elementAt(n2);
                ++n2;
            }
        }
        int n3 = 0;
        while (n3 < this.z.size()) {
            gXGridListenerArray[n3].onGXGridEvent(gXGridEvent);
            ++n3;
        }
    }

    public boolean insertCols(int n2, int n3, int[] nArray, int n4, int n5) {
        if (this.storeInsertCols(n2, n3)) {
            if (nArray != null) {
                int n6 = 0;
                while (n6 < n3) {
                    this.storeColWidth(n2 + n6, nArray[n6]);
                    ++n6;
                }
            }
            return true;
        }
        return false;
    }

    public boolean removeCols(int n2, int n3, int n4, int n5) {
        return this.storeRemoveCols(n2, n3);
    }

    public boolean insertRows(int n2, int n3, int[] nArray, int n4, int n5) {
        if (this.storeInsertRows(n2, n3)) {
            if (nArray != null) {
                int n6 = 0;
                while (n6 < n3) {
                    this.storeRowHeight(n2 + n6, nArray[n6]);
                    ++n6;
                }
            }
            return true;
        }
        return false;
    }

    public boolean removeRows(int n2, int n3, int n4, int n5) {
        return this.storeRemoveRows(n2, n3);
    }

    public boolean moveCols(int n2, int n3, int n4, int n5, int n6) {
        return this.storeMoveCols(n2, n3, n4);
    }

    public boolean moveRows(int n2, int n3, int n4, int n5, int n6) {
        return this.storeMoveRows(n2, n3, n4);
    }

    public boolean setFloatCellRowCol(GXRange gXRange, boolean bl, int n2) {
        return true;
    }

    public boolean setMergeCellRowCol(GXRange gXRange, boolean bl, int n2) {
        return true;
    }
}

