/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.factorycast;

import com.schneiderautomation.factorycast.ReadRef;
import com.schneiderautomation.factorycast.ServerChangeEvent;
import com.schneiderautomation.factorycast.ServerChangeListener;
import com.schneiderautomation.factorycast.comm.ClientHandlerInterface;
import com.schneiderautomation.factorycast.comm.FCIOException;
import com.schneiderautomation.factorycast.comm.GetRefRequest;
import com.schneiderautomation.factorycast.comm.GetRefResponse;
import com.schneiderautomation.factorycast.comm.StatusMessages;
import java.io.Serializable;

public abstract class GetRef
extends ReadRef
implements ServerChangeListener,
Serializable {
    static final long serialVersionUID = -1226215606180473093L;
    private transient ClientHandlerInterface server;

    protected GetRef(short s) {
        super(s);
    }

    protected GetRef(ClientHandlerInterface clientHandlerInterface, short s) {
        super(s);
        this.server = clientHandlerInterface;
    }

    public final synchronized void readValues() throws Exception {
        if (this.server == null) {
            System.out.println("GetRef: server == null!");
            return;
        }
        GetRefRequest getRefRequest = new GetRefRequest(this.getAddress(), this.getQuantity(), this.getDatatype(), this.isMultipleRanks());
        GetRefResponse getRefResponse = this.server.getRef(getRefRequest);
        if (getRefResponse.getErrorCode() != 0) {
            throw new FCIOException(StatusMessages.get(getRefResponse.getErrorCode()));
        }
        this.setValueType(getRefResponse.getDatatype());
        this.checkDatatype(this.getValueType());
        this.validateDatatype(this.getValueType());
        this.setValues(getRefResponse.getValues());
        this.fireStatusPropertyChange();
    }

    public void doAction() {
        try {
            this.readValues();
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }

    public synchronized void serverChanged(ServerChangeEvent serverChangeEvent) {
        this.server = serverChangeEvent.getServer();
    }
}

