/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.factorycast;

import com.schneiderautomation.dt.DT;
import com.schneiderautomation.factorycast.GetNumber;
import com.schneiderautomation.factorycast.MonitorRef;
import com.schneiderautomation.factorycast.comm.BadDataTypeException;
import com.schneiderautomation.factorycast.comm.ValueAdaptor;
import java.io.Serializable;

public class MonitorNumber
extends MonitorRef
implements Serializable {
    static final long serialVersionUID = 4081889410360578876L;
    private transient Number[] nValues;

    public MonitorNumber() {
        super((short)0);
    }

    public MonitorNumber(ValueAdaptor valueAdaptor) {
        super(valueAdaptor, (short)0);
    }

    public Number getValue() {
        return this.getValues()[0];
    }

    public Number[] getValues() {
        if (this.nValues == null) {
            return GetNumber.getNumberValues(new short[this.getQuantity()], (short)4);
        }
        return this.nValues;
    }

    public Number getValues(int n) {
        return this.getValues()[n];
    }

    public void setDatatype(short s) {
        super.setDatatype(s);
    }

    protected void fireValuePropertyChange(Object object) {
        Number[] numberArray = this.fInitialUpdate ? null : this.nValues;
        this.nValues = GetNumber.getNumberValues(this.getValueObject(), this.getValueType());
        if (this.nValues != null) {
            if (this.nValues.length == 1) {
                Number number = numberArray != null ? (Number)numberArray[0] : (Number)null;
                this.firePropertyChange("value", number, this.nValues[0]);
            }
            this.firePropertyChange("values", numberArray, this.nValues);
        }
    }

    protected void validateDatatype(short s) throws BadDataTypeException {
        if (s == 9) {
            throw new BadDataTypeException(DT.toName(s));
        }
    }
}

