/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.factorycast;

import com.schneiderautomation.factorycast.ReadRef;
import com.schneiderautomation.factorycast.ServerChangeEvent;
import com.schneiderautomation.factorycast.ServerChangeListener;
import com.schneiderautomation.factorycast.UpdateControl;
import com.schneiderautomation.factorycast.comm.FCIOException;
import com.schneiderautomation.factorycast.comm.GetRefRequest;
import com.schneiderautomation.factorycast.comm.StatusMessages;
import com.schneiderautomation.factorycast.comm.ValueAdaptor;
import com.schneiderautomation.factorycast.comm.ValueChangeEvent;
import java.io.Serializable;

public abstract class MonitorRef
extends ReadRef
implements ServerChangeListener,
Serializable {
    static final long serialVersionUID = 6151484835299385166L;
    private static final String callbackName = "updateValue";
    private static final String OK = new String();
    private UpdateControl updateControl = new UpdateControl();
    private transient ValueAdaptor adaptor;
    private transient int xactID;
    private transient boolean fRegistered;
    private transient boolean fSubscribed;
    private transient String subscribeMsg;
    protected transient boolean fInitialUpdate;

    protected MonitorRef(short s) {
        super(s);
    }

    protected MonitorRef(ValueAdaptor valueAdaptor, short s) {
        super(s);
        this.adaptor = valueAdaptor;
    }

    public boolean isRegistered() {
        return this.fRegistered;
    }

    public boolean isSubscribed() {
        return this.fSubscribed;
    }

    public String getSubscribeStatus() {
        return this.subscribeMsg != null ? this.subscribeMsg : OK;
    }

    public synchronized void setAddress(String string) {
        if (!string.equals(this.getAddress())) {
            super.setAddress(string);
            if (this.fRegistered) {
                this.deregister();
                this.register();
            }
        }
    }

    public synchronized void setQuantity(short s, boolean bl) {
        if (s != this.getQuantity() || bl != this.isMultipleRanks()) {
            super.setQuantity(s, bl);
            if (this.fRegistered) {
                this.deregister();
                this.register();
            }
        }
    }

    public synchronized void register() {
        if (this.adaptor == null) {
            return;
        }
        if (this.fRegistered) {
            return;
        }
        GetRefRequest getRefRequest = new GetRefRequest(this.getAddress(), this.getQuantity(), this.getDatatype(), this.isMultipleRanks());
        this.setRegistered(true);
        this.xactID = this.adaptor.registerEventHandler(this, callbackName, getRefRequest);
    }

    public synchronized void deregister() {
        if (this.adaptor == null) {
            return;
        }
        if (!this.fRegistered) {
            return;
        }
        if (!this.adaptor.deregisterEventHandler(this, callbackName, this.xactID)) {
            System.out.println("MonitorRef.deregister(): Item not found by adaptor!");
        }
        this.setSubscribed(false);
        this.setRegistered(false);
    }

    public synchronized void serverChanged(ServerChangeEvent serverChangeEvent) {
        if (this.fRegistered) {
            this.deregister();
        }
        this.adaptor = serverChangeEvent.getAdaptor();
        if (this.adaptor != null) {
            this.register();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateValue(ValueChangeEvent valueChangeEvent) {
        UpdateControl updateControl = this.updateControl;
        synchronized (updateControl) {
            this.fInitialUpdate = true;
            try {
                int n = valueChangeEvent.getStatus();
                if (n == 65536) {
                    char[] cArray = (char[])valueChangeEvent.getValue();
                    this.setSubscribeStatus(new String(cArray));
                    return;
                }
                if (n == 65537) {
                    this.setSubscribed(false);
                    return;
                }
                if (n == 65539) {
                    this.setSubscribed(true);
                    this.setSubscribeStatus("");
                    return;
                }
                boolean bl = this.fInitialUpdate = valueChangeEvent.getSource() == this.adaptor;
                if (!this.fSubscribed && !this.fInitialUpdate) {
                    return;
                }
                this.setSubscribed(true);
                if (n == 65538) {
                    char[] cArray = (char[])valueChangeEvent.getValue();
                    this.setSubscribeStatus(new String(cArray));
                    return;
                }
                if (n != 0) {
                    this.setSubscribeStatus(StatusMessages.get(n));
                    return;
                }
                try {
                    this.setValueType(valueChangeEvent.getDatatype());
                    this.checkDatatype(this.getValueType());
                    this.validateDatatype(this.getValueType());
                }
                catch (FCIOException fCIOException) {
                    this.setSubscribeStatus(fCIOException.getMessage());
                    return;
                }
                if (!this.getSubscribeStatus().equals(OK)) {
                    this.fInitialUpdate = true;
                }
                this.setValues(valueChangeEvent.getValue());
                this.setSubscribeStatus(OK);
                if (this.fInitialUpdate) {
                    this.fireStatusPropertyChange();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    protected synchronized void setDatatype(short s) {
        if (s != this.getDatatype()) {
            super.setDatatype(s);
            if (this.fRegistered) {
                this.deregister();
                this.register();
            }
        }
    }

    private void setRegistered(boolean bl) {
        Boolean bl2 = new Boolean(this.fRegistered);
        this.fRegistered = bl;
        this.firePropertyChange("registered", bl2, new Boolean(this.fRegistered));
    }

    private void setSubscribed(boolean bl) {
        Boolean bl2 = new Boolean(this.fSubscribed);
        this.fSubscribed = bl;
        this.firePropertyChange("subscribed", bl2, new Boolean(this.fSubscribed));
    }

    private void setSubscribeStatus(String string) {
        String string2 = this.fInitialUpdate ? null : this.subscribeMsg;
        this.subscribeMsg = string;
        this.firePropertyChange("subscribeStatus", string2, this.subscribeMsg);
    }
}

