/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.factorycast;

import com.schneiderautomation.dt.DT;
import com.schneiderautomation.factorycast.Ref;
import com.schneiderautomation.factorycast.ServerChangeEvent;
import com.schneiderautomation.factorycast.ServerChangeListener;
import com.schneiderautomation.factorycast.comm.BadDataTypeException;
import com.schneiderautomation.factorycast.comm.ClientHandlerInterface;
import com.schneiderautomation.factorycast.comm.FCIOException;
import com.schneiderautomation.factorycast.comm.InvalidAccessException;
import com.schneiderautomation.factorycast.comm.InvalidAddressException;
import com.schneiderautomation.factorycast.comm.InvalidSymbolTableException;
import com.schneiderautomation.factorycast.comm.NotFoundException;
import com.schneiderautomation.factorycast.comm.Request;
import com.schneiderautomation.factorycast.comm.SetRefRequest;
import com.schneiderautomation.factorycast.comm.SetRefResponse;
import com.schneiderautomation.factorycast.comm.StatusMessages;
import com.schneiderautomation.factorycast.comm.UtilInterface;
import com.schneiderautomation.namespace.VarLookupInterface;
import com.schneiderautomation.vars.VarInfo;
import java.io.Serializable;

public abstract class SetRef
extends Ref
implements ServerChangeListener,
Serializable {
    static final long serialVersionUID = 2385222702371577736L;
    private transient ClientHandlerInterface server;
    private transient VarLookupInterface varLookupAccess;
    private transient Object valueObj;
    private Number[] values = new Number[]{new Long(0L)};
    String strval;

    protected SetRef(short s) {
        super(s);
    }

    protected SetRef(ClientHandlerInterface clientHandlerInterface, short s) {
        super(s);
        this.server = clientHandlerInterface;
    }

    public short getQuantity() {
        return this.values != null ? (short)this.values.length : (short)0;
    }

    public synchronized void setAddress(String string) {
        this.setValueType((short)0);
        this.clearValueObject();
        super.setAddress(string);
    }

    public void enableAccessChecking(VarLookupInterface varLookupInterface) {
        this.varLookupAccess = varLookupInterface;
    }

    public final synchronized void sendValues() throws Exception {
        if (this.server == null) {
            System.out.println("SetRef: server == null!");
            return;
        }
        this.setValueType();
        this.validateDatatype(this.getValueType());
        SetRefRequest setRefRequest = new SetRefRequest(this.getAddress(), this.getValueType(), this.getQuantity(), this.getValueObject());
        if (this.varLookupAccess != null) {
            this.checkWriteAccess(setRefRequest);
        }
        try {
            SetRefResponse setRefResponse = this.server.setRef(setRefRequest);
            if (setRefResponse.getErrorCode() != 0) {
                throw new FCIOException(StatusMessages.get(setRefResponse.getErrorCode()));
            }
        }
        catch (ClassCastException classCastException) {
            throw new BadDataTypeException(DT.toName(this.getDatatype()));
        }
        this.fireStatusPropertyChange();
    }

    public void doAction() {
        try {
            this.sendValues();
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }

    public synchronized void serverChanged(ServerChangeEvent serverChangeEvent) {
        this.server = serverChangeEvent.getServer();
    }

    protected Number[] getNumberValues() {
        return this.values;
    }

    protected final synchronized void setNumberValue(Number number) {
        this.setNumberValues(new Number[]{number});
    }

    protected final synchronized void setNumberValues(Number[] numberArray) {
        short s = this.getQuantity();
        this.values = numberArray;
        this.clearValueObject();
        this.fireQuantityPropertyChange(new Short(s));
        this.fireValuePropertyChange(null);
    }

    protected final synchronized void setNumberValues(int n, Number number) {
        if (this.values == null) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (!number.equals(this.values[n])) {
            this.values[n] = number;
            this.clearValueObject();
            this.fireValuePropertyChange(null);
        }
    }

    protected void fireQuantityPropertyChange(Object object) {
        this.firePropertyChange("quantity", object, new Short(this.getQuantity()));
    }

    protected synchronized void setDatatype(short s) {
        this.setValueType((short)0);
        this.clearValueObject();
        super.setDatatype(s);
    }

    protected final synchronized Object getValueObject() {
        if (this.valueObj == null) {
            short s = this.getValueType();
            if (s == 0) {
                s = this.getDatatype();
            }
            this.valueObj = SetRefRequest.createValueObject(this.getNumberValues(), s);
        }
        return this.valueObj;
    }

    protected final synchronized void clearValueObject() {
        this.valueObj = null;
    }

    private void setValueType() throws Exception {
        if (this.getValueType() == 0) {
            UtilInterface utilInterface = this.server.getUtil();
            if (utilInterface.isDirectAddress(this.getAddress())) {
                this.setValueType(this.getDatatype());
                if (this.getValueType() == 0) {
                    short[] sArray = utilInterface.getDataTypesFromAddress(this.getAddress());
                    this.setValueType(sArray[0]);
                }
            } else {
                VarLookupInterface varLookupInterface;
                VarLookupInterface varLookupInterface2 = varLookupInterface = this.server.isSymbolTableOK() ? this.server.getVarLookup() : null;
                if (varLookupInterface == null) {
                    throw new InvalidSymbolTableException();
                }
                VarInfo varInfo = varLookupInterface.get(this.getAddress());
                if (varInfo == null) {
                    throw new NotFoundException(this.getAddress());
                }
                short s = DT.getNumericDataType(varInfo.getDataType());
                this.checkDatatype(s);
                if (this.server.isDebugModeEnabled()) {
                    throw new InvalidAccessException(this.getAddress());
                }
                this.setValueType(s);
            }
            if (this.getValueType() == 0) {
                throw new InvalidAddressException(this.getAddress());
            }
            this.clearValueObject();
        }
    }

    private void checkWriteAccess(Request request) throws Exception {
        UtilInterface utilInterface = this.server.getUtil();
        if (utilInterface.isDirectAddress(request.getAddress())) {
            int n = DT.getNumRefs(request.getDatatype());
            String string = utilInterface.normalizeAddress(request.getAddress());
            if (this.varLookupAccess.isReadOnly(string, request.getQuantity() * n)) {
                String[] stringArray = utilInterface.getAddressSeries(request.getAddress(), request.getDatatype(), request.getQuantity());
                StringBuffer stringBuffer = new StringBuffer(stringArray[0]);
                if (stringArray.length > 1) {
                    stringBuffer.append(" - " + stringArray[stringArray.length - 1]);
                }
                throw new InvalidAccessException(stringBuffer.toString());
            }
        } else {
            VarInfo varInfo = this.varLookupAccess.get(request.getAddress());
            if (varInfo != null && varInfo.isReadOnly()) {
                throw new InvalidAccessException(request.getAddress());
            }
        }
    }
}

