/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.factorycast.comm;

import com.schneiderautomation.factorycast.comm.ClientUpdateInterface;
import com.schneiderautomation.factorycast.comm.CommUpdateInterface;
import com.schneiderautomation.factorycast.comm.GetRefRequest;
import com.schneiderautomation.factorycast.comm.GetRefResponse;
import com.schneiderautomation.factorycast.comm.RefXact;
import com.schneiderautomation.factorycast.comm.SuspendControl;
import com.schneiderautomation.factorycast.comm.UpdateRequest;
import com.schneiderautomation.misc.GlobalConfig;
import java.util.Vector;

public class SubscriptionList
implements Runnable {
    private CommUpdateInterface server;
    private ClientUpdateInterface client;
    private Thread engine = null;
    private SuspendControl suspend = new SuspendControl();
    private int pollingDelay = GlobalConfig.MIN_POLLING_DELAY;
    private RefXact head = null;
    private RefXact tail = null;
    private RefXact current = null;
    private int m_nbPlcReq = 0;

    SubscriptionList(CommUpdateInterface commUpdateInterface, ClientUpdateInterface clientUpdateInterface) {
        this.server = commUpdateInterface;
        this.client = clientUpdateInterface;
    }

    public void run() {
        while (this.engine != null) {
            int n;
            if (this.m_nbPlcReq <= 1) {
                n = this.pollingDelay;
            } else {
                n = this.pollingDelay / this.m_nbPlcReq;
                if (n < GlobalConfig.MIN_POLLING_DELAY) {
                    n = GlobalConfig.MIN_POLLING_DELAY;
                }
            }
            try {
                Thread.sleep(n);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.suspend.waitUntilResume();
            this.processXact(this.getNext());
        }
    }

    void setPollingDelay(int n) {
        this.pollingDelay = Math.min(Math.max(n, GlobalConfig.MIN_POLLING_DELAY), GlobalConfig.MAX_POLLING_DELAY);
    }

    int getPollingDelay() {
        return this.pollingDelay;
    }

    synchronized void startProcessing() {
        if (this.engine == null) {
            this.engine = new Thread(this);
            this.engine.start();
            this.suspend.resume();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopProcessing(boolean bl) {
        Thread thread;
        SubscriptionList subscriptionList = this;
        synchronized (subscriptionList) {
            thread = this.engine;
            this.engine = null;
            this.notify();
            this.suspend.resume();
            if (bl) {
                this.removeAll();
            }
        }
        if (thread != null) {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    synchronized void suspendProcessing() {
        this.suspend.suspend();
    }

    synchronized void resumeProcessing() {
        this.suspend.resume();
    }

    synchronized GetRefResponse add(GetRefRequest getRefRequest) throws Exception {
        GetRefRequest[] getRefRequestArray = new GetRefRequest[]{getRefRequest};
        GetRefResponse[] getRefResponseArray = this.addList(getRefRequestArray);
        return getRefResponseArray.length > 0 ? getRefResponseArray[0] : null;
    }

    synchronized GetRefResponse[] addList(GetRefRequest[] getRefRequestArray) throws Exception {
        int n;
        if (this.engine == null) {
            return new GetRefResponse[0];
        }
        Vector vector = this.server.createRequests(getRefRequestArray);
        this.m_nbPlcReq = vector.size();
        System.out.println("SAComm optimized " + this.m_nbPlcReq + "PLC requests");
        RefXact[] refXactArray = new RefXact[this.m_nbPlcReq];
        UpdateRequest[] updateRequestArray = new UpdateRequest[this.m_nbPlcReq];
        int n2 = 0;
        for (int i = 0; i < updateRequestArray.length; ++i) {
            updateRequestArray[i] = (UpdateRequest)vector.elementAt(i);
            n2 += updateRequestArray[i].getRequests().length;
        }
        GetRefResponse[] getRefResponseArray = new GetRefResponse[n2];
        int n3 = 0;
        for (n = 0; n < refXactArray.length; ++n) {
            GetRefResponse[] getRefResponseArray2;
            try {
                getRefResponseArray2 = this.server.getRefs(updateRequestArray[n]);
            }
            catch (Exception exception) {
                String string = exception.getMessage();
                GetRefRequest[] getRefRequestArray2 = updateRequestArray[n].getRequests();
                getRefResponseArray2 = new GetRefResponse[getRefRequestArray2.length];
                for (int i = 0; i < getRefRequestArray2.length; ++i) {
                    getRefResponseArray2[i] = SubscriptionList.createErrorResponse(getRefRequestArray2[i].getXactID(), string, 65538);
                }
            }
            refXactArray[n] = new RefXact(updateRequestArray[n], getRefResponseArray2);
            System.arraycopy(getRefResponseArray2, 0, getRefResponseArray, n3, getRefResponseArray2.length);
            n3 += getRefResponseArray2.length;
        }
        for (n = 0; n < refXactArray.length; ++n) {
            if (this.head == null) {
                this.head = refXactArray[n];
            } else {
                this.tail.next = refXactArray[n];
            }
            this.tail = refXactArray[n];
        }
        this.notify();
        return getRefResponseArray;
    }

    synchronized boolean remove(int n) {
        RefXact refXact = null;
        RefXact refXact2 = this.head;
        while (refXact2 != null) {
            GetRefRequest[] getRefRequestArray = refXact2.request.getRequests();
            for (int i = 0; i < getRefRequestArray.length; ++i) {
                if (getRefRequestArray[i].getXactID() != n) continue;
                getRefRequestArray[i].setXactID(0);
                this.client.purgeValue(n);
                --refXact2.nActive;
                if (refXact2.nActive == 0) {
                    if (refXact != null) {
                        refXact.next = refXact2.next;
                    } else {
                        this.head = refXact2.next;
                    }
                    if (refXact2 == this.tail) {
                        this.tail = refXact;
                    }
                    if (refXact2 == this.current) {
                        this.current = refXact;
                    }
                }
                return true;
            }
            refXact = refXact2;
            refXact2 = refXact2.next;
        }
        return false;
    }

    synchronized void removeAll() {
        this.head = null;
        this.tail = null;
        this.current = null;
    }

    private synchronized RefXact getNext() {
        while (this.head == null && this.engine != null) {
            try {
                this.wait();
            }
            catch (Exception exception) {}
        }
        this.current = this.current == null ? this.head : (this.current.next == null ? this.head : this.current.next);
        return this.current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processXact(RefXact refXact) {
        GetRefResponse[] getRefResponseArray = this;
        synchronized (this) {
            if (this.engine == null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            try {
                getRefResponseArray = this.server.getRefs(refXact.request);
            }
            catch (Exception exception) {
                String string = exception.getMessage();
                getRefResponseArray = new GetRefResponse[refXact.response.length];
                for (int i = 0; i < getRefResponseArray.length; ++i) {
                    getRefResponseArray[i] = SubscriptionList.createErrorResponse(refXact.response[i].getXactID(), string, 65538);
                }
            }
            GetRefRequest[] getRefRequestArray = refXact.request.getRequests();
            for (int i = 0; i < getRefResponseArray.length; ++i) {
                if (getRefRequestArray[i].getXactID() == 0 || getRefResponseArray[i].equals(refXact.response[i])) continue;
                this.client.updateValue(getRefResponseArray[i].copy());
            }
            refXact.response = getRefResponseArray;
            return;
        }
    }

    public static GetRefResponse createErrorResponse(int n, String string, int n2) {
        return new GetRefResponse(n, string, n2);
    }
}

