/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.factorycast.comm.umas;

import com.schneiderautomation.dt.DT;
import com.schneiderautomation.factorycast.comm.AlarmObject;
import com.schneiderautomation.factorycast.comm.FCIOException;
import com.schneiderautomation.factorycast.comm.GetRefRequest;
import com.schneiderautomation.factorycast.comm.GetRefResponse;
import com.schneiderautomation.factorycast.comm.InvalidAccessException;
import com.schneiderautomation.factorycast.comm.InvalidAddressException;
import com.schneiderautomation.factorycast.comm.N_mmi;
import com.schneiderautomation.factorycast.comm.Request;
import com.schneiderautomation.factorycast.comm.ResultReadNextError;
import com.schneiderautomation.factorycast.comm.ServerHandlerInterface;
import com.schneiderautomation.factorycast.comm.SetRefRequest;
import com.schneiderautomation.factorycast.comm.SetRefResponse;
import com.schneiderautomation.factorycast.comm.StatusMessages;
import com.schneiderautomation.factorycast.comm.SubscriptionList;
import com.schneiderautomation.factorycast.comm.UnsupportedDataTypeException;
import com.schneiderautomation.factorycast.comm.UpdateRequest;
import com.schneiderautomation.factorycast.comm.UtilInterface;
import com.schneiderautomation.factorycast.comm.umas.AddressUMAS;
import com.schneiderautomation.factorycast.comm.umas.Extension;
import com.schneiderautomation.factorycast.comm.umas.IllegalReferenceTypeException;
import com.schneiderautomation.factorycast.comm.umas.MBAPReadException;
import com.schneiderautomation.factorycast.comm.umas.PlcInfo;
import com.schneiderautomation.factorycast.comm.umas.ProgInfoUMAS;
import com.schneiderautomation.factorycast.comm.umas.UpdateOptimizerBOL;
import com.schneiderautomation.factorycast.comm.umas.UpdateOptimizerSTD;
import com.schneiderautomation.factorycast.comm.umas.UpdateRequestUMAS;
import com.schneiderautomation.factorycast.comm.umas.Util;
import com.schneiderautomation.namespace.NameSpace;
import java.io.IOException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Vector;

public class ClientHandler
extends com.schneiderautomation.factorycast.comm.xbf.ClientHandler
implements UtilInterface {
    private static final int MBAP_HDRSIZE = 6;
    private static final int MAX_MSGSIZE = 272;
    private static final byte UMAS_GET_APPL_INFO = 3;
    private static final byte UMAS_GET_PLC_STATUS = 4;
    private static final byte UMAS_READ_BOL = 34;
    private static final byte UMAS_WRITE_BOL = 35;
    private static final byte UMAS_READ_VAR_LIST = 36;
    private static final byte UMAS_WRITE_VAR_LIST = 37;
    private static final byte UMAS_READ_IO_OBJECT = 112;
    private static final byte UMAS_DIAG = 88;
    private static final byte UMAS_DIAG_LOGON = 1;
    private static final byte UMAS_DIAG_LOGOUT = 2;
    private static final byte UMAS_DIAG_ACK = 3;
    private static final byte UMAS_DIAG_READ_NEXT = 7;
    public static final short RESULT_NEXT_ERROR_NOTHING = 0;
    public static final short RESULT_NEXT_ERROR_MODIFIED = 1;
    public static final short RESULT_NEXT_ERROR_NEW = 2;
    public static final short RESULT_NEXT_ERROR_TRUNCATED = 3;
    public static final short RESULT_NEXT_ERROR_RESET = 4;
    private final byte protocolID = (byte)this.getProtocolId();
    private final byte[] request = new byte[278];
    private final byte[] respHdr = new byte[6];
    private final byte[] respData = new byte[272];
    private int msglen;
    private int resplen;
    private boolean fUMASSupported;
    private boolean fUMASChecked;
    private UtilInterface umasUtil = new Util();
    private UtilInterface xbfUtil = super.getUtil();

    public ClientHandler(ServerHandlerInterface serverHandlerInterface) {
        super(serverHandlerInterface, null);
    }

    public void connect(String string, boolean bl) throws Exception {
        super.connect(string, bl);
        this.checkForUMAS();
    }

    public void disconnect() {
        super.disconnect();
        this.fUMASSupported = false;
        this.fUMASChecked = false;
    }

    public SetRefResponse setRef(SetRefRequest setRefRequest) throws Exception {
        if (this.fUMASSupported && this.isUMASRequest(setRefRequest)) {
            return this.setRef(setRefRequest, AddressUMAS.parse(setRefRequest, this.isSymbolTableOK() ? this.varLookup : null));
        }
        return super.setRef(setRefRequest);
    }

    public GetRefResponse getRef(GetRefRequest getRefRequest) throws Exception {
        if (this.fUMASSupported && this.isUMASRequest(getRefRequest)) {
            return this.getRef(getRefRequest, AddressUMAS.parse(getRefRequest, this.isSymbolTableOK() ? this.varLookup : null));
        }
        return super.getRef(getRefRequest);
    }

    public Vector createRequests(GetRefRequest[] getRefRequestArray) throws Exception {
        if (this.fUMASSupported) {
            Vector<GetRefRequest> vector = new Vector<GetRefRequest>(getRefRequestArray.length);
            Vector<GetRefRequest> vector2 = new Vector<GetRefRequest>(getRefRequestArray.length);
            for (int i = 0; i < getRefRequestArray.length; ++i) {
                if (this.isUMASRequest(getRefRequestArray[i])) {
                    vector2.addElement(getRefRequestArray[i]);
                    continue;
                }
                vector.addElement(getRefRequestArray[i]);
            }
            if (vector.isEmpty()) {
                return this.createRequestsUMAS(getRefRequestArray);
            }
            if (!vector2.isEmpty()) {
                Object[] objectArray = new GetRefRequest[vector.size()];
                vector.copyInto(objectArray);
                Vector vector3 = super.createRequests((GetRefRequest[])objectArray);
                objectArray = new GetRefRequest[vector2.size()];
                vector2.copyInto(objectArray);
                Vector vector4 = this.createRequestsUMAS((GetRefRequest[])objectArray);
                if (vector3.size() > vector4.size()) {
                    int n = vector4.size();
                    for (int i = 0; i < n; ++i) {
                        vector3.addElement(vector4.elementAt(i));
                    }
                    return vector3;
                }
                int n = vector3.size();
                for (int i = 0; i < n; ++i) {
                    vector4.addElement(vector3.elementAt(i));
                }
                return vector4;
            }
        }
        return super.createRequests(getRefRequestArray);
    }

    public GetRefResponse[] getRefs(UpdateRequest updateRequest) throws Exception {
        if (updateRequest instanceof UpdateRequestUMAS) {
            return this.getRefs((UpdateRequestUMAS)updateRequest);
        }
        return super.getRefs(updateRequest);
    }

    public Object getExtension(Class clazz) {
        if (this.fUMASSupported) {
            String[] stringArray = new String[]{"com.schneiderautomation.factorycast.comm.xbf.PremiumIOInterface", "com.schneiderautomation.factorycast.comm.umas.PlcInfoInterface"};
            String[] stringArray2 = new String[]{"com.schneiderautomation.factorycast.comm.umas.pbf.PremiumIO", "com.schneiderautomation.factorycast.comm.umas.PlcInfo"};
            String string = clazz.getName();
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string.equals(stringArray[i])) continue;
                try {
                    Extension extension = (Extension)Class.forName(stringArray2[i]).newInstance();
                    extension.server = this;
                    return extension;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return null;
                }
            }
        }
        return super.getExtension(clazz);
    }

    public UtilInterface getUtil() {
        return this;
    }

    public boolean isUMASSupported() {
        return this.fUMASSupported;
    }

    public short logonDiagBuffer(byte[] byArray, N_mmi n_mmi) throws Exception {
        if (this.fUMASSupported) {
            this.startRequest((byte)88);
            this.mapByte((short)1);
            this.mapWord(0);
            this.mapWord(0);
            this.mapByte(byArray[1]);
            this.mapByte(byArray[0]);
            int n = this.processRequest();
            if (n != 0) {
                throw new FCIOException(StatusMessages.get(n));
            }
            short s = this.unmapWord();
            n_mmi.setN_mmi(s);
            return 0;
        }
        return super.logonDiagBuffer(byArray, n_mmi);
    }

    public short logoutDiagBuffer(N_mmi n_mmi) throws Exception {
        if (this.fUMASSupported) {
            this.startRequest((byte)88);
            this.mapByte((short)2);
            this.mapWord(n_mmi.getN_mmi());
            this.mapWord(0);
            this.mapWord(0);
            int n = this.processRequest();
            if (n != 0) {
                throw new FCIOException(StatusMessages.get(n));
            }
            return 0;
        }
        return super.logoutDiagBuffer(n_mmi);
    }

    public boolean readNextErrorDiagBuffer(N_mmi n_mmi, AlarmObject alarmObject, ResultReadNextError resultReadNextError) throws Exception {
        if (this.fUMASSupported) {
            this.startRequest((byte)88);
            this.mapByte((short)7);
            this.mapWord(n_mmi.getN_mmi());
            this.mapWord(0);
            this.mapWord(0);
            int n = this.processRequest();
            if (n != 0) {
                throw new FCIOException(StatusMessages.get(n));
            }
            boolean bl = false;
            this.msglen += 3;
            byte by = (byte)this.unmapByteUnsigned();
            resultReadNextError.setResult(by);
            if (by > 0) {
                if (by == 3) {
                    System.out.println("Read Next Error response truncated");
                } else if (by == 4) {
                    System.out.println("Read Next Error response reset");
                }
                int n2 = 0;
                n2 = this.unmapWordUnsigned();
                alarmObject.SetNumber(n2);
                int n3 = 0;
                n3 = this.unmapWordUnsigned();
                alarmObject.SetIndex_Number(n3);
                byte by2 = this.respData[this.msglen++];
                alarmObject.SetClass(by2);
                ++this.msglen;
                int n4 = 0;
                int n5 = 0;
                byte[] byArray = new byte[]{this.respData[this.msglen++], this.respData[this.msglen++], this.respData[this.msglen++], this.respData[this.msglen++]};
                switch (by2 & 0xC0) {
                    case 0: {
                        n4 = byArray[3];
                        n4 = (n4 << 8) + byArray[2];
                        n4 = (n4 << 8) + byArray[1];
                        n4 = (n4 << 8) + byArray[0];
                        break;
                    }
                    case 64: {
                        n5 = byArray[3];
                        n5 = (n5 << 8) + byArray[2];
                        n5 = (n5 << 8) + byArray[1];
                        n5 = (n5 << 8) + byArray[0];
                    }
                }
                alarmObject.SetXi_t(n4);
                alarmObject.SetFirst_status(n5);
                byte[] byArray2 = new byte[]{this.respData[this.msglen++], this.respData[this.msglen++], this.respData[this.msglen++], this.respData[this.msglen++]};
                alarmObject.SetDate_start(byArray2);
                byte[] byArray3 = new byte[]{this.respData[this.msglen++], this.respData[this.msglen++], this.respData[this.msglen++], this.respData[this.msglen++]};
                alarmObject.SetDate_end(byArray3);
                this.msglen += 4;
                byte by3 = this.respData[this.msglen++];
                alarmObject.SetStatus(by3);
                if ((by3 & 0x10) == 16) {
                    resultReadNextError.setResult((byte)2);
                } else {
                    resultReadNextError.setResult((byte)1);
                }
                byte by4 = this.respData[this.msglen++];
                alarmObject.SetZone(by4);
                ++this.msglen;
                byte by5 = this.respData[this.msglen++];
                String string = null;
                byte by6 = 0;
                switch (by2 & 0xC0) {
                    case 0: {
                        by6 = this.respData[this.msglen++];
                        string = new String(this.respData, this.msglen, (int)by6);
                        this.msglen += by6;
                        alarmObject.SetComment(string);
                        by6 = this.respData[this.msglen++];
                        String string2 = new String(this.respData, this.msglen, (int)by6);
                        this.msglen += by6;
                        alarmObject.setSFCStepName(string2);
                        by6 = this.respData[this.msglen++];
                        String string3 = new String(this.respData, this.msglen, (int)by6);
                        this.msglen += by6;
                        alarmObject.setSFCTransitionName(string3);
                        byte[] byArray4 = new byte[]{this.respData[this.msglen++], this.respData[this.msglen++]};
                        short s = byArray4[1];
                        s = (short)((s << 8) + byArray4[0]);
                        alarmObject.SetReference_time_gr7(s);
                        break;
                    }
                    case 64: 
                    case 128: {
                        by6 = this.respData[this.msglen++];
                        string = new String(this.respData, this.msglen, (int)by6);
                        this.msglen += by6;
                        alarmObject.SetComment(string);
                        by6 = this.respData[this.msglen++];
                        String string4 = new String(this.respData, this.msglen, (int)by6);
                        this.msglen += by6;
                        alarmObject.SetInstanceName(string4);
                    }
                }
            }
            bl = true;
            return bl;
        }
        return super.readNextErrorDiagBuffer(n_mmi, alarmObject, resultReadNextError);
    }

    public boolean ackErrorDiagBuffer(N_mmi n_mmi, int n) throws Exception {
        if (this.fUMASSupported) {
            this.startRequest((byte)88);
            this.mapByte((short)3);
            this.mapWord(n_mmi.getN_mmi());
            this.mapWord(n);
            this.mapWord(0);
            int n2 = this.processRequest();
            if (n2 != 0) {
                throw new FCIOException(StatusMessages.get(n2));
            }
            return true;
        }
        return super.ackErrorDiagBuffer(n_mmi, n);
    }

    protected synchronized Object readVerInfo() throws Exception {
        this.checkForUMAS();
        if (this.fUMASSupported) {
            this.startRequest((byte)3);
            this.mapByte((short)0);
            int n = this.processRequest();
            if (n != 0) {
                throw new FCIOException(StatusMessages.get(n));
            }
            this.msglen += 9;
            this.msglen += 9;
            short s = this.unmapByteUnsigned();
            short s2 = this.unmapByteUnsigned();
            short s3 = this.unmapByteUnsigned();
            short s4 = this.unmapByteUnsigned();
            short s5 = this.unmapByteUnsigned();
            short s6 = this.unmapByteUnsigned();
            int n2 = this.unmapWordUnsigned();
            short s7 = this.unmapByteUnsigned();
            short s8 = this.unmapByteUnsigned();
            short s9 = this.unmapByteUnsigned();
            short s10 = this.unmapByteUnsigned();
            short s11 = this.unmapByteUnsigned();
            short s12 = this.unmapByteUnsigned();
            int n3 = this.unmapWordUnsigned();
            int n4 = this.unmapDWord() & Integer.MAX_VALUE;
            short s13 = this.unmapByteUnsigned();
            byte[] byArray = new byte[s13];
            this.unmapBytes(byArray, 0, s13);
            int n5 = 0;
            while (byArray[n5] != 0) {
                ++n5;
            }
            String string = new String(byArray, 0, n5);
            int n6 = n4 >> 24;
            int n7 = n4 >> 16 & 0xFF;
            int n8 = n4 & 0xFFFF;
            String string2 = n6 + "." + n7 + "." + n8;
            Date date = new GregorianCalendar(n2, s6 - 1, s5, s4, s3, s2).getTime();
            Date date2 = new GregorianCalendar(n3, s12 - 1, s11, s10, s9, s8).getTime();
            this.startRequest((byte)4);
            n = this.processRequest();
            if (n != 0) {
                throw new FCIOException(StatusMessages.get(n));
            }
            short s14 = this.unmapByteUnsigned();
            int n9 = this.unmapWordUnsigned();
            byte by = this.unmapByte();
            int n10 = this.unmapDWord();
            int n11 = this.unmapDWord();
            int n12 = this.unmapDWord();
            int n13 = this.unmapDWord();
            int n14 = this.unmapDWord();
            return new ProgInfoUMAS(string, string2, date, date2, n10, n11, n12, n13, n14);
        }
        return super.readVerInfo();
    }

    public short[] getDataTypesFromAddress(String string) throws Exception {
        if (this.fUMASSupported && this.isUMASRequest(string)) {
            return this.umasUtil.getDataTypesFromAddress(string);
        }
        return this.xbfUtil.getDataTypesFromAddress(string);
    }

    public String[] getAddressSeries(String string, short s, int n) throws Exception {
        if (this.fUMASSupported && this.isUMASRequest(string)) {
            return this.umasUtil.getAddressSeries(string, s, n);
        }
        return this.xbfUtil.getAddressSeries(string, s, n);
    }

    public boolean isDirectAddress(String string) throws Exception {
        if (this.fUMASSupported && this.isUMASRequest(string)) {
            return this.umasUtil.isDirectAddress(string);
        }
        return this.xbfUtil.isDirectAddress(string);
    }

    public String normalizeAddress(String string) throws Exception {
        if (this.fUMASSupported && this.isUMASRequest(string)) {
            return this.umasUtil.normalizeAddress(string);
        }
        return this.xbfUtil.normalizeAddress(string);
    }

    void startRequest(byte by) {
        this.msglen = 0;
        this.request[this.msglen++] = 0;
        this.request[this.msglen++] = 0;
        this.request[this.msglen++] = 0;
        this.request[this.msglen++] = this.protocolID;
        this.request[this.msglen++] = 0;
        this.request[this.msglen++] = 0;
        this.request[this.msglen++] = 0;
        if (this.protocolID == 1) {
            this.msglen += this.mapXWAY(this.request, this.msglen);
            this.request[this.msglen++] = -7;
            this.request[this.msglen++] = 0;
        }
        this.request[this.msglen++] = 90;
        this.request[this.msglen++] = 0;
        this.request[this.msglen++] = by;
    }

    synchronized int processRequest() throws IOException, FCIOException {
        int n;
        int n2 = this.msglen - 6;
        this.request[4] = (byte)(n2 >> 8);
        this.request[5] = (byte)n2;
        try {
            this.output.write(this.request, 0, this.msglen);
            n = this.input.read(this.respHdr);
            if (n != this.respHdr.length) {
                if (n == -1) {
                    throw new MBAPReadException("EOFMBAP");
                }
                throw new MBAPReadException("IncompleteMBAP");
            }
            this.resplen = (this.respHdr[4] << 8 | this.respHdr[5] & 0xFF) & 0xFFFF;
            n = this.input.read(this.respData, 0, this.resplen);
            if (n != this.resplen) {
                if (n == -1) {
                    throw new MBAPReadException("EOFUMAS");
                }
                throw new MBAPReadException("IncompleteUMAS");
            }
        }
        catch (IOException iOException) {
            System.out.println("IOException processing UMAS transaction: " + iOException.getMessage());
            System.out.println("Resetting connection to PLC!");
            this.reset();
            throw iOException;
        }
        catch (FCIOException fCIOException) {
            System.out.println("FCIOException processing UMAS transaction: " + fCIOException.getMessage());
            System.out.println("Resetting connection to PLC!");
            this.reset();
            throw fCIOException;
        }
        this.msglen = 1;
        if (this.protocolID == 1) {
            this.msglen = this.unmapXWAY(this.respData, this.msglen);
            this.msglen += 2;
        }
        this.msglen += 2;
        if (this.msglen >= this.resplen) {
            throw new MBAPReadException("IncompleteUMAS");
        }
        if ((n = this.respData[this.msglen++] & 0xFF) == 253) {
            byte by;
            if ((by = this.respData[this.msglen++]) == 0) {
                throw new FCIOException("Illegal UMAS error code of zero received");
            }
            if (by == 139) {
                final byte[] byArray = this.request;
                final int n3 = this.msglen;
                new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            ClientHandler clientHandler = ClientHandler.this;
                            synchronized (clientHandler) {
                                Thread.sleep(5000L);
                                ClientHandler.this.msglen = n3;
                                for (int i = 0; i < ClientHandler.this.request.length; ++i) {
                                    ((ClientHandler)ClientHandler.this).request[i] = byArray[i];
                                }
                                try {
                                    ClientHandler.this.processRequest();
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                        }
                    }
                }.start();
            }
            return -(by & 0xFF);
        }
        if (n != 254) {
            throw new FCIOException("Illegal UMAS response code " + n + " received");
        }
        return 0;
    }

    final void mapByte(short s) {
        this.request[this.msglen++] = (byte)s;
    }

    final void mapWord(int n) {
        this.request[this.msglen++] = (byte)n;
        this.request[this.msglen++] = (byte)(n >> 8);
    }

    final void mapDWord(long l) {
        this.request[this.msglen++] = (byte)l;
        this.request[this.msglen++] = (byte)(l >> 8);
        this.request[this.msglen++] = (byte)(l >> 16);
        this.request[this.msglen++] = (byte)(l >> 24);
    }

    final void mapLWord(long l) {
        this.request[this.msglen++] = (byte)l;
        this.request[this.msglen++] = (byte)(l >> 8);
        this.request[this.msglen++] = (byte)(l >> 16);
        this.request[this.msglen++] = (byte)(l >> 24);
        this.request[this.msglen++] = (byte)(l >> 32);
        this.request[this.msglen++] = (byte)(l >> 40);
        this.request[this.msglen++] = (byte)(l >> 48);
        this.request[this.msglen++] = (byte)(l >> 56);
    }

    final void mapFloat(float f) {
        this.mapDWord(Float.floatToIntBits(f));
    }

    final void mapBytes(byte[] byArray, int n, int n2) {
        System.arraycopy(byArray, n, this.request, this.msglen, n2);
        this.msglen += n2;
    }

    final void mapBytes(short[] sArray, int n, int n2) {
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            this.mapByte(sArray[i]);
        }
    }

    final void mapWords(short[] sArray, int n, int n2) {
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            this.mapWord(sArray[i]);
        }
    }

    final void mapWords(int[] nArray, int n, int n2) {
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            this.mapWord(nArray[i]);
        }
    }

    final void mapDWords(int[] nArray, int n, int n2) {
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            this.mapDWord(nArray[i]);
        }
    }

    final void mapDWords(long[] lArray, int n, int n2) {
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            this.mapDWord(lArray[i]);
        }
    }

    final void mapLWords(long[] lArray, int n, int n2) {
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            this.mapLWord(lArray[i]);
        }
    }

    final void mapFloats(float[] fArray, int n, int n2) {
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            this.mapFloat(fArray[i]);
        }
    }

    final byte unmapByte() {
        return this.respData[this.msglen++];
    }

    final short unmapByteUnsigned() {
        return (short)(this.respData[this.msglen++] & 0xFF);
    }

    final short unmapWord() {
        short s = (short)(this.respData[this.msglen + 1] << 8 | this.respData[this.msglen] & 0xFF);
        this.msglen += 2;
        return s;
    }

    final int unmapWordUnsigned() {
        int n = (this.respData[this.msglen + 1] & 0xFF) << 8 | this.respData[this.msglen] & 0xFF;
        this.msglen += 2;
        return n;
    }

    final int unmapDWord() {
        int n = this.respData[this.msglen + 3] << 24 | (this.respData[this.msglen + 2] & 0xFF) << 16 | (this.respData[this.msglen + 1] & 0xFF) << 8 | this.respData[this.msglen] & 0xFF;
        this.msglen += 4;
        return n;
    }

    final long unmapDWordUnsigned() {
        long l = ((long)this.respData[this.msglen + 3] & 0xFFL) << 24 | ((long)this.respData[this.msglen + 2] & 0xFFL) << 16 | ((long)this.respData[this.msglen + 1] & 0xFFL) << 8 | (long)this.respData[this.msglen] & 0xFFL;
        this.msglen += 4;
        return l;
    }

    final long unmapLWord() {
        long l = (long)this.respData[this.msglen + 7] << 56 | ((long)this.respData[this.msglen + 6] & 0xFFL) << 48 | ((long)this.respData[this.msglen + 5] & 0xFFL) << 40 | ((long)this.respData[this.msglen + 4] & 0xFFL) << 32 | ((long)this.respData[this.msglen + 3] & 0xFFL) << 24 | ((long)this.respData[this.msglen + 2] & 0xFFL) << 16 | ((long)this.respData[this.msglen + 1] & 0xFFL) << 8 | (long)this.respData[this.msglen] & 0xFFL;
        this.msglen += 8;
        return l;
    }

    final float unmapFloat() {
        return Float.intBitsToFloat(this.unmapDWord());
    }

    final void unmapBytes(byte[] byArray, int n, int n2) {
        System.arraycopy(this.respData, this.msglen, byArray, n, n2);
        this.msglen += n2;
    }

    final void unmapBytesUnsigned(short[] sArray, int n, int n2) {
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            sArray[i] = this.unmapByteUnsigned();
        }
    }

    final void unmapWords(short[] sArray, int n, int n2) {
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            sArray[i] = this.unmapWord();
        }
    }

    final void unmapWordsUnsigned(int[] nArray, int n, int n2) {
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            nArray[i] = this.unmapWordUnsigned();
        }
    }

    final void unmapDWords(int[] nArray, int n, int n2) {
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            nArray[i] = this.unmapDWord();
        }
    }

    final void unmapDWordsUnsigned(long[] lArray, int n, int n2) {
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            lArray[i] = this.unmapDWordUnsigned();
        }
    }

    final void unmapLWords(long[] lArray, int n, int n2) {
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            lArray[i] = this.unmapLWord();
        }
    }

    final void unmapFloats(float[] fArray, int n, int n2) {
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            fArray[i] = this.unmapFloat();
        }
    }

    private boolean isUMASRequest(Request request) {
        return this.isUMASRequest(request.getAddress());
    }

    private boolean isUMASRequest(String string) {
        try {
            return this.umasUtil.isDirectAddress(string) || !this.xbfUtil.isDirectAddress(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private synchronized void checkForUMAS() {
        if (!this.fUMASChecked) {
            this.fUMASChecked = true;
            this.fUMASSupported = false;
            try {
                new PlcInfo(this).getPlcInfo();
                this.fUMASSupported = true;
                System.out.println("PLC is UNITY");
            }
            catch (Exception exception) {
                System.out.println("PLC is not UNITY");
            }
        }
    }

    private Vector createRequestsUMAS(GetRefRequest[] getRefRequestArray) throws Exception {
        int n;
        Vector<UpdateRequestUMAS> vector = new Vector<UpdateRequestUMAS>();
        UpdateOptimizerBOL updateOptimizerBOL = new UpdateOptimizerBOL();
        UpdateOptimizerSTD updateOptimizerSTD = new UpdateOptimizerSTD();
        NameSpace nameSpace = this.isSymbolTableOK() ? this.varLookup : null;
        block6: for (int i = 0; i < getRefRequestArray.length; ++i) {
            AddressUMAS addressUMAS;
            try {
                addressUMAS = AddressUMAS.parse(getRefRequestArray[i], nameSpace);
            }
            catch (FCIOException fCIOException) {
                this.client.valueChanged(SubscriptionList.createErrorResponse(getRefRequestArray[i].getXactID(), fCIOException.getMessage(), 65536));
                continue;
            }
            UpdateRequestUMAS updateRequestUMAS = new UpdateRequestUMAS(getRefRequestArray[i], addressUMAS);
            switch (addressUMAS.getAddressType()) {
                case 0: {
                    updateOptimizerSTD.addElement(updateRequestUMAS);
                    continue block6;
                }
                case 2: {
                    if (addressUMAS.getDataType() != 9) {
                        updateOptimizerBOL.addElement(updateRequestUMAS);
                        continue block6;
                    }
                }
                default: {
                    vector.addElement(updateRequestUMAS);
                }
            }
        }
        Vector vector2 = updateOptimizerBOL.optimize();
        int n2 = vector2.size();
        for (n = 0; n < n2; ++n) {
            vector.addElement((UpdateRequestUMAS)vector2.elementAt(n));
        }
        vector2 = updateOptimizerSTD.optimize();
        n2 = vector2.size();
        for (n = 0; n < n2; ++n) {
            vector.addElement((UpdateRequestUMAS)vector2.elementAt(n));
        }
        return vector;
    }

    private GetRefResponse[] getRefs(UpdateRequestUMAS updateRequestUMAS) throws Exception {
        GetRefRequest[] getRefRequestArray = updateRequestUMAS.getRequests();
        AddressUMAS[] addressUMASArray = updateRequestUMAS.addresses;
        if (getRefRequestArray.length == 1) {
            return new GetRefResponse[]{this.getRef(getRefRequestArray[0], addressUMASArray[0])};
        }
        GetRefResponse[] getRefResponseArray = new GetRefResponse[getRefRequestArray.length];
        for (int i = 0; i < getRefResponseArray.length; ++i) {
            getRefResponseArray[i] = new GetRefResponse(getRefRequestArray[i].getXactID(), getRefRequestArray[i].getQuantity(), addressUMASArray[i].getDataType());
        }
        switch (addressUMASArray[0].getAddressType()) {
            case 2: {
                this.getVarRefs(addressUMASArray, getRefResponseArray);
                break;
            }
            case 0: {
                this.getStdRefs(addressUMASArray, getRefResponseArray);
                break;
            }
            default: {
                throw new FCIOException("IO request for multiple addresses not legal");
            }
        }
        return getRefResponseArray;
    }

    private GetRefResponse getRef(GetRefRequest getRefRequest, AddressUMAS addressUMAS) throws IOException, FCIOException {
        GetRefResponse getRefResponse = new GetRefResponse(getRefRequest.getXactID(), getRefRequest.getQuantity(), addressUMAS.getDataType());
        switch (addressUMAS.getAddressType()) {
            case 2: {
                if (addressUMAS.getDataType() == 9) {
                    this.getVarStr(addressUMAS, getRefResponse);
                    break;
                }
                this.getVarRef(addressUMAS, getRefResponse);
                break;
            }
            case 0: {
                this.getStdRef(addressUMAS, getRefResponse);
                break;
            }
            default: {
                this.getIoRef(addressUMAS, getRefResponse);
            }
        }
        return getRefResponse;
    }

    private SetRefResponse setRef(SetRefRequest setRefRequest, AddressUMAS addressUMAS) throws IOException, FCIOException {
        SetRefResponse setRefResponse = new SetRefResponse(setRefRequest.getXactID());
        switch (addressUMAS.getAddressType()) {
            case 2: {
                if (addressUMAS.getDataType() == 9) {
                    setRefResponse.setErrorCode(this.setVarStr((byte[])setRefRequest.getValues(), addressUMAS));
                    break;
                }
                setRefResponse.setErrorCode(this.setVarRef(setRefRequest.getValues(), addressUMAS));
                break;
            }
            case 0: {
                setRefResponse.setErrorCode(this.setStdRef(setRefRequest.getValues(), addressUMAS));
                break;
            }
            default: {
                throw new InvalidAccessException();
            }
        }
        return setRefResponse;
    }

    private synchronized int setStdRef(Object object, AddressUMAS addressUMAS) throws IOException, FCIOException {
        short s = addressUMAS.getDataType();
        boolean bl = addressUMAS.isBitAddress();
        boolean bl2 = addressUMAS.isBytes();
        int n = addressUMAS.getObjectType();
        int n2 = addressUMAS.getAddress();
        int n3 = 242 / addressUMAS.getObjectSize();
        int n4 = addressUMAS.getQuantity();
        if (n == 5 || n == 6) {
            throw new InvalidAccessException();
        }
        if (bl2) {
            n3 = (short)(n3 * 2);
        }
        if (bl) {
            n3 = 1;
            switch (n) {
                case 1: {
                    n = 32;
                    break;
                }
                case 3: {
                    n = 33;
                    break;
                }
                case 4: {
                    n = 34;
                    break;
                }
                default: {
                    throw new IllegalReferenceTypeException("IllegalWrite");
                }
            }
        }
        int n5 = 0;
        while (n4 > 0) {
            int n6 = n4 > n3 ? n3 : n4;
            this.startRequest((byte)37);
            this.mapByte((short)1);
            this.mapByte((short)0);
            this.mapByte((short)n);
            this.mapDWord(n2);
            if (bl) {
                boolean[] blArray = (boolean[])object;
                this.mapWord(1 << addressUMAS.getBitNumber());
                this.mapWord(blArray[n5] ? -1 : 0);
                ++n2;
            } else {
                this.mapWord(bl2 ? (n6 + 1) / 2 : n6);
                n2 += this.mapValues(object, n5, s, (short)n6);
            }
            int n7 = this.processRequest();
            if (n7 != 0) {
                return n7;
            }
            if (this.unmapByte() == 0) {
                throw new FCIOException("Invalid UMAS 'write var list' response");
            }
            int n8 = this.unmapWordUnsigned();
            if (n8 != 0) {
                return -(n8 & 0xFF);
            }
            n5 += n6;
            n4 = (short)(n4 - n6);
        }
        return 0;
    }

    private synchronized int setVarRef(Object object, AddressUMAS addressUMAS) throws IOException, FCIOException {
        int n;
        ProgInfoUMAS progInfoUMAS = (ProgInfoUMAS)this.getVerInfo();
        int n2 = progInfoUMAS.lid + progInfoUMAS.did;
        boolean bl = addressUMAS.isBitAddress();
        short s = addressUMAS.getDataType();
        if (bl) {
            n = 5;
        } else if (addressUMAS.isEBoolVar()) {
            n = 0;
        } else {
            switch (DT.getSize(s)) {
                case 1: {
                    n = 1;
                    break;
                }
                case 2: {
                    n = 2;
                    break;
                }
                case 4: {
                    n = 3;
                    break;
                }
                case 8: {
                    n = 4;
                    break;
                }
                default: {
                    throw new FCIOException("Invalid data size for variable");
                }
            }
        }
        this.startRequest((byte)35);
        this.mapDWord(n2);
        this.mapByte((short)1);
        this.mapByte((short)n);
        this.mapWord(addressUMAS.getBlock());
        this.mapDWord(addressUMAS.getOffset());
        if (bl) {
            boolean[] blArray = (boolean[])object;
            this.mapWord(1 << addressUMAS.getBitNumber());
            this.mapWord(blArray[0] ? -1 : 0);
        } else {
            this.mapValues(object, 0, s, (short)1);
        }
        int n3 = this.processRequest();
        if (n3 != 0) {
            return n3;
        }
        if (this.unmapByte() == 0) {
            throw new FCIOException("Invalid UMAS 'write BOL' response");
        }
        int n4 = this.unmapWordUnsigned();
        if (n4 != 0) {
            return -(n4 & 0xFF);
        }
        return 0;
    }

    private synchronized int setVarStr(byte[] byArray, AddressUMAS addressUMAS) throws IOException, FCIOException {
        ProgInfoUMAS progInfoUMAS = (ProgInfoUMAS)this.getVerInfo();
        int n = progInfoUMAS.lid + progInfoUMAS.did;
        int n2 = addressUMAS.getBlock();
        int n3 = addressUMAS.getOffset();
        short s = addressUMAS.getQuantity();
        int n4 = 0;
        while (s > 0) {
            int n5 = s > 236 ? 236 : (int)s;
            this.startRequest((byte)35);
            this.mapDWord(n);
            this.mapByte((short)1);
            this.mapByte((short)17);
            this.mapWord(n2);
            this.mapDWord(n3);
            this.mapWord(n5);
            this.mapBytes(byArray, n4, n5);
            int n6 = this.processRequest();
            if (n6 != 0) {
                return n6;
            }
            if (this.unmapByte() == 0) {
                throw new FCIOException("Invalid UMAS 'write BOL' response");
            }
            int n7 = this.unmapWordUnsigned();
            if (n7 != 0) {
                return -(n7 & 0xFF);
            }
            n3 += n5;
            n4 += n5;
            s = (short)(s - n5);
        }
        return 0;
    }

    private synchronized void getStdRef(AddressUMAS addressUMAS, GetRefResponse getRefResponse) throws IOException, FCIOException {
        Object object = getRefResponse.getValues();
        byte by = addressUMAS.getObjectType();
        short s = addressUMAS.getDataType();
        int n = addressUMAS.isBitAddress() ? addressUMAS.getBitNumber() : -1;
        boolean bl = addressUMAS.isBytes();
        int n2 = 250 / addressUMAS.getObjectSize();
        int n3 = addressUMAS.getQuantity();
        if (bl) {
            n2 = (short)(n2 * 2);
        }
        int n4 = 0;
        int n5 = addressUMAS.getAddress();
        while (n3 > 0) {
            int n6 = n3 > n2 ? n2 : n3;
            this.startRequest((byte)36);
            this.mapByte((short)1);
            this.mapByte((short)0);
            this.mapByte(by);
            this.mapDWord(n5);
            this.mapWord(bl ? (n6 + 1) / 2 : n6);
            int n7 = this.processRequest();
            if (n7 != 0) {
                getRefResponse.setErrorCode(n7);
                return;
            }
            if (this.unmapByte() == 0) {
                throw new FCIOException("Invalid UMAS 'read var list' response length");
            }
            int n8 = this.unmapWordUnsigned();
            if (n8 != 0) {
                getRefResponse.setErrorCode(-(n8 & 0xFF));
                return;
            }
            n5 += this.unmapValues(object, n4, s, (short)n6, n);
            n4 += n6;
            n3 = (short)(n3 - n6);
        }
    }

    private void getVarRef(AddressUMAS addressUMAS, GetRefResponse getRefResponse) throws IOException, FCIOException {
        this.getVarRefs(new AddressUMAS[]{addressUMAS}, new GetRefResponse[]{getRefResponse});
    }

    private synchronized void getVarStr(AddressUMAS addressUMAS, GetRefResponse getRefResponse) throws IOException, FCIOException {
        ProgInfoUMAS progInfoUMAS = (ProgInfoUMAS)this.getVerInfo();
        int n = progInfoUMAS.lid + progInfoUMAS.did;
        byte[] byArray = (byte[])getRefResponse.getValues();
        int n2 = addressUMAS.getBlock();
        int n3 = addressUMAS.getOffset();
        short s = addressUMAS.getQuantity();
        int n4 = 0;
        while (s > 0) {
            int n5 = s > 250 ? 250 : (int)s;
            this.startRequest((byte)34);
            this.mapDWord(n);
            this.mapByte((short)1);
            this.mapByte((short)17);
            this.mapWord(n2);
            this.mapByte((short)1);
            this.mapWord(n3 >> 8 & 0xFFFF);
            this.mapByte((short)(n3 & 0xFF));
            this.mapWord(n5);
            int n6 = this.processRequest();
            if (n6 != 0) {
                getRefResponse.setErrorCode(n6);
                return;
            }
            this.unmapBytes(byArray, n4, n5);
            n3 += n5;
            n4 += n5;
            s = (short)(s - n5);
        }
    }

    private synchronized void getIoRef(AddressUMAS addressUMAS, GetRefResponse getRefResponse) throws IOException, FCIOException {
        short s;
        short s2;
        int n = addressUMAS.getBus();
        int n2 = addressUMAS.getDrop();
        int n3 = addressUMAS.getRack();
        int n4 = addressUMAS.getSlot();
        int n5 = addressUMAS.getChannel();
        byte by = addressUMAS.getObjectType();
        short s3 = addressUMAS.getDataType();
        int n6 = addressUMAS.getObjectSize();
        int n7 = addressUMAS.isBitAddress() ? addressUMAS.getBitNumber() : -1;
        Object object = getRefResponse.getValues();
        int n8 = 32;
        if (addressUMAS.isIOMemoryObject() || addressUMAS.isMultipleRanks()) {
            s2 = 1;
            s = addressUMAS.getQuantity();
            if (by == 6) {
                n8 = 48;
            }
        } else {
            s2 = addressUMAS.getQuantity();
            s = 1;
        }
        int n9 = s * n6;
        int n10 = by == 1 || by == 2 ? addressUMAS.getRank() : addressUMAS.getRank() * 2;
        this.startRequest((byte)112);
        if (n == 0 && n2 == 0) {
            this.mapWord(4);
            this.mapWord(n3);
            this.mapWord(n4);
        } else {
            this.mapWord(8);
            this.mapWord(n);
            this.mapWord(n2);
            this.mapWord(n3);
            this.mapWord(n4);
        }
        this.mapByte((short)1);
        this.mapByte((short)n8);
        this.mapByte(by);
        this.mapWord(s2);
        this.mapWord(n5);
        this.mapWord(n9);
        this.mapWord(n10);
        int n11 = this.processRequest();
        if (n11 != 0) {
            getRefResponse.setErrorCode(n11);
            return;
        }
        if (this.unmapByte() == 0) {
            throw new FCIOException("Invalid UMAS 'Read I/O Object' response length");
        }
        if (this.unmapByte() > 0) {
            throw new FCIOException("Too mch data for the 'Read I/O Object' response");
        }
        if (this.unmapByte() != by) {
            throw new FCIOException("Wrong object type in 'Read I/O Object' response");
        }
        short s4 = this.unmapByteUnsigned();
        if (s4 != 0) {
            throw new FCIOException("Negative acknowledgement (" + s4 + ") to 'Read I/O Object' request");
        }
        int n12 = this.unmapWordUnsigned();
        if (n12 == 0) {
            throw new InvalidAddressException(addressUMAS.toString());
        }
        int n13 = 0;
        for (int i = 0; i < n12; ++i) {
            int n14 = this.unmapWordUnsigned();
            if (n14 == 0) {
                throw new InvalidAddressException(addressUMAS.toString());
            }
            this.unmapValues(object, n13, s3, (short)(n14 / n6), n7);
            n13 += s;
        }
    }

    private synchronized void getStdRefs(AddressUMAS[] addressUMASArray, GetRefResponse[] getRefResponseArray) throws IOException, FCIOException {
        int n;
        int n2;
        int n3;
        int n4 = addressUMASArray.length;
        this.startRequest((byte)36);
        this.mapByte((short)n4);
        for (n3 = 0; n3 < n4; ++n3) {
            AddressUMAS addressUMAS = addressUMASArray[n3];
            n2 = addressUMAS.getQuantity();
            n = addressUMAS.getObjectType();
            boolean bl = addressUMAS.isBytes();
            this.mapByte((short)0);
            this.mapByte((short)n);
            this.mapDWord(addressUMAS.getAddress());
            this.mapWord(bl ? (n2 + 1) / 2 : n2);
        }
        n3 = this.processRequest();
        if (n3 != 0) {
            for (int i = 0; i < n4; ++i) {
                getRefResponseArray[i].setErrorCode(n3);
            }
            return;
        }
        short s = this.unmapByteUnsigned();
        if (s < n4) {
            throw new FCIOException("Requested " + n4 + " variables, but received only " + s);
        }
        for (n2 = 0; n2 < n4; ++n2) {
            n = this.unmapWordUnsigned();
            if (n == 0) {
                AddressUMAS addressUMAS = addressUMASArray[n2];
                short s2 = addressUMAS.getQuantity();
                Object object = getRefResponseArray[n2].getValues();
                short s3 = addressUMAS.getDataType();
                int n5 = addressUMAS.isBitAddress() ? addressUMAS.getBitNumber() : -1;
                boolean bl = addressUMAS.isBytes();
                this.unmapValues(object, 0, s3, s2, n5);
                if (!bl || s2 % 2 != 1) continue;
                ++this.msglen;
                continue;
            }
            getRefResponseArray[n2].setErrorCode(-(n & 0xFF));
        }
    }

    private synchronized void getVarRefs(AddressUMAS[] addressUMASArray, GetRefResponse[] getRefResponseArray) throws IOException, FCIOException {
        int n;
        int n2;
        ProgInfoUMAS progInfoUMAS = (ProgInfoUMAS)this.getVerInfo();
        int n3 = progInfoUMAS.lid + progInfoUMAS.did;
        int n4 = addressUMASArray.length;
        this.startRequest((byte)34);
        this.mapDWord(n3);
        this.mapByte((short)n4);
        for (n2 = 0; n2 < n4; ++n2) {
            AddressUMAS addressUMAS = addressUMASArray[n2];
            short s = addressUMAS.getDataType();
            if (addressUMAS.isBitAddress()) {
                n = 2;
            } else if (addressUMAS.isEBoolVar()) {
                n = 0;
            } else {
                switch (DT.getSize(s)) {
                    case 1: {
                        n = 1;
                        break;
                    }
                    case 2: {
                        n = 2;
                        break;
                    }
                    case 4: {
                        n = 3;
                        break;
                    }
                    case 8: {
                        n = 4;
                        break;
                    }
                    default: {
                        throw new FCIOException("Invalid data size for variable");
                    }
                }
            }
            this.mapByte((short)n);
            this.mapWord(addressUMAS.getBlock());
            this.mapByte((short)1);
            this.mapWord(addressUMAS.getBaseOffset());
            this.mapByte(addressUMAS.getRelOffset());
        }
        n2 = this.processRequest();
        if (n2 != 0) {
            for (int i = 0; i < n4; ++i) {
                getRefResponseArray[i].setErrorCode(n2);
            }
            return;
        }
        for (int i = 0; i < n4; ++i) {
            AddressUMAS addressUMAS = addressUMASArray[i];
            n = addressUMAS.isBitAddress() ? addressUMAS.getBitNumber() : -1;
            this.unmapValues(getRefResponseArray[i].getValues(), 0, addressUMAS.getDataType(), (short)1, n);
        }
    }

    private int mapValues(Object object, int n, short s, short n2) throws UnsupportedDataTypeException {
        switch (s) {
            case 1: {
                boolean[] blArray = (boolean[])object;
                for (int i = 0; i < n2; ++i) {
                    this.mapByte(blArray[n++] ? (short)1 : 0);
                }
                return n2;
            }
            case 2: 
            case 9: {
                this.mapBytes((byte[])object, n, n2);
                return (n2 + 1) / 2;
            }
            case 3: {
                this.mapBytes((short[])object, n, n2);
                return (n2 + 1) / 2;
            }
            case 4: {
                this.mapWords((short[])object, n, n2);
                return n2;
            }
            case 5: {
                this.mapWords((int[])object, n, n2);
                return n2;
            }
            case 6: 
            case 14: 
            case 15: {
                this.mapDWords((int[])object, n, n2);
                return n2 * 2;
            }
            case 7: 
            case 10: {
                this.mapDWords((long[])object, n, n2);
                return n2 * 2;
            }
            case 8: {
                this.mapFloats((float[])object, n, n2);
                return n2 * 2;
            }
            case 16: {
                this.mapLWords((long[])object, n, n2);
                return n2 * 4;
            }
        }
        throw new UnsupportedDataTypeException(DT.toName(s));
    }

    private int unmapValues(Object object, int n, short s, short n2, int n3) throws UnsupportedDataTypeException {
        switch (s) {
            case 1: {
                int n4 = 0;
                short[] sArray = new short[n2];
                if (n3 < 0) {
                    this.unmapBytesUnsigned(sArray, 0, n2);
                } else {
                    this.unmapWords(sArray, 0, n2);
                    n4 = n3;
                }
                boolean[] blArray = (boolean[])object;
                for (int i = 0; i < n2; ++i) {
                    blArray[n++] = (sArray[i] & 1 << n4) != 0;
                }
                return n2;
            }
            case 2: 
            case 9: {
                this.unmapBytes((byte[])object, n, n2);
                return (n2 + 1) / 2;
            }
            case 3: {
                this.unmapBytesUnsigned((short[])object, n, n2);
                return (n2 + 1) / 2;
            }
            case 4: {
                this.unmapWords((short[])object, n, n2);
                return n2;
            }
            case 5: {
                this.unmapWordsUnsigned((int[])object, n, n2);
                return n2;
            }
            case 6: 
            case 14: 
            case 15: {
                this.unmapDWords((int[])object, n, n2);
                return n2 * 2;
            }
            case 7: 
            case 10: {
                this.unmapDWordsUnsigned((long[])object, n, n2);
                return n2 * 2;
            }
            case 8: {
                this.unmapFloats((float[])object, n, n2);
                return n2 * 2;
            }
            case 16: {
                this.unmapLWords((long[])object, n, n2);
                return n2 * 4;
            }
        }
        throw new UnsupportedDataTypeException(DT.toName(s));
    }
}

