/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.factorycast.comm.xbf;

import com.schneiderautomation.dt.DT;
import com.schneiderautomation.factorycast.comm.AlarmObject;
import com.schneiderautomation.factorycast.comm.ClientHandlerAdaptor;
import com.schneiderautomation.factorycast.comm.DiagnosticBufferHandlerInterface;
import com.schneiderautomation.factorycast.comm.FCIOException;
import com.schneiderautomation.factorycast.comm.GetRefRequest;
import com.schneiderautomation.factorycast.comm.GetRefResponse;
import com.schneiderautomation.factorycast.comm.InvalidSymbolTableException;
import com.schneiderautomation.factorycast.comm.N_mmi;
import com.schneiderautomation.factorycast.comm.ResultReadNextError;
import com.schneiderautomation.factorycast.comm.ServerHandlerInterface;
import com.schneiderautomation.factorycast.comm.SetRefRequest;
import com.schneiderautomation.factorycast.comm.SetRefResponse;
import com.schneiderautomation.factorycast.comm.StatusMessages;
import com.schneiderautomation.factorycast.comm.SubscriptionList;
import com.schneiderautomation.factorycast.comm.UnsupportedDataTypeException;
import com.schneiderautomation.factorycast.comm.UnsupportedOperationException;
import com.schneiderautomation.factorycast.comm.UpdateRequest;
import com.schneiderautomation.factorycast.comm.UtilInterface;
import com.schneiderautomation.factorycast.comm.xbf.Address984;
import com.schneiderautomation.factorycast.comm.xbf.ENetStatistics;
import com.schneiderautomation.factorycast.comm.xbf.ENetStats;
import com.schneiderautomation.factorycast.comm.xbf.IllegalReferenceTypeException;
import com.schneiderautomation.factorycast.comm.xbf.MBAPReadException;
import com.schneiderautomation.factorycast.comm.xbf.ProgInfo984;
import com.schneiderautomation.factorycast.comm.xbf.UnsupportedAddressException;
import com.schneiderautomation.factorycast.comm.xbf.UpdateOptimizer;
import com.schneiderautomation.factorycast.comm.xbf.UpdateOptimizer984;
import com.schneiderautomation.factorycast.comm.xbf.UpdateOptimizerVars;
import com.schneiderautomation.factorycast.comm.xbf.UpdateRequest984;
import com.schneiderautomation.factorycast.comm.xbf.Util;
import com.schneiderautomation.namespace.NameSpace;
import com.schneiderautomation.namespace.VarLookupInterface;
import com.schneiderautomation.namespace.VerInfo;
import java.io.IOException;
import java.util.Vector;

public class ClientHandler
extends ClientHandlerAdaptor
implements ENetStatistics,
DiagnosticBufferHandlerInterface {
    private static final int MBAP_HDRSIZE = 6;
    private static final int MAX_MBP_MSGSIZE = 256;
    private static final int MBAP_PORT = 502;
    private byte[] request = new byte[262];
    private byte[] respHdr = new byte[6];
    private byte[] respData = new byte[256];
    private byte[] totalResp = new byte[131068];
    private short xactID;
    private byte destID;
    private int msglen;
    private static final int MBUS_ERR_BASE = 0;
    private static final int PGM_ERR_BASE = 256;
    private static final int IEC_ERR_BASE = 512;

    public ClientHandler(ServerHandlerInterface serverHandlerInterface, VarLookupInterface varLookupInterface) {
        super(serverHandlerInterface, varLookupInterface);
    }

    public void connect(String string, boolean bl) throws Exception {
        this.destID = 0;
        super.connect(string, bl);
    }

    public Object getExtension(Class clazz) {
        if (clazz.getName().equals("com.schneiderautomation.factorycast.comm.xbf.ENetStatistics")) {
            return this;
        }
        return null;
    }

    protected int getPort() {
        return 502;
    }

    protected int getProtocolId() {
        return 0;
    }

    protected Object readVerInfo() throws Exception {
        int n = 4;
        byte by = 42;
        this.PackRequestHeader((short)n, by);
        this.request[this.msglen++] = 1;
        this.request[this.msglen++] = 1;
        int n2 = this.ProcessXact();
        if (n2 == ClientHandler.getModbusError(1)) {
            return null;
        }
        boolean bl = false;
        if (n2 == ClientHandler.getIECError(1)) {
            bl = true;
            this.PackRequestHeader((short)n, by);
            this.request[this.msglen++] = 1;
            this.request[this.msglen++] = 4;
            n2 = this.ProcessXact();
        }
        if (n2 != 0) {
            throw new FCIOException(StatusMessages.get(n2));
        }
        int n3 = this.respData[2] & 0xFF;
        byte[] byArray = bl ? new byte[15] : new byte[39];
        int n4 = byArray.length + 3;
        if (n3 != n4) {
            throw new MBAPReadException("InvalidLen");
        }
        System.arraycopy(this.respData, 6, byArray, 0, byArray.length);
        return ProgInfo984.parse(byArray);
    }

    public UtilInterface getUtil() {
        return new Util();
    }

    public SetRefResponse setRef(SetRefRequest setRefRequest) throws Exception {
        Address984 address984 = Address984.parse(setRefRequest, this.isSymbolTableOK() ? this.varLookup : null);
        SetRefResponse setRefResponse = new SetRefResponse(setRefRequest.getXactID());
        int n = address984.idRefType == 9 ? this.SetVar984(address984.idSymbol, address984.offset, setRefRequest.getDatatype(), setRefRequest.getValues()) : this.SetRef984(address984.idRefType, address984.idSymbol, address984.offset, setRefRequest.getQuantity(), setRefRequest.getDatatype(), setRefRequest.getValues());
        setRefResponse.setErrorCode(n);
        return setRefResponse;
    }

    public GetRefResponse getRef(GetRefRequest getRefRequest) throws Exception {
        return this.getRef(getRefRequest, Address984.parse(getRefRequest, this.isSymbolTableOK() ? this.varLookup : null));
    }

    public Vector createRequests(GetRefRequest[] getRefRequestArray) throws Exception {
        Object object;
        int n;
        Vector<UpdateRequest984> vector = new Vector<UpdateRequest984>();
        boolean bl = false;
        VerInfo verInfo = this.getVerInfo();
        if (verInfo != null && verInfo instanceof ProgInfo984) {
            bl = ((ProgInfo984)verInfo).isCC25();
        }
        UpdateOptimizer[] updateOptimizerArray = new UpdateOptimizer[]{new UpdateOptimizerVars(bl), new UpdateOptimizer984(), new UpdateOptimizer984(), new UpdateOptimizer984(), new UpdateOptimizer984()};
        NameSpace nameSpace = this.isSymbolTableOK() ? this.varLookup : null;
        block9: for (n = 0; n < getRefRequestArray.length; ++n) {
            block14: {
                try {
                    object = Address984.parse(getRefRequestArray[n], nameSpace);
                    if (((Address984)object).idDataType == 0) {
                        throw new UnsupportedDataTypeException();
                    }
                    if (((Address984)object).idRefType == 9) break block14;
                    ClientHandler.checkRefType(((Address984)object).idRefType, ((Address984)object).idDataType);
                }
                catch (FCIOException fCIOException) {
                    this.client.valueChanged(SubscriptionList.createErrorResponse(getRefRequestArray[n].getXactID(), fCIOException.getMessage(), 65536));
                    continue;
                }
            }
            UpdateRequest984 updateRequest984 = new UpdateRequest984(getRefRequestArray[n], (Address984)object);
            switch (((Address984)object).idRefType) {
                case 9: {
                    updateOptimizerArray[0].addElement(updateRequest984);
                    continue block9;
                }
                case 0: {
                    updateOptimizerArray[1].addElement(updateRequest984);
                    continue block9;
                }
                case 1: {
                    updateOptimizerArray[2].addElement(updateRequest984);
                    continue block9;
                }
                case 3: {
                    updateOptimizerArray[3].addElement(updateRequest984);
                    continue block9;
                }
                case 4: {
                    updateOptimizerArray[4].addElement(updateRequest984);
                    continue block9;
                }
                default: {
                    vector.addElement(updateRequest984);
                }
            }
        }
        for (n = 0; n < updateOptimizerArray.length; ++n) {
            if (updateOptimizerArray[n].size() <= 0) continue;
            object = updateOptimizerArray[n].optimize();
            for (int i = 0; i < ((Vector)object).size(); ++i) {
                vector.addElement((UpdateRequest984)((Vector)object).elementAt(i));
            }
        }
        return vector;
    }

    public GetRefResponse[] getRefs(UpdateRequest updateRequest) throws Exception {
        int n;
        UpdateRequest984 updateRequest984 = (UpdateRequest984)updateRequest;
        GetRefRequest[] getRefRequestArray = updateRequest984.getRequests();
        Address984[] address984Array = updateRequest984.addresses;
        if (getRefRequestArray.length == 1) {
            GetRefResponse[] getRefResponseArray = new GetRefResponse[]{this.getRef(getRefRequestArray[0], address984Array[0])};
            return getRefResponseArray;
        }
        GetRefResponse[] getRefResponseArray = new GetRefResponse[getRefRequestArray.length];
        Object[] objectArray = new Object[getRefRequestArray.length];
        for (n = 0; n < getRefResponseArray.length; ++n) {
            getRefResponseArray[n] = new GetRefResponse(getRefRequestArray[n].getXactID(), getRefRequestArray[n].getQuantity(), address984Array[n].idDataType);
            objectArray[n] = getRefResponseArray[n].getValues();
        }
        n = address984Array[0].idRefType == 9 ? this.GetVars984(getRefRequestArray, address984Array, objectArray) : this.GetRefs984(getRefRequestArray, address984Array, objectArray);
        for (int i = 0; i < getRefResponseArray.length; ++i) {
            getRefResponseArray[i].setErrorCode(n);
        }
        return getRefResponseArray;
    }

    public synchronized ENetStats getNetworkStatistics() throws Exception {
        int n = 6;
        byte by = 8;
        this.PackRequestHeader((short)n, by);
        this.request[this.msglen++] = 0;
        this.request[this.msglen++] = 21;
        this.request[this.msglen++] = 0;
        this.request[this.msglen++] = 3;
        int n2 = this.ProcessXact();
        if (n2 != 0) {
            throw new FCIOException(StatusMessages.get(n2));
        }
        return new ENetStats(this.respData, 7);
    }

    public synchronized void clearNetworkStatistics() throws Exception {
        int n = 6;
        byte by = 8;
        this.PackRequestHeader((short)n, by);
        this.request[this.msglen++] = 0;
        this.request[this.msglen++] = 21;
        this.request[this.msglen++] = 0;
        this.request[this.msglen++] = 4;
        int n2 = this.ProcessXact();
        if (n2 != 0) {
            throw new FCIOException(StatusMessages.get(n2));
        }
    }

    public short logonDiagBuffer(byte[] byArray, N_mmi n_mmi) throws Exception {
        return 1;
    }

    public short logoutDiagBuffer(N_mmi n_mmi) throws Exception {
        return 1;
    }

    public boolean readNextErrorDiagBuffer(N_mmi n_mmi, AlarmObject alarmObject, ResultReadNextError resultReadNextError) throws Exception {
        return true;
    }

    public boolean ackErrorDiagBuffer(N_mmi n_mmi, int n) throws Exception {
        return true;
    }

    private GetRefResponse getRef(GetRefRequest getRefRequest, Address984 address984) throws IOException, FCIOException {
        GetRefResponse getRefResponse = new GetRefResponse(getRefRequest.getXactID(), getRefRequest.getQuantity(), address984.idDataType);
        GetRefRequest[] getRefRequestArray = new GetRefRequest[]{getRefRequest};
        Address984[] address984Array = new Address984[]{address984};
        Object[] objectArray = new Object[]{getRefResponse.getValues()};
        int n = address984.idRefType == 9 ? this.GetVars984(getRefRequestArray, address984Array, objectArray) : this.GetRefs984(getRefRequestArray, address984Array, objectArray);
        getRefResponse.setErrorCode(n);
        return getRefResponse;
    }

    private synchronized int GetVars984(GetRefRequest[] getRefRequestArray, Address984[] address984Array, Object[] objectArray) throws IOException, FCIOException {
        int n;
        int n2;
        int n3;
        int n4;
        if (!this.isSymbolTableOK()) {
            throw new InvalidSymbolTableException();
        }
        ProgInfo984 progInfo984 = (ProgInfo984)this.getVerInfo();
        byte[] byArray = progInfo984.cookie;
        int n5 = getRefRequestArray.length;
        byte by = (byte)(byArray.length + 6 + n5 * 6);
        byte by2 = 42;
        this.PackRequestHeader(by, by2);
        this.request[this.msglen++] = (byte)(by - 3);
        this.request[this.msglen++] = (byte)(progInfo984.isCC25() ? 5 : 2);
        System.arraycopy(byArray, 0, this.request, this.msglen, byArray.length);
        this.msglen += byArray.length;
        this.request[this.msglen++] = (byte)n5;
        this.request[this.msglen++] = (byte)(n5 >> 8);
        for (n4 = 0; n4 < n5; ++n4) {
            n3 = address984Array[n4].idSymbol;
            n2 = address984Array[n4].offset;
            switch (address984Array[n4].idDataType) {
                case 1: 
                case 2: 
                case 3: {
                    n = 1;
                    break;
                }
                case 4: 
                case 5: {
                    n = 2;
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 10: {
                    n = 4;
                    break;
                }
                case 9: {
                    throw new UnsupportedDataTypeException(DT.toName((short)9));
                }
                default: {
                    throw new UnsupportedDataTypeException();
                }
            }
            if (progInfo984.isCC25()) {
                int n6 = n3 + n2;
                this.request[this.msglen++] = (byte)n;
                this.request[this.msglen++] = (byte)(n >> 8);
                this.request[this.msglen++] = (byte)n6;
                this.request[this.msglen++] = (byte)(n6 >> 8);
                this.request[this.msglen++] = (byte)(n6 >> 16);
                this.request[this.msglen++] = (byte)(n6 >> 24);
                continue;
            }
            this.request[this.msglen++] = (byte)n2;
            this.request[this.msglen++] = (byte)(n2 >> 8);
            this.request[this.msglen++] = (byte)n;
            this.request[this.msglen++] = (byte)(n >> 8);
            this.request[this.msglen++] = (byte)n3;
            this.request[this.msglen++] = (byte)(n3 >> 8);
        }
        n4 = this.ProcessXact();
        if (n4 != 0) {
            return n4;
        }
        n3 = 6;
        block17: for (n2 = 0; n2 < n5; ++n2) {
            n = 0;
            switch (address984Array[n2].idDataType) {
                case 1: {
                    Object[] objectArray2 = (boolean[])objectArray[n2];
                    objectArray2[n++] = this.respData[n3++] != 0;
                    continue block17;
                }
                case 2: {
                    Object[] objectArray2 = (byte[])objectArray[n2];
                    objectArray2[n++] = this.respData[n3++];
                    continue block17;
                }
                case 3: {
                    Object[] objectArray2 = (short[])objectArray[n2];
                    objectArray2[n++] = (short)(this.respData[n3++] & 0xFF);
                    continue block17;
                }
                case 4: {
                    Object[] objectArray2 = (short[])objectArray[n2];
                    objectArray2[n++] = (short)(this.respData[n3 + 1] << 8 | this.respData[n3] & 0xFF);
                    n3 += 2;
                    continue block17;
                }
                case 5: {
                    Object[] objectArray2 = (int[])objectArray[n2];
                    objectArray2[n++] = (this.respData[n3 + 1] & 0xFF) << 8 | this.respData[n3] & 0xFF;
                    n3 += 2;
                    continue block17;
                }
                case 6: {
                    Object[] objectArray2 = (int[])objectArray[n2];
                    objectArray2[n++] = this.respData[n3 + 3] << 24 | (this.respData[n3 + 2] & 0xFF) << 16 | (this.respData[n3 + 1] & 0xFF) << 8 | this.respData[n3] & 0xFF;
                    n3 += 4;
                    continue block17;
                }
                case 7: 
                case 10: {
                    Object[] objectArray2 = (long[])objectArray[n2];
                    long l = 255L;
                    objectArray2[n++] = ((long)this.respData[n3 + 3] & l) << 24 | ((long)this.respData[n3 + 2] & l) << 16 | ((long)this.respData[n3 + 1] & l) << 8 | (long)this.respData[n3] & l;
                    n3 += 4;
                    continue block17;
                }
                case 8: {
                    Object[] objectArray2 = (float[])objectArray[n2];
                    objectArray2[n++] = Float.intBitsToFloat(this.respData[n3 + 3] << 24 | (this.respData[n3 + 2] & 0xFF) << 16 | (this.respData[n3 + 1] & 0xFF) << 8 | this.respData[n3] & 0xFF);
                    n3 += 4;
                }
            }
        }
        return 0;
    }

    private synchronized int SetVar984(int n, int n2, short s, Object object) throws IOException, FCIOException {
        int n3;
        int n4;
        if (!this.isSymbolTableOK()) {
            throw new InvalidSymbolTableException();
        }
        switch (s) {
            case 1: 
            case 2: 
            case 3: {
                n4 = 1;
                break;
            }
            case 4: 
            case 5: {
                n4 = 2;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                n4 = 4;
                break;
            }
            case 9: {
                throw new UnsupportedDataTypeException(DT.toName((short)9));
            }
            default: {
                throw new UnsupportedDataTypeException();
            }
        }
        ProgInfo984 progInfo984 = (ProgInfo984)this.getVerInfo();
        byte[] byArray = progInfo984.cookie;
        int n5 = 1;
        byte by = (byte)(byArray.length + 12 + n4 * n5);
        byte by2 = 42;
        this.PackRequestHeader(by, by2);
        this.request[this.msglen++] = (byte)(by - 3);
        this.request[this.msglen++] = (byte)(progInfo984.isCC25() ? 6 : 3);
        System.arraycopy(byArray, 0, this.request, this.msglen, byArray.length);
        this.msglen += byArray.length;
        this.request[this.msglen++] = (byte)n5;
        this.request[this.msglen++] = (byte)(n5 >> 8);
        if (progInfo984.isCC25()) {
            n3 = n + n2;
            this.request[this.msglen++] = (byte)n4;
            this.request[this.msglen++] = (byte)(n4 >> 8);
            this.request[this.msglen++] = (byte)n3;
            this.request[this.msglen++] = (byte)(n3 >> 8);
            this.request[this.msglen++] = (byte)(n3 >> 16);
            this.request[this.msglen++] = (byte)(n3 >> 24);
        } else {
            this.request[this.msglen++] = (byte)n2;
            this.request[this.msglen++] = (byte)(n2 >> 8);
            this.request[this.msglen++] = (byte)n4;
            this.request[this.msglen++] = (byte)(n4 >> 8);
            this.request[this.msglen++] = (byte)n;
            this.request[this.msglen++] = (byte)(n >> 8);
        }
        n3 = 0;
        switch (s) {
            case 1: {
                boolean[] blArray = (boolean[])object;
                this.request[this.msglen++] = blArray[n3++] ? (byte)1 : 0;
                break;
            }
            case 2: {
                byte[] byArray2 = (byte[])object;
                this.request[this.msglen++] = byArray2[n3++];
                break;
            }
            case 3: {
                short[] sArray = (short[])object;
                this.request[this.msglen++] = (byte)sArray[n3++];
                break;
            }
            case 4: {
                short[] sArray = (short[])object;
                short s2 = sArray[n3++];
                this.request[this.msglen++] = (byte)s2;
                this.request[this.msglen++] = (byte)(s2 >> 8);
                break;
            }
            case 5: {
                int[] nArray = (int[])object;
                int n6 = nArray[n3++];
                this.request[this.msglen++] = (byte)n6;
                this.request[this.msglen++] = (byte)(n6 >> 8);
                break;
            }
            case 6: {
                int[] nArray = (int[])object;
                int n7 = nArray[n3++];
                this.request[this.msglen++] = (byte)n7;
                this.request[this.msglen++] = (byte)(n7 >> 8);
                this.request[this.msglen++] = (byte)(n7 >> 16);
                this.request[this.msglen++] = (byte)(n7 >> 24);
                break;
            }
            case 7: 
            case 10: {
                long[] lArray = (long[])object;
                int n8 = (int)lArray[n3++];
                this.request[this.msglen++] = (byte)n8;
                this.request[this.msglen++] = (byte)(n8 >> 8);
                this.request[this.msglen++] = (byte)(n8 >> 16);
                this.request[this.msglen++] = (byte)(n8 >> 24);
                break;
            }
            case 8: {
                float[] fArray = (float[])object;
                int n9 = Float.floatToIntBits(fArray[n3++]);
                this.request[this.msglen++] = (byte)n9;
                this.request[this.msglen++] = (byte)(n9 >> 8);
                this.request[this.msglen++] = (byte)(n9 >> 16);
                this.request[this.msglen++] = (byte)(n9 >> 24);
            }
        }
        return this.ProcessXact();
    }

    /*
     * Enabled aggressive block sorting
     */
    private synchronized int GetRefs984(GetRefRequest[] getRefRequestArray, Address984[] address984Array, Object[] objectArray) throws IOException, FCIOException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        byte by;
        int n6;
        byte by2 = address984Array[0].idRefType;
        int n7 = address984Array[0].idSymbol;
        int n8 = address984Array[0].offset;
        int n9 = 0;
        for (n6 = 0; n6 < getRefRequestArray.length; ++n6) {
            by = address984Array[n6].idDataType;
            ClientHandler.checkRefType(by2, by);
            n5 = address984Array[n6].idSymbol != 0 && address984Array[n6].idRefType != 8 ? 1 : 0;
            n4 = getRefRequestArray[n6].getQuantity();
            switch (by) {
                case 2: 
                case 3: 
                case 9: {
                    if (n5 != 0) {
                        n4 = (short)(n4 + 1);
                    }
                    n4 = (short)((n4 + 1) / 2);
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 10: {
                    n4 = (short)(n4 * 2);
                    if (n5 == 0) break;
                    n4 = (short)(n4 + 1);
                    break;
                }
                case 4: 
                case 5: {
                    if (n5 == 0) break;
                    n4 = (short)(n4 + 1);
                    break;
                }
                case 1: {
                    break;
                }
                default: {
                    throw new UnsupportedDataTypeException();
                }
            }
            n3 = address984Array[n6].offset + n4 - 1;
            if (n3 <= n9) continue;
            n9 = n3;
        }
        n3 = 0;
        switch (by2) {
            case 0: {
                n6 = 6;
                by = 1;
                n5 = 2000;
                n4 = n8 - 1;
                break;
            }
            case 1: {
                n6 = 6;
                by = 2;
                n5 = 2000;
                n4 = n8 - 1;
                break;
            }
            case 3: {
                n6 = 6;
                by = 4;
                n5 = 124;
                n4 = n8 - 1;
                break;
            }
            case 4: {
                n6 = 6;
                by = 3;
                n5 = 124;
                n4 = n8 - 1;
                break;
            }
            case 6: {
                n6 = 10;
                by = 20;
                n5 = 124;
                n4 = n8 % 10000;
                n3 = n8 / 10000 + 1;
                break;
            }
            case 8: {
                n6 = 8;
                by = 126;
                n5 = 123;
                n4 = n8;
                break;
            }
            default: {
                throw new IllegalReferenceTypeException("UnknownType");
            }
        }
        int n10 = n9 - n8 + 1;
        int n11 = 0;
        while (n10 > 0) {
            n2 = n10 > n5 ? n5 : n10;
            this.PackRequestHeader((short)n6, by);
            n = 0;
            int n12 = 0;
            switch (by2) {
                case 0: 
                case 1: {
                    this.request[this.msglen++] = (byte)(n4 >> 8);
                    this.request[this.msglen++] = (byte)n4;
                    this.request[this.msglen++] = (byte)(n2 >> 8);
                    this.request[this.msglen++] = (byte)n2;
                    n = 3;
                    n12 = (n2 + 7) / 8;
                    break;
                }
                case 3: 
                case 4: {
                    this.request[this.msglen++] = (byte)(n4 >> 8);
                    this.request[this.msglen++] = (byte)n4;
                    this.request[this.msglen++] = (byte)(n2 >> 8);
                    this.request[this.msglen++] = (byte)n2;
                    n = 3;
                    n12 = n2 * 2;
                    break;
                }
                case 6: {
                    this.request[this.msglen++] = 7;
                    this.request[this.msglen++] = 6;
                    this.request[this.msglen++] = (byte)(n3 >> 8);
                    this.request[this.msglen++] = (byte)n3;
                    this.request[this.msglen++] = (byte)(n4 >> 8);
                    this.request[this.msglen++] = (byte)n4;
                    this.request[this.msglen++] = (byte)(n2 >> 8);
                    this.request[this.msglen++] = (byte)n2;
                    n = 5;
                    n12 = n2 * 2;
                    break;
                }
                case 8: {
                    this.request[this.msglen++] = 5;
                    this.request[this.msglen++] = 3;
                    this.request[this.msglen++] = (byte)n2;
                    this.request[this.msglen++] = (byte)n7;
                    this.request[this.msglen++] = (byte)(n4 >> 8);
                    this.request[this.msglen++] = (byte)n4;
                    n = 8;
                    n12 = n2 * 2;
                    break;
                }
            }
            int n13 = this.ProcessXact();
            if (n13 != 0) {
                return n13;
            }
            System.arraycopy(this.respData, n, this.totalResp, n11, n12);
            n11 += n12;
            n10 = (short)(n10 - n2);
            n4 += n2;
        }
        n2 = 0;
        while (n2 < getRefRequestArray.length) {
            n = address984Array[n2].offset - n8;
            switch (by2) {
                case 0: 
                case 1: {
                    int n14;
                    boolean[] blArray = (boolean[])objectArray[n2];
                    for (int i = 0; i < blArray.length; ++n, ++i) {
                        n14 = n / 8;
                        int n15 = n % 8;
                        blArray[i] = (this.totalResp[n14] & 1 << n15) != 0;
                    }
                    break;
                }
                case 3: 
                case 4: 
                case 6: 
                case 8: {
                    int n14;
                    boolean bl = address984Array[n2].idSymbol != 0 && address984Array[n2].idRefType != 8;
                    n *= 2;
                    switch (address984Array[n2].idDataType) {
                        case 9: {
                            if (bl) {
                                ++n;
                            }
                            byte[] byArray = (byte[])objectArray[n2];
                            System.arraycopy(this.totalResp, n, byArray, 0, byArray.length);
                            break;
                        }
                        case 2: {
                            byte[] byArray = (byte[])objectArray[n2];
                            n14 = bl ? 0 : 1;
                            for (int i = 0; i < byArray.length; ++i) {
                                byArray[i] = this.totalResp[n + n14];
                                int n16 = n14 = n14 == 0 ? 1 : 0;
                                if (n14 != 1) continue;
                                n += 2;
                            }
                            break;
                        }
                        case 3: {
                            short[] sArray = (short[])objectArray[n2];
                            n14 = bl ? 0 : 1;
                            for (int i = 0; i < sArray.length; ++i) {
                                sArray[i] = (short)(this.totalResp[n + n14] & 0xFF);
                                int n17 = n14 = n14 == 0 ? 1 : 0;
                                if (n14 != 1) continue;
                                n += 2;
                            }
                            break;
                        }
                        case 4: {
                            short[] sArray = (short[])objectArray[n2];
                            for (n14 = 0; n14 < sArray.length; n += 2, ++n14) {
                                sArray[n14] = bl ? (short)(this.totalResp[n + 3] << 8 | this.totalResp[n] & 0xFF) : (short)(this.totalResp[n] << 8 | this.totalResp[n + 1] & 0xFF);
                            }
                            break;
                        }
                        case 5: {
                            int[] nArray = (int[])objectArray[n2];
                            for (n14 = 0; n14 < nArray.length; n += 2, ++n14) {
                                nArray[n14] = bl ? (this.totalResp[n + 3] & 0xFF) << 8 | this.totalResp[n] & 0xFF : (this.totalResp[n] & 0xFF) << 8 | this.totalResp[n + 1] & 0xFF;
                            }
                            break;
                        }
                        case 6: {
                            int[] nArray = (int[])objectArray[n2];
                            for (n14 = 0; n14 < nArray.length; n += 4, ++n14) {
                                nArray[n14] = bl ? this.totalResp[n + 5] << 24 | (this.totalResp[n + 2] & 0xFF) << 16 | (this.totalResp[n + 3] & 0xFF) << 8 | this.totalResp[n] & 0xFF : this.totalResp[n + 2] << 24 | (this.totalResp[n + 3] & 0xFF) << 16 | (this.totalResp[n] & 0xFF) << 8 | this.totalResp[n + 1] & 0xFF;
                            }
                            break;
                        }
                        case 7: 
                        case 10: {
                            long[] lArray = (long[])objectArray[n2];
                            for (int i = 0; i < lArray.length; n += 4, ++i) {
                                lArray[i] = bl ? ((long)this.totalResp[n + 5] & 0xFFL) << 24 | ((long)this.totalResp[n + 2] & 0xFFL) << 16 | ((long)this.totalResp[n + 3] & 0xFFL) << 8 | (long)this.totalResp[n] & 0xFFL : ((long)this.totalResp[n + 2] & 0xFFL) << 24 | ((long)this.totalResp[n + 3] & 0xFFL) << 16 | ((long)this.totalResp[n] & 0xFFL) << 8 | (long)this.totalResp[n + 1] & 0xFFL;
                            }
                            break;
                        }
                        case 8: {
                            float[] fArray = (float[])objectArray[n2];
                            for (n14 = 0; n14 < fArray.length; n += 4, ++n14) {
                                fArray[n14] = bl ? Float.intBitsToFloat(this.totalResp[n + 5] << 24 | (this.totalResp[n + 2] & 0xFF) << 16 | (this.totalResp[n + 3] & 0xFF) << 8 | this.totalResp[n] & 0xFF) : Float.intBitsToFloat(this.totalResp[n + 2] << 24 | (this.totalResp[n + 3] & 0xFF) << 16 | (this.totalResp[n] & 0xFF) << 8 | this.totalResp[n + 1] & 0xFF);
                            }
                        }
                    }
                    break;
                }
            }
            ++n2;
        }
        return 0;
    }

    private synchronized int SetRef984(byte by, int n, int n2, short n3, short s, Object object) throws IOException, FCIOException {
        int n4;
        int n5;
        int n6;
        int n7;
        byte by2;
        boolean bl;
        ClientHandler.checkRefType(by, s);
        boolean bl2 = bl = n != 0 && by != 8;
        if (n3 == 1 && (s == 2 || s == 3)) {
            return this.SetByteRef984(by, bl, n2, s, object);
        }
        if (bl) {
            throw new UnsupportedAddressException("OffsetAddress");
        }
        switch (by) {
            case 0: {
                by2 = 15;
                n7 = 800;
                n6 = n2 - 1;
                n5 = 0;
                break;
            }
            case 4: {
                by2 = 16;
                n7 = 100;
                n6 = n2 - 1;
                n5 = 0;
                break;
            }
            case 6: {
                by2 = 21;
                n7 = 120;
                n6 = n2 % 10000;
                n5 = n2 / 10000 + 1;
                break;
            }
            case 8: {
                throw new UnsupportedOperationException();
            }
            case 1: 
            case 3: {
                throw new IllegalReferenceTypeException("IllegalWrite");
            }
            default: {
                throw new IllegalReferenceTypeException("UnknownType");
            }
        }
        switch (s) {
            case 2: 
            case 3: 
            case 9: {
                n4 = (short)((n3 + 1) / 2);
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                n4 = n3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                n4 = (short)(n3 * 2);
                break;
            }
            default: {
                throw new UnsupportedDataTypeException();
            }
        }
        int n8 = 0;
        while (n4 > 0) {
            int n9;
            int n10;
            block56: {
                short s2;
                n10 = n4 > n7 ? n7 : n4;
                switch (by) {
                    case 0: {
                        s2 = (short)(7 + (n10 + 7) / 8);
                        break;
                    }
                    case 4: {
                        s2 = (short)(7 + n10 * 2);
                        break;
                    }
                    case 6: {
                        s2 = (short)(10 + n10 * 2);
                        break;
                    }
                    default: {
                        s2 = 0;
                    }
                }
                this.PackRequestHeader(s2, by2);
                if (by == 6) {
                    this.request[this.msglen++] = (byte)(s2 - 3);
                    this.request[this.msglen++] = 6;
                    this.request[this.msglen++] = (byte)(n5 >> 8);
                    this.request[this.msglen++] = (byte)n5;
                }
                this.request[this.msglen++] = (byte)(n6 >> 8);
                this.request[this.msglen++] = (byte)n6;
                this.request[this.msglen++] = (byte)(n10 >> 8);
                this.request[this.msglen++] = (byte)n10;
                block17 : switch (by) {
                    case 0: {
                        int n11;
                        this.request[this.msglen++] = (byte)(s2 - 7);
                        n9 = n10 / 8;
                        int n12 = n10 % 8;
                        boolean[] blArray = (boolean[])object;
                        for (n11 = 0; n11 < n9; ++n11) {
                            this.request[this.msglen] = 0;
                            if (blArray[n8++]) {
                                int n13 = this.msglen;
                                this.request[n13] = (byte)(this.request[n13] | 1);
                            }
                            if (blArray[n8++]) {
                                int n14 = this.msglen;
                                this.request[n14] = (byte)(this.request[n14] | 2);
                            }
                            if (blArray[n8++]) {
                                int n15 = this.msglen;
                                this.request[n15] = (byte)(this.request[n15] | 4);
                            }
                            if (blArray[n8++]) {
                                int n16 = this.msglen;
                                this.request[n16] = (byte)(this.request[n16] | 8);
                            }
                            if (blArray[n8++]) {
                                int n17 = this.msglen;
                                this.request[n17] = (byte)(this.request[n17] | 0x10);
                            }
                            if (blArray[n8++]) {
                                int n18 = this.msglen;
                                this.request[n18] = (byte)(this.request[n18] | 0x20);
                            }
                            if (blArray[n8++]) {
                                int n19 = this.msglen;
                                this.request[n19] = (byte)(this.request[n19] | 0x40);
                            }
                            if (blArray[n8++]) {
                                int n20 = this.msglen;
                                this.request[n20] = (byte)(this.request[n20] | 0x80);
                            }
                            ++this.msglen;
                        }
                        if (n12 <= 0) break;
                        this.request[this.msglen] = 0;
                        for (n11 = 0; n11 < n12; ++n11) {
                            if (!blArray[n8++]) continue;
                            int n21 = this.msglen;
                            this.request[n21] = (byte)(this.request[n21] | 1 << n11);
                        }
                        ++this.msglen;
                        break;
                    }
                    case 4: {
                        this.request[this.msglen++] = (byte)(s2 - 7);
                    }
                    case 6: {
                        int n11;
                        switch (s) {
                            case 9: {
                                boolean bl3;
                                n9 = n10 * 2;
                                byte[] byArray = (byte[])object;
                                boolean bl4 = bl3 = n8 + n9 > n3;
                                if (bl3) {
                                    --n9;
                                }
                                System.arraycopy(byArray, n8, this.request, this.msglen, n9);
                                this.msglen += n10 * 2;
                                if (bl3) {
                                    this.request[this.msglen - 1] = 0;
                                }
                                n8 += n9;
                                break block17;
                            }
                            case 2: {
                                n9 = n10;
                                byte[] byArray = (byte[])object;
                                for (int i = 0; i < n9; ++i) {
                                    this.request[this.msglen + 1] = byArray[n8++];
                                    this.request[this.msglen] = n8 < n3 ? byArray[n8++] : (byte)0;
                                    this.msglen += 2;
                                }
                                break block56;
                            }
                            case 3: {
                                n9 = n10;
                                short[] sArray = (short[])object;
                                for (int i = 0; i < n9; ++i) {
                                    this.request[this.msglen + 1] = (byte)sArray[n8++];
                                    this.request[this.msglen] = n8 < n3 ? (byte)sArray[n8++] : (byte)0;
                                    this.msglen += 2;
                                }
                                break block56;
                            }
                            case 4: {
                                n9 = n10;
                                short[] sArray = (short[])object;
                                for (int i = 0; i < n9; ++i) {
                                    n11 = sArray[n8++];
                                    this.request[this.msglen++] = (byte)(n11 >> 8);
                                    this.request[this.msglen++] = (byte)n11;
                                }
                                break block56;
                            }
                            case 5: {
                                n9 = n10;
                                int[] nArray = (int[])object;
                                for (int i = 0; i < n9; ++i) {
                                    n11 = nArray[n8++];
                                    this.request[this.msglen++] = (byte)(n11 >> 8);
                                    this.request[this.msglen++] = (byte)n11;
                                }
                                break block56;
                            }
                            case 6: {
                                n9 = n10 / 2;
                                int[] nArray = (int[])object;
                                for (int i = 0; i < n9; ++i) {
                                    n11 = nArray[n8++];
                                    this.request[this.msglen++] = (byte)(n11 >> 8);
                                    this.request[this.msglen++] = (byte)n11;
                                    this.request[this.msglen++] = (byte)(n11 >> 24);
                                    this.request[this.msglen++] = (byte)(n11 >> 16);
                                }
                                break block56;
                            }
                            case 7: 
                            case 10: {
                                n9 = n10 / 2;
                                long[] lArray = (long[])object;
                                for (int i = 0; i < n9; ++i) {
                                    n11 = (int)lArray[n8++];
                                    this.request[this.msglen++] = (byte)(n11 >> 8);
                                    this.request[this.msglen++] = (byte)n11;
                                    this.request[this.msglen++] = (byte)(n11 >> 24);
                                    this.request[this.msglen++] = (byte)(n11 >> 16);
                                }
                                break block56;
                            }
                            case 8: {
                                n9 = n10 / 2;
                                float[] fArray = (float[])object;
                                for (int i = 0; i < n9; ++i) {
                                    n11 = Float.floatToIntBits(fArray[n8++]);
                                    this.request[this.msglen++] = (byte)(n11 >> 8);
                                    this.request[this.msglen++] = (byte)n11;
                                    this.request[this.msglen++] = (byte)(n11 >> 24);
                                    this.request[this.msglen++] = (byte)(n11 >> 16);
                                }
                            }
                        }
                    }
                }
            }
            n9 = this.ProcessXact();
            if (n9 != 0) {
                return n9;
            }
            n4 = (short)(n4 - n10);
            n6 += n10;
        }
        return 0;
    }

    private synchronized int SetByteRef984(byte by, boolean bl, int n, short s, Object object) throws IOException, FCIOException {
        if (by != 4) {
            throw new IllegalReferenceTypeException("IllegalWrite");
        }
        int n2 = n - 1;
        byte by2 = 22;
        short s2 = 8;
        int n3 = 0;
        switch (s) {
            case 2: {
                Object[] objectArray = (byte[])object;
                n3 = objectArray[0] & 0xFF;
                break;
            }
            case 3: {
                Object[] objectArray = (short[])object;
                n3 = objectArray[0] & 0xFF;
            }
        }
        if (bl) {
            n3 <<= 8;
        }
        int n4 = bl ? 255 : 65280;
        this.PackRequestHeader(s2, by2);
        this.request[this.msglen++] = (byte)(n2 >> 8);
        this.request[this.msglen++] = (byte)n2;
        this.request[this.msglen++] = (byte)(n4 >> 8);
        this.request[this.msglen++] = (byte)n4;
        this.request[this.msglen++] = (byte)(n3 >> 8);
        this.request[this.msglen++] = (byte)n3;
        return this.ProcessXact();
    }

    private void PackRequestHeader(short s, byte by) {
        this.xactID = (short)(this.xactID + 1);
        this.msglen = 0;
        this.request[this.msglen++] = (byte)(this.xactID >> 8);
        this.request[this.msglen++] = (byte)this.xactID;
        this.request[this.msglen++] = 0;
        this.request[this.msglen++] = 0;
        this.request[this.msglen++] = (byte)(s >> 8);
        this.request[this.msglen++] = (byte)s;
        this.request[this.msglen++] = this.destID;
        this.request[this.msglen++] = by;
    }

    private int ProcessXact() throws IOException, FCIOException {
        try {
            this.output.write(this.request, 0, this.msglen);
            int n = this.input.read(this.respHdr);
            if (n != this.respHdr.length) {
                if (n == -1) {
                    throw new MBAPReadException("EOFMBAP");
                }
                throw new MBAPReadException("IncompleteMBAP");
            }
            short s = (short)(this.respHdr[0] << 8 | this.respHdr[1] & 0xFF);
            int n2 = (this.respHdr[4] << 8 | this.respHdr[5] & 0xFF) & 0xFFFF;
            if (this.xactID != s) {
                throw new MBAPReadException("BadMBAP");
            }
            n = this.input.read(this.respData, 0, n2);
            if (n != n2) {
                if (n == -1) {
                    throw new MBAPReadException("EOFMBUS");
                }
                throw new MBAPReadException("IncompleteMBUS");
            }
        }
        catch (IOException iOException) {
            System.out.println("IOException processing Modbus transaction: " + iOException.getMessage());
            System.out.println("Resetting connection to PLC!");
            this.reset();
            throw iOException;
        }
        catch (FCIOException fCIOException) {
            System.out.println("FCIOException processing Modbus transaction: " + fCIOException.getMessage());
            System.out.println("Resetting connection to PLC!");
            this.reset();
            throw fCIOException;
        }
        if ((this.respData[1] & 0x80) != 0) {
            return ClientHandler.getModbusError(this.respData[2] & 0xFF);
        }
        if (this.respData[1] == 126 && (this.respData[3] & 0x80) != 0) {
            return ClientHandler.getProgramError(this.respData[4] & 0xFF);
        }
        if (this.respData[1] == 42 && (this.respData[4] != 0 || this.respData[5] != 0)) {
            return ClientHandler.getIECError((this.respData[5] & 0xFF) << 8 | this.respData[4] & 0xFF);
        }
        return 0;
    }

    private static final void checkRefType(byte by, short s) throws IllegalReferenceTypeException {
        boolean bl;
        boolean bl2 = bl = by == 0 || by == 1;
        if (bl && s != 1 || !bl && s == 1) {
            throw new IllegalReferenceTypeException("MismatchDT");
        }
    }

    private static final int getModbusError(int n) {
        return n + 0;
    }

    private static final int getProgramError(int n) {
        return n + 256;
    }

    private static final int getIECError(int n) {
        return n + 512;
    }
}

