/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.ftpsession;

import com.schneiderautomation.ftpsession.FTPSessionErrors;
import com.schneiderautomation.ftpsession.FileInfo;
import com.schneiderautomation.ftpsession.FtpSessionException;
import com.schneiderautomation.misc.GlobalConfig;
import java.awt.TextArea;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

public class FTPSession
implements Runnable {
    static final String EOL = "\n";
    String currentHostName = null;
    Socket s;
    int SocketTimeoutValue = 60000;
    boolean Connected = false;
    boolean LoggedIn = false;
    PrintStream ftpctrlout;
    BufferedReader ftpctrlin;
    PrintStream ftpdataout;
    BufferedReader ftpdatain;
    Vector v;
    Vector files;
    Vector dirs;
    private boolean dataRead = false;
    TextArea ata;
    Socket writerSocket;
    FTPSessionErrors sessionErrs;
    ResourceBundle ftpResourceBundle = null;
    String strData;
    private Boolean fContinue;
    public static final int ASCII = 0;
    public static final int BINARY = 1;
    private int transferMode = 1;
    private boolean modeChange = true;

    public FTPSession() throws FtpSessionException {
        this.setLocale(null);
    }

    public FTPSession(Locale locale) throws FtpSessionException {
        this.setLocale(locale);
    }

    public void setLocale(Locale locale) throws FtpSessionException {
        try {
            this.ftpResourceBundle = locale == null ? ResourceBundle.getBundle("com.schneiderautomation.ftpsession.res.FTPStrBundle") : ResourceBundle.getBundle("com.schneiderautomation.ftpsession.res.FTPStrBundle", locale);
        }
        catch (MissingResourceException missingResourceException) {
            throw new FtpSessionException(missingResourceException.getMessage());
        }
    }

    public boolean isConnected(String string) {
        if (this.currentHostName == null) {
            return false;
        }
        return this.currentHostName.equals(string) && this.Connected;
    }

    public boolean isConnected() {
        return this.Connected;
    }

    public boolean isLoggedIn() {
        return this.LoggedIn;
    }

    public boolean connectHost(String string) throws FtpSessionException {
        int n;
        byte[] byArray = new byte[3];
        String string2 = null;
        this.currentHostName = null;
        this.Connected = false;
        this.LoggedIn = false;
        try {
            this.s = new Socket(string, 21);
        }
        catch (UnknownHostException unknownHostException) {
            throw new FtpSessionException(600, this.ftpResourceBundle);
        }
        catch (IOException iOException) {
            throw new FtpSessionException(601, this.ftpResourceBundle);
        }
        try {
            this.s.setSoTimeout(this.SocketTimeoutValue);
        }
        catch (SocketException socketException) {
            throw new FtpSessionException(627, this.ftpResourceBundle);
        }
        try {
            this.ftpctrlout = new PrintStream(this.s.getOutputStream());
            this.ftpctrlin = new BufferedReader(new InputStreamReader(this.s.getInputStream()));
        }
        catch (IOException iOException) {
            throw new FtpSessionException(602, this.ftpResourceBundle);
        }
        try {
            string2 = this.ctrlReadLine();
        }
        catch (IOException iOException) {
            this.Connected = false;
            this.LoggedIn = false;
            throw new FtpSessionException(603, this.ftpResourceBundle);
        }
        try {
            n = Integer.parseInt(string2.substring(0, 3));
        }
        catch (NumberFormatException numberFormatException) {
            throw new FtpSessionException(604, this.ftpResourceBundle);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new FtpSessionException(605, this.ftpResourceBundle);
        }
        if (n != 220) {
            throw new FtpSessionException(606, this.ftpResourceBundle);
        }
        this.currentHostName = string;
        this.Connected = true;
        return true;
    }

    public void login(String string, String string2) throws FtpSessionException {
        this.LoggedIn = false;
        String string3 = GlobalConfig.getFtpUser();
        String string4 = GlobalConfig.getFtpPassword();
        if (string3 != null) {
            string = string3;
        }
        if (string4 != null) {
            string2 = string4;
        }
        if (string == null) {
            throw new FtpSessionException(607, this.ftpResourceBundle);
        }
        try {
            int n = this.doCmd("USER " + string + EOL);
            if (n != 331) {
                throw new FtpSessionException(608, this.ftpResourceBundle);
            }
            n = this.doCmd("PASS " + string2 + EOL);
            if (n != 230) {
                throw new FtpSessionException(608, this.ftpResourceBundle);
            }
        }
        catch (FtpSessionException ftpSessionException) {
            throw new FtpSessionException(609, this.ftpResourceBundle);
        }
        this.LoggedIn = true;
    }

    public void setTransferMode(int n) {
        if (n != this.transferMode && (n == 0 || n == 1)) {
            this.transferMode = n;
            this.modeChange = true;
        }
        this.modeChange = true;
    }

    private synchronized String ctrlReadLine() throws IOException {
        this.strData = null;
        Thread thread = new Thread(this);
        thread.start();
        try {
            this.wait(this.SocketTimeoutValue);
        }
        catch (InterruptedException interruptedException) {
            throw new IOException();
        }
        if (this.strData == null) {
            throw new IOException();
        }
        return this.strData;
    }

    private synchronized String clearCtrlLine() throws IOException {
        this.strData = null;
        Thread thread = new Thread(this);
        thread.start();
        try {
            this.wait(this.SocketTimeoutValue);
        }
        catch (InterruptedException interruptedException) {
            throw new IOException();
        }
        return this.strData;
    }

    private synchronized void semaphoreMethod() {
        try {
            this.strData = this.ftpctrlin.readLine();
        }
        catch (IOException iOException) {
            this.strData = null;
        }
        this.notify();
    }

    public void run() {
        this.semaphoreMethod();
    }

    public String getPWD() throws FtpSessionException {
        int n = 0;
        String string = null;
        this.ftpctrlout.print("XPWD\n");
        try {
            string = this.ctrlReadLine();
        }
        catch (IOException iOException) {
            this.Connected = false;
            this.LoggedIn = false;
            throw new FtpSessionException(603, this.ftpResourceBundle);
        }
        try {
            n = Integer.parseInt(string.substring(0, 3));
        }
        catch (NumberFormatException numberFormatException) {
            throw new FtpSessionException(604, this.ftpResourceBundle);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new FtpSessionException(605, this.ftpResourceBundle);
        }
        if (n == 257) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\"");
            stringTokenizer.nextToken();
            return stringTokenizer.nextToken();
        }
        throw new FtpSessionException(610, this.ftpResourceBundle);
    }

    public boolean deleteDir(String string) throws FtpSessionException {
        int n = 0;
        n = this.doCmd("RMD " + string + EOL);
        if (n != 250 && n != 200) {
            throw new FtpSessionException(612, this.ftpResourceBundle);
        }
        return true;
    }

    public String literalCommand(String string) throws FtpSessionException {
        this.ftpctrlout.print(string + EOL);
        if (string.equalsIgnoreCase("free")) {
            return this.literalFree();
        }
        if (string.equalsIgnoreCase("format")) {
            this.literalFormat();
        }
        return null;
    }

    public String literalFree() throws FtpSessionException {
        String string = null;
        int n = 0;
        try {
            string = this.ctrlReadLine();
        }
        catch (IOException iOException) {
            this.Connected = false;
            this.LoggedIn = false;
            throw new FtpSessionException(627, this.ftpResourceBundle);
        }
        try {
            n = Integer.parseInt(string.substring(0, 3));
        }
        catch (NumberFormatException numberFormatException) {
            throw new FtpSessionException(604, this.ftpResourceBundle);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new FtpSessionException(605, this.ftpResourceBundle);
        }
        if (n != 250) {
            throw new FtpSessionException(627, this.ftpResourceBundle);
        }
        int n2 = string.lastIndexOf(":");
        if (n2 <= 0) {
            throw new FtpSessionException(627, this.ftpResourceBundle);
        }
        String string2 = string.substring(n2 + 1).trim();
        return string2;
    }

    public void literalFormat() throws FtpSessionException {
        String string = null;
        int n = 0;
        try {
            string = this.ctrlReadLine();
        }
        catch (IOException iOException) {
            this.Connected = false;
            this.LoggedIn = false;
            throw new FtpSessionException(627, this.ftpResourceBundle);
        }
        try {
            n = Integer.parseInt(string.substring(0, 3));
        }
        catch (NumberFormatException numberFormatException) {
            throw new FtpSessionException(604, this.ftpResourceBundle);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new FtpSessionException(605, this.ftpResourceBundle);
        }
        while (n != 250) {
            if (n == 501) {
                throw new FtpSessionException(630, this.ftpResourceBundle);
            }
            if (n == 550) {
                throw new FtpSessionException(630, this.ftpResourceBundle);
            }
            try {
                string = this.ctrlReadLine();
            }
            catch (IOException iOException) {
                this.Connected = false;
                this.LoggedIn = false;
                throw new FtpSessionException(627, this.ftpResourceBundle);
            }
            try {
                n = Integer.parseInt(string.substring(0, 3));
            }
            catch (NumberFormatException numberFormatException) {
                throw new FtpSessionException(604, this.ftpResourceBundle);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                throw new FtpSessionException(605, this.ftpResourceBundle);
            }
        }
    }

    public boolean makeDIR(String string) throws FtpSessionException {
        int n = 0;
        String string2 = null;
        this.ftpctrlout.print("MKD " + string + EOL);
        try {
            string2 = this.ctrlReadLine();
        }
        catch (IOException iOException) {
            this.Connected = false;
            this.LoggedIn = false;
            throw new FtpSessionException(603, this.ftpResourceBundle);
        }
        try {
            n = Integer.parseInt(string2.substring(0, 3));
        }
        catch (NumberFormatException numberFormatException) {
            throw new FtpSessionException(604, this.ftpResourceBundle);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new FtpSessionException(605, this.ftpResourceBundle);
        }
        if (n != 257) {
            throw new FtpSessionException(613, this.ftpResourceBundle);
        }
        return true;
    }

    public boolean renameFile(String string, String string2) throws FtpSessionException {
        int n;
        String string3;
        this.ftpctrlout.print("RNFR " + string + EOL);
        try {
            string3 = this.ctrlReadLine();
        }
        catch (IOException iOException) {
            this.Connected = false;
            this.LoggedIn = false;
            throw new FtpSessionException(603, this.ftpResourceBundle);
        }
        try {
            n = Integer.parseInt(string3.substring(0, 3));
        }
        catch (NumberFormatException numberFormatException) {
            throw new FtpSessionException(604, this.ftpResourceBundle);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new FtpSessionException(605, this.ftpResourceBundle);
        }
        if (n != 350) {
            throw new FtpSessionException(629, this.ftpResourceBundle);
        }
        this.ftpctrlout.print("RNTO " + string2 + EOL);
        try {
            string3 = this.ctrlReadLine();
        }
        catch (IOException iOException) {
            this.Connected = false;
            this.LoggedIn = false;
            throw new FtpSessionException(603, this.ftpResourceBundle);
        }
        try {
            n = Integer.parseInt(string3.substring(0, 3));
        }
        catch (NumberFormatException numberFormatException) {
            throw new FtpSessionException(604, this.ftpResourceBundle);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new FtpSessionException(605, this.ftpResourceBundle);
        }
        if (n != 250 && n != 200) {
            throw new FtpSessionException(629, this.ftpResourceBundle);
        }
        return true;
    }

    public boolean changeDir(String string) throws FtpSessionException {
        int n = 0;
        n = this.doCmd("CWD " + string + EOL);
        if (n != 250 && n != 200) {
            throw new FtpSessionException(614, this.ftpResourceBundle);
        }
        return true;
    }

    public BufferedInputStream getFile(String string) throws FtpSessionException {
        Socket socket;
        BufferedInputStream bufferedInputStream = null;
        if (this.modeChange) {
            int n = this.transferMode == 0 ? this.doCmd("TYPE A\n") : this.doCmd("TYPE I\n");
            if (n != 200) {
                throw new FtpSessionException(615, this.ftpResourceBundle);
            }
            this.modeChange = false;
        }
        if ((socket = this.doIOCmd("RETR " + string + EOL)) == null) {
            throw new FtpSessionException(618, this.ftpResourceBundle);
        }
        try {
            socket.setSoTimeout(this.SocketTimeoutValue);
        }
        catch (SocketException socketException) {
            throw new FtpSessionException(627, this.ftpResourceBundle);
        }
        try {
            bufferedInputStream = new BufferedInputStream(socket.getInputStream());
        }
        catch (IOException iOException) {
            throw new FtpSessionException(621, this.ftpResourceBundle, iOException.getMessage());
        }
        return bufferedInputStream;
    }

    public BufferedOutputStream putFile(String string) throws FtpSessionException {
        BufferedOutputStream bufferedOutputStream = null;
        if (this.modeChange) {
            int n = this.transferMode == 0 ? this.doCmd("TYPE A\n") : this.doCmd("TYPE I\n");
            if (n != 200) {
                throw new FtpSessionException(615, this.ftpResourceBundle);
            }
            this.modeChange = false;
        }
        this.writerSocket = this.doIOCmd("STOR " + string + EOL);
        if (this.writerSocket == null) {
            throw new FtpSessionException(618, this.ftpResourceBundle);
        }
        try {
            this.writerSocket.setSoTimeout(this.SocketTimeoutValue);
        }
        catch (SocketException socketException) {
            throw new FtpSessionException(627, this.ftpResourceBundle);
        }
        try {
            bufferedOutputStream = new BufferedOutputStream(this.writerSocket.getOutputStream());
        }
        catch (IOException iOException) {
            throw new FtpSessionException(622, this.ftpResourceBundle, iOException.getMessage());
        }
        return bufferedOutputStream;
    }

    public boolean deleteFile(String string) throws FtpSessionException {
        int n = this.doCmd("DELE " + string + EOL);
        if (n != 250 && n != 200) {
            throw new FtpSessionException(617, this.ftpResourceBundle);
        }
        return true;
    }

    public synchronized void timeOut(long l) throws FtpSessionException {
        try {
            this.wait(l);
        }
        catch (InterruptedException interruptedException) {
            throw new FtpSessionException(618, this.ftpResourceBundle);
        }
    }

    public int getPASV() throws FtpSessionException {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        do {
            this.ftpctrlout.print("PASV\n");
            try {
                String string = this.ctrlReadLine();
                n2 = Integer.parseInt(string.substring(0, 3));
                if (n2 == 425) {
                    if (n3++ > 60) {
                        throw new FtpSessionException(618, this.ftpResourceBundle);
                    }
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string, "(,)");
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                int n4 = Integer.parseInt(stringTokenizer.nextToken());
                int n5 = Integer.parseInt(stringTokenizer.nextToken());
                n = n4 * 256 + n5;
            }
            catch (IOException iOException) {
                throw new FtpSessionException(603, this.ftpResourceBundle);
            }
            catch (NumberFormatException numberFormatException) {
                throw new FtpSessionException(604, this.ftpResourceBundle);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                throw new FtpSessionException(605, this.ftpResourceBundle);
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new FtpSessionException(603, this.ftpResourceBundle);
            }
        } while (n2 == 425);
        return n;
    }

    private Socket doIOCmd(String string) throws FtpSessionException {
        int n;
        Object var2_2 = null;
        Socket socket = null;
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            throw new FtpSessionException(600, this.ftpResourceBundle);
        }
        int n2 = this.getPASV();
        for (n = 0; n <= 60; ++n) {
            try {
                socket = new Socket(this.currentHostName, n2);
                break;
            }
            catch (IOException iOException) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        if (n > 60) {
            throw new FtpSessionException(600, this.ftpResourceBundle);
        }
        try {
            socket.setSoTimeout(this.SocketTimeoutValue);
        }
        catch (SocketException socketException) {
            throw new FtpSessionException(627, this.ftpResourceBundle);
        }
        int n3 = this.doCmd(string);
        if (n3 == 550) {
            return null;
        }
        return socket;
    }

    private int doCmd(String string) throws FtpSessionException {
        int n;
        String string2 = null;
        this.ftpctrlout.print(string);
        try {
            string2 = this.ctrlReadLine();
        }
        catch (IOException iOException) {
            this.Connected = false;
            this.LoggedIn = false;
            throw new FtpSessionException(603, this.ftpResourceBundle);
        }
        try {
            n = Integer.parseInt(string2.substring(0, 3));
        }
        catch (NumberFormatException numberFormatException) {
            throw new FtpSessionException(604, this.ftpResourceBundle);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new FtpSessionException(605, this.ftpResourceBundle);
        }
        while (n == 100 || n == 220) {
            try {
                string2 = this.ctrlReadLine();
            }
            catch (IOException iOException) {
                this.Connected = false;
                this.LoggedIn = false;
                throw new FtpSessionException(603, this.ftpResourceBundle);
            }
            try {
                n = Integer.parseInt(string2.substring(0, 3));
            }
            catch (NumberFormatException numberFormatException) {
                throw new FtpSessionException(604, this.ftpResourceBundle);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                throw new FtpSessionException(605, this.ftpResourceBundle);
            }
        }
        if (string2.charAt(3) == '-') {
            int n2 = 0;
            do {
                try {
                    string2 = this.ctrlReadLine();
                }
                catch (IOException iOException) {
                    this.Connected = false;
                    this.LoggedIn = false;
                    throw new FtpSessionException(603, this.ftpResourceBundle);
                }
                n2 = -1;
                if (string2.length() <= 0) continue;
                try {
                    n2 = Integer.parseInt(string2.substring(0, 3));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new FtpSessionException(604, this.ftpResourceBundle);
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    throw new FtpSessionException(605, this.ftpResourceBundle);
                }
            } while (n2 != n || string2.charAt(3) != ' ');
        }
        return n;
    }

    public void closeSession() throws FtpSessionException {
        if (this.Connected) {
            try {
                this.ftpctrlin.close();
                this.ftpctrlout.close();
            }
            catch (IOException iOException) {
                this.currentHostName = null;
                this.Connected = false;
                this.LoggedIn = false;
                this.dataRead = false;
                throw new FtpSessionException(609, this.ftpResourceBundle);
            }
        }
        this.currentHostName = null;
        this.Connected = false;
        this.LoggedIn = false;
        this.dataRead = false;
    }

    public void quit() throws FtpSessionException {
        if (this.Connected) {
            try {
                this.doCmd("QUIT\n");
            }
            catch (FtpSessionException ftpSessionException) {
                this.closeSession();
                throw new FtpSessionException(609, this.ftpResourceBundle);
            }
        }
        this.closeSession();
    }

    public void readComplete() throws FtpSessionException {
        String string = null;
        try {
            string = this.ctrlReadLine();
        }
        catch (IOException iOException) {
            this.Connected = false;
            this.LoggedIn = false;
            throw new FtpSessionException(603, this.ftpResourceBundle);
        }
        while (string != null) {
            int n;
            try {
                n = Integer.parseInt(string.substring(0, 3));
            }
            catch (NumberFormatException numberFormatException) {
                throw new FtpSessionException(604, this.ftpResourceBundle);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                throw new FtpSessionException(605, this.ftpResourceBundle);
            }
            if (n == 226) break;
            if (n < 100 || n >= 200) {
                throw new FtpSessionException(620, this.ftpResourceBundle);
            }
            try {
                string = this.ctrlReadLine();
            }
            catch (IOException iOException) {
                this.Connected = false;
                this.LoggedIn = false;
                throw new FtpSessionException(621, this.ftpResourceBundle, iOException.getMessage());
            }
        }
    }

    public void writeComplete() throws FtpSessionException {
        String string = null;
        try {
            this.writerSocket.close();
            string = this.clearCtrlLine();
        }
        catch (IOException iOException) {
            this.Connected = false;
            this.LoggedIn = false;
            throw new FtpSessionException(621, this.ftpResourceBundle, iOException.getMessage());
        }
        while (string != null) {
            int n;
            try {
                n = Integer.parseInt(string.substring(0, 3));
            }
            catch (NumberFormatException numberFormatException) {
                throw new FtpSessionException(604, this.ftpResourceBundle);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                throw new FtpSessionException(605, this.ftpResourceBundle);
            }
            if (n == 226) break;
            if (n < 100 || n >= 200) {
                throw new FtpSessionException(620, this.ftpResourceBundle);
            }
            try {
                string = this.ctrlReadLine();
            }
            catch (IOException iOException) {
                this.Connected = false;
                this.LoggedIn = false;
                throw new FtpSessionException(621, this.ftpResourceBundle, iOException.getMessage());
            }
        }
    }

    public Vector getFileList() throws FtpSessionException {
        BufferedReader bufferedReader = null;
        String string = null;
        boolean bl = false;
        this.v = new Vector(100);
        Socket socket = this.doIOCmd("LIST\n");
        if (socket == null) {
            return this.v;
        }
        try {
            socket.setSoTimeout(this.SocketTimeoutValue);
        }
        catch (SocketException socketException) {
            throw new FtpSessionException(627, this.ftpResourceBundle);
        }
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        }
        catch (IOException iOException) {
            throw new FtpSessionException(625, this.ftpResourceBundle, iOException.getMessage());
        }
        bl = false;
        while (!bl) {
            try {
                string = bufferedReader.readLine();
            }
            catch (IOException iOException) {
                throw new FtpSessionException(603, this.ftpResourceBundle, iOException.getMessage());
            }
            if (string == null) {
                bl = true;
                continue;
            }
            if (string.toLowerCase().startsWith("total")) continue;
            this.v.addElement(new FileInfo(string));
        }
        this.readComplete();
        try {
            socket.close();
        }
        catch (IOException iOException) {
            throw new FtpSessionException(626, this.ftpResourceBundle, iOException.getMessage());
        }
        return this.v;
    }

    public String getDirName(String string) {
        String string2 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreElements()) {
            string2 = stringTokenizer.nextToken();
        }
        String string3 = string2.substring(0, string2.length() - 1);
        return string3;
    }

    public String getFileName(String string) {
        String string2 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreElements()) {
            string2 = stringTokenizer.nextToken();
        }
        char c = string2.charAt(string2.length() - 1);
        if (c == '*' || c == '@' || c == '=') {
            return string2.substring(0, string2.length() - 1);
        }
        return string2;
    }
}

