/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.vars;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.StringTokenizer;

public class VarInfo
implements Serializable {
    static final long serialVersionUID = 5514404605200016864L;
    private String name;
    private String address;
    private long idSymbol;
    private int offset;
    private int idDataType;
    private short variableType;
    private short symbolType;
    private boolean readOnly;
    private int symbolID;
    private short dataType;

    public VarInfo() {
    }

    public VarInfo(String string, String string2, long l, int n, int n2, short s, short s2, boolean bl) {
        this.name = string;
        this.address = string2;
        this.idSymbol = l;
        this.offset = n;
        this.idDataType = n2;
        this.variableType = s;
        this.symbolType = s2;
        this.readOnly = bl;
    }

    public String getName() {
        return this.name;
    }

    public String getAddress() {
        return this.address;
    }

    public long getSymbolID() {
        return this.idSymbol;
    }

    public int getOffset() {
        return this.offset;
    }

    public short getDataType() {
        return (short)this.idDataType;
    }

    public short getMaxStrLen() {
        return (short)(this.idDataType >> 16);
    }

    public short getVariableType() {
        return this.variableType;
    }

    public short getSymbolType() {
        return this.symbolType;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    public void writeData(PrintWriter printWriter) throws IOException {
        printWriter.print("|" + this.name);
        printWriter.print("|" + this.address);
        printWriter.print("|" + this.idSymbol);
        printWriter.print("|" + this.offset);
        printWriter.print("|" + this.idDataType);
        printWriter.print("|" + this.variableType);
        printWriter.print("|" + this.symbolType);
        printWriter.println("|" + this.readOnly);
    }

    public boolean readData(BufferedReader bufferedReader) throws IOException {
        String string = bufferedReader.readLine();
        if (string == null) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        this.name = stringTokenizer.nextToken();
        this.address = stringTokenizer.nextToken();
        this.idSymbol = Long.parseLong(stringTokenizer.nextToken());
        this.offset = Integer.parseInt(stringTokenizer.nextToken());
        this.idDataType = Integer.parseInt(stringTokenizer.nextToken());
        this.variableType = Short.parseShort(stringTokenizer.nextToken());
        this.symbolType = Short.parseShort(stringTokenizer.nextToken());
        this.readOnly = Boolean.valueOf(stringTokenizer.nextToken());
        return true;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        try {
            objectInputStream.defaultReadObject();
            if (this.symbolID != 0) {
                this.idSymbol = this.symbolID;
                this.symbolID = 0;
            }
            if (this.dataType != 0) {
                this.idDataType = this.dataType;
                this.dataType = 0;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("ClassNotFoundException reading VarInfo object: " + classNotFoundException.getMessage());
        }
    }
}

