/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.widgets;

import com.schneiderautomation.widgets.DeadbandFilter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.Serializable;

abstract class Bar
implements Serializable {
    static final long serialVersionUID = -5543615966263683005L;
    private transient DeadbandFilter dbfilter;
    protected float value = 0.0f;
    protected float minimum = 0.0f;
    protected float maximum = 100.0f;
    protected int deadband = 0;
    protected Color foreground = Color.blue;
    protected Color background = Color.cyan;
    protected Rectangle box = new Rectangle();
    protected float[] limits = new float[]{this.minimum, this.minimum, this.maximum, this.maximum};
    protected Color[] colors = new Color[]{Color.red, Color.yellow, Color.yellow, Color.red};

    Bar() {
    }

    abstract void paint(Graphics var1);

    abstract Dimension getMinimumSize();

    void setBounds(Rectangle rectangle) {
        this.box = rectangle;
    }

    void setValue(float f) {
        this.value = f;
    }

    float getValue() {
        return this.value;
    }

    void setForeground(Color color) {
        this.foreground = color;
    }

    Color getForeground() {
        return this.foreground;
    }

    void setBackground(Color color) {
        this.background = color;
    }

    Color getBackground() {
        return this.background;
    }

    void setDeadband(int n) {
        this.deadband = Math.min(Math.max(n, 0), 10);
        if (this.dbfilter != null) {
            this.dbfilter.setDeadband(this.minimum, this.maximum, this.deadband);
        }
    }

    int getDeadband() {
        return this.deadband;
    }

    void setLimitColor(int n, Color color) {
        this.colors[n] = color;
    }

    Color getLimitColor(int n) {
        return this.colors[n];
    }

    void setLimitValue(int n, float f) {
        this.limits[n] = Math.min(Math.max(f, this.minimum), this.maximum);
    }

    float getLimitValue(int n) {
        return this.limits[n];
    }

    void setMinimum(float f) {
        if ((f = Bar.limitFloat(f)) > this.maximum) {
            f = this.maximum;
        }
        this.minimum = f;
        for (int i = 0; i < this.limits.length; ++i) {
            this.limits[i] = Math.max(this.limits[i], this.minimum);
        }
        if (this.dbfilter != null) {
            this.dbfilter.setDeadband(this.minimum, this.maximum, this.deadband);
        }
    }

    float getMinimum() {
        return this.minimum;
    }

    void setMaximum(float f) {
        if ((f = Bar.limitFloat(f)) < this.minimum) {
            f = this.minimum;
        }
        this.maximum = f;
        for (int i = 0; i < this.limits.length; ++i) {
            this.limits[i] = Math.min(this.limits[i], this.maximum);
        }
        if (this.dbfilter != null) {
            this.dbfilter.setDeadband(this.minimum, this.maximum, this.deadband);
        }
    }

    float getMaximum() {
        return this.maximum;
    }

    protected Color barColor() {
        if (this.dbfilter == null) {
            this.dbfilter = new DeadbandFilter(this.value);
            this.dbfilter.setDeadband(this.minimum, this.maximum, this.deadband);
        } else {
            this.dbfilter.newValue(this.value);
        }
        if (this.dbfilter.lowValue() < this.limits[0]) {
            return this.colors[0];
        }
        if (this.dbfilter.lowValue() < this.limits[1]) {
            return this.colors[1];
        }
        if (this.dbfilter.highValue() > this.limits[3]) {
            return this.colors[3];
        }
        if (this.dbfilter.highValue() > this.limits[2]) {
            return this.colors[2];
        }
        return this.foreground;
    }

    static final float limitFloat(float f) {
        if (f > 0.0f) {
            return Math.min(Math.max(f, Float.MIN_VALUE), Float.MAX_VALUE);
        }
        if (f < 0.0f) {
            return Math.min(Math.max(f, -3.4028235E38f), -1.4E-45f);
        }
        return f;
    }
}

