/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.widgets;

import com.schneiderautomation.dt.FT;
import com.schneiderautomation.widgets.Bar;
import com.schneiderautomation.widgets.DeadbandFilter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;

class DDisplay
implements Serializable {
    static final long serialVersionUID = 8468796123164988639L;
    private transient DecimalFormat formatter;
    private transient DeadbandFilter dbfilter;
    private short datatype = (short)7;
    private Rectangle box = new Rectangle();
    private Number value = new Integer(0);
    private String units = "";
    private float minimum = 0.0f;
    private float maximum = 100.0f;
    private int deadband = 0;
    private int format = 2;
    private int precision = 0;
    private Color foreground = Color.black;
    private Color background = Color.lightGray;
    private Font font = new Font("SansSerif", 0, 18);
    private float[] limits = new float[]{this.minimum, this.minimum, this.maximum, this.maximum};
    private Color[] colors = new Color[]{Color.red, Color.yellow, Color.yellow, Color.red};

    DDisplay() {
    }

    Dimension getMinimumSize() {
        int n = Toolkit.getDefaultToolkit().getFontMetrics(this.font).getHeight();
        int n2 = 16;
        return new Dimension(n2, n);
    }

    void setBounds(Rectangle rectangle) {
        this.box = rectangle;
    }

    void setDatatype(short s) {
        this.datatype = s;
    }

    void setValue(Number number) {
        this.value = number;
    }

    Number getValue() {
        return this.value;
    }

    void setUnits(String string) {
        this.units = string;
    }

    String getUnits() {
        return this.units;
    }

    void setFormat(int n) {
        this.format = n;
    }

    int getFormat() {
        return this.format;
    }

    void setForeground(Color color) {
        this.foreground = color;
    }

    Color getForeground() {
        return this.foreground;
    }

    void setBackground(Color color) {
        this.background = color;
    }

    Color getBackground() {
        return this.background;
    }

    void setFont(Font font) {
        this.font = font;
    }

    Font getFont() {
        return this.font;
    }

    void setDeadband(int n) {
        this.deadband = Math.min(Math.max(n, 0), 10);
        if (this.dbfilter != null) {
            this.dbfilter.setDeadband(this.minimum, this.maximum, this.deadband);
        }
    }

    int getDeadband() {
        return this.deadband;
    }

    void setPrecision(int n) {
        this.precision = Math.min(Math.max(n, -1), 6);
        if (this.formatter != null && this.precision >= 0) {
            this.formatter.setMaximumFractionDigits(this.precision);
            this.formatter.setMinimumFractionDigits(this.precision);
        }
    }

    int getPrecision() {
        return this.precision;
    }

    void setLimitColor(int n, Color color) {
        this.colors[n] = color;
    }

    Color getLimitColor(int n) {
        return this.colors[n];
    }

    void setLimitValue(int n, float f) {
        this.limits[n] = Math.min(Math.max(f, this.minimum), this.maximum);
    }

    float getLimitValue(int n) {
        return this.limits[n];
    }

    void setMinimum(float f) {
        if ((f = Bar.limitFloat(f)) > this.maximum) {
            f = this.maximum;
        }
        this.minimum = f;
        for (int i = 0; i < this.limits.length; ++i) {
            this.limits[i] = Math.max(this.limits[i], this.minimum);
        }
        if (this.dbfilter != null) {
            this.dbfilter.setDeadband(this.minimum, this.maximum, this.deadband);
        }
    }

    float getMinimum() {
        return this.minimum;
    }

    void setMaximum(float f) {
        if ((f = Bar.limitFloat(f)) < this.minimum) {
            f = this.minimum;
        }
        this.maximum = f;
        for (int i = 0; i < this.limits.length; ++i) {
            this.limits[i] = Math.min(this.limits[i], this.maximum);
        }
        if (this.dbfilter != null) {
            this.dbfilter.setDeadband(this.minimum, this.maximum, this.deadband);
        }
    }

    float getMaximum() {
        return this.maximum;
    }

    void paint(Graphics graphics) {
        int n;
        FontMetrics fontMetrics = graphics.getFontMetrics(this.font);
        String string = this.formattedValue();
        if (this.units.length() > 0) {
            string = string + " " + this.units;
        }
        if ((n = this.box.x + (this.box.width - fontMetrics.stringWidth(string)) / 2) < this.box.x) {
            n = this.box.x;
        }
        int n2 = this.box.y + (this.box.height + fontMetrics.getHeight()) / 2 - fontMetrics.getDescent();
        graphics.setColor(this.background);
        graphics.fillRect(this.box.x, this.box.y, this.box.width, this.box.height);
        graphics.setColor(this.valueColor());
        graphics.setFont(this.font);
        graphics.drawString(string, n, n2);
    }

    private String formattedValue() {
        if (this.formatter == null && this.precision >= 0) {
            this.formatter = (DecimalFormat)NumberFormat.getInstance();
            this.formatter.setMaximumFractionDigits(this.precision);
            this.formatter.setMinimumFractionDigits(this.precision);
        }
        switch (this.format) {
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                return FT.formatValue((Number)this.value, (int)this.format, (short)this.datatype);
            }
            case 2: {
                if (this.precision < 0) {
                    return this.value.toString();
                }
                return this.formatter.format(this.value.doubleValue());
            }
        }
        return "?";
    }

    private Color valueColor() {
        if (this.dbfilter == null) {
            this.dbfilter = new DeadbandFilter(this.value.floatValue());
            this.dbfilter.setDeadband(this.minimum, this.maximum, this.deadband);
        } else {
            this.dbfilter.newValue(this.value.floatValue());
        }
        if (this.dbfilter.lowValue() < this.limits[0]) {
            return this.colors[0];
        }
        if (this.dbfilter.lowValue() < this.limits[1]) {
            return this.colors[1];
        }
        if (this.dbfilter.highValue() > this.limits[3]) {
            return this.colors[3];
        }
        if (this.dbfilter.highValue() > this.limits[2]) {
            return this.colors[2];
        }
        return this.foreground;
    }
}

