/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.widgets;

import com.schneiderautomation.dt.DT;
import com.schneiderautomation.factorycast.MonitorNumber;
import com.schneiderautomation.factorycast.MonitorRef;
import com.schneiderautomation.factorycast.ServerChangeEvent;
import com.schneiderautomation.factorycast.SetNumber;
import com.schneiderautomation.factorycast.SetRef;
import com.schneiderautomation.gde.GraphicalObject;
import com.schneiderautomation.gde.MonitorSupport;
import com.schneiderautomation.gde.WriteSupport;
import com.schneiderautomation.widgets.Bar;
import com.schneiderautomation.widgets.DirectOutputGui;
import com.schneiderautomation.widgets.InputActionListener;
import java.awt.event.ActionEvent;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.io.Serializable;

public class DirectOutput
extends DirectOutputGui
implements GraphicalObject,
InputActionListener,
TextListener,
Serializable {
    static final long serialVersionUID = 4130676093346989617L;
    private transient boolean fEnabled;
    private SetNumber setter = new SetNumber();
    private MonitorNumber monitor = new MonitorNumber();
    private WriteSupport writeSupport = new WriteSupport((SetRef)this.setter, (GraphicalObject)this);
    private MonitorSupport readSupport = new MonitorSupport((MonitorRef)this.monitor, (GraphicalObject)this);
    private float minInputValue;
    private float maxInputValue;
    private float minValue;
    private float maxValue;
    private float minimum;
    private float maximum;

    public DirectOutput() {
        this.addInputActionListener(this);
        this.addTextListener(this);
        this.minimum = 0.0f;
        this.minValue = 0.0f;
        this.minInputValue = 0.0f;
        this.maximum = 100.0f;
        this.maxValue = 100.0f;
        this.maxInputValue = 100.0f;
    }

    public void serverChanged(ServerChangeEvent serverChangeEvent) {
        this.monitor.serverChanged(serverChangeEvent);
        this.setter.serverChanged(serverChangeEvent);
        if (serverChangeEvent.getCommBean() != null) {
            this.setter.enableAccessChecking(serverChangeEvent.getVarLookup());
            this.setEnabled(this.fEnabled);
        } else {
            this.setEnabled(false);
        }
    }

    public void enableUserInput() {
        this.fEnabled = true;
        this.setEnabled(this.fEnabled);
    }

    public void disableUserInput() {
        this.fEnabled = false;
        this.setEnabled(this.fEnabled);
    }

    public String getStatus() {
        return this.readSupport.getStatus();
    }

    public boolean isErrorStatus() {
        return this.readSupport.isErrorStatus();
    }

    public String getAddress() {
        return this.monitor.getAddress();
    }

    public void setAddress(String string) {
        this.monitor.setAddress(string);
        this.setter.setAddress(this.monitor.getAddress());
    }

    public short getDatatype() {
        return this.monitor.getDatatype();
    }

    public void setDatatype(short s) {
        this.monitor.setDatatype(s);
        this.setter.setDatatype(this.monitor.getDatatype());
        this.setMinValue(this.minValue);
        this.setMaxValue(this.maxValue);
    }

    public void setMinimum(float f) {
        if ((f = Bar.limitFloat(f)) > this.maximum) {
            f = this.maximum;
        }
        this.minimum = f;
        this.setMinInputValue(this.minInputValue);
        this.setMaxInputValue(this.maxInputValue);
    }

    public float getMinimum() {
        return this.minimum;
    }

    public void setMaximum(float f) {
        if ((f = Bar.limitFloat(f)) < this.minimum) {
            f = this.minimum;
        }
        this.maximum = f;
        this.setMinInputValue(this.minInputValue);
        this.setMaxInputValue(this.maxInputValue);
    }

    public float getMaximum() {
        return this.maximum;
    }

    public void setMinValue(float f) {
        short s = this.getDatatype();
        if ((f = (float)Math.min(Math.max((double)f, DT.minValue((short)s)), DT.maxValue((short)s))) > this.maxValue) {
            f = this.maxValue;
        }
        this.minValue = f;
    }

    public float getMinValue() {
        return this.minValue;
    }

    public void setMaxValue(float f) {
        short s = this.getDatatype();
        if ((f = (float)Math.min(Math.max((double)f, DT.minValue((short)s)), DT.maxValue((short)s))) < this.minValue) {
            f = this.minValue;
        }
        this.maxValue = f;
    }

    public float getMaxValue() {
        return this.maxValue;
    }

    public void setMinInputValue(float f) {
        if ((f = Math.min(Math.max(f, this.minimum), this.maximum)) > this.maxInputValue) {
            f = this.maxInputValue;
        }
        this.minInputValue = f;
    }

    public float getMinInputValue() {
        return this.minInputValue;
    }

    public void setMaxInputValue(float f) {
        if ((f = Math.min(Math.max(f, this.minimum), this.maximum)) < this.minInputValue) {
            f = this.minInputValue;
        }
        this.maxInputValue = f;
    }

    public float getMaxInputValue() {
        return this.maxInputValue;
    }

    public void textValueChanged(TextEvent textEvent) {
        boolean bl = false;
        String string = this.getText();
        if (string.length() > 0) {
            try {
                float f = Float.valueOf(string).floatValue();
                bl = f >= this.minInputValue && f <= this.maxInputValue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.setInputActionEnabled(bl);
    }

    public void inputActionPerformed(ActionEvent actionEvent) {
        if (this.fEnabled) {
            try {
                float f = Float.valueOf(this.getText()).floatValue();
                float f2 = (this.maximum - this.minimum) / (this.maxValue - this.minValue);
                float f3 = (f - this.minimum) / f2 + this.minValue;
                this.setter.setValue((Number)new Float(f3));
                this.setter.sendValues();
            }
            catch (Exception exception) {
                this.writeSupport.setStatus(true, exception.getMessage());
            }
        }
    }
}

