/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.widgets;

import com.schneiderautomation.gde.GdeTopPanel;
import com.schneiderautomation.gde.Wrapper;
import com.schneiderautomation.widgets.Border;
import com.schneiderautomation.widgets.CircularIndicator;
import com.schneiderautomation.widgets.GenericImageLoader;
import com.schneiderautomation.widgets.HLabel;
import com.schneiderautomation.widgets.RScale;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.Serializable;

public class ExtMeterGui
extends Canvas
implements Serializable {
    static final long serialVersionUID = -8413083267058708236L;
    public static final int NEEDLE_POINTER = 0;
    public static final int ARROW_POINTER = 1;
    public static final int HAND_POINTER = 2;
    private String sBitmap = "Vumeter_1_180.png";
    private Border border = new Border();
    private HLabel label = new HLabel();
    private RScale scale = new RScale();
    private CircularIndicator indicator = new CircularIndicator();
    private int indexfin;
    private int iSweep;
    protected boolean bstatusError = false;

    public ExtMeterGui() {
        this.InitWrapper();
        this.indicator.setDegSweep(this.scale.getDegSweep());
        this.indicator.setDialBandWidth(this.scale.getDialBandWidth());
        this.scale.setBottomPad(10);
        this.setDegSweep(this.getSweep());
    }

    public void paint(Graphics graphics) {
        GenericImageLoader genericImageLoader = new GenericImageLoader();
        Dimension dimension = this.getSize();
        if (this.bstatusError && GdeTopPanel.bWidgeterror) {
            graphics.drawImage(genericImageLoader.iDownloadImage("Default.png"), 0, 0, dimension.width, dimension.height, this);
        } else {
            graphics.drawImage(genericImageLoader.iDownloadImage(this.getBitmap()), 0, 0, dimension.width, dimension.height, this);
            this.label.paint(graphics);
            this.indicator.paint(graphics);
            this.border.paint(graphics);
        }
        if (Wrapper.BORDER_WIDTH != 0) {
            this.InitWrapper();
        }
    }

    private void InitWrapper() {
        Wrapper.BORDER_WIDTH = 0;
        Wrapper.BORDER_WIDTH_X2 = 0;
    }

    public int getSweep() {
        this.indexfin = this.getBitmap().indexOf(".");
        String string = this.getBitmap().substring(0, this.indexfin).trim();
        char[] cArray = string.toCharArray();
        for (int i = cArray.length - 1; cArray[i] != '_' && i >= 0; --i) {
        }
        String string2 = "";
        for (int i = i + 1; i < cArray.length; ++i) {
            string2 = string2 + cArray[i];
        }
        this.iSweep = Integer.parseInt(string2);
        return this.iSweep;
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.scale.setPointerBackground(color);
        this.indicator.setPointerBackground(color);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.getMinimumSize();
        if (n3 < dimension2.width) {
            n3 = dimension2.width;
        }
        if (n4 < dimension2.height) {
            n4 = dimension2.height;
        }
        super.setBounds(n, n2, n3, n4);
        if (dimension.width != n3 || dimension.height != n4) {
            this.doLayout();
        }
    }

    public void setValue(float f) {
        this.indicator.setEUValue(f);
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            this.indicator.paint(graphics);
            graphics.dispose();
        }
        this.repaint();
    }

    public float getValue() {
        return this.indicator.getEUValue();
    }

    public void setMinimum(float f) {
        this.indicator.setEUMinimum(f);
        this.scale.setMinimum(this.indicator.getEUMinimum());
        this.doLayout();
        this.repaint();
    }

    public float getMinimum() {
        return this.indicator.getEUMinimum();
    }

    public void setMaximum(float f) {
        this.indicator.setEUMaximum(f);
        this.scale.setMaximum(this.indicator.getEUMaximum());
        this.doLayout();
        this.repaint();
    }

    public float getMaximum() {
        return this.indicator.getEUMaximum();
    }

    public void setLabel(String string) {
        this.label.setText(string);
        this.doLayout();
        this.repaint();
    }

    public String getLabel() {
        return this.label.getText();
    }

    public void setLabelColor(Color color) {
        this.label.setForeground(color);
        this.repaint();
    }

    public Color getLabelColor() {
        return this.label.getForeground();
    }

    public void setLabelFont(Font font) {
        this.label.setFont(font);
        this.doLayout();
        this.repaint();
    }

    public Font getLabelFont() {
        return this.label.getFont();
    }

    public void setDegSweep(int n) {
        this.scale.setDegSweep(n);
        this.indicator.setDegSweep(this.scale.getDegSweep());
        this.doLayout();
        this.repaint();
    }

    public int getDegSweep() {
        return this.scale.getDegSweep();
    }

    public void setPointerColor(Color color) {
        this.indicator.setPointerColor(color);
    }

    public Color getPointerColor() {
        return this.indicator.getPointerColor();
    }

    public void setDialColor(Color color) {
        this.scale.setDialColor(color);
    }

    public Color getDialColor() {
        return this.scale.getDialColor();
    }

    public void setPointerType(int n) {
        this.indicator.setPointerType(n);
    }

    public int getPointerType() {
        return this.indicator.getPointerType();
    }

    public void setBorderColor(Color color) {
        this.border.setColor(color);
        this.repaint();
    }

    public Color getBorderColor() {
        return this.border.getColor();
    }

    public void setBorderWidth(int n) {
        this.border.setWidth(n);
        this.doLayout();
        this.repaint();
    }

    public int getBorderWidth() {
        return this.border.getWidth();
    }

    public void setBitmap(String string) {
        this.sBitmap = string;
        this.doLayout();
        this.setDegSweep(this.getSweep());
        this.repaint();
    }

    public String getBitmap() {
        return this.sBitmap;
    }

    public void doLayout() {
        int n;
        Dimension dimension = this.getSize();
        this.border.setBounds(new Rectangle(0, 0, dimension.width, dimension.height));
        int n2 = this.border.getMinimumSize().height;
        dimension.width -= n2;
        dimension.height -= n2;
        int n3 = this.label.getMinimumSize().height;
        int n4 = dimension.height - n3;
        int n5 = n = n2 / 2;
        this.scale.setBounds(new Rectangle(n, n5, dimension.width, n4));
        this.indicator.setBounds(this.scale.getBounds(), this.scale.getCenterX(), this.scale.getCenterY(), this.scale.getInnerRadius());
        this.label.setBounds(new Rectangle(n, n5 += n4, dimension.width, n3));
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.getMinimumSize();
        dimension.width += 15;
        dimension.height += 15;
        return dimension;
    }

    public Dimension getMinimumSize() {
        Dimension dimension = this.scale.getMinimumSize();
        Dimension dimension2 = this.label.getMinimumSize();
        Dimension dimension3 = this.border.getMinimumSize();
        int n = dimension.width;
        if (dimension2.width > n) {
            n = dimension2.width;
        }
        int n2 = dimension.height + dimension2.height + dimension3.height;
        return new Dimension(n += dimension3.width, n2);
    }
}

