/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.widgets;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.io.Serializable;

class ExtValveLight
implements Runnable,
Serializable {
    static final long serialVersionUID = 7654703374185757778L;
    private transient Thread flasher;
    private transient boolean fFlash;
    private transient boolean fPainted;
    private boolean value = false;
    private String onWord = "";
    private Font onFont = new Font("SansSerif", 0, 12);
    private String offWord = "";
    private Font offFont = new Font("SansSerif", 0, 12);
    private int flashDelay = 0;
    public boolean fInvert = false;
    private String OffBitmap = "VAN_HB1_Off.png";
    private String OnBitmap = "VAN_HB1_On.png";
    private Color offForegrnd = Color.black;
    private Color onForegrnd = Color.black;
    private Component parent;
    public Rectangle box = new Rectangle();

    ExtValveLight(Component component) {
        this.parent = component;
    }

    Dimension getMinimumSize() {
        int n = Toolkit.getDefaultToolkit().getFontMetrics(this.onFont).getHeight();
        int n2 = Toolkit.getDefaultToolkit().getFontMetrics(this.offFont).getHeight();
        int n3 = Math.max(n, n2);
        int n4 = 16;
        return new Dimension(n4, n3);
    }

    void setBounds(Rectangle rectangle) {
        this.box = rectangle;
    }

    synchronized void setValue(boolean bl) {
        this.value = bl;
        this.fPainted = false;
    }

    boolean getValue() {
        return this.value;
    }

    void setOffForeground(Color color) {
        this.offForegrnd = color;
    }

    Color getOffForeground() {
        return this.offForegrnd;
    }

    void setOnForeground(Color color) {
        this.onForegrnd = color;
    }

    Color getOnForeground() {
        return this.onForegrnd;
    }

    void setOnWord(String string) {
        this.onWord = string;
    }

    String getOnWord() {
        return this.onWord;
    }

    void setOnFont(Font font) {
        this.onFont = font;
    }

    Font getOnFont() {
        return this.onFont;
    }

    void setOffWord(String string) {
        this.offWord = string;
    }

    String getOffWord() {
        return this.offWord;
    }

    void setOffFont(Font font) {
        this.offFont = font;
    }

    Font getOffFont() {
        return this.offFont;
    }

    synchronized void setFlashInterval(int n) {
        this.flashDelay = n == 0 ? 0 : Math.min(Math.max(n, 200), 2000);
        this.fPainted = false;
    }

    int getFlashInterval() {
        return this.flashDelay;
    }

    synchronized void setInputInverted(boolean bl) {
        this.fInvert = bl;
        this.fPainted = false;
    }

    boolean isInputInverted() {
        return this.fInvert;
    }

    void setOffBitmap(String string) {
        this.OffBitmap = string;
    }

    String getOffBitmap() {
        return this.OffBitmap;
    }

    void setOnBitmap(String string) {
        this.OnBitmap = string;
    }

    String getOnBitmap() {
        return this.OnBitmap;
    }

    synchronized void paint(Graphics graphics) {
        if (this.flashDelay == 0 && this.flasher != null) {
            this.stopFlasher();
        } else if (this.flashDelay > 0 && this.flasher == null) {
            this.flasher = new Thread(this);
            this.flasher.start();
        }
        boolean bl = this.fInvert ? !this.value : this.value;
        Color color = bl ? this.onForegrnd : this.offForegrnd;
        String string = bl ? this.onWord : this.offWord;
        Font font = bl ? this.onFont : this.offFont;
        boolean bl2 = bl ? this.fFlash : false;
        Shape shape = graphics.getClip();
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        int n = this.box.x + (this.box.width - fontMetrics.stringWidth(string)) / 2;
        if (n < this.box.x) {
            n = this.box.x;
        }
        int n2 = this.box.y + (this.box.height + fontMetrics.getHeight()) / 2 - fontMetrics.getDescent();
        graphics.setColor(color);
        graphics.setFont(font);
        graphics.setClip(this.box);
        graphics.drawString(string, n, n2);
        graphics.setClip(shape);
    }

    synchronized void stopFlasher() {
        this.flasher = null;
        this.fFlash = false;
        this.notify();
    }

    public synchronized void run() {
        this.fPainted = false;
        while (this.flasher != null) {
            boolean bl;
            try {
                this.wait(this.flashDelay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.flasher == null) continue;
            boolean bl2 = this.fFlash = !this.fFlash;
            boolean bl3 = this.fInvert ? !this.value : (bl = this.value);
            if (!bl && this.fPainted) continue;
            Graphics graphics = this.parent.getGraphics();
            if (graphics != null) {
                this.paint(graphics);
                graphics.dispose();
            }
            this.fPainted = true;
        }
    }
}

