/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.widgets;

import com.schneiderautomation.gde.BeanBox;
import com.schneiderautomation.gde.GdeTopPanel;
import com.schneiderautomation.gde.Wrapper;
import com.schneiderautomation.widgets.Border;
import com.schneiderautomation.widgets.Choices;
import com.schneiderautomation.widgets.GenericImageLoader;
import com.schneiderautomation.widgets.HLabel;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.io.Serializable;

public class GenericImageGui
extends Canvas
implements Serializable {
    static final long serialVersionUID = 7387162693618778409L;
    private boolean fInvert = false;
    private boolean on;
    private Component parent;
    private Rectangle box = new Rectangle();
    private String nomFichierImageOn = null;
    private String nomFichierImageOff = null;
    private Choices choices;
    private long value = 0L;
    private Font font = new Font("SansSerif", 0, 12);
    private HLabel label = new HLabel();
    private Border border = new Border();
    private String sImage;
    private int index;
    public static boolean bGraphicalWidget = true;
    private String sError;
    protected boolean bstatusError = false;
    private transient boolean fPainted;
    private transient String message;
    private transient String paths;
    private transient Image ImageFtp;

    public GenericImageGui() {
        this.InitWrapper();
        long[] lArray = new long[]{0L};
        String[] stringArray = new String[]{"Bitmap.png"};
        this.choices = new Choices(lArray, stringArray);
    }

    private void InitWrapper() {
        Wrapper.BORDER_WIDTH = 0;
        Wrapper.BORDER_WIDTH_X2 = 0;
    }

    public void paint(Graphics graphics) {
        GenericImageLoader genericImageLoader = new GenericImageLoader();
        String string = this.getMessage();
        if (this.bstatusError && GdeTopPanel.bWidgeterror) {
            graphics.drawImage(genericImageLoader.iDownloadImage("Default.png"), this.box.x, this.box.y, this.box.width, this.box.height, this);
        } else if (string.equals("No Bitmap available")) {
            String string2 = "<" + this.value + ">";
            FontMetrics fontMetrics = graphics.getFontMetrics(this.font);
            int n = this.box.x + (this.box.width - fontMetrics.stringWidth(string) / 2 / 2 - fontMetrics.getDescent());
            if (n < this.box.x) {
                n = this.box.x;
            }
            int n2 = this.box.y + (this.box.height + fontMetrics.getHeight()) / 2 - fontMetrics.getDescent();
            graphics.drawImage(genericImageLoader.iDownloadImage("Default.png"), this.box.x, this.box.y, this.box.width, this.box.height, this);
            graphics.drawString(string2, n, n2);
        } else {
            String string3 = this.getMessage();
            if (this.index != -1) {
                this.ImageFtp = BeanBox.getBeanImage((String)this.getMessage(), (String)this.getPath());
                MediaTracker mediaTracker = new MediaTracker(this);
                mediaTracker.addImage(this.ImageFtp, 0);
                try {
                    mediaTracker.waitForAll();
                }
                catch (InterruptedException interruptedException) {
                    System.out.print("error downloading class");
                }
                graphics.drawImage(this.ImageFtp, this.box.x, this.box.y, this.box.width, this.box.height, this);
            } else {
                graphics.drawImage(genericImageLoader.iDownloadImage(this.getMessage()), this.box.x, this.box.y, this.box.width, this.box.height, this);
            }
        }
        this.label.paint(graphics);
        this.border.paint(graphics);
        if (Wrapper.BORDER_WIDTH != 0) {
            this.InitWrapper();
        }
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.getMinimumSize();
        if (n3 < dimension2.width) {
            n3 = dimension2.width;
        }
        if (n4 < dimension2.height) {
            n4 = dimension2.height;
        }
        super.setBounds(n, n2, n3, n4);
        if (dimension.width != n3 || dimension.height != n4) {
            this.doLayout();
        }
    }

    void setValue(long l) {
        this.value = l;
        this.message = null;
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            this.paint(graphics);
            graphics.dispose();
        }
    }

    long getValue() {
        return this.value;
    }

    public void setLabel(String string) {
        this.label.setText(string);
        this.doLayout();
        this.repaint();
    }

    public String getLabel() {
        return this.label.getText();
    }

    public void setLabelColor(Color color) {
        this.label.setForeground(color);
        this.repaint();
    }

    public Color getLabelColor() {
        return this.label.getForeground();
    }

    public void setLabelFont(Font font) {
        this.label.setFont(font);
        this.doLayout();
        this.repaint();
    }

    public Font getLabelFont() {
        return this.label.getFont();
    }

    public void doLayout() {
        Dimension dimension = this.getSize();
        this.border.setBounds(new Rectangle(0, 0, dimension.width, dimension.height));
        int n = this.border.getMinimumSize().height;
        dimension.width -= n;
        dimension.height -= n;
        int n2 = this.label.getMinimumSize().height;
        int n3 = dimension.height - n2;
        int n4 = n / 2;
        this.box = new Rectangle(n4, n4, dimension.width, n3);
        this.label.setBounds(new Rectangle(n4, n4 + n3, dimension.width, n2));
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.getMinimumSize();
        ++dimension.width;
        ++dimension.height;
        return dimension;
    }

    public Dimension getMinimumSize() {
        int n = 40;
        int n2 = 40;
        return new Dimension(n, n2);
    }

    public void setStringImageOff(String string) {
        this.nomFichierImageOff = string;
    }

    public String getStringImageOff() {
        return this.nomFichierImageOff;
    }

    public void setStringImageOn(String string) {
        this.nomFichierImageOn = string;
    }

    public String getStringImageOn() {
        return this.nomFichierImageOn;
    }

    public void setBorderColor(Color color) {
        this.border.setColor(color);
        this.repaint();
    }

    public Color getBorderColor() {
        return this.border.getColor();
    }

    public void setBorderWidth(int n) {
        this.border.setWidth(n);
        this.doLayout();
        this.repaint();
    }

    public int getBorderWidth() {
        return this.border.getWidth();
    }

    public void setChoices(Choices choices) {
        this.choices = choices;
        this.setValue(this.getValue());
        this.doLayout();
        this.repaint();
    }

    public Choices getChoices() {
        return this.choices;
    }

    private String getMessage() {
        for (int i = 0; i < this.choices.values.length; ++i) {
            if (this.value != this.choices.values[i]) continue;
            this.message = this.choices.labels[i];
            this.index = this.message.indexOf(":");
            if (this.index == -1) break;
            this.paths = this.message.substring(this.index + 1, this.message.length()).trim();
            this.setPath(this.paths);
            this.message = this.message.substring(0, this.index).trim();
            break;
        }
        if (this.message == null) {
            this.message = "No Bitmap available";
        }
        return this.message;
    }

    private String getPath() {
        return this.paths;
    }

    private void setPath(String string) {
        this.paths = string;
    }
}

