/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.widgets;

import com.schneiderautomation.gde.Wrapper;
import com.schneiderautomation.widgets.Bar;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;

class HBar
extends Bar
implements Serializable {
    static final long serialVersionUID = 1070459861958715838L;
    private transient DecimalFormat formatter;
    private boolean valueVisible = false;
    private int precision = 0;
    private Font font = new Font("SansSerif", 0, 18);

    HBar() {
    }

    Dimension getMinimumSize() {
        Dimension dimension = new Dimension(8, 8);
        if (this.valueVisible) {
            dimension.height = Toolkit.getDefaultToolkit().getFontMetrics(this.font).getHeight();
        }
        return dimension;
    }

    void setPrecision(int n) {
        this.precision = n;
        if (this.formatter != null && this.precision >= 0) {
            this.formatter.setMaximumFractionDigits(this.precision);
            this.formatter.setMinimumFractionDigits(this.precision);
        }
    }

    void setFont(Font font) {
        this.font = font;
    }

    Font getFont() {
        return this.font;
    }

    boolean isValueVisible() {
        return this.valueVisible;
    }

    void setValueVisible(boolean bl) {
        this.valueVisible = bl;
    }

    void paint(Graphics graphics) {
        float f = (this.value - this.minimum) / (this.maximum - this.minimum);
        int n = (int)(f * (float)this.box.width);
        graphics.setColor(this.barColor());
        graphics.fillRect(this.box.x, this.box.y, n, this.box.height);
        graphics.setColor(this.background);
        graphics.fillRect(this.box.x + n, this.box.y, this.box.width - n, this.box.height);
        if (this.valueVisible) {
            String string;
            FontMetrics fontMetrics = graphics.getFontMetrics(this.font);
            int n2 = this.box.x + (this.box.width - fontMetrics.stringWidth(string = this.formattedValue())) / 2;
            if (n2 < this.box.x) {
                n2 = this.box.x;
            }
            int n3 = this.box.y + (this.box.height + fontMetrics.getHeight()) / 2 - fontMetrics.getDescent();
            graphics.setColor(Color.black);
            graphics.setXORMode(Color.white);
            graphics.setFont(this.font);
            graphics.drawString(string, n2, n3);
            graphics.setPaintMode();
            if (Wrapper.BORDER_WIDTH != 4) {
                Wrapper.BORDER_WIDTH = 4;
                Wrapper.BORDER_WIDTH_X2 = Wrapper.BORDER_WIDTH * 2;
            }
        }
    }

    private String formattedValue() {
        if (this.formatter == null && this.precision >= 0) {
            this.formatter = (DecimalFormat)NumberFormat.getInstance();
            this.formatter.setMaximumFractionDigits(this.precision);
            this.formatter.setMinimumFractionDigits(this.precision);
        }
        if (this.precision < 0) {
            return String.valueOf(this.value);
        }
        return this.formatter.format(this.value);
    }
}

