/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.widgets;

import com.schneiderautomation.gde.Wrapper;
import com.schneiderautomation.widgets.Bar;
import com.schneiderautomation.widgets.HBar;
import com.schneiderautomation.widgets.HScale;
import com.schneiderautomation.widgets.IndicatorGui;
import com.schneiderautomation.widgets.Scale;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.io.Serializable;

public class HIndicatorGui
extends IndicatorGui
implements Serializable {
    static final long serialVersionUID = 7867941045634890590L;
    private HScale scale;
    private HBar bar;

    public HIndicatorGui() {
        this.InitWrapper();
        this.scale = new HScale(false);
        this.bar = new HBar();
        this.scale.setMinimum(this.bar.getMinimum());
        this.scale.setMaximum(this.bar.getMaximum());
        this.bar.setPrecision(this.scale.getPrecision());
    }

    Scale getScale() {
        return this.scale;
    }

    private void InitWrapper() {
        Wrapper.BORDER_WIDTH = 4;
        Wrapper.BORDER_WIDTH_X2 = Wrapper.BORDER_WIDTH * 2;
    }

    Bar getBar() {
        return this.bar;
    }

    public void setValueVisible(boolean bl) {
        this.bar.setValueVisible(bl);
        this.doLayout();
        this.repaint();
    }

    public boolean isValueVisible() {
        return this.bar.isValueVisible();
    }

    public void setPrecision(int n) {
        this.scale.setPrecision(n);
        this.bar.setPrecision(this.scale.getPrecision());
        this.doLayout();
        this.repaint();
    }

    public int getPrecision() {
        return this.scale.getPrecision();
    }

    public void setValueFont(Font font) {
        this.bar.setFont(font);
        this.doLayout();
        this.repaint();
    }

    public Font getValueFont() {
        return this.bar.getFont();
    }

    public void doLayout() {
        int n;
        Dimension dimension = this.getSize();
        this.border.setBounds(new Rectangle(0, 0, dimension.width, dimension.height));
        int n2 = this.border.getMinimumSize().height;
        dimension.width -= n2;
        dimension.height -= n2;
        int n3 = this.scale.getMinimumSize().height;
        int n4 = this.label.getMinimumSize().height;
        int n5 = dimension.height - (n3 + n4);
        int n6 = n = n2 / 2;
        this.scale.setBounds(new Rectangle(n, n6, dimension.width, n3));
        this.bar.setBounds(new Rectangle(n, n6 += n3, dimension.width, n5));
        this.label.setBounds(new Rectangle(n, n6 += n5, dimension.width, n4));
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.getMinimumSize();
        dimension.width += 100;
        dimension.height += 4;
        return dimension;
    }

    public Dimension getMinimumSize() {
        Dimension dimension = this.scale.getMinimumSize();
        Dimension dimension2 = this.bar.getMinimumSize();
        Dimension dimension3 = this.label.getMinimumSize();
        Dimension dimension4 = this.border.getMinimumSize();
        int n = dimension.width;
        if (dimension2.width > n) {
            n = dimension2.width;
        }
        if (dimension3.width > n) {
            n = dimension3.width;
        }
        int n2 = dimension.height + dimension3.height + dimension2.height + dimension4.height;
        return new Dimension(n += dimension4.width, n2);
    }
}

