/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.widgets;

import com.schneiderautomation.widgets.Scale;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.io.Serializable;

class HScale
extends Scale
implements Serializable {
    static final long serialVersionUID = -2734843248260141503L;
    static final int TOP = 0;
    static final int BOTTOM = 1;
    private int orientation = 0;

    HScale(boolean bl) {
        super(bl);
    }

    HScale(boolean bl, int n) {
        super(bl);
        this.orientation = n;
    }

    Dimension getMinimumSize() {
        Dimension dimension = new Dimension(0, 0);
        if (this.majorTics > 0) {
            FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.font);
            dimension.height = fontMetrics.getHeight() + this.majorTicSize;
            dimension.width = fontMetrics.stringWidth(this.formatValue(this.minval)) + fontMetrics.stringWidth(this.formatValue(this.maxval));
        } else if (this.minorTics > 0) {
            dimension.height = this.minorTicSize;
            dimension.width = this.minorTics + 1;
        }
        return dimension;
    }

    void paint(Graphics graphics) {
        int n;
        int n2;
        int n3;
        graphics.setColor(this.foreground);
        if (this.majorTics > 0) {
            FontMetrics fontMetrics = graphics.getFontMetrics(this.font);
            graphics.setFont(this.font);
            n3 = this.orientation == 0 ? this.box.y + fontMetrics.getHeight() : this.box.y;
            n2 = this.orientation == 0 ? this.box.y + this.box.height - 1 : this.box.y + this.majorTicSize - 1;
            n = this.orientation == 0 ? n3 - fontMetrics.getDescent() : this.box.y + this.box.height - fontMetrics.getDescent();
            String string = this.formatValue(this.minval);
            int n4 = fontMetrics.stringWidth(string);
            int n5 = this.box.x;
            int n6 = this.box.x;
            if (this.fCenterEndLabels) {
                n6 = n5 - n4 / 2;
            }
            graphics.drawString(string, n6, n);
            graphics.drawLine(n5, n3, n5, n2);
            double d = (double)this.maxval - (double)this.minval;
            for (int i = 1; i < this.majorTics; ++i) {
                double d2 = (double)i / (double)this.majorTics;
                float f = (float)(d * d2 + (double)this.minval);
                string = this.formatValue(f);
                n4 = fontMetrics.stringWidth(string);
                n5 = this.box.x + this.box.width * i / this.majorTics;
                n6 = n5 - n4 / 2;
                graphics.drawString(string, n6, n);
                graphics.drawLine(n5, n3, n5, n2);
            }
            string = this.formatValue(this.maxval);
            n4 = fontMetrics.stringWidth(string);
            n5 = this.box.x + this.box.width - 1;
            n6 = this.fCenterEndLabels ? n5 - n4 / 2 : this.box.x + this.box.width - n4;
            graphics.drawString(string, n6, n);
            graphics.drawLine(n5, n3, n5, n2);
        }
        if (this.minorTics > 0) {
            int n7 = this.orientation == 0 ? this.box.y + this.box.height - this.minorTicSize : this.box.y;
            n3 = n7 + this.minorTicSize - 1;
            for (n2 = 0; n2 < this.minorTics; ++n2) {
                n = this.box.x + this.box.width * n2 / this.minorTics;
                graphics.drawLine(n, n7, n, n3);
            }
            n2 = this.box.x + this.box.width - 1;
            graphics.drawLine(n2, n7, n2, n3);
        }
        if (this.minorTics > 0 || this.majorTics > 0) {
            int n8 = this.orientation == 0 ? this.box.y + this.box.height - 1 : this.box.y;
            graphics.drawLine(this.box.x, n8, this.box.x + this.box.width - 1, n8);
        }
    }
}

