/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.widgets;

import com.schneiderautomation.dt.DT;
import com.schneiderautomation.factorycast.MonitorNumber;
import com.schneiderautomation.factorycast.MonitorRef;
import com.schneiderautomation.factorycast.ServerChangeEvent;
import com.schneiderautomation.factorycast.SetNumber;
import com.schneiderautomation.factorycast.SetRef;
import com.schneiderautomation.gde.GraphicalObject;
import com.schneiderautomation.gde.WriteSupport;
import com.schneiderautomation.widgets.HSliderGui;
import com.schneiderautomation.widgets.SliderSupport;
import com.schneiderautomation.widgets.SliderSupportInterface;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.io.Serializable;

public class HSlider
extends HSliderGui
implements GraphicalObject,
SliderSupportInterface,
AdjustmentListener,
Serializable {
    static final long serialVersionUID = 2298745499991971346L;
    private transient boolean fEnabled;
    private SetNumber setter = new SetNumber();
    private MonitorNumber monitor = new MonitorNumber();
    private WriteSupport writeSupport = new WriteSupport((SetRef)this.setter, (GraphicalObject)this);
    private SliderSupport readSupport = new SliderSupport(this, (MonitorRef)this.monitor, this);
    private float minValue;
    private float maxValue;

    public HSlider() {
        this.addAdjustmentListener(this);
        this.minValue = this.getMinimum();
        this.maxValue = this.getMaximum();
    }

    public void serverChanged(ServerChangeEvent serverChangeEvent) {
        this.monitor.serverChanged(serverChangeEvent);
        this.setter.serverChanged(serverChangeEvent);
        if (serverChangeEvent.getCommBean() != null) {
            this.setter.enableAccessChecking(serverChangeEvent.getVarLookup());
            this.setEnabled(this.fEnabled);
        } else {
            this.setEnabled(false);
        }
    }

    public void enableUserInput() {
        this.fEnabled = true;
        this.setEnabled(this.fEnabled);
    }

    public void disableUserInput() {
        this.fEnabled = false;
        this.setEnabled(this.fEnabled);
    }

    public String getStatus() {
        return this.readSupport.getStatus();
    }

    public boolean isErrorStatus() {
        return this.readSupport.isErrorStatus();
    }

    public void setMinValue(float f) {
        short s = this.getDatatype();
        if ((f = (float)Math.min(Math.max((double)f, DT.minValue((short)s)), DT.maxValue((short)s))) > this.maxValue) {
            f = this.maxValue;
        }
        this.minValue = f;
    }

    public float getMinValue() {
        return this.minValue;
    }

    public void setMaxValue(float f) {
        short s = this.getDatatype();
        if ((f = (float)Math.min(Math.max((double)f, DT.minValue((short)s)), DT.maxValue((short)s))) < this.minValue) {
            f = this.minValue;
        }
        this.maxValue = f;
    }

    public float getMaxValue() {
        return this.maxValue;
    }

    public String getAddress() {
        return this.monitor.getAddress();
    }

    public void setAddress(String string) {
        this.monitor.setAddress(string);
        this.setter.setAddress(this.monitor.getAddress());
    }

    public short getDatatype() {
        return this.monitor.getDatatype();
    }

    public void setDatatype(short s) {
        this.monitor.setDatatype(s);
        this.setter.setDatatype(this.monitor.getDatatype());
        this.setMinValue(this.minValue);
        this.setMaxValue(this.maxValue);
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (this.fEnabled) {
            this.readSupport.updateNotify();
            try {
                float f = this.getMinimum();
                float f2 = this.getMaximum();
                float f3 = (this.maxValue - this.minValue) / (f2 - f);
                float f4 = (this.getValue() - f) * f3 + this.minValue;
                this.setter.setValue((Number)new Float(f4));
                this.setter.sendValues();
            }
            catch (Exception exception) {
                this.writeSupport.setStatus(true, exception.getMessage());
            }
        }
    }

    public void slide(float f) {
        float f2 = this.getMinimum();
        float f3 = this.getMaximum();
        float f4 = (f3 - f2) / (this.maxValue - this.minValue);
        float f5 = (f - this.minValue) * f4 + f2;
        if (f5 < f2) {
            f5 = f2;
        }
        if (f5 > f3) {
            f5 = f3;
        }
        this.setValue(f5);
    }
}

