/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.widgets;

import com.schneiderautomation.widgets.Bar;
import com.schneiderautomation.widgets.Border;
import com.schneiderautomation.widgets.HLabel;
import com.schneiderautomation.widgets.Scale;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.io.Serializable;

public abstract class IndicatorGui
extends Canvas
implements Serializable {
    static final long serialVersionUID = -8282412718779003808L;
    protected Border border = new Border();
    protected HLabel label = new HLabel();

    IndicatorGui() {
    }

    abstract Scale getScale();

    abstract Bar getBar();

    public void paint(Graphics graphics) {
        this.setBackground(Color.lightGray);
        this.getScale().paint(graphics);
        this.getBar().paint(graphics);
        this.label.paint(graphics);
        this.border.paint(graphics);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.getMinimumSize();
        if (n3 < dimension2.width) {
            n3 = dimension2.width;
        }
        if (n4 < dimension2.height) {
            n4 = dimension2.height;
        }
        super.setBounds(n, n2, n3, n4);
        if (dimension.width != n3 || dimension.height != n4) {
            this.doLayout();
        }
    }

    public void setValue(float f) {
        this.getBar().setValue(f);
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            this.getBar().paint(graphics);
            graphics.dispose();
        }
    }

    public float getValue() {
        return this.getBar().getValue();
    }

    public void setMinimum(float f) {
        this.getBar().setMinimum(f);
        this.getScale().setMinimum(this.getBar().getMinimum());
        this.doLayout();
        this.repaint();
    }

    public float getMinimum() {
        return this.getBar().getMinimum();
    }

    public void setMaximum(float f) {
        this.getBar().setMaximum(f);
        this.getScale().setMaximum(this.getBar().getMaximum());
        this.doLayout();
        this.repaint();
    }

    public float getMaximum() {
        return this.getBar().getMaximum();
    }

    public void setLabel(String string) {
        this.label.setText(string);
        this.doLayout();
        this.repaint();
    }

    public String getLabel() {
        return this.label.getText();
    }

    public void setLabelColor(Color color) {
        this.label.setForeground(color);
        this.repaint();
    }

    public Color getLabelColor() {
        return this.label.getForeground();
    }

    public void setLabelFont(Font font) {
        this.label.setFont(font);
        this.doLayout();
        this.repaint();
    }

    public Font getLabelFont() {
        return this.label.getFont();
    }

    public void setBarForeground(Color color) {
        this.getBar().setForeground(color);
        this.repaint();
    }

    public Color getBarForeground() {
        return this.getBar().getForeground();
    }

    public void setBarBackground(Color color) {
        this.getBar().setBackground(color);
        this.repaint();
    }

    public Color getBarBackground() {
        return this.getBar().getBackground();
    }

    public void setMinorTics(int n) {
        this.getScale().setMinorTics(n);
        this.doLayout();
        this.repaint();
    }

    public int getMinorTics() {
        return this.getScale().getMinorTics();
    }

    public void setMajorTics(int n) {
        this.getScale().setMajorTics(n);
        this.doLayout();
        this.repaint();
    }

    public int getMajorTics() {
        return this.getScale().getMajorTics();
    }

    public void setScaleFont(Font font) {
        this.getScale().setFont(font);
        this.doLayout();
        this.repaint();
    }

    public Font getScaleFont() {
        return this.getScale().getFont();
    }

    public void setScaleColor(Color color) {
        this.getScale().setForeground(color);
        this.repaint();
    }

    public Color getScaleColor() {
        return this.getScale().getForeground();
    }

    public void setDeadband(int n) {
        this.getBar().setDeadband(n);
        this.repaint();
    }

    public int getDeadband() {
        return this.getBar().getDeadband();
    }

    public void setLimitLoLo(float f) {
        this.getBar().setLimitValue(0, f);
        this.repaint();
    }

    public float getLimitLoLo() {
        return this.getBar().getLimitValue(0);
    }

    public void setLimitLo(float f) {
        this.getBar().setLimitValue(1, f);
        this.repaint();
    }

    public float getLimitLo() {
        return this.getBar().getLimitValue(1);
    }

    public void setLimitHi(float f) {
        this.getBar().setLimitValue(2, f);
        this.repaint();
    }

    public float getLimitHi() {
        return this.getBar().getLimitValue(2);
    }

    public void setLimitHiHi(float f) {
        this.getBar().setLimitValue(3, f);
        this.repaint();
    }

    public float getLimitHiHi() {
        return this.getBar().getLimitValue(3);
    }

    public void setColorLoLo(Color color) {
        this.getBar().setLimitColor(0, color);
        this.repaint();
    }

    public Color getColorLoLo() {
        return this.getBar().getLimitColor(0);
    }

    public void setColorLo(Color color) {
        this.getBar().setLimitColor(1, color);
        this.repaint();
    }

    public Color getColorLo() {
        return this.getBar().getLimitColor(1);
    }

    public void setColorHi(Color color) {
        this.getBar().setLimitColor(2, color);
        this.repaint();
    }

    public Color getColorHi() {
        return this.getBar().getLimitColor(2);
    }

    public void setColorHiHi(Color color) {
        this.getBar().setLimitColor(3, color);
        this.repaint();
    }

    public Color getColorHiHi() {
        return this.getBar().getLimitColor(3);
    }

    public void setBorderColor(Color color) {
        this.border.setColor(color);
        this.repaint();
    }

    public Color getBorderColor() {
        return this.border.getColor();
    }

    public void setBorderWidth(int n) {
        this.border.setWidth(n);
        this.doLayout();
        this.repaint();
    }

    public int getBorderWidth() {
        return this.border.getWidth();
    }
}

