/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.widgets;

import com.schneiderautomation.gde.Wrapper;
import com.schneiderautomation.widgets.Border;
import com.schneiderautomation.widgets.HLabel;
import com.schneiderautomation.widgets.Light;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.Serializable;

public class IndicatorLightGui
extends Canvas
implements Serializable {
    static final long serialVersionUID = 7357755647632411575L;
    public static final int RECT_SHAPE = 0;
    public static final int RNDRECT_SHAPE = 1;
    public static final int OVAL_SHAPE = 2;
    public static final int CIRCLE_SHAPE = 3;
    private Border border = new Border();
    private Light display = new Light(this);
    private HLabel label = new HLabel();

    public IndicatorLightGui() {
        this.InitWrapper();
        this.setBackground(Color.lightGray);
    }

    public void paint(Graphics graphics) {
        this.display.paint(graphics);
        this.label.paint(graphics);
        this.border.paint(graphics);
        if (Wrapper.BORDER_WIDTH != 4) {
            this.InitWrapper();
        }
    }

    private void InitWrapper() {
        Wrapper.BORDER_WIDTH = 4;
        Wrapper.BORDER_WIDTH_X2 = Wrapper.BORDER_WIDTH * 2;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.getMinimumSize();
        if (n3 < dimension2.width) {
            n3 = dimension2.width;
        }
        if (n4 < dimension2.height) {
            n4 = dimension2.height;
        }
        super.setBounds(n, n2, n3, n4);
        if (dimension.width != n3 || dimension.height != n4) {
            this.doLayout();
        }
    }

    public void setValue(long l) {
        this.display.setValue(l != 0L);
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            this.display.paint(graphics);
            graphics.dispose();
        }
    }

    public long getValue() {
        return this.display.getValue() ? 1L : 0L;
    }

    public void setLabel(String string) {
        this.label.setText(string);
        this.doLayout();
        this.repaint();
    }

    public String getLabel() {
        return this.label.getText();
    }

    public void setLabelColor(Color color) {
        this.label.setForeground(color);
        this.repaint();
    }

    public Color getLabelColor() {
        return this.label.getForeground();
    }

    public void setLabelFont(Font font) {
        this.label.setFont(font);
        this.doLayout();
        this.repaint();
    }

    public Font getLabelFont() {
        return this.label.getFont();
    }

    public void setOffWord(String string) {
        this.display.setOffWord(string);
        this.doLayout();
        this.repaint();
    }

    public String getOffWord() {
        return this.display.getOffWord();
    }

    public void setOffWordForeground(Color color) {
        this.display.setOffForeground(color);
        this.repaint();
    }

    public Color getOffWordForeground() {
        return this.display.getOffForeground();
    }

    public void setOffWordBackground(Color color) {
        this.display.setOffBackground(color);
        this.repaint();
    }

    public Color getOffWordBackground() {
        return this.display.getOffBackground();
    }

    public void setOffWordFont(Font font) {
        this.display.setOffFont(font);
        this.doLayout();
        this.repaint();
    }

    public Font getOffWordFont() {
        return this.display.getOffFont();
    }

    public void setOnWord(String string) {
        this.display.setOnWord(string);
        this.doLayout();
        this.repaint();
    }

    public String getOnWord() {
        return this.display.getOnWord();
    }

    public void setOnWordForeground(Color color) {
        this.display.setOnForeground(color);
        this.repaint();
    }

    public Color getOnWordForeground() {
        return this.display.getOnForeground();
    }

    public void setOnWordBackground(Color color) {
        this.display.setOnBackground(color);
        this.repaint();
    }

    public Color getOnWordBackground() {
        return this.display.getOnBackground();
    }

    public void setOnWordFont(Font font) {
        this.display.setOnFont(font);
        this.doLayout();
        this.repaint();
    }

    public Font getOnWordFont() {
        return this.display.getOnFont();
    }

    public void setFlashInterval(int n) {
        this.display.setFlashInterval(n);
        this.repaint();
    }

    public int getFlashInterval() {
        return this.display.getFlashInterval();
    }

    public void setShape(int n) {
        this.display.setShape(n);
        this.doLayout();
        this.repaint();
    }

    public int getShape() {
        return this.display.getShape();
    }

    public void setInputInverted(boolean bl) {
        this.display.setInputInverted(bl);
        this.repaint();
    }

    public boolean isInputInverted() {
        return this.display.isInputInverted();
    }

    public void setBorderColor(Color color) {
        this.border.setColor(color);
        this.repaint();
    }

    public Color getBorderColor() {
        return this.border.getColor();
    }

    public void setBorderWidth(int n) {
        this.border.setWidth(n);
        this.doLayout();
        this.repaint();
    }

    public int getBorderWidth() {
        return this.border.getWidth();
    }

    public void doLayout() {
        Dimension dimension = this.getSize();
        this.border.setBounds(new Rectangle(0, 0, dimension.width, dimension.height));
        int n = this.border.getMinimumSize().height;
        dimension.width -= n;
        dimension.height -= n;
        int n2 = this.label.getMinimumSize().height;
        int n3 = dimension.height - n2;
        int n4 = n / 2;
        this.display.setBounds(new Rectangle(n4, n4, dimension.width, n3));
        this.label.setBounds(new Rectangle(n4, n4 + n3, dimension.width, n2));
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.getMinimumSize();
        dimension.width += 100;
        dimension.height += 10;
        return dimension;
    }

    public Dimension getMinimumSize() {
        Dimension dimension = this.display.getMinimumSize();
        Dimension dimension2 = this.label.getMinimumSize();
        Dimension dimension3 = this.border.getMinimumSize();
        int n = dimension.width;
        if (dimension2.width > n) {
            n = dimension2.width;
        }
        int n2 = dimension2.height + dimension.height + dimension3.height;
        return new Dimension(n += dimension3.width, n2);
    }

    public void removeNotify() {
        this.display.stopFlasher();
        super.removeNotify();
    }
}

