/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.widgets;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.io.Serializable;

class Light
implements Runnable,
Serializable {
    static final long serialVersionUID = 7654703374185757778L;
    static final int RECT_LIGHT = 0;
    static final int RNDRECT_LIGHT = 1;
    static final int OVAL_LIGHT = 2;
    static final int CIRCLE_LIGHT = 3;
    static final int N_LIGHT = 4;
    private transient Thread flasher;
    private transient boolean fFlash;
    private transient boolean fPainted;
    private boolean value = false;
    private String onWord = "";
    private Color onForegrnd = Color.black;
    private Color onBackgrnd = Color.green;
    private Font onFont = new Font("SansSerif", 0, 12);
    private String offWord = "";
    private Color offForegrnd = Color.black;
    private Color offBackgrnd = Color.red;
    private Font offFont = new Font("SansSerif", 0, 12);
    private int idShape = 0;
    private int flashDelay = 0;
    private boolean fInvert = false;
    private Component parent;
    private Rectangle box = new Rectangle();

    Light(Component component) {
        this.parent = component;
    }

    Dimension getMinimumSize() {
        int n = Toolkit.getDefaultToolkit().getFontMetrics(this.onFont).getHeight();
        int n2 = Toolkit.getDefaultToolkit().getFontMetrics(this.offFont).getHeight();
        int n3 = Math.max(n, n2);
        int n4 = 16;
        return new Dimension(n4, n3);
    }

    void setBounds(Rectangle rectangle) {
        this.box = rectangle;
    }

    synchronized void setValue(boolean bl) {
        this.value = bl;
        this.fPainted = false;
    }

    boolean getValue() {
        return this.value;
    }

    void setOnWord(String string) {
        this.onWord = string;
    }

    String getOnWord() {
        return this.onWord;
    }

    void setOnForeground(Color color) {
        this.onForegrnd = color;
    }

    Color getOnForeground() {
        return this.onForegrnd;
    }

    void setOnBackground(Color color) {
        this.onBackgrnd = color;
    }

    Color getOnBackground() {
        return this.onBackgrnd;
    }

    void setOnFont(Font font) {
        this.onFont = font;
    }

    Font getOnFont() {
        return this.onFont;
    }

    void setOffWord(String string) {
        this.offWord = string;
    }

    String getOffWord() {
        return this.offWord;
    }

    void setOffForeground(Color color) {
        this.offForegrnd = color;
    }

    Color getOffForeground() {
        return this.offForegrnd;
    }

    void setOffBackground(Color color) {
        this.offBackgrnd = color;
    }

    Color getOffBackground() {
        return this.offBackgrnd;
    }

    void setOffFont(Font font) {
        this.offFont = font;
    }

    Font getOffFont() {
        return this.offFont;
    }

    synchronized void setFlashInterval(int n) {
        this.flashDelay = n == 0 ? 0 : Math.min(Math.max(n, 200), 2000);
        this.fPainted = false;
    }

    int getFlashInterval() {
        return this.flashDelay;
    }

    void setShape(int n) {
        this.idShape = n;
    }

    int getShape() {
        return this.idShape;
    }

    synchronized void setInputInverted(boolean bl) {
        this.fInvert = bl;
        this.fPainted = false;
    }

    boolean isInputInverted() {
        return this.fInvert;
    }

    synchronized void paint(Graphics graphics) {
        if (this.flashDelay == 0 && this.flasher != null) {
            this.stopFlasher();
        } else if (this.flashDelay > 0 && this.flasher == null) {
            this.flasher = new Thread(this);
            this.flasher.start();
        }
        boolean bl = this.fInvert ? !this.value : this.value;
        String string = bl ? this.onWord : this.offWord;
        Font font = bl ? this.onFont : this.offFont;
        Color color = bl ? this.onForegrnd : this.offForegrnd;
        Color color2 = bl ? this.onBackgrnd : this.offBackgrnd;
        boolean bl2 = bl ? this.fFlash : false;
        Shape shape = graphics.getClip();
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        int n = this.box.x + (this.box.width - fontMetrics.stringWidth(string)) / 2;
        if (n < this.box.x) {
            n = this.box.x;
        }
        int n2 = this.box.y + (this.box.height + fontMetrics.getHeight()) / 2 - fontMetrics.getDescent();
        graphics.setColor(bl2 ? color : color2);
        switch (this.idShape) {
            case 2: {
                graphics.fillOval(this.box.x, this.box.y, this.box.width, this.box.height);
                break;
            }
            case 3: {
                int n3;
                int n4;
                int n5;
                if (this.box.width > this.box.height) {
                    n5 = this.box.height;
                    n4 = this.box.x + (this.box.width - n5) / 2;
                    n3 = this.box.y;
                } else {
                    n5 = this.box.width;
                    n4 = this.box.x;
                    n3 = this.box.y + (this.box.height - n5) / 2;
                }
                graphics.fillOval(n4, n3, n5, n5);
                break;
            }
            case 1: {
                int n6 = (this.box.width + this.box.height) / 4;
                graphics.fillRoundRect(this.box.x, this.box.y, this.box.width, this.box.height, n6, n6);
                break;
            }
            default: {
                graphics.fillRect(this.box.x, this.box.y, this.box.width, this.box.height);
            }
        }
        graphics.setColor(bl2 ? color2 : color);
        graphics.setFont(font);
        graphics.setClip(this.box);
        graphics.drawString(string, n, n2);
        graphics.setClip(shape);
    }

    synchronized void stopFlasher() {
        this.flasher = null;
        this.fFlash = false;
        this.notify();
    }

    public synchronized void run() {
        this.fPainted = false;
        while (this.flasher != null) {
            boolean bl;
            try {
                this.wait(this.flashDelay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.flasher == null) continue;
            boolean bl2 = this.fFlash = !this.fFlash;
            boolean bl3 = this.fInvert ? !this.value : (bl = this.value);
            if (!bl && this.fPainted) continue;
            Graphics graphics = this.parent.getGraphics();
            if (graphics != null) {
                this.paint(graphics);
                graphics.dispose();
            }
            this.fPainted = true;
        }
    }
}

