/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.widgets;

import com.schneiderautomation.widgets.Choices;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.io.Serializable;

class MDisplay
implements Serializable {
    static final long serialVersionUID = -5211247300927792444L;
    private transient String message;
    private long value = 0L;
    private Color foreground = Color.black;
    private Color background = Color.lightGray;
    private Font font = new Font("SansSerif", 0, 12);
    private Choices choices;
    private Rectangle box = new Rectangle();

    MDisplay() {
        long[] lArray = new long[]{0L};
        String[] stringArray = new String[]{"A"};
        this.choices = new Choices(lArray, stringArray);
    }

    Dimension getMinimumSize() {
        int n = Toolkit.getDefaultToolkit().getFontMetrics(this.font).getHeight();
        int n2 = 16;
        return new Dimension(n2, n);
    }

    void setBounds(Rectangle rectangle) {
        this.box = rectangle;
    }

    void setChoices(Choices choices) {
        this.choices = choices;
    }

    Choices getChoices() {
        return this.choices;
    }

    void setValue(long l) {
        this.value = l;
        this.message = null;
    }

    long getValue() {
        return this.value;
    }

    void setForeground(Color color) {
        this.foreground = color;
    }

    Color getForeground() {
        return this.foreground;
    }

    void setBackground(Color color) {
        this.background = color;
    }

    Color getBackground() {
        return this.background;
    }

    void setFont(Font font) {
        this.font = font;
    }

    Font getFont() {
        return this.font;
    }

    void paint(Graphics graphics) {
        String string;
        FontMetrics fontMetrics = graphics.getFontMetrics(this.font);
        int n = this.box.x + (this.box.width - fontMetrics.stringWidth(string = this.getMessage())) / 2;
        if (n < this.box.x) {
            n = this.box.x;
        }
        int n2 = this.box.y + (this.box.height + fontMetrics.getHeight()) / 2 - fontMetrics.getDescent();
        Shape shape = graphics.getClip();
        graphics.setColor(this.background);
        graphics.fillRect(this.box.x, this.box.y, this.box.width, this.box.height);
        graphics.setColor(this.foreground);
        graphics.setFont(this.font);
        graphics.setClip(this.box);
        graphics.drawString(string, n, n2);
        graphics.setClip(shape);
    }

    private String getMessage() {
        if (this.message == null) {
            for (int i = 0; i < this.choices.values.length; ++i) {
                if (this.value != this.choices.values[i]) continue;
                this.message = this.choices.labels[i];
                break;
            }
            if (this.message == null) {
                this.message = "<" + this.value + ">";
            }
        }
        return this.message;
    }
}

