/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.widgets;

import com.schneiderautomation.widgets.Border;
import com.schneiderautomation.widgets.Choices;
import com.schneiderautomation.widgets.HLabel;
import com.schneiderautomation.widgets.ListScaleInterface;
import com.schneiderautomation.widgets.SelectorInterface;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.ItemSelectable;
import java.awt.Panel;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public abstract class SelectorGui
extends Panel
implements ItemSelectable,
AdjustmentListener,
Serializable {
    static final long serialVersionUID = -3314643598471126854L;
    private Vector listeners = new Vector();
    protected Border border = new Border();
    protected HLabel label = new HLabel();

    public SelectorGui() {
        this.setLayout(null);
    }

    protected abstract ListScaleInterface getScale();

    protected abstract SelectorInterface getSelector();

    public void paint(Graphics graphics) {
        this.label.paint(graphics);
        this.border.paint(graphics);
        super.paint(graphics);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.getMinimumSize();
        if (n3 < dimension2.width) {
            n3 = dimension2.width;
        }
        if (n4 < dimension2.height) {
            n4 = dimension2.height;
        }
        super.setBounds(n, n2, n3, n4);
        if (dimension.width != n3 || dimension.height != n4) {
            this.doLayout();
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        ItemEvent itemEvent = new ItemEvent(this, 701, this, 1);
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            ((ItemListener)enumeration.nextElement()).itemStateChanged(itemEvent);
        }
    }

    public void addItemListener(ItemListener itemListener) {
        this.listeners.addElement(itemListener);
    }

    public void removeItemListener(ItemListener itemListener) {
        this.listeners.removeElement(itemListener);
    }

    public Object[] getSelectedObjects() {
        Object[] objectArray = new Object[]{this.getSelectedItem()};
        return objectArray;
    }

    public abstract int getSelectedIndex();

    public String getSelectedItem() {
        String[] stringArray = this.getScale().getLabels();
        return stringArray[this.getSelectedIndex()];
    }

    public void setSelection(long l) {
        this.getSelector().select(l);
    }

    public long getSelectedValue() {
        return this.getSelector().getSelectedValue();
    }

    public void setEnabled(boolean bl) {
        this.getSelector().setEnabled(bl);
        this.repaint();
    }

    public boolean isEnabled() {
        return this.getSelector().isEnabled();
    }

    public void setBorderColor(Color color) {
        this.border.setColor(color);
        this.repaint();
    }

    public Color getBorderColor() {
        return this.border.getColor();
    }

    public void setBorderWidth(int n) {
        this.border.setWidth(n);
        this.doLayout();
        this.repaint();
    }

    public int getBorderWidth() {
        return this.border.getWidth();
    }

    public void setChoices(Choices choices) {
        this.getSelector().setValues(choices.values);
        this.getScale().setLabels(choices.labels);
        this.doLayout();
        this.repaint();
    }

    public Choices getChoices() {
        return new Choices(this.getSelector().getValues(), this.getScale().getLabels());
    }

    public void setLabel(String string) {
        this.label.setText(string);
        this.doLayout();
        this.repaint();
    }

    public String getLabel() {
        return this.label.getText();
    }

    public void setLabelColor(Color color) {
        this.label.setForeground(color);
        this.repaint();
    }

    public Color getLabelColor() {
        return this.label.getForeground();
    }

    public void setLabelFont(Font font) {
        this.label.setFont(font);
        this.doLayout();
        this.repaint();
    }

    public Font getLabelFont() {
        return this.label.getFont();
    }

    public void setScaleVisible(boolean bl) {
        this.getScale().setVisible(bl);
        this.doLayout();
        this.repaint();
    }

    public boolean isScaleVisible() {
        return this.getScale().isVisible();
    }

    public void setScaleFont(Font font) {
        this.getScale().setFont(font);
        this.doLayout();
        this.repaint();
    }

    public Font getScaleFont() {
        return this.getScale().getFont();
    }

    public void setScaleColor(Color color) {
        this.getScale().setForeground(color);
        this.repaint();
    }

    public Color getScaleColor() {
        return this.getScale().getForeground();
    }
}

