/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.widgets;

import com.schneiderautomation.widgets.Scale;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.io.Serializable;

class VScale
extends Scale
implements Serializable {
    static final long serialVersionUID = -3254352023764454737L;
    static final int LEFT = 0;
    static final int RIGHT = 1;
    private int orientation = 1;

    VScale(boolean bl) {
        super(bl);
    }

    VScale(boolean bl, int n) {
        super(bl);
        this.orientation = n;
    }

    Dimension getMinimumSize() {
        Dimension dimension = new Dimension(0, 0);
        if (this.majorTics > 0) {
            FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.font);
            int n = 0;
            for (int i = 0; i <= this.majorTics; ++i) {
                float f = (this.maxval - this.minval) * (float)(this.majorTics - i) / (float)this.majorTics + this.minval;
                int n2 = fontMetrics.stringWidth(this.formatValue(f));
                if (n2 <= n) continue;
                n = n2;
            }
            dimension.width = n + this.majorTicSize;
            dimension.height = fontMetrics.getAscent() * (this.majorTics + 1);
        } else if (this.minorTics > 0) {
            dimension.width = this.minorTicSize;
            dimension.height = this.minorTics + 1;
        }
        return dimension;
    }

    void paint(Graphics graphics) {
        int n;
        int n2;
        int n3;
        graphics.setColor(this.foreground);
        if (this.majorTics > 0) {
            FontMetrics fontMetrics = graphics.getFontMetrics(this.font);
            graphics.setFont(this.font);
            n3 = this.box.y;
            n2 = this.fCenterEndLabels ? n3 + fontMetrics.getAscent() / 2 : n3 + fontMetrics.getAscent() - 1;
            n = this.orientation == 1 ? this.box.x : this.box.x + this.box.width - this.majorTicSize - 1;
            int n4 = this.orientation == 1 ? this.box.x + this.majorTicSize : this.box.x + this.box.width - 1;
            String string = this.formatValue(this.maxval);
            if (this.orientation == 1) {
                graphics.drawString(string, n4, n2 - 1);
                graphics.drawLine(n, n3, n4 - 2, n3);
            } else {
                graphics.drawString(string, n - fontMetrics.stringWidth(string), n2 - 1);
                graphics.drawLine(n + 2, n3, n4, n3);
            }
            double d = (double)this.maxval - (double)this.minval;
            for (int i = 1; i < this.majorTics; ++i) {
                double d2 = (double)(this.majorTics - i) / (double)this.majorTics;
                float f = (float)(d * d2 + (double)this.minval);
                n3 = this.box.y + this.box.height * i / this.majorTics;
                n2 = n3 + fontMetrics.getAscent() / 2;
                string = this.formatValue(f);
                if (this.orientation == 1) {
                    graphics.drawString(string, n4, n2 - 1);
                    graphics.drawLine(n, n3, n4 - 2, n3);
                    continue;
                }
                graphics.drawString(string, n - fontMetrics.stringWidth(string), n2 - 1);
                graphics.drawLine(n + 2, n3, n4, n3);
            }
            n3 = this.box.y + this.box.height - 1;
            n2 = this.fCenterEndLabels ? n3 + fontMetrics.getAscent() / 2 : n3 + 2;
            string = this.formatValue(this.minval);
            if (this.orientation == 1) {
                graphics.drawString(string, n4, n2 - 1);
                graphics.drawLine(n, n3, n4 - 2, n3);
            } else {
                graphics.drawString(string, n - fontMetrics.stringWidth(string), n2 - 1);
                graphics.drawLine(n + 2, n3, n4, n3);
            }
        }
        if (this.minorTics > 0) {
            int n5 = this.orientation == 1 ? this.box.x : this.box.x + this.box.width - this.minorTicSize - 1;
            n3 = this.orientation == 1 ? this.box.x + this.minorTicSize : this.box.x + this.box.width - 1;
            for (n2 = 0; n2 < this.minorTics; ++n2) {
                n = this.box.y + this.box.height * n2 / this.minorTics;
                graphics.drawLine(n5, n, n3, n);
            }
            n2 = this.box.y + this.box.height - 1;
            graphics.drawLine(n5, n2, n3, n2);
        }
        if (this.minorTics > 0 || this.majorTics > 0) {
            int n6 = this.orientation == 1 ? this.box.x : this.box.x + this.box.width - 1;
            graphics.drawLine(n6, this.box.y, n6, this.box.y + this.box.height - 1);
        }
    }
}

