/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.widgets;

import com.schneiderautomation.gde.Wrapper;
import com.schneiderautomation.widgets.Scale;
import com.schneiderautomation.widgets.Scroller;
import com.schneiderautomation.widgets.SliderGui;
import com.schneiderautomation.widgets.SliderInterface;
import com.schneiderautomation.widgets.VScale;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.Serializable;

public class VSliderGui
extends SliderGui
implements Serializable {
    static final long serialVersionUID = 1948484660722459862L;
    private Scale scale = new VScale(true);
    private Scroller bar = new Scroller(1);

    public VSliderGui() {
        this.InitWrapper();
        this.setBackground(Color.lightGray);
        this.add(this.bar);
        this.scale.setMinimum(this.bar.getEUMinimum());
        this.scale.setMaximum(this.bar.getEUMaximum());
    }

    protected Scale getScale() {
        return this.scale;
    }

    private void InitWrapper() {
        Wrapper.BORDER_WIDTH = 4;
        Wrapper.BORDER_WIDTH_X2 = Wrapper.BORDER_WIDTH * 2;
    }

    protected SliderInterface getSlider() {
        return this.bar;
    }

    public void paint(Graphics graphics) {
        this.scale.paint(graphics);
        super.paint(graphics);
        if (Wrapper.BORDER_WIDTH != 4) {
            this.InitWrapper();
        }
    }

    public void doLayout() {
        Dimension dimension = this.getSize();
        this.border.setBounds(new Rectangle(0, 0, dimension.width, dimension.height));
        int n = this.border.getMinimumSize().height;
        dimension.width -= n;
        dimension.height -= n;
        int n2 = this.label.getMinimumSize().height;
        int n3 = this.scale.getMinimumSize().width;
        int n4 = dimension.width - n3;
        int n5 = dimension.height - n2;
        int n6 = n / 2;
        int n7 = n5 - 32 - this.bar.getThumbLength();
        int n8 = n6 + 16 + this.bar.getThumbLength() / 2;
        this.bar.setBounds(new Rectangle(n6, n6, n4, n5));
        this.scale.setBounds(new Rectangle(n6 + n4, n8, n3, n7));
        this.label.setBounds(new Rectangle(n6, n6 + n5, dimension.width, n2));
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.getMinimumSize();
        dimension.width += 6;
        dimension.height += 80;
        return dimension;
    }

    public Dimension getMinimumSize() {
        Dimension dimension = this.scale.getMinimumSize();
        Dimension dimension2 = this.bar.getMinimumSize();
        Dimension dimension3 = this.label.getMinimumSize();
        Dimension dimension4 = this.border.getMinimumSize();
        int n = dimension.width + dimension2.width;
        if (dimension3.width > n) {
            n = dimension3.width;
        }
        n += dimension4.width;
        int n2 = dimension.height;
        if (dimension2.height > n2) {
            n2 = dimension2.height;
        }
        return new Dimension(n, n2 += dimension4.height + dimension3.height);
    }
}

