/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.gde;

import com.schneiderautomation.factorycast.AddressEditor;
import com.schneiderautomation.namespace.VarLookupInterface;
import com.schneiderautomation.navigator.VarSelect;
import com.schneiderautomation.navigator.VarSelectEvent;
import com.schneiderautomation.navigator.VarSelectOwner;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.BitSet;

public class AddressViewPanel
extends Panel
implements FocusListener,
VarSelectOwner {
    private static Point location = new Point(100, 100);
    private TextField address = new TextField(10);
    private Button lookupButton = new Button("...");
    private AddressEditor editor;
    private BitSet datatypes;
    private VarLookupInterface varLookup;
    private VarSelect varSelect;

    public AddressViewPanel(AddressEditor addressEditor) {
        this(addressEditor, null, null);
    }

    public AddressViewPanel(AddressEditor addressEditor, BitSet bitSet, VarLookupInterface varLookupInterface) {
        this.editor = addressEditor;
        this.datatypes = bitSet;
        this.setVarLookup(varLookupInterface);
        this.lookupButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AddressViewPanel.this.lookupVar();
            }
        });
        this.address.setText((String)addressEditor.getValue());
        this.address.addFocusListener(this);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets.right = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.address, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.0;
        this.add((Component)this.lookupButton, gridBagConstraints);
    }

    public void repaint() {
        this.address.setText((String)this.editor.getValue());
    }

    public void setVarLookup(VarLookupInterface varLookupInterface) {
        this.varLookup = varLookupInterface;
        this.lookupButton.setEnabled(varLookupInterface != null);
    }

    public void closeVarLookupDlg() {
        if (this.varSelect != null) {
            this.varSelect.dispose();
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        this.editor.setValue((Object)this.address.getText());
        this.editor.firePropertyChange();
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void varSelectionPerformed(VarSelectEvent varSelectEvent) {
        this.address.setText(varSelectEvent.getSelection()[0]);
        this.editor.setValue((Object)this.address.getText());
        this.editor.firePropertyChange();
    }

    public void varSelectClosed() {
        location = this.varSelect.getLocation();
        this.varSelect = null;
    }

    private void lookupVar() {
        if (this.varSelect == null) {
            this.varSelect = new VarSelect(this.getFrameParent(), this, true, false, this.getLocale());
            ((Component)this.varSelect).setLocation(location);
            try {
                this.varSelect.setDatatypeFilter(this.datatypes);
                this.varSelect.initSelection(this.varLookup);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.varSelect.showMe();
    }

    private Frame getFrameParent() {
        Container container = this.getParent();
        while (!(container instanceof Frame)) {
            container = ((Component)container).getParent();
        }
        return (Frame)container;
    }
}

