/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.gde;

import com.schneiderautomation.gde.GdeCustomizer;
import com.schneiderautomation.gde.GdeStrings;
import com.schneiderautomation.gde.GdeTopPanel;
import com.schneiderautomation.gde.PropertySheetOwner;
import com.schneiderautomation.gde.Wrapper;
import com.schneiderautomation.namespace.VarLookupInterface;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.Customizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class CustomizerDialog
extends Dialog
implements GdeCustomizer,
PropertyChangeListener {
    private VarLookupInterface varLookup;
    private PropertySheetOwner owner;
    private Customizer customizer;
    private Component body;
    private Component target;

    CustomizerDialog(Frame frame, PropertySheetOwner propertySheetOwner, Customizer customizer, Component component, Point point, VarLookupInterface varLookupInterface) {
        super(frame, false);
        this.customizer = customizer;
        this.varLookup = varLookupInterface;
        this.target = component;
        this.owner = propertySheetOwner;
        this.body = (Component)((Object)customizer);
        customizer.setObject(component);
        customizer.addPropertyChangeListener(this);
        Object[] objectArray = new Object[]{((Wrapper)component.getParent()).getName()};
        this.setTitle(GdeStrings.getFormattedString("CSTM_TITLE", objectArray));
        Button button = new Button(GdeStrings.getString("DONE_BTN_LBL"));
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerDialog.this.dispose();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                CustomizerDialog.this.dispose();
            }

            public void windowClosed(WindowEvent windowEvent) {
                CustomizerDialog.this.owner.dialogClosed();
            }
        });
        ((Component)this).setBackground(Color.lightGray);
        this.body.setBackground(GdeTopPanel.panelBkgnd);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.add(this.body, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        this.add((Component)button, gridBagConstraints);
        if (point == null) {
            point = frame.getLocation();
            point.x += 100;
            point.y += 100;
        }
        Insets insets = this.getInsets();
        Dimension dimension = this.body.getPreferredSize();
        int n = insets.left + insets.right + dimension.width;
        if ((n += gridBagConstraints.insets.left + gridBagConstraints.insets.right) < 250) {
            n = 250;
        }
        int n2 = insets.top + insets.bottom + dimension.height + 40;
        if ((n2 += (gridBagConstraints.insets.top + gridBagConstraints.insets.bottom) * 2) < 150) {
            n2 = 150;
        }
        ((Component)this).setBounds(point.x, point.y, n, n2);
        this.setResizable(false);
    }

    public void paint(Graphics graphics) {
        Rectangle rectangle = this.body.getBounds();
        int n = rectangle.x - 2;
        int n2 = rectangle.y - 2;
        int n3 = rectangle.x + rectangle.width + 1;
        int n4 = rectangle.y + rectangle.height + 1;
        graphics.setColor(Color.gray);
        graphics.drawLine(n, n4, n, n2);
        graphics.drawLine(n, n2, n3, n2);
        graphics.setColor(Color.white);
        graphics.drawLine(n3, n2, n3, n4);
        graphics.drawLine(n3, n4, n, n4);
        graphics.setColor(Color.black);
        graphics.drawLine(++n, --n4, n, ++n2);
        graphics.drawLine(n, n2, --n3, n2);
        graphics.setColor(Color.lightGray);
        graphics.drawLine(n3, n2, n3, n4);
        graphics.drawLine(n3, n4, n, n4);
    }

    public VarLookupInterface getVarLookup() {
        return this.varLookup;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.target.invalidate();
        int n = Wrapper.BORDER_WIDTH;
        Dimension dimension = this.target.getMinimumSize();
        if (dimension.width < n) {
            dimension.width = n;
        }
        if (dimension.height < n) {
            dimension.height = n;
        }
        Dimension dimension2 = this.target.getSize();
        if (dimension2.width < dimension.width) {
            dimension2.width = dimension.width;
        }
        if (dimension2.height < dimension.height) {
            dimension2.height = dimension.height;
        }
        Wrapper wrapper = (Wrapper)this.target.getParent();
        wrapper.setSize(dimension2.width + Wrapper.BORDER_WIDTH_X2, dimension2.height + Wrapper.BORDER_WIDTH_X2);
        this.target.repaint();
        this.owner.propertyModified();
    }
}

