/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.gde;

import com.schneiderautomation.gde.FontEditorPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyEditorSupport;

public class FontEditor
extends PropertyEditorSupport {
    private Font value;

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object object) {
        this.value = (Font)object;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        return new FontEditorPanel(this);
    }

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        FontMetrics fontMetrics = graphics.getFontMetrics(this.value);
        int n = rectangle.x + 2;
        int n2 = rectangle.y + (rectangle.height + fontMetrics.getHeight()) / 2 - fontMetrics.getDescent();
        graphics.setFont(this.value);
        graphics.setColor(Color.black);
        graphics.drawString("Abcdefg", n, n2);
        graphics.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
    }

    public String getJavaInitializationString() {
        return "(new java.awt.Font(\"" + this.value.getName() + "\", " + this.value.getStyle() + ", " + this.value.getSize() + "))";
    }
}

