/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.gde;

import java.awt.Adjustable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;

public class GdeScrollPane
extends Panel
implements AdjustmentListener {
    public static final int SCROLLBARS_AS_NEEDED = 0;
    public static final int SCROLLBARS_ALWAYS = 1;
    public static final int SCROLLBARS_NEVER = 2;
    private static final int BORDER_WIDTH = 2;
    private static final int HSB_WIDTH = 16;
    private static final int VSB_WIDTH = 16;
    private int scrollbarDisplayPolicy;
    private Component comp = new Panel();
    private Panel view = new Panel();
    private Scrollbar vsb = new Scrollbar(1);
    private Scrollbar hsb = new Scrollbar(0);

    public GdeScrollPane() {
        this(0);
    }

    public GdeScrollPane(int n) {
        this.scrollbarDisplayPolicy = n;
        this.vsb.addAdjustmentListener(this);
        this.vsb.setUnitIncrement(1);
        this.hsb.addAdjustmentListener(this);
        this.hsb.setUnitIncrement(1);
        this.view.setLayout(null);
        this.view.add(this.comp);
        this.setLayout(null);
        super.add(this.vsb);
        super.add(this.hsb);
        super.add(this.view);
    }

    public Component add(Component component) {
        this.view.remove(this.comp);
        this.comp = this.view.add(component);
        return this.comp;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        int n = 0;
        int n2 = 0;
        int n3 = dimension.width - 1;
        int n4 = dimension.height - 1;
        graphics.setColor(Color.gray);
        graphics.drawLine(n, n4, n, n2);
        graphics.drawLine(n, n2, n3, n2);
        graphics.setColor(Color.white);
        graphics.drawLine(n3, n2, n3, n4);
        graphics.drawLine(n3, n4, n, n4);
        graphics.setColor(Color.black);
        graphics.drawLine(++n, --n4, n, ++n2);
        graphics.drawLine(n, n2, --n3, n2);
        graphics.setColor(Color.lightGray);
        graphics.drawLine(n3, n2, n3, n4);
        graphics.drawLine(n3, n4, n, n4);
    }

    public int getScrollbarDisplayPolicy() {
        return this.scrollbarDisplayPolicy;
    }

    public Dimension getViewportSize() {
        return this.view.getSize();
    }

    public int getHScrollbarHeight() {
        return this.scrollbarDisplayPolicy != 2 ? 0 : 16;
    }

    public int getVScrollbarWidth() {
        return this.scrollbarDisplayPolicy != 2 ? 0 : 16;
    }

    public Adjustable getHAdjustable() {
        return this.hsb;
    }

    public Adjustable getVAdjustable() {
        return this.vsb;
    }

    public void setScrollPosition(Point point) {
        this.setScrollPosition(point.x, point.y);
    }

    public void setScrollPosition(int n, int n2) {
        this.hsb.setValue(n);
        this.vsb.setValue(n2);
    }

    public Point getScrollPosition() {
        return new Point(this.hsb.getValue(), this.vsb.getValue());
    }

    public void doLayout() {
        Dimension dimension = this.getSize();
        dimension.width -= 4;
        dimension.height -= 4;
        Dimension dimension2 = this.comp.getPreferredSize();
        boolean bl = false;
        boolean bl2 = false;
        switch (this.scrollbarDisplayPolicy) {
            case 0: {
                if (dimension2.height <= dimension.height && dimension2.width <= dimension.width) break;
                if (dimension2.height <= dimension.height - 16) {
                    bl = true;
                    break;
                }
                if (dimension2.width <= dimension.width - 16) {
                    bl2 = true;
                    break;
                }
            }
            case 1: {
                bl2 = true;
                bl = true;
            }
        }
        if (bl) {
            dimension.height -= 16;
        }
        if (bl2) {
            dimension.width -= 16;
        }
        if (dimension2.height <= dimension.height) {
            dimension2.height = dimension.height;
            this.setScrollbarSpan(this.vsb, 0, 1);
        } else {
            this.setScrollbarSpan(this.vsb, dimension.height, dimension2.height);
        }
        if (dimension2.width <= dimension.width) {
            dimension2.width = dimension.width;
            this.setScrollbarSpan(this.hsb, 0, 1);
        } else {
            this.setScrollbarSpan(this.hsb, dimension.width, dimension2.width);
        }
        this.hsb.setVisible(bl);
        this.vsb.setVisible(bl2);
        this.hsb.setBounds(2, dimension.height + 2, dimension.width, 16);
        this.vsb.setBounds(dimension.width + 2, 2, 16, dimension.height);
        this.view.setBounds(2, 2, dimension.width, dimension.height);
        this.comp.setBounds(0, 0, dimension2.width, dimension2.height);
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (adjustmentEvent.getSource() == this.vsb) {
            this.comp.setLocation(this.comp.getLocation().x, -this.vsb.getValue());
        } else {
            this.comp.setLocation(-this.hsb.getValue(), this.comp.getLocation().y);
        }
    }

    private void setScrollbarSpan(Scrollbar scrollbar, int n, int n2) {
        scrollbar.setValues(0, n, 0, n2);
        scrollbar.setBlockIncrement(n);
        scrollbar.setEnabled(n > 0);
    }
}

