/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.gde;

import com.schneiderautomation.gde.PropertyDialog;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyEditor;

public class PropertyCanvas
extends Canvas
implements MouseListener {
    private static boolean ignoreClick = false;
    private PropertyEditor editor;
    private Frame frame;
    private Container parent;
    private String name;

    public PropertyCanvas(PropertyEditor propertyEditor, Frame frame, Container container, String string) {
        this(propertyEditor);
        this.init(frame, container, string);
    }

    public PropertyCanvas(PropertyEditor propertyEditor) {
        this.editor = propertyEditor;
        this.addMouseListener(this);
    }

    public void init(Frame frame, Container container, String string) {
        this.frame = frame;
        this.parent = container;
        this.name = string;
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        Rectangle rectangle = new Rectangle(0, 0, dimension.width, dimension.height);
        this.editor.paintValue(graphics, rectangle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseClicked(MouseEvent mouseEvent) {
        if (!ignoreClick) {
            try {
                ignoreClick = true;
                this.parent.setCursor(Cursor.getPredefinedCursor(3));
                PropertyDialog propertyDialog = new PropertyDialog(this.frame, this.name, this.editor);
                this.parent.setCursor(Cursor.getPredefinedCursor(0));
                Point point = this.parent.getLocation();
                ((Component)propertyDialog).setLocation(point.x + 12, point.y + 48);
                propertyDialog.show();
            }
            finally {
                ignoreClick = false;
            }
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }
}

