/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.gde;

import com.schneiderautomation.gde.GdeScrollPane;
import com.schneiderautomation.gde.GdeStrings;
import com.schneiderautomation.gde.PropertySheetOwner;
import com.schneiderautomation.gde.PropertySheetPanel;
import com.schneiderautomation.namespace.VarLookupInterface;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

class PropertySheet
extends Dialog
implements Runnable {
    private Thread engine;
    private Component target;
    private PropertySheetOwner owner;
    private GdeScrollPane pane;
    private PropertySheetPanel panel;

    PropertySheet(Frame frame, PropertySheetOwner propertySheetOwner, Point point, VarLookupInterface varLookupInterface) {
        super(frame, false);
        this.owner = propertySheetOwner;
        Button button = new Button(GdeStrings.getString("DONE_BTN_LBL"));
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PropertySheet.this.dispose();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                PropertySheet.this.dispose();
            }

            public void windowClosed(WindowEvent windowEvent) {
                PropertySheet.this.panel.closeDialogs();
                PropertySheet.this.owner.dialogClosed();
                PropertySheet.this.stop();
            }
        });
        this.pane = new GdeScrollPane();
        this.panel = new PropertySheetPanel(frame, this, varLookupInterface);
        this.pane.add(this.panel);
        ((Component)this).setBackground(Color.lightGray);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.add((Component)this.pane, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        this.add((Component)button, gridBagConstraints);
        if (point == null) {
            point = frame.getLocation();
            point.x += 100;
            point.y += 100;
        }
        this.setResizable(false);
        ((Component)this).setBounds(point.x, point.y, 390, 400);
        this.engine = new Thread(this);
        this.engine.start();
    }

    GdeScrollPane getScrollPane() {
        return this.pane;
    }

    synchronized void setTarget(Component component) {
        this.target = component;
        if (component == null) {
            this.panel.setTarget(null);
        } else {
            this.notify();
        }
    }

    void refresh() {
        this.panel.refresh();
    }

    void notifyModified() {
        this.owner.propertyModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.engine != null) {
            Component component;
            PropertySheet propertySheet = this;
            synchronized (propertySheet) {
                while (this.engine != null && this.target == null) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                component = this.target;
                this.target = null;
            }
            if (component == null) continue;
            this.panel.setTarget(component);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() {
        if (this.engine != null) {
            Thread thread = this.engine;
            PropertySheet propertySheet = this;
            synchronized (propertySheet) {
                this.engine = null;
                this.target = null;
                this.notify();
            }
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

