/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.sysdiag;

import com.schneiderautomation.sysdiag.Assert;
import com.schneiderautomation.sysdiag.Orientation;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class RowLayout
implements LayoutManager {
    private static int _defaultGap = 5;
    private int gap;
    private Orientation verticalOrientation;
    private Orientation horizontalOrientation;

    public RowLayout() {
        this(Orientation.CENTER, Orientation.CENTER, _defaultGap);
    }

    public RowLayout(int n) {
        this(Orientation.CENTER, Orientation.CENTER, n);
    }

    public RowLayout(Orientation orientation, Orientation orientation2) {
        this(orientation, orientation2, _defaultGap);
    }

    public RowLayout(Orientation orientation, Orientation orientation2, int n) {
        Assert.notFalse(n >= 0);
        Assert.notFalse(orientation == Orientation.LEFT || orientation == Orientation.CENTER || orientation == Orientation.RIGHT);
        Assert.notFalse(orientation2 == Orientation.TOP || orientation2 == Orientation.CENTER || orientation2 == Orientation.BOTTOM);
        this.gap = n;
        this.verticalOrientation = orientation2;
        this.horizontalOrientation = orientation;
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public Dimension preferredLayoutSize(Container container) {
        Insets insets = container.getInsets();
        Dimension dimension = new Dimension(0, 0);
        int n = container.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = container.getComponent(i);
            if (!component.isVisible()) continue;
            Dimension dimension2 = component.getPreferredSize();
            dimension.width += dimension2.width;
            dimension.height = Math.max(dimension2.height, dimension.height);
            if (i <= 0) continue;
            dimension.width += this.gap;
        }
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }

    public Dimension minimumLayoutSize(Container container) {
        Insets insets = container.getInsets();
        Dimension dimension = new Dimension(0, 0);
        int n = container.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = container.getComponent(i);
            if (!component.isVisible()) continue;
            Dimension dimension2 = component.getMinimumSize();
            dimension.width += dimension2.width;
            dimension.height = Math.max(dimension2.height, dimension.height);
            if (i <= 0) continue;
            dimension.width += this.gap;
        }
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }

    public void layoutContainer(Container container) {
        Insets insets = container.getInsets();
        int n = container.getComponentCount();
        int n2 = 0;
        int n3 = insets.left;
        Dimension dimension = container.getPreferredSize();
        Dimension dimension2 = container.getSize();
        if (this.horizontalOrientation == Orientation.CENTER) {
            n3 = n3 + dimension2.width / 2 - dimension.width / 2;
        }
        if (this.horizontalOrientation == Orientation.RIGHT) {
            n3 = n3 + dimension2.width - dimension.width;
        }
        for (int i = 0; i < n; ++i) {
            Component component = container.getComponent(i);
            if (!component.isVisible()) continue;
            Dimension dimension3 = component.getPreferredSize();
            if (this.verticalOrientation == Orientation.CENTER) {
                n2 = dimension2.height / 2 - dimension3.height / 2;
            } else if (this.verticalOrientation == Orientation.TOP) {
                n2 = insets.top;
            } else if (this.verticalOrientation == Orientation.BOTTOM) {
                n2 = dimension2.height - dimension3.height - insets.bottom;
            }
            component.setBounds(n3, n2, dimension3.width, dimension3.height);
            n3 += dimension3.width + this.gap;
        }
    }
}

