/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.sysdiag.qbf;

import com.schneiderautomation.factorycast.CommBean;
import com.schneiderautomation.factorycast.MonitorNumber;
import com.schneiderautomation.sysdiag.qbf.AnalogDataPanel;
import com.schneiderautomation.sysdiag.qbf.AnalogListener;
import com.schneiderautomation.sysdiag.qbf.ModuleDescriptor;
import com.schneiderautomation.sysdiag.qbf.ThreeDBorder;
import com.schneiderautomation.sysdiag.qbf.TrafficCop;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;

public class AnalogPanel
extends Panel
implements ActionListener {
    private static final Color myLightYellow = new Color(240, 243, 187);
    private static final int NUMBER = 64;
    private static TrafficCop myCop;
    private Label[] labelArray = new Label[64];
    private TextField[] fieldArray = new TextField[64];
    private MonitorNumber monitorInBean = null;
    private MonitorNumber monitorOutBean = null;
    private AnalogListener analogInListener;
    private AnalogListener analogOutListener;
    private ModuleDescriptor modDesc = new ModuleDescriptor();
    private CommBean comm;
    private Label l1;
    private GridBagConstraints constraints;
    private GridBagLayout gbLayout;
    private AnalogDataPanel dataPanel;
    private Button backbutton;
    Label in1 = new Label("Input Range xxxxxx - xxxxxx", 1);
    Label out1 = new Label("Output Range xxxxxx - xxxxxx", 1);

    public AnalogPanel(CommBean commBean, TrafficCop trafficCop, Button button) {
        this.comm = commBean;
        this.backbutton = button;
        myCop = trafficCop;
        if (myCop == null) {
            myCop = new TrafficCop(commBean);
        }
        this.setBackground(myLightYellow);
        this.constraints = new GridBagConstraints();
        this.gbLayout = new GridBagLayout();
        this.setLayout(this.gbLayout);
        Panel panel = new Panel();
        this.l1 = new Label("Analog Screen  -  Drop # xxx  Rack # xx Drop # xx", 1);
        this.l1.setFont(new Font("TimesRoman", 1, 16));
        panel.add(this.l1);
        this.constraints.gridx = 1;
        this.constraints.gridy = 1;
        this.constraints.gridwidth = 1;
        this.constraints.gridheight = 1;
        this.constraints.anchor = 11;
        this.constraints.fill = 0;
        this.constraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)panel, this.constraints);
        this.dataPanel = new AnalogDataPanel(this.labelArray, this.fieldArray, 64);
        Panel panel2 = new Panel();
        panel2.setBackground(myLightYellow);
        ThreeDBorder threeDBorder = new ThreeDBorder(this.dataPanel, 4, 5);
        panel2.add(threeDBorder);
        ++this.constraints.gridy;
        this.constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)panel2, this.constraints);
        this.in1.setFont(new Font("TimesRoman", 1, 14));
        this.out1.setFont(new Font("TimesRoman", 1, 14));
        this.constraints.fill = 2;
        ++this.constraints.gridy;
        this.add((Component)this.out1, this.constraints);
        ++this.constraints.gridy;
        this.add((Component)this.in1, this.constraints);
        button.addActionListener(this);
    }

    public void showActualModule(short s, short s2, short s3, short s4, CommBean commBean, short s5, String string) {
        boolean bl;
        String string2;
        String string3;
        int n;
        boolean bl2;
        int n2 = 0;
        this.l1.setText(string + ": Drop " + s2 + "  Rack " + s3 + "  Slot " + s4);
        this.modDesc = myCop.getModuleIO(s, s2, s3, s4, s5);
        if (this.modDesc == null) {
            this.labelArray[0].setText("??????");
            this.labelArray[0].setForeground(Color.magenta);
            this.labelArray[0].setVisible(true);
            this.fieldArray[0].setText("?");
            this.fieldArray[0].setForeground(Color.magenta);
            this.fieldArray[0].setVisible(true);
            for (int i = 1; i < this.labelArray.length; ++i) {
                this.labelArray[i].setVisible(false);
                this.fieldArray[i].setVisible(false);
            }
            this.refreshLayout();
            return;
        }
        int n3 = this.modDesc.numInputBytes * 8;
        int n4 = this.modDesc.numOutputBytes * 8;
        if (n4 > 0) {
            bl2 = true;
            if (this.modDesc.outputsReference == 1) {
                n = n4;
                string3 = String.valueOf(1000000 + this.modDesc.outStartReference);
                string2 = String.valueOf(1000000 + this.modDesc.outStartReference + n - 1);
                this.out1.setText("Output Range " + string3.substring(1) + " - " + string2.substring(1));
            } else {
                n = (n4 + 15) / 16;
                string3 = String.valueOf(400000 + this.modDesc.outStartReference);
                string2 = String.valueOf(400000 + this.modDesc.outStartReference + n - 1);
                this.out1.setText("Output Range " + string3 + " - " + string2);
            }
        } else {
            bl2 = false;
            this.out1.setText("");
        }
        if (n3 > 0) {
            bl = true;
            if (this.modDesc.inputsReference == 0) {
                n = n3;
                string3 = String.valueOf(100000 + this.modDesc.inStartReference);
                string2 = String.valueOf(100000 + this.modDesc.inStartReference + n - 1);
                this.in1.setText("Input Range " + string3 + " - " + string2);
            } else {
                n = (n3 + 15) / 16;
                string3 = String.valueOf(300000 + this.modDesc.inStartReference);
                string2 = String.valueOf(300000 + this.modDesc.inStartReference + n - 1);
                this.in1.setText("Input Range " + string3 + " - " + string2);
            }
        } else {
            bl = false;
            this.in1.setText("");
        }
        n3 = (n3 + 15) / 16;
        n4 = (n4 + 15) / 16;
        if (n3 > this.labelArray.length || n4 > this.labelArray.length) {
            if (n4 > this.labelArray.length) {
                n4 = this.labelArray.length;
                bl = false;
            } else {
                n3 = this.labelArray.length;
                bl2 = false;
            }
        } else if (n3 + n4 > this.labelArray.length) {
            bl = false;
        }
        if (this.modDesc.outputsReference != 3) {
            bl2 = false;
        }
        if (this.modDesc.inputsReference != 2) {
            bl = false;
        }
        for (n = 0; n < this.labelArray.length; ++n) {
            this.labelArray[n].setVisible(false);
            this.fieldArray[n].setVisible(false);
        }
        if (this.monitorOutBean != null) {
            this.monitorOutBean.deregister();
            if (this.analogOutListener != null) {
                this.monitorOutBean.removePropertyChangeListener((PropertyChangeListener)this.analogOutListener);
            }
        }
        if (this.monitorInBean != null) {
            this.monitorInBean.deregister();
            if (this.analogInListener != null) {
                this.monitorInBean.removePropertyChangeListener((PropertyChangeListener)this.analogInListener);
            }
        }
        if (bl2) {
            n2 = n4;
            for (n = 0; n < n4; ++n) {
                this.labelArray[n].setText(String.valueOf(400000 + this.modDesc.outStartReference + n));
                this.labelArray[n].setVisible(true);
                this.fieldArray[n].setText("-----");
                this.fieldArray[n].setVisible(true);
            }
            this.analogOutListener = new AnalogListener(this.fieldArray, n4, 0);
            this.monitorOutBean = new MonitorNumber(commBean.getAdaptor());
            this.monitorOutBean.setAddress("4" + Integer.toString(this.modDesc.outStartReference));
            this.monitorOutBean.setDatatype((short)5);
            this.monitorOutBean.setQuantity((short)n4);
            this.monitorOutBean.addPropertyChangeListener((PropertyChangeListener)this.analogOutListener);
            this.monitorOutBean.register();
        }
        if (bl) {
            for (n = 0; n < n3; ++n) {
                int n5 = n + n2;
                this.labelArray[n5].setText(String.valueOf(300000 + this.modDesc.inStartReference + n));
                this.labelArray[n5].setVisible(true);
                this.fieldArray[n5].setText("-----");
                this.fieldArray[n5].setVisible(true);
            }
            this.analogInListener = new AnalogListener(this.fieldArray, n3, n2);
            this.monitorInBean = new MonitorNumber(commBean.getAdaptor());
            this.monitorInBean.setAddress("3" + Integer.toString(this.modDesc.inStartReference));
            this.monitorInBean.setDatatype((short)5);
            this.monitorInBean.setQuantity((short)n3);
            this.monitorInBean.addPropertyChangeListener((PropertyChangeListener)this.analogInListener);
            this.monitorInBean.register();
        }
        this.refreshLayout();
    }

    private void refreshLayout() {
        this.dataPanel.invalidate();
        this.validate();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.monitorInBean != null) {
            this.monitorInBean.deregister();
            this.monitorInBean.removePropertyChangeListener((PropertyChangeListener)this.analogInListener);
            this.monitorInBean = null;
            this.analogInListener = null;
        }
        if (this.monitorOutBean != null) {
            this.monitorOutBean.deregister();
            this.monitorOutBean.removePropertyChangeListener((PropertyChangeListener)this.analogOutListener);
            this.monitorOutBean = null;
            this.analogOutListener = null;
        }
    }
}

