/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.sysdiag.qbf;

import com.schneiderautomation.sysdiag.Assert;
import com.schneiderautomation.sysdiag.Etching;
import com.schneiderautomation.sysdiag.Orientation;
import com.schneiderautomation.sysdiag.qbf.EtchedRectangle;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;

public class Box
extends Panel {
    private static Orientation _defaultOrientation = Orientation.CENTER;
    private EtchedRectangle box = new EtchedRectangle(this);
    private Label titleLabel;
    private Orientation orient;

    public Box(Component component, String string) {
        this(component, new Label(string, 1), _defaultOrientation);
    }

    public Box(Component component, String string, Orientation orientation) {
        this(component, new Label(string, 1), orientation);
    }

    public Box(Component component, Label label) {
        this(component, label, _defaultOrientation);
    }

    public Box(Component component, Label label, Orientation orientation) {
        Assert.notNull(component);
        Assert.notNull(label);
        this.titleLabel = label;
        this.orient = orientation;
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.gridwidth = 0;
        if (orientation == Orientation.CENTER) {
            gridBagConstraints.anchor = 11;
        } else if (orientation == Orientation.RIGHT) {
            gridBagConstraints.anchor = 12;
            gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        } else if (orientation == Orientation.LEFT) {
            gridBagConstraints.anchor = 18;
            gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        }
        gridBagLayout.setConstraints(this.titleLabel, gridBagConstraints);
        this.add(this.titleLabel);
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        this.add(component);
    }

    public void etchedIn() {
        this.box.etchedIn();
    }

    public void etchedOut() {
        this.box.etchedOut();
    }

    public void paint(Graphics graphics) {
        this.box.paint();
        super.paint(graphics);
    }

    protected String paramString() {
        return super.paramString() + ",etching=" + (this.box.isEtchedIn() ? Etching.IN : Etching.OUT) + ",title=" + this.titleLabel;
    }
}

