/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.sysdiag.qbf;

import com.schneiderautomation.factorycast.CommBean;
import com.schneiderautomation.misc.GlobalConfig;
import com.schneiderautomation.sysdiag.MessageDisplay;
import com.schneiderautomation.sysdiag.SeparatorPanel;
import com.schneiderautomation.sysdiag.qbf.CPUHeaderPanel;
import com.schneiderautomation.sysdiag.qbf.CPUStatisticsPanel;
import com.schneiderautomation.sysdiag.qbf.LocalCPUStrings;
import com.schneiderautomation.sysdiag.qbf.MessageStrings;
import com.schneiderautomation.sysdiag.qbf.PlcInfo;
import com.schneiderautomation.sysdiag.qbf.QuantumCPUInfo;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;

public class CPUConfigApplet
extends Applet {
    private CommBean comm;

    public void init() {
        Object object;
        GlobalConfig.setLanguage((String)this.getParameter("Language"));
        this.setLocale(GlobalConfig.getLocale());
        LocalCPUStrings.init(this.getLocale());
        MessageStrings.init(this.getLocale());
        this.comm = new CommBean(this.getLocale());
        try {
            object = this.getParameter("server");
            if (object == null) {
                this.comm.connect(this.getCodeBase().getHost(), false);
            } else {
                this.comm.connect((String)object, false);
            }
            this.comm.start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            new MessageDisplay(this, MessageStrings.getString("M_COMMERR"), exception.getMessage());
        }
        object = new PlcInfo();
        new QuantumCPUInfo(this.comm, (PlcInfo)object);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        String string = this.getParameter("title");
        if (string == null) {
            string = LocalCPUStrings.getString("S_TITLE");
        }
        Label label = new Label(string, 1);
        label.setFont(new Font("Serif", 1, 16));
        label.setBackground(Color.white);
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.add(label);
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        ++gridBagConstraints.gridy;
        CPUHeaderPanel cPUHeaderPanel = new CPUHeaderPanel((PlcInfo)object, this, this.comm);
        gridBagLayout.setConstraints(cPUHeaderPanel, gridBagConstraints);
        this.add(cPUHeaderPanel);
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        ++gridBagConstraints.gridy;
        SeparatorPanel separatorPanel = new SeparatorPanel();
        gridBagLayout.setConstraints(separatorPanel, gridBagConstraints);
        this.add(separatorPanel);
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        ++gridBagConstraints.gridy;
        CPUStatisticsPanel cPUStatisticsPanel = new CPUStatisticsPanel((PlcInfo)object, this, this.comm);
        gridBagLayout.setConstraints(cPUStatisticsPanel, gridBagConstraints);
        this.add(cPUStatisticsPanel);
        this.setBackground(Color.white);
    }

    public void start() {
        try {
            this.comm.resume();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            new MessageDisplay(this, MessageStrings.getString("M_COMMERR"), exception.getMessage());
        }
    }

    public void stop() {
        try {
            this.comm.suspend();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            new MessageDisplay(this, MessageStrings.getString("M_COMMERR"), exception.getMessage());
        }
    }

    public void destroy() {
        try {
            this.comm.disconnect();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

