/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.sysdiag.qbf;

import com.schneiderautomation.dt.FT;
import com.schneiderautomation.factorycast.CommBean;
import com.schneiderautomation.factorycast.MonitorNumber;
import com.schneiderautomation.sysdiag.qbf.CPUConfigApplet;
import com.schneiderautomation.sysdiag.qbf.LocalCPUStrings;
import com.schneiderautomation.sysdiag.qbf.PlcInfo;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

class CPUStatisticsPanel
extends Panel
implements PropertyChangeListener {
    private static final Font columnFont = new Font("SansSerif", 1, 14);
    private static final Font lclfont = new Font("SansSerif", 1, 12);
    private static final Color myLightYellow = new Color(240, 243, 187);
    private static final int TEXTWIDTH = 6;
    private static final short MEM_PROT = 32;
    private static final short CNST_SWP = 1024;
    private Applet applet;
    private TextField stopCodesField;
    private TextField memProtectField;
    private TextField sweepField;
    private TextField optimizeField;

    CPUStatisticsPanel(PlcInfo plcInfo, CPUConfigApplet cPUConfigApplet, CommBean commBean) {
        String string;
        Object object;
        this.applet = cPUConfigApplet;
        this.setBackground(myLightYellow);
        boolean bl = false;
        try {
            bl = commBean.getServer().isUMASSupported();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        gridBagConstraints.anchor = 17;
        boolean bl2 = plcInfo.status == 4;
        Color color = bl2 ? Color.magenta.darker() : Color.black;
        gridBagConstraints.gridwidth = 2;
        Label label = new Label(LocalCPUStrings.getString("S_DESC"), 2);
        label.setFont(columnFont);
        this.add((Component)label, gridBagConstraints);
        Label label2 = new Label(LocalCPUStrings.getString("S_REGS"), 2);
        label2.setFont(columnFont);
        this.add((Component)label2, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        Label label3 = new Label(LocalCPUStrings.getString("S_ASCII"), 2);
        label3.setFont(columnFont);
        this.add((Component)label3, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        this.createLabel(LocalCPUStrings.getString("S_SYSMEM"), gridBagConstraints);
        TextField textField = this.createField(6, Color.white, gridBagConstraints, color);
        textField.setText(String.valueOf(plcInfo.systemMem / 1024) + LocalCPUStrings.getString("S_KB"));
        if (bl) {
            this.createLabel("0xxxxx (%M)", gridBagConstraints);
        } else {
            this.createLabel("0xxxxx", gridBagConstraints);
        }
        TextField textField2 = this.createField(12, Color.white, gridBagConstraints, color);
        if (plcInfo.number0xReg == 0) {
            textField2.setText(LocalCPUStrings.getString("S_UNKNOWN"));
        } else {
            object = String.valueOf(1000000 + plcInfo.number0xReg);
            textField2.setText("000001-" + ((String)object).substring(1));
        }
        this.createLabel(LocalCPUStrings.getString("S_TOTWDS"), gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        object = this.createField(6, Color.white, gridBagConstraints, color);
        ((TextField)object).setText(String.valueOf(plcInfo.totalAsciiWords));
        gridBagConstraints.gridwidth = 1;
        this.createLabel(LocalCPUStrings.getString("S_EXTMEM"), gridBagConstraints);
        TextField textField3 = this.createField(6, Color.white, gridBagConstraints, color);
        textField3.setText(String.valueOf(plcInfo.extendedMem / 1024) + LocalCPUStrings.getString("S_KB"));
        if (bl) {
            this.createLabel("1xxxxx (%I)", gridBagConstraints);
        } else {
            this.createLabel("1xxxxx", gridBagConstraints);
        }
        TextField textField4 = this.createField(12, Color.white, gridBagConstraints, color);
        if (plcInfo.number1xReg == 0) {
            textField4.setText(LocalCPUStrings.getString("S_UNKNOWN"));
        } else {
            textField4.setText("100001-" + String.valueOf(100000 + plcInfo.number1xReg));
        }
        this.createLabel(LocalCPUStrings.getString("S_TOTMSG"), gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        TextField textField5 = this.createField(6, Color.white, gridBagConstraints, color);
        textField5.setText(String.valueOf(plcInfo.totalAsciiMessages));
        gridBagConstraints.gridwidth = 1;
        this.createLabel(LocalCPUStrings.getString("S_FREEMEM"), gridBagConstraints);
        TextField textField6 = this.createField(6, Color.white, gridBagConstraints, color);
        textField6.setText(String.valueOf(plcInfo.availableMem));
        if (bl) {
            this.createLabel("3xxxxx (%IW)", gridBagConstraints);
        } else {
            this.createLabel("3xxxxx", gridBagConstraints);
        }
        TextField textField7 = this.createField(12, Color.white, gridBagConstraints, color);
        if (plcInfo.number3xReg == 0) {
            textField7.setText(LocalCPUStrings.getString("S_UNKNOWN"));
        } else {
            textField7.setText("300001-" + String.valueOf(300000 + plcInfo.number3xReg));
        }
        this.createLabel(LocalCPUStrings.getString("S_USEDWDS"), gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        TextField textField8 = this.createField(6, Color.white, gridBagConstraints, color);
        textField8.setText(String.valueOf(plcInfo.asciiWordsUsed));
        gridBagConstraints.gridwidth = 1;
        this.createLabel(LocalCPUStrings.getString("S_IOMAP"), gridBagConstraints);
        TextField textField9 = this.createField(6, Color.white, gridBagConstraints, color);
        textField9.setText(String.valueOf(plcInfo.ioMapWords));
        if (bl) {
            this.createLabel("4xxxxx (%MW)", gridBagConstraints);
        } else {
            this.createLabel("4xxxxx", gridBagConstraints);
        }
        TextField textField10 = this.createField(12, Color.white, gridBagConstraints, color);
        if (plcInfo.number4xReg == 0) {
            textField10.setText(LocalCPUStrings.getString("S_UNKNOWN"));
        } else {
            textField10.setText("400001-" + String.valueOf(400000 + plcInfo.number4xReg));
        }
        this.createLabel(LocalCPUStrings.getString("S_USEDMSG"), gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        TextField textField11 = this.createField(6, Color.white, gridBagConstraints, color);
        textField11.setText(String.valueOf(plcInfo.asciiMessagesUsed));
        gridBagConstraints.gridwidth = 1;
        this.createLabel(LocalCPUStrings.getString("S_SEGMENTS"), gridBagConstraints);
        TextField textField12 = this.createField(6, Color.white, gridBagConstraints, color);
        textField12.setText(String.valueOf(plcInfo.numberOfSegments));
        this.createLabel("6xxxxx", gridBagConstraints);
        TextField textField13 = this.createField(12, Color.white, gridBagConstraints, color);
        if (plcInfo.extendedMem == 0) {
            textField13.setText(LocalCPUStrings.getString("S_NONE"));
        } else if (plcInfo.number6xReg == 0) {
            textField13.setText(LocalCPUStrings.getString("S_UNKNOWN"));
        } else {
            textField13.setText("600000-" + String.valueOf(600000 + (plcInfo.number6xReg - 1)));
        }
        this.createLabel(LocalCPUStrings.getString("S_FREEWDS"), gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        TextField textField14 = this.createField(6, Color.white, gridBagConstraints, color);
        textField14.setText(String.valueOf(plcInfo.asciiWordsFree));
        gridBagConstraints.gridwidth = 1;
        this.createLabel(LocalCPUStrings.getString("S_DROPID"), gridBagConstraints);
        TextField textField15 = this.createField(6, Color.white, gridBagConstraints, color);
        textField15.setText(String.valueOf(plcInfo.DCPDrop));
        this.createLabel(LocalCPUStrings.getString("S_BATTCOIL"), gridBagConstraints);
        TextField textField16 = this.createField(12, Color.white, gridBagConstraints, color);
        if (plcInfo.batteryCfg) {
            string = String.valueOf(1000000 + plcInfo.battery0x);
            textField16.setText(string.substring(1));
        } else {
            textField16.setText("0-----");
        }
        string = LocalCPUStrings.getString("S_FREEMSG");
        this.createLabel(string, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        TextField textField17 = this.createField(6, Color.white, gridBagConstraints, color);
        textField17.setText(String.valueOf(plcInfo.asciiMessagesFree));
        gridBagConstraints.gridwidth = 1;
        this.createLabel(LocalCPUStrings.getString("S_MEMPROT"), gridBagConstraints);
        this.memProtectField = this.createField(6, Color.white, gridBagConstraints, color);
        this.createLabel(LocalCPUStrings.getString("S_TIMREG"), gridBagConstraints);
        TextField textField18 = this.createField(12, Color.white, gridBagConstraints, color);
        if (plcInfo.timerRegConfigured) {
            textField18.setText(String.valueOf(400000 + plcInfo.timer4x));
        } else {
            textField18.setText("4-----");
        }
        this.createLabel(LocalCPUStrings.getString("S_ASCIIPORT"), gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        TextField textField19 = this.createField(6, Color.white, gridBagConstraints, color);
        textField19.setText(String.valueOf(plcInfo.numberAsciiPorts));
        gridBagConstraints.gridwidth = 1;
        this.createLabel(LocalCPUStrings.getString("S_CNSTSWP"), gridBagConstraints);
        this.sweepField = this.createField(6, Color.white, gridBagConstraints, color);
        this.createLabel(LocalCPUStrings.getString("S_TODCLK"), gridBagConstraints);
        TextField textField20 = this.createField(12, Color.white, gridBagConstraints, color);
        if (plcInfo.TODConfigured) {
            textField20.setText(String.valueOf(400000 + plcInfo.TOD4x));
        } else {
            textField20.setText("4-----");
        }
        this.createLabel(LocalCPUStrings.getString("S_ASCIIN"), gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        gridBagConstraints.gridwidth = 0;
        TextField textField21 = this.createField(6, Color.white, gridBagConstraints, color);
        if (plcInfo.asciiInputCfg) {
            textField21.setText(String.valueOf(400000 + plcInfo.asciiInput4x));
        } else {
            textField21.setText("4-----");
        }
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.createLabel(LocalCPUStrings.getString("S_OPTIMIZE"), gridBagConstraints);
        this.optimizeField = this.createField(6, Color.white, gridBagConstraints, color);
        this.createLabel(LocalCPUStrings.getString("S_STOPCODE"), gridBagConstraints);
        this.stopCodesField = this.createField(12, Color.white, gridBagConstraints, color);
        this.createLabel(LocalCPUStrings.getString("S_ASCIOUT"), gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 0, 10, 10);
        TextField textField22 = this.createField(6, Color.white, gridBagConstraints, color);
        if (plcInfo.asciiOutputCfg) {
            textField22.setText(String.valueOf(400000 + plcInfo.asciiOutput4x));
        } else {
            textField22.setText("4-----");
        }
        if (bl2) {
            String string2 = LocalCPUStrings.getString("S_UNKNOWN");
            this.stopCodesField.setText(string2);
            this.memProtectField.setText(string2);
            this.sweepField.setText(string2);
            this.optimizeField.setText(string2);
        } else {
            MonitorNumber monitorNumber = new MonitorNumber(commBean.getAdaptor());
            monitorNumber.setAddress("800101");
            monitorNumber.setQuantity((short)10);
            monitorNumber.setDatatype((short)5);
            monitorNumber.addPropertyChangeListener((PropertyChangeListener)this);
            monitorNumber.register();
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string;
        String string2 = propertyChangeEvent.getPropertyName();
        if (string2.equals("values")) {
            boolean bl;
            boolean bl2;
            boolean bl3;
            Number[] numberArray = (Number[])propertyChangeEvent.getNewValue();
            int n = numberArray[0].intValue();
            int n2 = numberArray[9].intValue();
            this.stopCodesField.setText("0x" + FT.formatValue((Number)numberArray[4], (int)3, (short)5));
            boolean bl4 = bl3 = (n & 0x20) == 32;
            if (bl3) {
                this.memProtectField.setText(LocalCPUStrings.getString("S_OFF"));
            } else {
                this.memProtectField.setText(LocalCPUStrings.getString("S_ON"));
            }
            boolean bl5 = bl2 = (n & 0x400) == 1024;
            if (bl2) {
                this.sweepField.setText(LocalCPUStrings.getString("S_ON"));
            } else {
                this.sweepField.setText(LocalCPUStrings.getString("S_OFF"));
            }
            boolean bl6 = bl = n2 == 1;
            if (bl) {
                this.optimizeField.setText(LocalCPUStrings.getString("S_YES"));
            } else {
                this.optimizeField.setText(LocalCPUStrings.getString("S_NO"));
            }
        } else if (string2.equals("subscribeStatus") && (string = (String)propertyChangeEvent.getNewValue()).length() > 0) {
            this.applet.showStatus(string);
            this.stopCodesField.setForeground(Color.magenta);
            this.memProtectField.setForeground(Color.magenta);
            this.sweepField.setForeground(Color.magenta);
            this.optimizeField.setForeground(Color.magenta);
        }
    }

    private void createLabel(String string, GridBagConstraints gridBagConstraints) {
        Label label = new Label(string, 2);
        label.setFont(lclfont);
        label.setBackground(myLightYellow);
        this.add((Component)label, gridBagConstraints);
    }

    private TextField createField(int n, Color color, GridBagConstraints gridBagConstraints, Color color2) {
        TextField textField = new TextField(n);
        textField.setFont(lclfont);
        textField.setEditable(false);
        textField.setBackground(color);
        textField.setForeground(color2);
        this.add((Component)textField, gridBagConstraints);
        return textField;
    }
}

