/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.sysdiag.qbf;

import com.schneiderautomation.factorycast.CommBean;
import com.schneiderautomation.factorycast.comm.xbf.ENetStatistics;
import com.schneiderautomation.factorycast.comm.xbf.ENetStats;
import com.schneiderautomation.misc.GlobalConfig;
import com.schneiderautomation.sysdiag.MessageDisplay;
import com.schneiderautomation.sysdiag.qbf.EnetPanel;
import com.schneiderautomation.sysdiag.qbf.EnetStrings;
import com.schneiderautomation.sysdiag.qbf.MessageStrings;
import com.schneiderautomation.sysdiag.qbf.StatPanel;
import java.applet.Applet;
import java.awt.Button;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class EnetApplet
extends Applet
implements Runnable {
    private static final Color lightYellow = new Color(240, 243, 187);
    private CommBean comm;
    private ENetStatistics enet;
    private Thread engine;
    private EnetPanel hdrpanel;
    private StatPanel statpanel;
    static /* synthetic */ Class class$com$schneiderautomation$factorycast$comm$xbf$ENetStatistics;

    public void init() {
        GlobalConfig.setLanguage((String)this.getParameter("Language"));
        this.setLocale(GlobalConfig.getLocale());
        EnetStrings.init(this.getLocale());
        MessageStrings.init(this.getLocale());
        this.comm = new CommBean(this.getLocale());
        String string = this.getParameter("htmlhost");
        if (string == null) {
            string = this.getCodeBase().getHost();
        }
        try {
            this.showStatus(EnetStrings.getString("CONNECTWAIT"));
            this.comm.connect(string, false);
            this.enet = (ENetStatistics)this.comm.getServer().getExtension(class$com$schneiderautomation$factorycast$comm$xbf$ENetStatistics == null ? (class$com$schneiderautomation$factorycast$comm$xbf$ENetStatistics = EnetApplet.class$("com.schneiderautomation.factorycast.comm.xbf.ENetStatistics")) : class$com$schneiderautomation$factorycast$comm$xbf$ENetStatistics);
        }
        catch (Exception exception) {
            new MessageDisplay(this, MessageStrings.getString("M_COMMERR"), exception.getMessage());
            exception.printStackTrace();
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setBackground(Color.white);
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        String string2 = this.getParameter("title");
        if (string2 == null) {
            string2 = EnetStrings.getString("TITLE");
        }
        Panel panel = new Panel();
        Label label = new Label(string2, 1);
        label.setFont(new Font("TimesRoman", 1, 16));
        panel.add(label);
        gridBagLayout.setConstraints(panel, gridBagConstraints);
        this.add(panel);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        ++gridBagConstraints.gridy;
        this.hdrpanel = new EnetPanel(this.comm, this, string);
        gridBagLayout.setConstraints(this.hdrpanel, gridBagConstraints);
        this.add(this.hdrpanel);
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 17;
        ++gridBagConstraints.gridy;
        this.statpanel = new StatPanel();
        this.statpanel.setBackground(lightYellow);
        gridBagLayout.setConstraints(this.statpanel, gridBagConstraints);
        this.add(this.statpanel);
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        gridBagConstraints.anchor = 11;
        ++gridBagConstraints.gridy;
        Button button = new Button(EnetStrings.getString("ZEROCOUNT"));
        button.addActionListener(new EnetButtonActionListener());
        gridBagLayout.setConstraints(button, gridBagConstraints);
        this.add(button);
    }

    public void start() {
        this.startMonitoring();
    }

    public void stop() {
        this.stopMonitoring();
    }

    public void destroy() {
        try {
            this.comm.disconnect();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void startMonitoring() {
        if (this.engine == null) {
            this.engine = new Thread(this);
            this.engine.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopMonitoring() {
        Thread thread = null;
        EnetApplet enetApplet = this;
        synchronized (enetApplet) {
            thread = this.engine;
            this.engine = null;
            this.notify();
        }
        if (thread != null) {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public synchronized void run() {
        boolean bl = true;
        while (this.engine != null) {
            boolean bl2;
            ENetStats eNetStats;
            try {
                eNetStats = this.enet.getNetworkStatistics();
                bl2 = false;
            }
            catch (Exception exception) {
                eNetStats = new ENetStats();
                bl2 = true;
            }
            this.hdrpanel.refresh(eNetStats, bl2, bl);
            this.statpanel.refresh(eNetStats, bl2);
            try {
                this.wait(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            bl = false;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class EnetButtonActionListener
    implements ActionListener {
        EnetButtonActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                EnetApplet.this.enet.clearNetworkStatistics();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

