/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.sysdiag.qbf;

import com.schneiderautomation.factorycast.CommBean;
import com.schneiderautomation.factorycast.GetNumber;
import com.schneiderautomation.sysdiag.qbf.DropDescriptor;
import com.schneiderautomation.sysdiag.qbf.ModElement;
import com.schneiderautomation.sysdiag.qbf.ModuleDescriptor;
import com.schneiderautomation.sysdiag.qbf.ModuleList;
import com.schneiderautomation.sysdiag.qbf.RIOElement;
import com.schneiderautomation.sysdiag.qbf.RIOList;

public class TrafficCop {
    public static DropDescriptor[] dDescArray;
    private static final String TCOP_ADDR = "800089";
    private static final String MACH_STATUS = "800105";
    private static final short TCOP_BIT = 16384;
    private static final short DIM_BIT = 8192;
    private static final short REF_BIT = 128;
    private static final short BCD_BIT = 64;
    private static final int _800IO = 0;
    private static final int QIO = 1;
    private static final int DIO = 2;
    private static int tCopAddress;
    private static short tCopLength;
    private static short tCopDrops;
    private static Number[] totalArray;
    private static ModuleDescriptor moduleDesc;
    private static DropDescriptor dropDesc;
    private static boolean beenthere;
    private int modsInRack;
    private boolean fValidTcop;

    TrafficCop(CommBean commBean) {
        this.validateTrafficCop(commBean);
        if (this.fValidTcop) {
            GetNumber getNumber = new GetNumber(commBean.getServer());
            getNumber.setAddress(TCOP_ADDR);
            getNumber.setQuantity((short)2);
            getNumber.setDatatype((short)5);
            try {
                getNumber.readValues();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            Number[] numberArray = getNumber.getValues();
            tCopAddress = numberArray[0].intValue();
            int n = numberArray[0].intValue();
            short s = numberArray[1].shortValue();
            String string = String.valueOf(tCopAddress);
            int n2 = 6 - string.length();
            StringBuffer stringBuffer = new StringBuffer("800000");
            stringBuffer.insert(n2, tCopAddress);
            stringBuffer.setLength(6);
            getNumber.setAddress(stringBuffer.toString());
            getNumber.setQuantity((short)3);
            getNumber.setDatatype((short)5);
            try {
                getNumber.readValues();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            Number[] numberArray2 = getNumber.getValues();
            tCopLength = numberArray2[0].shortValue();
            tCopDrops = numberArray2[2].shortValue();
            n += 3;
            if (!beenthere) {
                TrafficCop.getAllDescriptors(commBean, n, tCopDrops, tCopLength);
            }
        }
    }

    public boolean isTCopValid() {
        return this.fValidTcop;
    }

    public int getTCopAddress() {
        return tCopAddress;
    }

    public short getTCopLength() {
        return tCopLength;
    }

    public short getTCopDrops() {
        return tCopDrops;
    }

    public Number[] getTCopValues() {
        return totalArray;
    }

    private void validateTrafficCop(CommBean commBean) {
        GetNumber getNumber = new GetNumber(commBean.getServer());
        getNumber.setAddress(MACH_STATUS);
        getNumber.setQuantity((short)1);
        getNumber.setDatatype((short)5);
        try {
            getNumber.readValues();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Number number = getNumber.getValue();
        boolean bl = (number.shortValue() & 0x2000) == 8192;
        boolean bl2 = (number.shortValue() & 0x4000) == 0;
        this.fValidTcop = bl2 && !bl;
    }

    private static void getAllDescriptors(CommBean commBean, int n, short n2, short s) {
        int n3 = 0;
        int n4 = 0;
        totalArray = new Number[s];
        dDescArray = new DropDescriptor[n2];
        for (int i = 0; i < n2; ++i) {
            TrafficCop.dDescArray[i] = new DropDescriptor();
        }
        GetNumber getNumber = new GetNumber(commBean.getServer());
        getNumber.setAddress("800" + String.valueOf(n));
        getNumber.setQuantity(s);
        getNumber.setDatatype((short)5);
        try {
            getNumber.readValues();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        totalArray = getNumber.getValues();
        getNumber = null;
        for (int i = 0; i < n2; ++i) {
            dropDesc = new DropDescriptor();
            TrafficCop.dropDesc.dropLength = totalArray[n4].shortValue();
            TrafficCop.dropDesc.readOnly = (totalArray[n4 + 1].shortValue() & 0x8000) == 32768;
            TrafficCop.dropDesc.dropNumber = (byte)totalArray[n4 + 1].shortValue();
            TrafficCop.dropDesc.dropType = (byte)((totalArray[n4 + 1].shortValue() & 0x7F00) >> 8);
            TrafficCop.dropDesc.holdupTime = totalArray[n4 + 2].intValue();
            TrafficCop.dropDesc.asciiPortNum = (byte)totalArray[n4 + 3].shortValue();
            TrafficCop.dropDesc.headSlotNum = (byte)((totalArray[n4 + 3].shortValue() & 0xFF00) >> 8);
            TrafficCop.dropDesc.numModulesCfgd = totalArray[n4 + 4].shortValue();
            if (TrafficCop.dropDesc.dropType > 0) {
                TrafficCop.dropDesc.modStatTableAdd = totalArray[n4 + 5].shortValue();
                n4 += 6;
            } else {
                TrafficCop.dropDesc.modStatTableAdd = 0;
                n4 += 5;
            }
            dropDesc.initModDesc();
            for (int j = 0; j < TrafficCop.dropDesc.numModulesCfgd; ++j) {
                int n5;
                moduleDesc = new ModuleDescriptor();
                if (TrafficCop.dropDesc.dropType != 0) {
                    TrafficCop.moduleDesc.slot = (byte)totalArray[n4].shortValue();
                    TrafficCop.moduleDesc.rack = (byte)((totalArray[n4].shortValue() & 0xFF00) >> 8);
                    TrafficCop.moduleDesc.modulePerson = totalArray[n4 + 1].intValue();
                    byte by = (byte)totalArray[n4 + 2].shortValue();
                    TrafficCop.moduleDesc.numInputBytes = (byte)((totalArray[n4 + 2].shortValue() & 0xFF00) >> 8);
                    TrafficCop.moduleDesc.inputsReference = (short)((by & 0x80) == 128 ? 0 : 2);
                    TrafficCop.moduleDesc.inputsBCD = (by & 0x40) == 64;
                    TrafficCop.moduleDesc.inStartReference = totalArray[n4 + 3].intValue();
                    by = (byte)totalArray[n4 + 4].shortValue();
                    TrafficCop.moduleDesc.numOutputBytes = (byte)((totalArray[n4 + 4].shortValue() & 0xFF00) >> 8);
                    TrafficCop.moduleDesc.outputsReference = (short)((by & 0x80) == 128 ? 1 : 3);
                    TrafficCop.moduleDesc.outputsBCD = (by & 0x40) == 64;
                    TrafficCop.moduleDesc.outStartReference = totalArray[n4 + 5].intValue();
                    short s2 = totalArray[n4 + 6].shortValue();
                    if (512 <= TrafficCop.moduleDesc.modulePerson && TrafficCop.moduleDesc.modulePerson <= 767) {
                        TrafficCop.moduleDesc.numInputBytes = (short)(TrafficCop.moduleDesc.numInputBytes * 16);
                        TrafficCop.moduleDesc.numOutputBytes = (short)(TrafficCop.moduleDesc.numOutputBytes * 16 + 6);
                    }
                    dropDesc.setModDesc(moduleDesc);
                    moduleDesc = null;
                    n4 += 7 + s2;
                    continue;
                }
                TrafficCop.moduleDesc.rack = (byte)((totalArray[n4].shortValue() & 0xF000) >> 12);
                TrafficCop.moduleDesc.slot = (byte)((totalArray[n4].shortValue() & 0xF00) >> 8);
                TrafficCop.moduleDesc.modulePerson = (byte)totalArray[n4].shortValue();
                if (TrafficCop.moduleDesc.modulePerson == 0) {
                    dropDesc.setModDesc(moduleDesc);
                    if (TrafficCop.moduleDesc.numInputBytes > 0 && TrafficCop.moduleDesc.numOutputBytes > 0) {
                        n4 += 4;
                        continue;
                    }
                    n4 += 3;
                    continue;
                }
                TrafficCop.moduleDesc.numInputBytes = (byte)((totalArray[n4 + 1].shortValue() & 0xFF00) >> 8);
                TrafficCop.moduleDesc.numOutputBytes = (byte)totalArray[n4 + 1].shortValue();
                if (TrafficCop.moduleDesc.numInputBytes > 0 && TrafficCop.moduleDesc.numOutputBytes == 0) {
                    n5 = totalArray[n4 + 2].intValue();
                    TrafficCop.moduleDesc.inputsReference = (short)((n5 & 0x8000) == 32768 ? 0 : 2);
                    TrafficCop.moduleDesc.inputsBCD = (n5 & 0x4000) == 16384;
                    TrafficCop.moduleDesc.inStartReference = totalArray[n4 + 2].intValue() & 0x3FFF;
                    n4 += 3;
                } else if (TrafficCop.moduleDesc.numInputBytes == 0 && TrafficCop.moduleDesc.numOutputBytes > 0) {
                    n5 = totalArray[n4 + 2].intValue();
                    TrafficCop.moduleDesc.outputsReference = (short)((n5 & 0x8000) == 32768 ? 1 : 3);
                    TrafficCop.moduleDesc.outputsBCD = (n5 & 0x4000) == 16384;
                    TrafficCop.moduleDesc.outStartReference = totalArray[n4 + 2].intValue() & 0x3FFF;
                    n4 += 3;
                } else {
                    n5 = totalArray[n4 + 2].intValue();
                    TrafficCop.moduleDesc.inputsReference = (short)((n5 & 0x8000) == 32768 ? 0 : 2);
                    TrafficCop.moduleDesc.inputsBCD = (n5 & 0x4000) == 16384;
                    TrafficCop.moduleDesc.inStartReference = totalArray[n4 + 2].intValue() & 0x3FFF;
                    n5 = totalArray[n4 + 3].intValue();
                    TrafficCop.moduleDesc.outputsReference = (short)((n5 & 0x8000) == 32768 ? 1 : 3);
                    TrafficCop.moduleDesc.outputsBCD = (n5 & 0x4000) == 16384;
                    TrafficCop.moduleDesc.outStartReference = totalArray[n4 + 3].intValue() & 0x3FFF;
                    n4 += 4;
                }
                dropDesc.setModDesc(moduleDesc);
            }
            TrafficCop.dDescArray[n3] = dropDesc;
            ++n3;
        }
        beenthere = true;
    }

    private RIOList getRIOList() {
        RIOList rIOList = new RIOList();
        if (tCopDrops == 0) {
            return null;
        }
        for (int i = 0; i < tCopDrops; ++i) {
            if ((TrafficCop.dDescArray[i].dropType & 0x7F) == 2) continue;
            RIOElement rIOElement = new RIOElement();
            rIOElement.isEmpty = false;
            rIOElement.isQIO = (TrafficCop.dDescArray[i].dropType & 0x7F) == 1;
            for (int j = 0; j < TrafficCop.dDescArray[i].numModulesCfgd; ++j) {
                if (TrafficCop.dDescArray[i].mDescArray[j].rack < 1 || TrafficCop.dDescArray[i].mDescArray[j].rack > 5) continue;
                rIOElement.rack[TrafficCop.dDescArray[i].mDescArray[j].rack - 1] = true;
            }
            rIOList.setElement(TrafficCop.dDescArray[i].dropNumber, rIOElement);
        }
        return rIOList;
    }

    public ModuleList getModuleList(short s, short s2) {
        ModuleList moduleList = new ModuleList();
        if (tCopDrops == 0) {
            return null;
        }
        short s3 = 0;
        if (s3 < tCopDrops && TrafficCop.dDescArray[s3].dropNumber == s && (TrafficCop.dDescArray[s3].dropType & 0x7F) != 2) {
            this.modsInRack = TrafficCop.dDescArray[s3].numModulesCfgd;
            for (int i = 0; i < TrafficCop.dDescArray[s3].numModulesCfgd; ++i) {
                if (TrafficCop.dDescArray[s3].mDescArray[i].rack != s2) continue;
                ModElement modElement = new ModElement();
                modElement.personality = TrafficCop.dDescArray[s3].mDescArray[i].modulePerson;
                modElement.isQIO = (TrafficCop.dDescArray[s3].dropType & 0x7F) == 1;
                moduleList.addModule(TrafficCop.dDescArray[s3].mDescArray[i].slot, modElement);
            }
        }
        return moduleList;
    }

    public ModuleDescriptor getModuleIO(short s, short s2, short s3, short s4, short s5) {
        if (tCopDrops == 0) {
            return null;
        }
        ModuleDescriptor moduleDescriptor = new ModuleDescriptor();
        block0: for (int i = 0; i < tCopDrops; ++i) {
            if (TrafficCop.dDescArray[i].headSlotNum != s || TrafficCop.dDescArray[i].dropNumber != s2 || (TrafficCop.dDescArray[i].dropType & 0x7F) != s5) continue;
            this.modsInRack = TrafficCop.dDescArray[i].numModulesCfgd;
            for (int j = 0; j < TrafficCop.dDescArray[i].numModulesCfgd; ++j) {
                if (TrafficCop.dDescArray[i].mDescArray[j].rack != s3 || TrafficCop.dDescArray[i].mDescArray[j].slot != s4) continue;
                moduleDescriptor.rack = s3;
                moduleDescriptor.slot = s4;
                moduleDescriptor.modulePerson = TrafficCop.dDescArray[i].mDescArray[j].modulePerson;
                moduleDescriptor.numInputBytes = TrafficCop.dDescArray[i].mDescArray[j].numInputBytes;
                moduleDescriptor.inputsReference = TrafficCop.dDescArray[i].mDescArray[j].inputsReference;
                moduleDescriptor.inputsBCD = TrafficCop.dDescArray[i].mDescArray[j].inputsBCD;
                moduleDescriptor.inStartReference = TrafficCop.dDescArray[i].mDescArray[j].inStartReference;
                moduleDescriptor.numOutputBytes = TrafficCop.dDescArray[i].mDescArray[j].numOutputBytes;
                moduleDescriptor.outputsReference = TrafficCop.dDescArray[i].mDescArray[j].outputsReference;
                moduleDescriptor.outputsBCD = TrafficCop.dDescArray[i].mDescArray[j].outputsBCD;
                moduleDescriptor.outStartReference = TrafficCop.dDescArray[i].mDescArray[j].outStartReference;
                continue block0;
            }
        }
        return moduleDescriptor;
    }

    static {
        beenthere = false;
    }
}

