/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.widgets;

import com.schneiderautomation.factorycast.AddressEditor;
import com.schneiderautomation.factorycast.DatatypeEditor;
import com.schneiderautomation.gde.AddressViewPanel;
import com.schneiderautomation.gde.GdeCustomizer;
import com.schneiderautomation.gde.GdePropertyEditorManager;
import com.schneiderautomation.gde.PropertyCanvas;
import com.schneiderautomation.gde.PropertySelector;
import com.schneiderautomation.gde.PropertyText;
import com.schneiderautomation.widgets.BeanBoxStrings;
import com.schneiderautomation.widgets.Chart;
import com.schneiderautomation.widgets.ChartGui;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.Customizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;

public class ChartCustomizer
extends Panel
implements Customizer {
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    private CheckboxGroup cardChoices = new CheckboxGroup();
    private Panel cardPanel = new Panel();
    private CardLayout cards = new CardLayout(2, 2);
    private GeneralCard genCard = new GeneralCard();
    private PenCard penCard1 = new PenCard();
    private PenCard penCard2 = new PenCard();
    private Checkbox genCardBtn = new Checkbox(BeanBoxStrings.getString("CC_GEN_TAB"), this.cardChoices, true);
    private Checkbox penCard1Btn = new Checkbox(BeanBoxStrings.getString("CC_PENS1"), this.cardChoices, false);
    private Checkbox penCard2Btn = new Checkbox(BeanBoxStrings.getString("CC_PENS2"), this.cardChoices, false);
    private PenPanel[] penPanels = new PenPanel[ChartGui.MAX_PENS];
    static /* synthetic */ Class class$java$awt$Color;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$awt$Font;

    public ChartCustomizer() {
        for (int i = 0; i < this.penPanels.length; ++i) {
            this.penPanels[i] = new PenPanel(i);
        }
        this.penCard1.add(this.penPanels[0]);
        this.penCard1.add(this.penPanels[1]);
        this.penCard1.add(this.penPanels[2]);
        this.penCard2.add(this.penPanels[3]);
        this.penCard2.add(this.penPanels[4]);
        this.penCard2.add(this.penPanels[5]);
        this.cardPanel.setLayout(this.cards);
        this.cardPanel.add((Component)this.genCard, "GENERAL");
        this.cardPanel.add((Component)this.penCard1, "PENS1");
        this.cardPanel.add((Component)this.penCard2, "PENS2");
        Panel panel = new Panel();
        panel.add(this.genCardBtn);
        panel.add(this.penCard1Btn);
        panel.add(this.penCard2Btn);
        this.setLayout(new BorderLayout(4, 4));
        this.add((Component)panel, "North");
        this.add((Component)this.cardPanel, "Center");
        this.genCardBtn.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                ChartCustomizer.this.cards.show(ChartCustomizer.this.cardPanel, "GENERAL");
            }
        });
        this.penCard1Btn.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                ChartCustomizer.this.cards.show(ChartCustomizer.this.cardPanel, "PENS1");
            }
        });
        this.penCard2Btn.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                ChartCustomizer.this.cards.show(ChartCustomizer.this.cardPanel, "PENS2");
            }
        });
        this.cards.show(this.cardPanel, "GENERAL");
    }

    public void addNotify() {
        super.addNotify();
        Frame frame = this.getFrameParent();
        Container container = this.getParent();
        this.genCard.init(frame, container);
        for (int i = 0; i < this.penPanels.length; ++i) {
            this.penPanels[i].init(frame, container);
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(600, 320);
    }

    public void setObject(Object object) {
        this.genCard.setObject(object);
        for (int i = 0; i < this.penPanels.length; ++i) {
            this.penPanels[i].setObject(object);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    private Frame getFrameParent() {
        Container container = this.getParent();
        while (!(container instanceof Frame)) {
            container = container.getParent();
        }
        return (Frame)container;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class PenPanel
    extends Panel
    implements PropertyChangeListener {
        private Chart chart;
        private int index;
        private AddressEditor addressEditor = new AddressEditor();
        private PropertyEditor datatypeEditor = new DatatypeEditor();
        private PropertyEditor penLabelEditor = GdePropertyEditorManager.findEditor((Class)(class$java$lang$String == null ? (class$java$lang$String = ChartCustomizer.class$("java.lang.String")) : class$java$lang$String));
        private PropertyEditor penColorEditor = GdePropertyEditorManager.findEditor((Class)(class$java$awt$Color == null ? (class$java$awt$Color = ChartCustomizer.class$("java.awt.Color")) : class$java$awt$Color));
        private PropertyEditor maxValueEditor = GdePropertyEditorManager.findEditor(Float.TYPE);
        private PropertyEditor minValueEditor = GdePropertyEditorManager.findEditor(Float.TYPE);
        private Component address;
        private PropertySelector datatype;
        private PropertyText penLabel;
        private PropertyCanvas penColor;
        private PropertyText maxValue;
        private PropertyText minValue;
        private Object addressValue;
        private Object datatypeValue;
        private Object penLabelValue;
        private Object penColorValue;
        private Object maxValueValue;
        private Object minValueValue;

        PenPanel(int n) {
            this.index = n;
            this.setLayout(new GridLayout(9, 1, 4, 4));
            this.address = this.addressEditor.supportsCustomEditor() ? new PropertyCanvas((PropertyEditor)this.addressEditor) : new AddressViewPanel(this.addressEditor);
            this.datatype = new PropertySelector(this.datatypeEditor);
            this.penLabel = new PropertyText(this.penLabelEditor);
            this.penColor = new PropertyCanvas(this.penColorEditor);
            this.maxValue = new PropertyText(this.maxValueEditor);
            this.minValue = new PropertyText(this.minValueEditor);
            this.add(this.address);
            this.add((Component)this.datatype);
            this.add((Component)this.penColor);
            this.add((Component)this.penLabel);
            this.add((Component)this.maxValue);
            this.add((Component)this.minValue);
            this.add(new Label());
            this.add(new Label());
            this.add(new Label());
        }

        void init(Frame frame, Container container) {
            this.penColor.init(frame, container, BeanBoxStrings.getString("CHARTFOREGROUND_PROP"));
            if (this.address instanceof PropertyCanvas) {
                ((PropertyCanvas)this.address).init(frame, container, BeanBoxStrings.getString("ADDRESS_PROP"));
            } else if (container instanceof GdeCustomizer) {
                ((AddressViewPanel)this.address).setVarLookup(((GdeCustomizer)container).getVarLookup());
                if (container instanceof Window) {
                    ((Window)container).addWindowListener(new WindowAdapter(this){
                        private final /* synthetic */ PenPanel this$1;
                        {
                            this.this$1 = penPanel;
                        }

                        public void windowClosed(WindowEvent windowEvent) {
                            ((AddressViewPanel)PenPanel.access$300(this.this$1)).closeVarLookupDlg();
                        }
                    });
                }
            }
        }

        void setObject(Object object) {
            this.chart = (Chart)object;
            this.refresh();
            this.addressEditor.addPropertyChangeListener(this);
            this.datatypeEditor.addPropertyChangeListener(this);
            this.penLabelEditor.addPropertyChangeListener(this);
            this.penColorEditor.addPropertyChangeListener(this);
            this.maxValueEditor.addPropertyChangeListener(this);
            this.minValueEditor.addPropertyChangeListener(this);
        }

        void refresh() {
            Object object = this.chart.getAddress(this.index);
            if (object != null && !object.equals(this.addressValue)) {
                this.addressValue = object;
                this.addressEditor.setValue(this.addressValue);
                this.address.repaint();
            }
            if ((object = new Short(this.chart.getDatatype(this.index))) != null && !object.equals(this.datatypeValue)) {
                this.datatypeValue = object;
                this.datatypeEditor.setValue(this.datatypeValue);
                this.datatype.repaint();
            }
            if ((object = this.chart.getPenLabel(this.index)) != null && !object.equals(this.penLabelValue)) {
                this.penLabelValue = object;
                this.penLabelEditor.setValue(this.penLabelValue);
                this.penLabel.repaint();
            }
            if ((object = this.chart.getPenColor(this.index)) != null && !object.equals(this.penColorValue)) {
                this.penColorValue = object;
                this.penColorEditor.setValue(this.penColorValue);
                this.penColor.repaint();
            }
            if ((object = new Float(this.chart.getMaxValue(this.index))) != null && !object.equals(this.maxValueValue)) {
                this.maxValueValue = object;
                this.maxValueEditor.setValue(this.maxValueValue);
                this.maxValue.repaint();
            }
            if ((object = new Float(this.chart.getMinValue(this.index))) != null && !object.equals(this.minValueValue)) {
                this.minValueValue = object;
                this.minValueEditor.setValue(this.minValueValue);
                this.minValue.repaint();
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            PropertyEditor propertyEditor = (PropertyEditor)propertyChangeEvent.getSource();
            Object object = propertyEditor.getValue();
            if (propertyEditor == this.addressEditor) {
                if (object.equals(this.addressValue)) {
                    return;
                }
                this.addressValue = object;
                this.chart.setAddress(this.index, (String)object);
                this.address.repaint();
            } else if (propertyEditor == this.datatypeEditor) {
                if (object.equals(this.datatypeValue)) {
                    return;
                }
                this.datatypeValue = object;
                this.chart.setDatatype(this.index, (Short)object);
            } else if (propertyEditor == this.penLabelEditor) {
                if (object.equals(this.penLabelValue)) {
                    return;
                }
                this.penLabelValue = object;
                this.chart.setPenLabel(this.index, (String)object);
            } else if (propertyEditor == this.penColorEditor) {
                if (object.equals(this.penColorValue)) {
                    return;
                }
                this.penColorValue = object;
                this.chart.setPenColor(this.index, (Color)object);
                this.penColor.repaint();
            } else if (propertyEditor == this.maxValueEditor) {
                if (object.equals(this.maxValueValue)) {
                    return;
                }
                this.maxValueValue = object;
                this.chart.setMaxValue(this.index, ((Float)object).floatValue());
            } else if (propertyEditor == this.minValueEditor) {
                if (object.equals(this.minValueValue)) {
                    return;
                }
                this.minValueValue = object;
                this.chart.setMinValue(this.index, ((Float)object).floatValue());
            } else {
                System.out.println("Unknown Chart Pen property changed: " + propertyEditor);
                return;
            }
            ChartCustomizer.this.support.firePropertyChange("", null, null);
            this.refresh();
        }

        static /* synthetic */ Component access$300(PenPanel penPanel) {
            return penPanel.address;
        }
    }

    class PenCard
    extends Panel {
        final Insets insets = new Insets(4, 4, 4, 4);

        PenCard() {
            this.setLayout(new GridLayout(1, 3, 4, 4));
            Panel panel = new Panel();
            panel.setLayout(new GridLayout(9, 1, 4, 4));
            panel.add(new Label(BeanBoxStrings.getString("ADDRESS_PROP")));
            panel.add(new Label(BeanBoxStrings.getString("DATATYPE_PROP")));
            panel.add(new Label(BeanBoxStrings.getString("CHARTFOREGROUND_PROP")));
            panel.add(new Label(BeanBoxStrings.getString("PEN_LABEL_PROP")));
            panel.add(new Label(BeanBoxStrings.getString("MAXVALUE_PROP")));
            panel.add(new Label(BeanBoxStrings.getString("MINVALUE_PROP")));
            panel.add(new Label());
            panel.add(new Label());
            panel.add(new Label());
            this.add(panel);
        }

        public Insets getInsets() {
            return this.insets;
        }
    }

    class GeneralCard
    extends Panel
    implements PropertyChangeListener {
        final GridBagConstraints labelConstraints = new GridBagConstraints();
        final GridBagConstraints viewConstraints = new GridBagConstraints();
        final Insets insets = new Insets(4, 4, 4, 4);
        private Chart chart;
        private PropertyEditor backgrndEditor = GdePropertyEditorManager.findEditor((Class)(class$java$awt$Color == null ? (class$java$awt$Color = ChartCustomizer.class$("java.awt.Color")) : class$java$awt$Color));
        private PropertyEditor labelEditor = GdePropertyEditorManager.findEditor((Class)(class$java$lang$String == null ? (class$java$lang$String = ChartCustomizer.class$("java.lang.String")) : class$java$lang$String));
        private PropertyEditor labelColorEditor = GdePropertyEditorManager.findEditor((Class)(class$java$awt$Color == null ? (class$java$awt$Color = ChartCustomizer.class$("java.awt.Color")) : class$java$awt$Color));
        private PropertyEditor labelFontEditor = GdePropertyEditorManager.findEditor((Class)(class$java$awt$Font == null ? (class$java$awt$Font = ChartCustomizer.class$("java.awt.Font")) : class$java$awt$Font));
        private PropertyEditor majorDivEditor = GdePropertyEditorManager.findEditor(Integer.TYPE);
        private PropertyEditor minorDivEditor = GdePropertyEditorManager.findEditor(Integer.TYPE);
        private PropertyEditor scaleColorEditor = GdePropertyEditorManager.findEditor((Class)(class$java$awt$Color == null ? (class$java$awt$Color = ChartCustomizer.class$("java.awt.Color")) : class$java$awt$Color));
        private PropertyEditor scaleFontEditor = GdePropertyEditorManager.findEditor((Class)(class$java$awt$Font == null ? (class$java$awt$Font = ChartCustomizer.class$("java.awt.Font")) : class$java$awt$Font));
        private PropertyEditor scalePrecEditor = GdePropertyEditorManager.findEditor(Integer.TYPE);
        private PropertyEditor maxScaleEditor = GdePropertyEditorManager.findEditor(Float.TYPE);
        private PropertyEditor minScaleEditor = GdePropertyEditorManager.findEditor(Float.TYPE);
        private PropertyEditor updateEditor = GdePropertyEditorManager.findEditor(Float.TYPE);
        private PropertyEditor timeScaleEditor = GdePropertyEditorManager.findEditor(Integer.TYPE);
        private PropertyEditor chartColorEditor = GdePropertyEditorManager.findEditor((Class)(class$java$awt$Color == null ? (class$java$awt$Color = ChartCustomizer.class$("java.awt.Color")) : class$java$awt$Color));
        private PropertyEditor gridColorEditor = GdePropertyEditorManager.findEditor((Class)(class$java$awt$Color == null ? (class$java$awt$Color = ChartCustomizer.class$("java.awt.Color")) : class$java$awt$Color));
        private PropertyEditor vertGridDivEditor = GdePropertyEditorManager.findEditor(Integer.TYPE);
        private PropertyEditor borderWidthEditor = GdePropertyEditorManager.findEditor(Integer.TYPE);
        private PropertyEditor borderColorEditor = GdePropertyEditorManager.findEditor((Class)(class$java$awt$Color == null ? (class$java$awt$Color = ChartCustomizer.class$("java.awt.Color")) : class$java$awt$Color));
        private PropertyCanvas backgrnd = new PropertyCanvas(this.backgrndEditor);
        private PropertyText label = new PropertyText(this.labelEditor);
        private PropertyCanvas labelColor = new PropertyCanvas(this.labelColorEditor);
        private PropertyCanvas labelFont = new PropertyCanvas(this.labelFontEditor);
        private PropertyText majorDiv = new PropertyText(this.majorDivEditor);
        private PropertyText minorDiv = new PropertyText(this.minorDivEditor);
        private PropertyCanvas scaleColor = new PropertyCanvas(this.scaleColorEditor);
        private PropertyCanvas scaleFont = new PropertyCanvas(this.scaleFontEditor);
        private PropertyText scalePrec = new PropertyText(this.scalePrecEditor);
        private PropertyText maxScale = new PropertyText(this.maxScaleEditor);
        private PropertyText minScale = new PropertyText(this.minScaleEditor);
        private PropertyText update = new PropertyText(this.updateEditor);
        private PropertyText timeScale = new PropertyText(this.timeScaleEditor);
        private PropertyCanvas chartColor = new PropertyCanvas(this.chartColorEditor);
        private PropertyCanvas gridColor = new PropertyCanvas(this.gridColorEditor);
        private PropertyText vertGridDiv = new PropertyText(this.vertGridDivEditor);
        private PropertyText borderWidth = new PropertyText(this.borderWidthEditor);
        private PropertyCanvas borderColor = new PropertyCanvas(this.borderColorEditor);
        private Object backgrndValue;
        private Object labelValue;
        private Object labelColorValue;
        private Object labelFontValue;
        private Object majorDivValue;
        private Object minorDivValue;
        private Object scaleColorValue;
        private Object scaleFontValue;
        private Object scalePrecValue;
        private Object maxScaleValue;
        private Object minScaleValue;
        private Object updateValue;
        private Object timeScaleValue;
        private Object chartColorValue;
        private Object gridColorValue;
        private Object vertGridDivValue;
        private Object borderWidthValue;
        private Object borderColorValue;

        GeneralCard() {
            this.setLayout(new GridBagLayout());
            this.labelConstraints.gridx = 0;
            this.labelConstraints.gridy = 0;
            this.labelConstraints.gridwidth = 1;
            this.labelConstraints.gridheight = 1;
            this.labelConstraints.anchor = 17;
            this.labelConstraints.fill = 2;
            this.labelConstraints.insets.bottom = 4;
            this.viewConstraints.gridx = 1;
            this.viewConstraints.gridy = 0;
            this.viewConstraints.gridwidth = 1;
            this.viewConstraints.gridheight = 1;
            this.viewConstraints.weightx = 1.0;
            this.viewConstraints.anchor = 17;
            this.viewConstraints.fill = 1;
            this.viewConstraints.insets.bottom = 4;
            this.viewConstraints.insets.right = 16;
            this.add((Component)new Label(BeanBoxStrings.getString("BACKGROUND_PROP")), this.labelConstraints);
            this.add((Component)this.backgrnd, this.viewConstraints);
            ++this.viewConstraints.gridy;
            ++this.labelConstraints.gridy;
            this.add((Component)new Label(BeanBoxStrings.getString("LABEL_PROP")), this.labelConstraints);
            this.add((Component)this.label, this.viewConstraints);
            ++this.viewConstraints.gridy;
            ++this.labelConstraints.gridy;
            this.add((Component)new Label(BeanBoxStrings.getString("LABELCOLOR_PROP")), this.labelConstraints);
            this.add((Component)this.labelColor, this.viewConstraints);
            ++this.viewConstraints.gridy;
            ++this.labelConstraints.gridy;
            this.add((Component)new Label(BeanBoxStrings.getString("LABELFONT_PROP")), this.labelConstraints);
            this.add((Component)this.labelFont, this.viewConstraints);
            ++this.viewConstraints.gridy;
            ++this.labelConstraints.gridy;
            this.add((Component)new Label(BeanBoxStrings.getString("MAJORTICS_PROP")), this.labelConstraints);
            this.add((Component)this.majorDiv, this.viewConstraints);
            ++this.viewConstraints.gridy;
            ++this.labelConstraints.gridy;
            this.add((Component)new Label(BeanBoxStrings.getString("MINORTICS_PROP")), this.labelConstraints);
            this.add((Component)this.minorDiv, this.viewConstraints);
            ++this.viewConstraints.gridy;
            ++this.labelConstraints.gridy;
            this.add((Component)new Label(BeanBoxStrings.getString("SCALECOLOR_PROP")), this.labelConstraints);
            this.add((Component)this.scaleColor, this.viewConstraints);
            ++this.viewConstraints.gridy;
            ++this.labelConstraints.gridy;
            this.add((Component)new Label(BeanBoxStrings.getString("SCALEFONT_PROP")), this.labelConstraints);
            this.add((Component)this.scaleFont, this.viewConstraints);
            ++this.viewConstraints.gridy;
            ++this.labelConstraints.gridy;
            this.add((Component)new Label(BeanBoxStrings.getString("SCALEPRECISION_PROP")), this.labelConstraints);
            this.add((Component)this.scalePrec, this.viewConstraints);
            this.labelConstraints.gridx = 2;
            this.labelConstraints.gridy = 0;
            this.viewConstraints.gridx = 3;
            this.viewConstraints.gridy = 0;
            this.viewConstraints.insets.right = 0;
            this.add((Component)new Label(BeanBoxStrings.getString("MAXIMUM_PROP")), this.labelConstraints);
            this.add((Component)this.maxScale, this.viewConstraints);
            ++this.viewConstraints.gridy;
            ++this.labelConstraints.gridy;
            this.add((Component)new Label(BeanBoxStrings.getString("MINIMUM_PROP")), this.labelConstraints);
            this.add((Component)this.minScale, this.viewConstraints);
            ++this.viewConstraints.gridy;
            ++this.labelConstraints.gridy;
            this.add((Component)new Label(BeanBoxStrings.getString("UPDATEINTERVAL_PROP")), this.labelConstraints);
            this.add((Component)this.update, this.viewConstraints);
            ++this.viewConstraints.gridy;
            ++this.labelConstraints.gridy;
            this.add((Component)new Label(BeanBoxStrings.getString("TIMEDIVISIONS_PROP")), this.labelConstraints);
            this.add((Component)this.timeScale, this.viewConstraints);
            ++this.viewConstraints.gridy;
            ++this.labelConstraints.gridy;
            this.add((Component)new Label(BeanBoxStrings.getString("CHARTBACKGROUND_PROP")), this.labelConstraints);
            this.add((Component)this.chartColor, this.viewConstraints);
            ++this.viewConstraints.gridy;
            ++this.labelConstraints.gridy;
            this.add((Component)new Label(BeanBoxStrings.getString("GRIDCOLOR_PROP")), this.labelConstraints);
            this.add((Component)this.gridColor, this.viewConstraints);
            ++this.viewConstraints.gridy;
            ++this.labelConstraints.gridy;
            this.add((Component)new Label(BeanBoxStrings.getString("GRIDDIVISIONS_PROP")), this.labelConstraints);
            this.add((Component)this.vertGridDiv, this.viewConstraints);
            ++this.viewConstraints.gridy;
            ++this.labelConstraints.gridy;
            this.add((Component)new Label(BeanBoxStrings.getString("BORDERWIDTH_PROP")), this.labelConstraints);
            this.add((Component)this.borderWidth, this.viewConstraints);
            ++this.viewConstraints.gridy;
            ++this.labelConstraints.gridy;
            this.add((Component)new Label(BeanBoxStrings.getString("BORDERCOLOR_PROP")), this.labelConstraints);
            this.add((Component)this.borderColor, this.viewConstraints);
        }

        public Insets getInsets() {
            return this.insets;
        }

        void init(Frame frame, Container container) {
            this.backgrnd.init(frame, container, BeanBoxStrings.getString("BACKGROUND_PROP"));
            this.labelColor.init(frame, container, BeanBoxStrings.getString("LABELCOLOR_PROP"));
            this.labelFont.init(frame, container, BeanBoxStrings.getString("LABELFONT_PROP"));
            this.scaleColor.init(frame, container, BeanBoxStrings.getString("SCALECOLOR_PROP"));
            this.scaleFont.init(frame, container, BeanBoxStrings.getString("SCALEFONT_PROP"));
            this.chartColor.init(frame, container, BeanBoxStrings.getString("CHARTBACKGROUND_PROP"));
            this.gridColor.init(frame, container, BeanBoxStrings.getString("GRIDCOLOR_PROP"));
            this.borderColor.init(frame, container, BeanBoxStrings.getString("BORDERCOLOR_PROP"));
        }

        void setObject(Object object) {
            this.chart = (Chart)object;
            this.refresh();
            this.backgrndEditor.addPropertyChangeListener(this);
            this.labelEditor.addPropertyChangeListener(this);
            this.labelColorEditor.addPropertyChangeListener(this);
            this.labelFontEditor.addPropertyChangeListener(this);
            this.majorDivEditor.addPropertyChangeListener(this);
            this.minorDivEditor.addPropertyChangeListener(this);
            this.scaleColorEditor.addPropertyChangeListener(this);
            this.scaleFontEditor.addPropertyChangeListener(this);
            this.scalePrecEditor.addPropertyChangeListener(this);
            this.maxScaleEditor.addPropertyChangeListener(this);
            this.minScaleEditor.addPropertyChangeListener(this);
            this.updateEditor.addPropertyChangeListener(this);
            this.timeScaleEditor.addPropertyChangeListener(this);
            this.chartColorEditor.addPropertyChangeListener(this);
            this.gridColorEditor.addPropertyChangeListener(this);
            this.vertGridDivEditor.addPropertyChangeListener(this);
            this.borderWidthEditor.addPropertyChangeListener(this);
            this.borderColorEditor.addPropertyChangeListener(this);
        }

        void refresh() {
            Object object = this.chart.getBackground();
            if (object != null && !object.equals(this.backgrndValue)) {
                this.backgrndValue = object;
                this.backgrndEditor.setValue(this.backgrndValue);
                this.backgrnd.repaint();
            }
            if ((object = this.chart.getLabel()) != null && !object.equals(this.labelValue)) {
                this.labelValue = object;
                this.labelEditor.setValue(this.labelValue);
                this.label.repaint();
            }
            if ((object = this.chart.getLabelColor()) != null && !object.equals(this.labelColorValue)) {
                this.labelColorValue = object;
                this.labelColorEditor.setValue(this.labelColorValue);
                this.labelColor.repaint();
            }
            if ((object = this.chart.getLabelFont()) != null && !object.equals(this.labelFontValue)) {
                this.labelFontValue = object;
                this.labelFontEditor.setValue(this.labelFontValue);
                this.labelFont.repaint();
            }
            if ((object = new Integer(this.chart.getMajorTics())) != null && !object.equals(this.majorDivValue)) {
                this.majorDivValue = object;
                this.majorDivEditor.setValue(this.majorDivValue);
                this.majorDiv.repaint();
            }
            if ((object = new Integer(this.chart.getMinorTics())) != null && !object.equals(this.minorDivValue)) {
                this.minorDivValue = object;
                this.minorDivEditor.setValue(this.minorDivValue);
                this.minorDiv.repaint();
            }
            if ((object = this.chart.getScaleColor()) != null && !object.equals(this.scaleColorValue)) {
                this.scaleColorValue = object;
                this.scaleColorEditor.setValue(this.scaleColorValue);
                this.scaleColor.repaint();
            }
            if ((object = this.chart.getScaleFont()) != null && !object.equals(this.scaleFontValue)) {
                this.scaleFontValue = object;
                this.scaleFontEditor.setValue(this.scaleFontValue);
                this.scaleFont.repaint();
            }
            if ((object = new Integer(this.chart.getPrecision())) != null && !object.equals(this.scalePrecValue)) {
                this.scalePrecValue = object;
                this.scalePrecEditor.setValue(this.scalePrecValue);
                this.scalePrec.repaint();
            }
            if ((object = new Float(this.chart.getMaximum())) != null && !object.equals(this.maxScaleValue)) {
                this.maxScaleValue = object;
                this.maxScaleEditor.setValue(this.maxScaleValue);
                this.maxScale.repaint();
            }
            if ((object = new Float(this.chart.getMinimum())) != null && !object.equals(this.minScaleValue)) {
                this.minScaleValue = object;
                this.minScaleEditor.setValue(this.minScaleValue);
                this.minScale.repaint();
            }
            if ((object = new Float(this.chart.getUpdateInterval())) != null && !object.equals(this.updateValue)) {
                this.updateValue = object;
                this.updateEditor.setValue(this.updateValue);
                this.update.repaint();
            }
            if ((object = new Integer(this.chart.getTimeDivisions())) != null && !object.equals(this.timeScaleValue)) {
                this.timeScaleValue = object;
                this.timeScaleEditor.setValue(this.timeScaleValue);
                this.timeScale.repaint();
            }
            if ((object = this.chart.getChartBackground()) != null && !object.equals(this.chartColorValue)) {
                this.chartColorValue = object;
                this.chartColorEditor.setValue(this.chartColorValue);
                this.chartColor.repaint();
            }
            if ((object = this.chart.getGridColor()) != null && !object.equals(this.gridColorValue)) {
                this.gridColorValue = object;
                this.gridColorEditor.setValue(this.gridColorValue);
                this.gridColor.repaint();
            }
            if ((object = new Integer(this.chart.getGridDivisions())) != null && !object.equals(this.vertGridDivValue)) {
                this.vertGridDivValue = object;
                this.vertGridDivEditor.setValue(this.vertGridDivValue);
                this.vertGridDiv.repaint();
            }
            if ((object = new Integer(this.chart.getBorderWidth())) != null && !object.equals(this.borderWidthValue)) {
                this.borderWidthValue = object;
                this.borderWidthEditor.setValue(this.borderWidthValue);
                this.borderWidth.repaint();
            }
            if ((object = this.chart.getBorderColor()) != null && !object.equals(this.borderColorValue)) {
                this.borderColorValue = object;
                this.borderColorEditor.setValue(this.borderColorValue);
                this.borderColor.repaint();
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            PropertyEditor propertyEditor = (PropertyEditor)propertyChangeEvent.getSource();
            Object object = propertyEditor.getValue();
            if (propertyEditor == this.backgrndEditor) {
                if (object.equals(this.backgrndValue)) {
                    return;
                }
                this.backgrndValue = object;
                this.chart.setBackground((Color)object);
                this.backgrnd.repaint();
            } else if (propertyEditor == this.labelEditor) {
                if (object.equals(this.labelValue)) {
                    return;
                }
                this.labelValue = object;
                this.chart.setLabel((String)object);
            } else if (propertyEditor == this.labelColorEditor) {
                if (object.equals(this.labelColorValue)) {
                    return;
                }
                this.labelColorValue = object;
                this.chart.setLabelColor((Color)object);
                this.labelColor.repaint();
            } else if (propertyEditor == this.labelFontEditor) {
                if (object.equals(this.labelFontValue)) {
                    return;
                }
                this.labelFontValue = object;
                this.chart.setLabelFont((Font)object);
                this.labelFont.repaint();
            } else if (propertyEditor == this.majorDivEditor) {
                if (object.equals(this.majorDivValue)) {
                    return;
                }
                this.majorDivValue = object;
                this.chart.setMajorTics((Integer)object);
            } else if (propertyEditor == this.minorDivEditor) {
                if (object.equals(this.minorDivValue)) {
                    return;
                }
                this.minorDivValue = object;
                this.chart.setMinorTics((Integer)object);
            } else if (propertyEditor == this.scaleColorEditor) {
                if (object.equals(this.scaleColorValue)) {
                    return;
                }
                this.scaleColorValue = object;
                this.chart.setScaleColor((Color)object);
                this.scaleColor.repaint();
            } else if (propertyEditor == this.scaleFontEditor) {
                if (object.equals(this.scaleFontValue)) {
                    return;
                }
                this.scaleFontValue = object;
                this.chart.setScaleFont((Font)object);
                this.scaleFont.repaint();
            } else if (propertyEditor == this.scalePrecEditor) {
                if (object.equals(this.scalePrecValue)) {
                    return;
                }
                this.scalePrecValue = object;
                this.chart.setPrecision((Integer)object);
            } else if (propertyEditor == this.maxScaleEditor) {
                if (object.equals(this.maxScaleValue)) {
                    return;
                }
                this.maxScaleValue = object;
                this.chart.setMaximum(((Float)object).intValue());
            } else if (propertyEditor == this.minScaleEditor) {
                if (object.equals(this.minScaleValue)) {
                    return;
                }
                this.minScaleValue = object;
                this.chart.setMinimum(((Float)object).intValue());
            } else if (propertyEditor == this.updateEditor) {
                if (object.equals(this.updateValue)) {
                    return;
                }
                this.updateValue = object;
                this.chart.setUpdateInterval(((Float)object).intValue());
            } else if (propertyEditor == this.timeScaleEditor) {
                if (object.equals(this.timeScaleValue)) {
                    return;
                }
                this.timeScaleValue = object;
                this.chart.setTimeDivisions((Integer)object);
            } else if (propertyEditor == this.chartColorEditor) {
                if (object.equals(this.chartColorValue)) {
                    return;
                }
                this.chartColorValue = object;
                this.chart.setChartBackground((Color)object);
                this.chartColor.repaint();
            } else if (propertyEditor == this.gridColorEditor) {
                if (object.equals(this.gridColorValue)) {
                    return;
                }
                this.gridColorValue = object;
                this.chart.setGridColor((Color)object);
                this.gridColor.repaint();
            } else if (propertyEditor == this.vertGridDivEditor) {
                if (object.equals(this.vertGridDivValue)) {
                    return;
                }
                this.vertGridDivValue = object;
                this.chart.setGridDivisions((Integer)object);
            } else if (propertyEditor == this.borderWidthEditor) {
                if (object.equals(this.borderWidthValue)) {
                    return;
                }
                this.borderWidthValue = object;
                this.chart.setBorderWidth((Integer)object);
            } else if (propertyEditor == this.borderColorEditor) {
                if (object.equals(this.borderColorValue)) {
                    return;
                }
                this.borderColorValue = object;
                this.chart.setBorderColor((Color)object);
                this.borderColor.repaint();
            } else {
                System.out.println("Unknown Chart property changed: " + propertyEditor);
                return;
            }
            ChartCustomizer.this.support.firePropertyChange("", null, null);
            this.refresh();
        }
    }
}

