/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.widgets;

import com.schneiderautomation.widgets.LiveCircle;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.Serializable;

class CircularIndicator
extends LiveCircle
implements Serializable {
    static final long serialVersionUID = 4644717054183519950L;
    static final int NEEDLE_PTR = 0;
    static final int ARROW_PTR = 1;
    static final int HAND_PTR = 2;
    static final int N_PTR = 3;
    private transient Polygon oldPointer;
    private int dialBandWidth;
    private double dialRadius;
    private int ptrType = 0;

    CircularIndicator() {
    }

    void setDegSweep(int n) {
        super.setDegSweep(n);
        this.oldPointer = null;
    }

    void setPointerType(int n) {
        this.ptrType = n;
    }

    int getPointerType() {
        return this.ptrType;
    }

    void setDialBandWidth(int n) {
        this.dialBandWidth = n;
    }

    void setBounds(Rectangle rectangle, double d, double d2, double d3) {
        super.setBounds(rectangle, d, d2, d3);
        this.dialRadius = d3 - (double)this.dialBandWidth;
        this.oldPointer = null;
    }

    void paint(Graphics graphics) {
        Shape shape = graphics.getClip();
        graphics.setClip(this.clip);
        this.drawPointer(graphics);
        graphics.setClip(shape);
    }

    private void drawPointer(Graphics graphics) {
        int n;
        int n2;
        double d;
        double d2;
        double d3 = (double)this.degSweep * Math.PI / 180.0;
        double d4 = (Math.PI - d3) / 2.0;
        double d5 = d4 + d3;
        double d6 = (double)(this.maximum - this.minimum) / d3;
        double d7 = d5 - (double)(this.value - this.minimum) / d6;
        if (this.ptrType == 2) {
            d2 = d3 / (Math.PI * 2) * 0.22;
            d = this.dialRadius - 1.0;
        } else if (this.ptrType == 0) {
            d2 = 1.5707963267948966;
            d = this.dialRadius * 0.15;
        } else {
            d2 = d3 / (Math.PI * 2) * 0.35;
            d = this.dialRadius - 1.0;
        }
        Polygon polygon = new Polygon();
        if (this.ptrType == 2) {
            n2 = (int)(this.cx + 0.5);
            n = (int)(this.cy + 0.5);
            polygon.addPoint(n2, n);
        }
        n2 = (int)(this.cx + d * Math.cos(d7 - d2) + 0.5);
        n = (int)(this.cy - d * Math.sin(d7 - d2) + 0.5);
        polygon.addPoint(n2, n);
        n2 = (int)(this.cx + (this.outerRadius - 2.0) * Math.cos(d7) + 0.5);
        n = (int)(this.cy - (this.outerRadius - 2.0) * Math.sin(d7) + 0.5);
        polygon.addPoint(n2, n);
        n2 = (int)(this.cx + d * Math.cos(d7 + d2) + 0.5);
        n = (int)(this.cy - d * Math.sin(d7 + d2) + 0.5);
        polygon.addPoint(n2, n);
        if (this.oldPointer != null) {
            graphics.setColor(this.ptrBkgrnd);
            graphics.fillPolygon(this.oldPointer);
        }
        graphics.setColor(this.ptrColor);
        graphics.fillPolygon(polygon);
        this.oldPointer = polygon;
    }
}

