/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.widgets;

import com.schneiderautomation.gde.Wrapper;
import com.schneiderautomation.widgets.Border;
import com.schneiderautomation.widgets.DDisplay;
import com.schneiderautomation.widgets.FormatEditor;
import com.schneiderautomation.widgets.HLabel;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.Serializable;

public class DIndicatorGui
extends Canvas
implements Serializable {
    static final long serialVersionUID = 6835994536223254709L;
    public static final int DEC_FORMAT = 2;
    public static final int HEX_FORMAT = 3;
    public static final int BIN_FORMAT = 4;
    public static final int TIME_FORMAT = 7;
    public static final int ASCII_FORMAT = 6;
    private Border border = new Border();
    private DDisplay display = new DDisplay();
    private HLabel label = new HLabel();

    public DIndicatorGui() {
        this.InitWrapper();
        this.setBackground(Color.lightGray);
    }

    public void paint(Graphics graphics) {
        FormatEditor formatEditor = new FormatEditor();
        this.display.paint(graphics);
        this.label.paint(graphics);
        this.border.paint(graphics);
        if (Wrapper.BORDER_WIDTH != 4) {
            this.InitWrapper();
        }
    }

    private void InitWrapper() {
        Wrapper.BORDER_WIDTH = 4;
        Wrapper.BORDER_WIDTH_X2 = Wrapper.BORDER_WIDTH * 2;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.getMinimumSize();
        if (n3 < dimension2.width) {
            n3 = dimension2.width;
        }
        if (n4 < dimension2.height) {
            n4 = dimension2.height;
        }
        super.setBounds(n, n2, n3, n4);
        if (dimension.width != n3 || dimension.height != n4) {
            this.doLayout();
        }
    }

    public void setValue(Number number) {
        this.display.setValue(number);
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            this.display.paint(graphics);
            graphics.dispose();
        }
    }

    public Number getValue() {
        return this.display.getValue();
    }

    public void setUnits(String string) {
        this.display.setUnits(string);
        this.doLayout();
        this.repaint();
    }

    public String getUnits() {
        return this.display.getUnits();
    }

    public void setFormat(int n) {
        this.display.setFormat(n);
        this.doLayout();
        this.repaint();
    }

    public int getFormat() {
        return this.display.getFormat();
    }

    public void setMinimum(float f) {
        this.display.setMinimum(f);
        this.doLayout();
        this.repaint();
    }

    public float getMinimum() {
        return this.display.getMinimum();
    }

    public void setMaximum(float f) {
        this.display.setMaximum(f);
        this.doLayout();
        this.repaint();
    }

    public float getMaximum() {
        return this.display.getMaximum();
    }

    public void setPrecision(int n) {
        this.display.setPrecision(n);
        this.doLayout();
        this.repaint();
    }

    public int getPrecision() {
        return this.display.getPrecision();
    }

    public void setLabel(String string) {
        this.label.setText(string);
        this.doLayout();
        this.repaint();
    }

    public String getLabel() {
        return this.label.getText();
    }

    public void setLabelColor(Color color) {
        this.label.setForeground(color);
        this.repaint();
    }

    public Color getLabelColor() {
        return this.label.getForeground();
    }

    public void setLabelFont(Font font) {
        this.label.setFont(font);
        this.doLayout();
        this.repaint();
    }

    public Font getLabelFont() {
        return this.label.getFont();
    }

    public void setValueForeground(Color color) {
        this.display.setForeground(color);
        this.repaint();
    }

    public Color getValueForeground() {
        return this.display.getForeground();
    }

    public void setValueBackground(Color color) {
        this.display.setBackground(color);
        this.repaint();
    }

    public Color getValueBackground() {
        return this.display.getBackground();
    }

    public void setValueFont(Font font) {
        this.display.setFont(font);
        this.doLayout();
        this.repaint();
    }

    public Font getValueFont() {
        return this.display.getFont();
    }

    public void setDeadband(int n) {
        this.display.setDeadband(n);
        this.repaint();
    }

    public int getDeadband() {
        return this.display.getDeadband();
    }

    public void setLimitLoLo(float f) {
        this.display.setLimitValue(0, f);
        this.repaint();
    }

    public float getLimitLoLo() {
        return this.display.getLimitValue(0);
    }

    public void setLimitLo(float f) {
        this.display.setLimitValue(1, f);
        this.repaint();
    }

    public float getLimitLo() {
        return this.display.getLimitValue(1);
    }

    public void setLimitHi(float f) {
        this.display.setLimitValue(2, f);
        this.repaint();
    }

    public float getLimitHi() {
        return this.display.getLimitValue(2);
    }

    public void setLimitHiHi(float f) {
        this.display.setLimitValue(3, f);
        this.repaint();
    }

    public float getLimitHiHi() {
        return this.display.getLimitValue(3);
    }

    public void setColorLoLo(Color color) {
        this.display.setLimitColor(0, color);
        this.repaint();
    }

    public Color getColorLoLo() {
        return this.display.getLimitColor(0);
    }

    public void setColorLo(Color color) {
        this.display.setLimitColor(1, color);
        this.repaint();
    }

    public Color getColorLo() {
        return this.display.getLimitColor(1);
    }

    public void setColorHi(Color color) {
        this.display.setLimitColor(2, color);
        this.repaint();
    }

    public Color getColorHi() {
        return this.display.getLimitColor(2);
    }

    public void setColorHiHi(Color color) {
        this.display.setLimitColor(3, color);
        this.repaint();
    }

    public Color getColorHiHi() {
        return this.display.getLimitColor(3);
    }

    public void setBorderColor(Color color) {
        this.border.setColor(color);
        this.repaint();
    }

    public Color getBorderColor() {
        return this.border.getColor();
    }

    public void setBorderWidth(int n) {
        this.border.setWidth(n);
        this.doLayout();
        this.repaint();
    }

    public int getBorderWidth() {
        return this.border.getWidth();
    }

    public void doLayout() {
        Dimension dimension = this.getSize();
        this.border.setBounds(new Rectangle(0, 0, dimension.width, dimension.height));
        int n = this.border.getMinimumSize().height;
        dimension.width -= n;
        dimension.height -= n;
        int n2 = this.label.getMinimumSize().height;
        int n3 = dimension.height - n2;
        int n4 = n / 2;
        this.display.setBounds(new Rectangle(n4, n4, dimension.width, n3));
        this.label.setBounds(new Rectangle(n4, n4 + n3, dimension.width, n2));
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.getMinimumSize();
        dimension.width += 100;
        dimension.height += 10;
        return dimension;
    }

    public Dimension getMinimumSize() {
        Dimension dimension = this.display.getMinimumSize();
        Dimension dimension2 = this.label.getMinimumSize();
        Dimension dimension3 = this.border.getMinimumSize();
        int n = dimension.width;
        if (dimension2.width > n) {
            n = dimension2.width;
        }
        int n2 = dimension2.height + dimension.height + dimension3.height;
        return new Dimension(n += dimension3.width, n2);
    }

    protected void setValueType(short s) {
        this.display.setDatatype(s);
    }
}

