/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.widgets;

class DeadbandFilter {
    private float deadband;
    private float output;

    DeadbandFilter(float f) {
        this.output = f;
    }

    void setDeadband(float f, float f2, int n) {
        this.setDeadband((f2 - f) * (float)n / 100.0f);
    }

    void setDeadband(float f) {
        this.output -= (f - this.deadband) / 2.0f;
        this.deadband = f;
    }

    float getDeadband() {
        return this.deadband;
    }

    float lowValue() {
        return this.output;
    }

    float highValue() {
        return this.output + this.deadband;
    }

    void newValue(float f) {
        if (f > this.output + this.deadband) {
            this.output = f - this.deadband;
        } else if (f < this.output) {
            this.output = f;
        }
    }
}

