/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.widgets;

import com.schneiderautomation.gde.Wrapper;
import com.schneiderautomation.widgets.Border;
import com.schneiderautomation.widgets.HLabel;
import com.schneiderautomation.widgets.InputActionListener;
import com.schneiderautomation.widgets.WidgetStrings;
import java.awt.Button;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.TextListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class DirectOutputGui
extends Panel
implements ActionListener,
Serializable {
    static final long serialVersionUID = 1782140693144253129L;
    private transient boolean fActionEnabled;
    private Vector listeners = new Vector();
    private Border border = new Border();
    private HLabel label = new HLabel();
    private TextField input = new TextField(2);
    private Button button = new Button(WidgetStrings.getString("SETBTN_LBL"));

    public DirectOutputGui() {
        this.InitWrapper();
        this.setBackground(Color.lightGray);
        this.setLayout(null);
        this.add(this.input);
        this.add(this.button);
        this.input.addActionListener(this);
        this.button.addActionListener(this);
    }

    public void addInputActionListener(InputActionListener inputActionListener) {
        this.listeners.addElement(inputActionListener);
    }

    private void InitWrapper() {
        Wrapper.BORDER_WIDTH = 4;
        Wrapper.BORDER_WIDTH_X2 = Wrapper.BORDER_WIDTH * 2;
    }

    public void removeInputActionListener(InputActionListener inputActionListener) {
        this.listeners.removeElement(inputActionListener);
    }

    public void addTextListener(TextListener textListener) {
        this.input.addTextListener(textListener);
    }

    public void removeTextListener(TextListener textListener) {
        this.input.removeTextListener(textListener);
    }

    public void paint(Graphics graphics) {
        this.label.paint(graphics);
        this.border.paint(graphics);
        if (Wrapper.BORDER_WIDTH != 4) {
            this.InitWrapper();
        }
    }

    public void setEnabled(boolean bl) {
        if (!bl) {
            this.input.setText("");
        }
        this.input.setBackground(bl ? Color.white : Color.lightGray);
        this.input.setEditable(bl);
        this.button.setEnabled(this.isEnabled() && this.fActionEnabled);
    }

    public boolean isEnabled() {
        return this.input.isEditable();
    }

    public void setInputActionEnabled(boolean bl) {
        this.fActionEnabled = bl;
        this.input.setForeground(bl ? Color.black : Color.red);
        this.button.setEnabled(this.isEnabled() && this.fActionEnabled);
    }

    public boolean isInputActionEnabled() {
        return this.fActionEnabled;
    }

    public String getText() {
        return this.input.getText();
    }

    public void setText(String string) {
        this.input.setText(string);
    }

    public void setBorderColor(Color color) {
        this.border.setColor(color);
        this.repaint();
    }

    public Color getBorderColor() {
        return this.border.getColor();
    }

    public void setBorderWidth(int n) {
        this.border.setWidth(n);
        this.doLayout();
        this.repaint();
    }

    public int getBorderWidth() {
        return this.border.getWidth();
    }

    public void setLabel(String string) {
        this.label.setText(string);
        this.doLayout();
        this.repaint();
    }

    public String getLabel() {
        return this.label.getText();
    }

    public void setLabelColor(Color color) {
        this.label.setForeground(color);
        this.repaint();
    }

    public Color getLabelColor() {
        return this.label.getForeground();
    }

    public void setLabelFont(Font font) {
        this.label.setFont(font);
        this.doLayout();
        this.repaint();
    }

    public Font getLabelFont() {
        return this.label.getFont();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.fActionEnabled) {
            Enumeration enumeration = this.listeners.elements();
            while (enumeration.hasMoreElements()) {
                InputActionListener inputActionListener = (InputActionListener)enumeration.nextElement();
                inputActionListener.inputActionPerformed(actionEvent);
            }
        }
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.getMinimumSize();
        if (n3 < dimension2.width) {
            n3 = dimension2.width;
        }
        if (n4 < dimension2.height) {
            n4 = dimension2.height;
        }
        Dimension dimension3 = this.getMaximumSize();
        if (n3 > dimension3.width) {
            n3 = dimension3.width;
        }
        if (n4 > dimension3.height) {
            n4 = dimension3.height;
        }
        super.setBounds(n, n2, n3, n4);
        if (dimension.width != n3 || dimension.height != n4) {
            this.doLayout();
        }
    }

    public void doLayout() {
        Dimension dimension = this.getSize();
        this.border.setBounds(new Rectangle(0, 0, dimension.width, dimension.height));
        int n = this.border.getMinimumSize().height;
        dimension.width -= n;
        dimension.height -= n;
        int n2 = this.label.getMinimumSize().height;
        int n3 = dimension.height - n2;
        int n4 = n / 2;
        int n5 = this.button.getMinimumSize().width;
        this.input.setBounds(new Rectangle(n4, n4, dimension.width - n5, n3));
        this.button.setBounds(new Rectangle(n4 + dimension.width - n5, n4, n5, n3));
        this.label.setBounds(new Rectangle(n4, n4 + n3, dimension.width, n2));
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Dimension getMaximumSize() {
        return new Dimension(1000, this.getMinimumSize().height);
    }

    public Dimension getMinimumSize() {
        Dimension dimension = this.input.getMinimumSize();
        Dimension dimension2 = this.button.getMinimumSize();
        Dimension dimension3 = this.label.getMinimumSize();
        Dimension dimension4 = this.border.getMinimumSize();
        int n = dimension.width + dimension2.width;
        if (dimension3.width > n) {
            n = dimension3.width;
        }
        int n2 = dimension3.height + dimension.height + dimension4.height;
        return new Dimension(n += dimension4.width, n2);
    }
}

