/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.widgets;

import com.schneiderautomation.gde.GdeTopPanel;
import com.schneiderautomation.gde.Wrapper;
import com.schneiderautomation.widgets.Bar;
import com.schneiderautomation.widgets.GenericImageLoader;
import com.schneiderautomation.widgets.IndicatorGui;
import com.schneiderautomation.widgets.Scale;
import com.schneiderautomation.widgets.VBarBargraph;
import com.schneiderautomation.widgets.VScale;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.Serializable;

public class ExtBargraphGui
extends IndicatorGui
implements Serializable {
    static final long serialVersionUID = -5004871052658539372L;
    protected VScale scale = new VScale(false);
    protected VBarBargraph bar = new VBarBargraph();
    private Font font = new Font("SansSerif", 0, 12);
    public int ix = 5;
    protected boolean bstatusError = false;

    public ExtBargraphGui() {
        this.InitWrapper();
        this.scale.setMinimum(this.bar.getMinimum());
        this.scale.setMaximum(this.bar.getMaximum());
    }

    public void paint(Graphics graphics) {
        GenericImageLoader genericImageLoader = new GenericImageLoader();
        if (this.bstatusError && GdeTopPanel.bWidgeterror) {
            graphics.drawImage(genericImageLoader.iDownloadImage("Default.png"), this.bar.box.x, this.bar.box.y, this.bar.box.width, this.bar.box.height, this);
            String string = "<" + this.bar.value + ">";
            FontMetrics fontMetrics = graphics.getFontMetrics(this.font);
            int n = this.bar.box.x + (this.bar.box.width / 2 - 7 * fontMetrics.getDescent());
            if (n < this.bar.box.x) {
                n = this.bar.box.x;
            }
            int n2 = this.bar.box.y + (this.bar.box.height + fontMetrics.getHeight()) / 2 - fontMetrics.getDescent();
            graphics.setColor(Color.black);
            graphics.drawString(string, n, n2);
        } else {
            this.bar.paint(graphics);
            graphics.drawImage(genericImageLoader.iDownloadImage("Bargraph.png"), this.bar.box.x, this.bar.box.y, this.bar.box.width, this.bar.box.height, this);
        }
        this.label.paint(graphics);
        this.border.paint(graphics);
        if (Wrapper.BORDER_WIDTH != 0) {
            this.InitWrapper();
        }
    }

    private void InitWrapper() {
        Wrapper.BORDER_WIDTH = 0;
        Wrapper.BORDER_WIDTH_X2 = 0;
    }

    Scale getScale() {
        return this.scale;
    }

    Bar getBar() {
        return this.bar;
    }

    public void setPrecision(int n) {
        this.scale.setPrecision(n);
        this.doLayout();
        this.repaint();
    }

    public int getPrecision() {
        return this.scale.getPrecision();
    }

    public void doLayout() {
        Dimension dimension = this.getSize();
        this.border.setBounds(new Rectangle(0, 0, dimension.width, dimension.height));
        int n = this.border.getMinimumSize().height;
        dimension.width -= n;
        dimension.height -= n;
        int n2 = this.label.getMinimumSize().height;
        int n3 = dimension.height - n2;
        int n4 = n / 2;
        this.bar.setBounds(new Rectangle(n4, n4, dimension.width, n3));
        this.label.setBounds(new Rectangle(n4, n4 + n3, dimension.width, n2));
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.getMinimumSize();
        dimension.width += 60;
        dimension.height += 90;
        return dimension;
    }

    public Dimension getMinimumSize() {
        Dimension dimension = this.scale.getMinimumSize();
        Dimension dimension2 = this.bar.getMinimumSize();
        Dimension dimension3 = this.label.getMinimumSize();
        Dimension dimension4 = this.border.getMinimumSize();
        int n = dimension.width + dimension2.width;
        if (dimension3.width > n) {
            n = dimension3.width;
        }
        n += dimension4.width;
        int n2 = dimension.height;
        if (dimension2.height > n2) {
            n2 = dimension2.height;
        }
        return new Dimension(n, n2 += dimension4.height + dimension3.height);
    }

    public void setBargraphDerive(boolean bl) {
        this.bar.setBargraphDerive(bl);
    }

    boolean getBargraphCarre() {
        return this.bar.getBargraphCarre();
    }

    public void setix(int n) {
        this.bar.setix(n);
    }

    int getix() {
        return this.bar.getix();
    }

    public void setiy(int n) {
        this.bar.setiy(n);
    }

    int getiy() {
        return this.bar.getiy();
    }

    public void setiwidth(int n) {
        this.bar.setiwidth(n);
    }

    int getiwidth() {
        return this.bar.getiwidth();
    }

    public void setiheight(int n) {
        this.bar.setiheight(n);
    }

    int getiheight() {
        return this.bar.getiheight();
    }

    public void setixbar(int n) {
        this.bar.setixbar(n);
    }

    int getixbar() {
        return this.bar.getix();
    }

    public void setiybar(int n) {
        this.bar.setiybar(n);
    }

    int getiybar() {
        return this.bar.getiybar();
    }

    public void setiwidthbar(int n) {
        this.bar.setiwidthbar(n);
    }

    int getiwidthbar() {
        return this.bar.getiwidthbar();
    }

    public void setiheightbar(int n) {
        this.bar.setiheightbar(n);
    }

    int getiheightbar() {
        return this.bar.getiheightbar();
    }
}

